/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.quartz.job;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/**
 * EJBLocalHome を渡すことで、EJBLocalObjectをコールするQuartzジョブ実装
 */
public class EJBLocalInvokerJob implements Job {
	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( EJBLocalInvokerJob.class );

	public static final String EJB_LOCAL_HOME_INSTANCE = "localHomeInstance";

	public static final String EJB_METHOD_KEY = "method";

	public static final String EJB_ARG_TYPES_KEY = "argTypes";

	public static final String EJB_ARGS_KEY = "args";

	/*
	 * コンストラクタ
	 */
	public EJBLocalInvokerJob() {
	}

	@Override
	public void execute(JobExecutionContext context) throws JobExecutionException {
		JobDetail detail = context.getJobDetail();

		JobDataMap dataMap = detail.getJobDataMap();

		EJBLocalHome ejbLocalHome = (EJBLocalHome)dataMap.get(EJB_LOCAL_HOME_INSTANCE);
		String method = dataMap.getString(EJB_METHOD_KEY);
		m_log.debug("class=" + ejbLocalHome.getClass().getName() + ", method=" + method + ", isMutable=" + dataMap.isMutable());

		Object[] arguments = (Object[]) dataMap.get(EJB_ARGS_KEY);
		if (arguments == null) {
			arguments = new Object[0];
		}

		Method methodCreate = null;
		try {
			methodCreate = ejbLocalHome.getClass().getDeclaredMethod("create", ((Class[])null));
		} catch (NoSuchMethodException nsme) {
			throw new JobExecutionException(nsme);
		}

		EJBLocalObject remoteObj = null;
		try {
			remoteObj = (EJBLocalObject) methodCreate.invoke(ejbLocalHome, ((Object[])null));
		} catch (IllegalAccessException iae) {
			throw new JobExecutionException(iae);
		} catch (InvocationTargetException ite) {
			throw new JobExecutionException(ite);
		}

		Method methodExecute = null;
		try {
			Class[] argTypes = (Class[]) dataMap.get(EJB_ARG_TYPES_KEY);
			if (argTypes == null) {
				argTypes = new Class[arguments.length];
				for (int i = 0; i < arguments.length; i++) {
					argTypes[i] = arguments[i].getClass();
				}
			}

			methodExecute = remoteObj.getClass().getMethod(method, argTypes);
		} catch (NoSuchMethodException nsme) {
			throw new JobExecutionException(nsme);
		}

		try {
			methodExecute.invoke(remoteObj, arguments);
		} catch (IllegalAccessException iae) {
			throw new JobExecutionException(iae);
		} catch (InvocationTargetException ite) {
			throw new JobExecutionException(ite);
		}
	}
}