/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.custom.factory;

import java.util.ArrayList;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.commons.scheduler.TriggerSchedulerException;
import com.clustercontrol.custom.ejb.entity.MonitorCustomInfoLocal;
import com.clustercontrol.custom.ejb.entity.MonitorCustomInfoUtil;
import com.clustercontrol.monitor.run.factory.DeleteMonitor;

/**
 * コマンド監視の特有設定に対する削除処理実装クラス
 * @since 4.0
 * @author Tomoya Takahata
 */
public class DeleteCustom extends DeleteMonitor {

	/**
	 * マネージャからコマンド監視のスケジュールを削除する。(エージェント側で定期実行のため、何もしない)<br/>
	 */
	@Override
	protected void deleteSchedule() throws NamingException, TriggerSchedulerException {
		// do nothing
		// this monitoring works in agent process.
	}

	/**
	 * コマンド監視特有の設定情報を削除する。<br/>
	 * また、コマンド監視設定が変更されたことを影響するエージェントに通知する。<br/>
	 */
	@Override
	protected boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {
		// Local Variables
		MonitorCustomInfoLocal commandInfo = null;
		ArrayList<String> facilityIds = null;

		// MAIN
		commandInfo = MonitorCustomInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// コマンド監視設定を削除する
		commandInfo.remove();

		return true;
	}


}
