/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.custom.factory;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.commons.scheduler.TriggerScheduler;
import com.clustercontrol.custom.bean.CustomCheckInfo;
import com.clustercontrol.custom.ejb.entity.MonitorCustomInfoLocal;
import com.clustercontrol.custom.ejb.entity.MonitorCustomInfoUtil;
import com.clustercontrol.monitor.run.factory.ModifyMonitorNumericValueType;

/**
 * コマンド監視の特有設定に対する変更処理実装クラス<br/>
 * @since 4.0
 * @author Tomoya Takahata
 */
public class ModifyCustom extends ModifyMonitorNumericValueType {
	/**
	 * コマンド監視特有の設定情報を更新する。<br/>
	 * また、コマンド監視設定が変更されたことを影響するエージェントに通知する。<br/>
	 */
	@Override
	protected boolean modifyCheckInfo() throws CreateException, FinderException, NamingException {
		// Local Variables
		MonitorCustomInfoLocal commandInfo = null;
		CustomCheckInfo checkInfo = null;

		// MAIN
		checkInfo = m_monitorInfo.getCustomCheckInfo();

		// 変更前の実行対象の一覧を取得する
		commandInfo = MonitorCustomInfoUtil.getLocalHome().findByPrimaryKey(m_monitorInfo.getMonitorId());

		// コマンド監視設定を更新する
		commandInfo.setCommandExecType(checkInfo.getCommandExecType());
		commandInfo.setSelectedFacilityId(checkInfo.getSelectedFacilityId());
		commandInfo.setEffectiveUser(checkInfo.getEffectiveUser());
		commandInfo.setCommand(checkInfo.getCommand());
		commandInfo.setTimeout(checkInfo.getTimeout());

		return true;
	}

	/**
	 * スケジュール実行の遅延時間を返します。
	 */
	@Override
	protected int getDelayTime() {
		return 0;
	}

	/**
	 * スケジュール実行種別を返します。
	 */
	@Override
	protected String getTriggerType() {
		return TriggerScheduler.TRIGGER_TYPE_NONE;
	}
}
