/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl;


/**
 * ジョブリレーションマスタのBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobRelationMaster"
 *    jndi-name="JobRelationMaster"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config BMP EntityBean"
 * 
 * @jboss.depend
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobRelationMasterDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl
 */
public abstract class JobRelationMasterBean implements javax.ejb.EntityBean {
	/** 所属ジョブユニットのジョブID **/
	protected String jobunit_id;
	/** ジョブID */
	protected String job_id;
	/** 親ジョブが所属するジョブユニットのジョブID */
	protected String parent_jobunit_id;
	/** 親ジョブID */
	protected String parent_job_id;

	/**
	 * ジョブリレーションマスタを生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 * @param job_id ジョブID
	 * @param parent_jobunit_id 親ジョブが所属するジョブユニットのジョブID
	 * @param parent_job_id 親ジョブID
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 */
	public JobRelationMasterPK ejbCreate(
			String jobunit_id,
			String job_id,
			String parent_jobunit_id,
			String parent_job_id
	) throws javax.ejb.CreateException {
		this.jobunit_id = jobunit_id;
		this.job_id = job_id;
		this.parent_jobunit_id = parent_jobunit_id;
		this.parent_job_id = parent_job_id;
		return null;
	}

	/**
	 * 全てのジョブリレーションマスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}

	/**
	 * プライマリキーに一致するジョブリレーションマスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl#findByPrimaryKey(JobRelationMasterPK)
	 */
	public JobRelationMasterPK ejbFindByPrimaryKey(JobRelationMasterPK pk) throws FinderException {
		return null;
	}

	/**
	 * 親ジョブのジョブユニットのジョブIDと親ジョブIDが一致するジョブリレーションマスタを検索します。
	 * 
	 * @param parent_jobunit_id 親ジョブのジョブユニットのジョブID
	 * @param parent_job_id 親ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl#findByParentJobId(String)
	 */
	public Collection ejbFindByParentJobunitIdAndJobId(java.lang.String parent_jobunit_id, java.lang.String parent_job_id) throws FinderException {
		return null;
	}

	/**
	 * ジョブユニットのジョブIDとジョブIDが一致するジョブリレーションマスタを検索します。
	 * 
	 * @param jobunit_id ジョブユニットのジョブID
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 */
	public JobRelationMasterPK ejbFindByJobunitJob(java.lang.String jobunit_id, java.lang.String job_id) throws FinderException {
		return null;
	}

	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return 所属ョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}

	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}

	/**
	 * 親ジョブが所属するジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return 親ジョブが所属するジョブユニットのジョブID
	 */
	public java.lang.String getParent_jobunit_id() {
		return parent_jobunit_id;
	}

	/**
	 * 親ジョブが所属するジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param parent_jobunit_id 親ジョブが所属するジョブユニットのジョブID
	 */
	public void setParent_jobunit_id(java.lang.String parent_jobunit_id) {
		this.parent_jobunit_id = parent_jobunit_id;
	}

	/**
	 * 親ジョブIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getParent_job_id() {
		return parent_job_id;
	}

	/**
	 * 親ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param parent_job_id 親ジョブID
	 */
	public void setParent_job_id(java.lang.String parent_job_id) {
		this.parent_job_id = parent_job_id;
	}

	/**
	 * ジョブマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterBean#ejbFindByPrimaryKey(JobMasterPK)
	 */
	public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}


	/**
	 * 引数で指定されたジョブIDの子のジョブIDのリストを返します。
	 * 
	 * @ejb.home-method view-type="local"
	 * 
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobId ジョブID
	 * @return ジョブIDのコレクション
	 * @throws javax.ejb.FinderException
	 */
	public Collection ejbHomeGetJobsList(String jobunitId, String jobId) throws javax.ejb.FinderException{


		JobRelationMasterDAOImpl jrmDAO = new JobRelationMasterDAOImpl();


		return jrmDAO.getJobsList(jobunitId, jobId);
	}

	//    /**
	//     * 引数で指定されたジョブIDの最上位のジョブIDを返します。
	//     *
	//     * @ejb.home-method view-type="local"
	//     *
	//     * @param jobId ジョブID
	//     * @return 最上位のジョブID
	//     * @throws javax.ejb.FinderException
	//     */
	//    public String ejbHomeGetTopJobId(String jobId) throws javax.ejb.FinderException{
	//
	//
	//    	JobRelationMasterDAOImpl jrmDAO = new JobRelationMasterDAOImpl();
	//
	//
	//    	return jrmDAO.getTopJobId(jobId);
	//    }
}
