/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;

/**
 * スケジュール設定のBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobSchedule"
 *    jndi-name="JobSchedule"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobScheduleDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobScheduleDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobInfoDAO
 * @see com.clustercontrol.jobmanagement.dao.JobInfoDAOImpl
 */
public abstract class JobScheduleBean implements javax.ejb.EntityBean {
	/** スケジュールID */
	protected String schedule_id;
	/** スケジュール名 */
	protected String schedule_name;
	/** ジョブユニットID */
	protected String jobunit_id;
	/** ジョブ名 */
	protected String job_id;
	/** カレンダID */
	protected String calendar_id;
	/** スケジュール種別 */
	protected Integer schedule_type;
	/** スケジュール */
	protected Integer month;
	protected Integer day;
	protected Integer week;
	protected Integer hour;
	protected Integer minute;
	/** 有効無効フラグ*/
	protected Integer valid_flg;
	/** 作成日時 */
	protected Date reg_date;
	/** 最終更新日時 */
	protected Date update_date;
	/** 新規作成ユーザ */
	protected String reg_user;
	/** 最終更新日時 */
	protected String update_user;

	/**
	 * ジョブ情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param schedule_id スケジュールID
	 * @param schedule_name スケジュール名
	 * @param jobunit_id ジョブユニットID
	 * @param job_id ジョブ名
	 * @param calendar_id カレンダID
	 * @param schedule_type スケジュール種別
	 * @param schedule_date スケジュール日時
	 * @param valid_flg ジョブ種別
	 * @param reg_date 作成日時
	 * @param update_date 最終更新日時
	 * @param reg_user 新規作成ユーザ
	 * @param update_user 最終更新ユーザ
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public JobSchedulePK ejbCreate(
			String schedule_id,
			String schedule_name,
			String jobunit_id,
			String job_id,
			String calendar_id,
			Integer schedule_type,
			Integer month,
			Integer day,
			Integer week,
			Integer hour,
			Integer minute,
			Integer valid_flg,
			Date reg_date,
			Date update_date,
			String reg_user,
			String update_user
	) throws javax.ejb.CreateException {
		this.schedule_id = schedule_id;
		this.schedule_name = schedule_name;
		this.jobunit_id = jobunit_id;
		this.job_id = job_id;
		this.calendar_id = calendar_id;
		this.schedule_type = schedule_type;
		this.month = month;
		this.day = day;
		this.week = week;
		this.hour = hour;
		this.minute = minute;
		this.valid_flg = valid_flg;
		this.reg_date = reg_date;
		this.update_date = update_date;
		this.reg_user = reg_user;
		this.update_user = update_user;
		return null;
	}

	/**
	 * 全てのジョブ情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}

	/**
	 * プライマリキーに一致するジョブ情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobInfoDAOImpl#findByPrimaryKey(JobInfoPK)
	 */
	public JobSchedulePK ejbFindByPrimaryKey(JobSchedulePK pk) throws FinderException {
		return null;
	}

	/**
	 * スケジュールIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return スケジュールID
	 */
	public String getSchedule_id() {
		return schedule_id;
	}

	/**
	 * スケジュールIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param schedule_id スケジュールID
	 */
	public void setSchedule_id(java.lang.String schedule_id) {
		this.schedule_id = schedule_id;
	}

	/**
	 * スケジュール名を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return スケジュール名
	 */
	public String getSchedule_name() {
		return schedule_name;
	}

	/**
	 * スケジュール名を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param schedule_name スケジュール名
	 */
	public void setSchedule_name(String schedule_name) {
		this.schedule_name = schedule_name;
	}

	/**
	 * ジョブユニットIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return ジョブユニットID
	 */
	public String getJobunit_id() {
		return jobunit_id;
	}

	/**
	 * ジョブユニットIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id ジョブユニットID
	 */
	public void setJobunit_id(String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public String getJob_id() {
		return job_id;
	}

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(String job_id) {
		this.job_id = job_id;
	}

	/**
	 * カレンダIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return カレンダID
	 */
	public String getCalendar_id() {
		return calendar_id;
	}

	/**
	 * カレンダIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param calendar_id カレンダID
	 */
	public void setCalendar_id(String calendar_id) {
		this.calendar_id = calendar_id;
	}

	/**
	 * スケジュール種別を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return スケジュール種別
	 */
	public Integer getSchedule_type() {
		return schedule_type;
	}

	/**
	 * スケジュール種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param schedule_type スケジュール種別
	 */
	public void setSchedule_type(Integer schedule_type) {
		this.schedule_type = schedule_type;
	}

	/**
	 * スケジュール日時を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return スケジュール日時
	 */
	public Integer getMonth() {
		return month;
	}

	/**
	 * スケジュール日時を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param schedule_date スケジュール日時
	 */
	public void setMonth(Integer month) {
		this.month = month;
	}

	/**
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * @return
	 */
	public Integer getDay() {
		return day;
	}
	/**
	 * @ejb.interface-method
	 * @param day
	 */
	public void setDay(Integer day) {
		this.day = day;
	}
	/**
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * @return
	 */
	public Integer getWeek() {
		return week;
	}
	/**
	 * @ejb.interface-method
	 * @param week
	 */
	public void setWeek(Integer week) {
		this.week = week;
	}
	/**
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * @return
	 */
	public Integer getHour() {
		return hour;
	}
	/**
	 * @ejb.interface-method
	 * @param hour
	 */
	public void setHour(Integer hour) {
		this.hour = hour;
	}
	/**
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * @return
	 */
	public Integer getMinute() {
		return minute;
	}
	/**
	 * @ejb.interface-method
	 * @param minute
	 */
	public void setMinute(Integer minute) {
		this.minute = minute;
	}

	/**
	 * 有効無効フラグを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 有効無効フラグ
	 */
	public Integer getValid_flg() {
		return valid_flg;
	}

	/**
	 * 有効無効フラグを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param valid_flg 有効無効フラグ
	 */
	public void setValid_flg(Integer valid_flg) {
		this.valid_flg = valid_flg;
	}

	/**
	 * 作成日時を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 作成日時
	 */
	public java.util.Date getReg_date() {
		return reg_date;
	}

	/**
	 * 作成日時を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param reg_date 作成日時
	 */
	public void setReg_date(java.util.Date reg_date) {
		this.reg_date = reg_date;
	}

	/**
	 * 最終更新日時を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 最終更新日時
	 */
	public java.util.Date getUpdate_date() {
		return update_date;
	}

	/**
	 * 最終更新日時を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param update_date 最終更新日時
	 */
	public void setUpdate_date(java.util.Date update_date) {
		this.update_date = update_date;
	}

	/**
	 * 新規作成ユーザを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public java.lang.String getReg_user() {
		return reg_user;
	}

	/**
	 * 新規作成ユーザを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param reg_user 新規作成ユーザ
	 */
	public void setReg_user(java.lang.String reg_user) {
		this.reg_user = reg_user;
	}

	/**
	 * 最終更新ユーザを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 最終更新ユーザ
	 */
	public java.lang.String getUpdate_user() {
		return update_user;
	}

	/**
	 * 最終更新ユーザを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param update_user 最終更新ユーザ
	 */
	public void setUpdate_user(java.lang.String update_user) {
		this.update_user = update_user;
	}
}
