/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.factory;

import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.JobInfoNotFound;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;

/**
 *  ジョブ操作の停止[強制]を行うクラスです。
 * 
 * @author Hinemos
 *
 */
public class OperateForceStopOfJob  extends OperationJob {

	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( OperateForceStopOfJob.class );
	/**
	 * コンストラクタ
	 */
	public OperateForceStopOfJob(){
		super();
	}

	/**
	 * ジョブを停止[強制]します。
	 * 
	 * @param sessionId セッションID
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobId ジョブID
	 * @param facilityId ファシリティID
	 * @param endValue 終了値
	 * @throws NamingException
	 * @throws JobInfoNotFound
	 * @throws HinemosUnknown
	 */
	public void forceStopJob(
			String sessionId,
			String jobunitId,
			String jobId,
			String facilityId,
			Integer endValue) throws NamingException, JobInfoNotFound, HinemosUnknown {

		m_log.debug("forceStopJob() : sessionId=" + sessionId + ", jobunitId=" + jobunitId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", endValue=" + endValue);

		if(facilityId != null && facilityId.length() > 0){
			//ノードの場合

			//セッションIDとジョブIDから、セッションジョブを取得
			JobSessionNodeLocal sessionNode;
			try {
				sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
						new JobSessionNodePK(sessionId, jobunitId, jobId, facilityId));
			} catch (FinderException e) {
				m_log.warn("JobSessionNodeUtil.getLocalHome().findByPrimaryKey() : " + e.getMessage());
				JobInfoNotFound je = new JobInfoNotFound(e.getMessage(), e);
				je.setSessionId(sessionId);
				je.setJobunitId(jobunitId);
				je.setJobId(jobId);
				throw je;
			}

			if(sessionNode != null){
				//実行状態を終了にする
				sessionNode.setStatus(Integer.valueOf(StatusConstant.TYPE_END));
				//終了値を設定
				sessionNode.setEnd_value(endValue);
				//終了日時を設定
				sessionNode.setEnd_date(new Date());
				sessionNode = null;

				//セッションIDとジョブIDから、セッションジョブを取得
				JobSessionJobLocal sessionJob = null;
				try {
					sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
							new JobSessionJobPK(sessionId, jobunitId, jobId));
				} catch (FinderException e) {
					m_log.warn("JobSessionJobUtil.getLocalHome().findByPrimaryKey() : " + e.getMessage());
					JobInfoNotFound je = new JobInfoNotFound(e.getMessage(), e);
					je.setSessionId(sessionId);
					je.setJobunitId(jobunitId);
					je.setJobId(jobId);
					throw je;
				}

				//ジョブ終了チェック
				if(checkJobEnd(sessionJob)){
					//ジョブ終了の場合
					sessionJob =null;

					//終了状態を取得
					Integer endStatus = checkEndStatus(sessionId, jobunitId, jobId);

					//実行状態、終了状態、終了値、終了日時を設定
					setEndStaus(sessionId, jobunitId, jobId,
							Integer.valueOf(StatusConstant.TYPE_END), endStatus, null);

					//通知処理
					new Notice().notify(sessionId, jobunitId, jobId, endStatus);

					//ジョブ終了時関連処理
					endJob(sessionId, jobunitId, jobId);
				}
			}
		}
		else{
			//ノード以外の場合

			//セッションIDとジョブIDから、セッションジョブを取得
			JobSessionJobLocal sessionJob;
			try {
				sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
						new JobSessionJobPK(sessionId, jobunitId, jobId));
			} catch (FinderException e) {
				m_log.warn("JobSessionJobUtil.getLocalHome().findByPrimaryKey() : " + e.getMessage());
				JobInfoNotFound je = new JobInfoNotFound(e.getMessage(), e);
				je.setSessionId(sessionId);
				je.setJobunitId(jobunitId);
				je.setJobId(jobId);
				throw je;
			}

			if(sessionJob != null){
				//実行状態を終了にする
				sessionJob.setStatus(Integer.valueOf(StatusConstant.TYPE_END));
				//終了状態を設定
				sessionJob.setEnd_status(null);
				//終了値を設定
				sessionJob.setEnd_value(endValue);
				//終了日時を設定
				sessionJob.setEnd_date(new Date());
				sessionJob = null;

				//ジョブ終了時関連処理
				endJob(sessionId, jobunitId, jobId);
			}
		}

	}
}
