/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.logfile.util;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.logfile.bean.LogfileCheckInfo;
import com.clustercontrol.logfile.ejb.entity.MonitorLogfileInfoLocal;
import com.clustercontrol.logfile.ejb.entity.MonitorLogfileInfoUtil;

/**
 * ログファイル監視 判定情報を管理するクラス<BR>
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public class ControlLogfileInfo {
	private static Log m_log = LogFactory.getLog( ControlLogfileInfo.class );

	/** 監視対象ID */
	private String m_monitorTypeId;

	/** 監視ID */
	private String m_monitorId;

	/**
	 * コンストラクタ
	 * 
	 * @param monitorId 監視項目ID
	 * @param monitorTypeId 監視対象ID
	 * @version 4.0.0
	 * @since 4.0.0
	 */
	public ControlLogfileInfo(String monitorId, String monitorTypeId) {
		m_monitorId = monitorId;
		m_monitorTypeId = monitorTypeId;
	}

	/**
	 * ログファイル監視情報を取得します。<BR>
	 * 
	 * @return ログファイル監視情報
	 * @throws FinderException
	 * @throws NamingException
	 * @version 4.0.0
	 * @since 4.0.0
	 */
	public LogfileCheckInfo get() throws FinderException, NamingException{

		// ログファイル監視情報を取得
		MonitorLogfileInfoLocal logfileLocal = MonitorLogfileInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		LogfileCheckInfo logfile = new LogfileCheckInfo();
		logfile.setMonitorTypeId(m_monitorTypeId);
		logfile.setMonitorId(m_monitorId);
		logfile.setLogfile(logfileLocal.getLogfile());

		return logfile;
	}

	/**
	 * ログファイル監視情報を追加します。<BR>
	 * 
	 * @param logfile ログファイル監視情報
	 * @return 成功した場合、true
	 * @throws CreateException
	 * @throws NamingException
	 * @version 4.0.0
	 * @since 4.0.0
	 */
	public boolean add(LogfileCheckInfo logfile) throws CreateException, NamingException {

		// ログファイル監視情報を追加
		Object o = MonitorLogfileInfoUtil.getLocalHome();
		m_log.info("logfile " + logfile);

		MonitorLogfileInfoUtil.getLocalHome().create(
				m_monitorId,
				logfile.getLogfile()
		);

		return true;
	}

	/**
	 * ログファイル監視情報を変更します。<BR>
	 * 
	 * @param logfile ログファイル監視情報
	 * @return 成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @version 4.0.0
	 * @since 4.0.0
	 */
	public boolean modify(LogfileCheckInfo logfile) throws CreateException, FinderException, NamingException {

		// ログファイル監視情報を取得
		MonitorLogfileInfoLocal logfileLocal = MonitorLogfileInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// ログファイル監視情報を設定
		logfileLocal.setLogfile(logfile.getLogfile());

		return true;
	}

	/**
	 * ログファイル監視情報を削除します。<BR>
	 * 
	 * @return 成功した場合、true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @version 4.0.0
	 * @since 4.0.0
	 */
	public boolean delete() throws FinderException, RemoveException, NamingException {

		// ログファイル監視情報を取得
		MonitorLogfileInfoLocal logfileLocal = MonitorLogfileInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// ログファイル監視情報を削除
		logfileLocal.remove();

		return true;
	}
}
