/*
Copyright (C) 2010 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.nodemap.ejb.entity;

import java.lang.String;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * <!-- begin-user-doc --> マップ情報のEntityBean '<em><b>MapInfoBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="MapInfo"
 *	jndi-name="MapInfo"
 *	type="CMP"
 *  view-type = "local"
 *  schema="MapInfo"
 *  cmp-version="2.x"
 *  data-source="java:/DefaultDS"
 *  primkey-field="mapId"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.persistence
 *   table-name="cc_map_info"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM MapInfo as a"
 *    signature="java.util.Collection findAll()"
 *
 * @ejb.pk class="java.lang.String"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class MapInfoBean implements javax.ejb.EntityBean {
	protected static Log m_log = LogFactory.getLog( MapInfoBean.class );

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String map_id,
			String bg_image
	) throws javax.ejb.CreateException {
		setMapId(map_id);
		setBackgroundImage(bg_image);
		return null;
	}


	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * CMP Field map_id
	 *
	 * Returns the map_id
	 * @return the map_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="map_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getMapId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the map_id
	 * 
	 * @param java.lang.String the new map_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setMapId(java.lang.String map_id);

	/**
	 * <!-- begin-user-doc -->
	 * CMP Field background_image
	 *
	 * Returns the background_image
	 * @return the background_image
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="background_image"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getBackgroundImage();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the background_image
	 * 
	 * @param java.lang.String the new background_image value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setBackgroundImage(java.lang.String backgroundImage);


	//	//	==========================================
	//	//	 CMR fields
	//	//	==========================================
	//
	//	/**
	//	 * @ejb.interface-method view-type="local"
	//	 *
	//	 * @ejb.relation
	//	 * name="MapInfo-FacilityPosition"
	//	 * role-name="MapInfo-FacilityPosition(single)"
	//	 *
	//	 */
	//	public abstract Collection getFacilityPosition();
	//
	//	/**
	//	 *
	//	 * @ejb.interface-method view-type="local"
	//	 */
	//	public abstract void setFacilityPosition(Collection collection);
	//
	//	/**
	//	 * @ejb.interface-method view-type="local"
	//	 *
	//	 * @ejb.relation
	//	 * name="MapInfo-Association"
	//	 * role-name="MapInfo-Association(single)"
	//	 *
	//	 */
	//	public abstract Collection getAssociation();
	//
	//	/**
	//	 *
	//	 * @ejb.interface-method view-type="local"
	//	 */
	//	public abstract void setAssociation(Collection collection);
}
