/*

 Copyright (C) 2006 - 2009 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.process.ejb.entity;

import javax.ejb.EntityBean;

/**
 * プラットフォームごとの収集方法を保持するEntityBean <BR>
 * @ejb.bean name="MonitorProcessMethodMst"
 *           jndi-name="MonitorProcessMethodMst"
 *           type="CMP"
 *           schema="MonitorProcessMethodMst"
 *           cmp-version="2.x"
 *           data-source="java:/DefaultDS"
 *           view-type="local"
 * 
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_monitor_process_method_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *
 *  @jboss.read-only read-only="true"
 * 
 *  @ejb.permission
 *     unchecked="true"
 * 
 *  @ejb.persistence
 *   table-name="cc_monitor_process_method_mst"
 * 
 *  @ejb.finder
 *    query="SELECT OBJECT(a) FROM MonitorProcessMethodMst as a"
 *    signature="java.util.Collection findAll()"
 *
 *  @ejb.pk class="com.clustercontrol.process.ejb.entity.MonitorProcessMethodMstPK"
 * 
 */
public abstract class MonitorProcessMethodMstBean implements EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public MonitorProcessMethodMstPK ejbCreate(
			String platformId,
			String subPlatformId
	) throws javax.ejb.CreateException {

		this.setPlatformId(platformId);
		this.setSubPlatformId(subPlatformId);

		return null;
	}

	/**
	 * プラットフォームを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the platformId.
	 */
	public abstract String getPlatformId();

	/**
	 * プラットフォームを設定します。
	 * 
	 * @param platformId The platformId to set.
	 */
	public abstract void setPlatformId(String platformId);

	/**
	 * サブプラットフォームを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="sub_platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the subPlatformId.
	 */
	public abstract String getSubPlatformId();

	/**
	 * サブプラットフォームを設定します。
	 * 
	 * @param subPlatformId The subPlatformId to set.
	 */
	public abstract void setSubPlatformId(String subPlatformId);

	/**
	 * 収集方法を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="collect_method"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the collectMethod.
	 */
	public abstract String getCollectMethod();

	/**
	 * 収集方法を設定します。
	 * 
	 * @param collectMethod The collectMethod to set.
	 */
	public abstract void setCollectMethod(String collectMethod);

}
