/*

Copyright (C) since 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */
package com.clustercontrol.repository.bean;

import java.io.Serializable;
import java.util.ArrayList;

import javax.xml.bind.annotation.XmlType;

import com.clustercontrol.repository.bean.NodeDeviceInfo;
import com.clustercontrol.repository.bean.NodeFilesystemInfo;
import com.clustercontrol.repository.bean.NodeHostnameInfo;
import com.clustercontrol.repository.bean.NodeNoteInfo;

/**
 * このクラスはノード詳細のクラスです。
 * ノードの詳細を保持するために使用されます。
 * @since 0.8
 */
@XmlType(namespace = "http://repository.ws.clustercontrol.com")
public class NodeInfo extends FacilityInfo implements Serializable
{
	private static final long serialVersionUID = -4120880233299545923L;

	// HW
	private java.lang.String platformFamily = "";
	private java.lang.String hardwareType = "";
	private java.lang.String iconImage = "";

	// IPアドレス
	private java.lang.Integer ipAddressVersion = new Integer(-1);
	private java.lang.String ipAddressV4 = "";
	private java.lang.String ipAddressV6 = "";
	private ArrayList<NodeHostnameInfo> nodeHostnameInfo;

	// OS
	private java.lang.String nodeName = "";
	private java.lang.String osName = "";
	private java.lang.String osRelease = "";
	private java.lang.String osVersion = "";
	private java.lang.String characterSet = "";

	// SNMP
	private java.lang.Integer snmpPort = new Integer(-1);
	private java.lang.String snmpCommunity = "";
	private java.lang.String snmpVersion = "";
	private java.lang.Integer snmpTimeout = new Integer(-1);
	private java.lang.Integer snmpRetryCount = new Integer(-1);
	private java.lang.String snmpProxy = "";

	// WBEM
	private java.lang.String wbemUser = "";
	private java.lang.String wbemUserPassword = "";
	private java.lang.Integer wbemPort = new Integer(-1);
	private java.lang.String wbemProtocol = "";
	private java.lang.Integer wbemTimeout = new Integer(-1);
	private java.lang.Integer wbemRetryCount = new Integer(-1);

	// IPMI
	private java.lang.String ipmiIpAddress = "";
	private java.lang.Integer ipmiPort = new Integer(-1);
	private java.lang.String ipmiUser = "";
	private java.lang.String ipmiUserPassword = "";
	private java.lang.Integer ipmiTimeout = new Integer(-1);
	private java.lang.Integer ipmiRetries = new Integer(-1);
	private java.lang.String ipmiProtocol = "";
	private java.lang.String ipmiLevel = "";

	// WinRM
	private java.lang.String winrmUser = "";
	private java.lang.String winrmUserPassword = "";
	private java.lang.String winrmVersion = "";
	private java.lang.Integer winrmPort = new Integer(-1);
	private java.lang.String winrmProtocol = "";
	private java.lang.Integer winrmTimeout = new Integer(-1);
	private java.lang.Integer winrmRetries = new Integer(-1);

	// デバイス
	private ArrayList<NodeDeviceInfo> nodeDeviceInfo;
	private ArrayList<NodeCpuInfo> nodeCpuInfo;
	private ArrayList<NodeMemoryInfo> nodeMemoryInfo;
	private ArrayList<NodeDiskInfo> nodeDiskInfo;
	private ArrayList<NodeNetworkInterfaceInfo> nodeNetworkInterfaceInfo;
	private ArrayList<NodeFilesystemInfo> nodeFilesystemInfo;

	// サーバ仮想化
	private java.lang.String virtualizationNodeType = "";
	private java.lang.String vmManagementNode = "";
	private java.lang.Integer vmIndex = new Integer(-1);
	private java.lang.String vmName = "";
	private java.lang.String virtualizationSolution = "";
	private java.lang.String vmId = "";
	private java.lang.String vmUser = "";
	private java.lang.String vmUserPassword = "";
	private java.lang.String vmProtocol = "";

	// ネットワーク仮想化
	private java.lang.String vNetSwitchType = "";
	private java.lang.String vNetHostNode = "";
	private java.lang.String openFlowDataPathId = "";
	private java.lang.String openFlowCtrlIpAddress = "";

	// ノード変数
	private ArrayList<NodeVariableInfo> nodeVariableInfo;

	// 保守
	private java.lang.String administrator = "";
	private java.lang.String contact = "";

	// 備考
	private ArrayList<NodeNoteInfo> nodeNoteInfo;

	/**
	 * デフォルトコンストラクタ
	 */
	public NodeInfo() {}

	/**
	 * コンストラクタです。
	 * ファシリティIDとファシリティ名は引数で与えます。
	 * ファシリティ種別は1、表示ソート順は100に設定されます。
	 * @param facilityId
	 * @param facilityName
	 */
	public NodeInfo(String facilityId, String facilityName)
	{
		super();

		setFacilityId(facilityId);
		setFacilityName(facilityName);

		/*
		 * デフォルト値
		 */
		// 0 - scope, 1 - node
		setFacilityType(FacilityConstant.TYPE_NODE);

		// 100 - node, 200 - scope
		// 10000 - display_sort_order, 11000 - REGISTERED, 12000 - UNREGISTERED
		setDisplaySortOrder(100);

		/*
		setDescription(description);
		setCreateUserId(createUserId);
		setCreateDatetime(createDatetime);
		setModifyUserId(modifyUserId);
		setModifyDatetime(modifyDatetime);
		 */
	}

	/**
	 * プラットフォームのgetterです。
	 * @return String
	 */
	public java.lang.String getPlatformFamily()
	{
		return this.platformFamily;
	}

	/**
	 * プラットフォームのsetterです。
	 * @param platformFamily
	 */
	public void setPlatformFamily( java.lang.String platformFamily )
	{
		this.platformFamily = platformFamily;
	}

	/**
	 * H/Wのgetterです。
	 * @return String
	 */
	public java.lang.String getHardwareType()
	{
		return this.hardwareType;
	}

	/**
	 * H/Wのsetterです。
	 * @param hardwareType
	 */
	public void setHardwareType( java.lang.String hardwareType )
	{
		this.hardwareType = hardwareType;
	}

	/**
	 * 画面アイコンイメージのgetterです。
	 * @return String
	 */
	public java.lang.String getIconImage()
	{
		return this.iconImage;
	}

	/**
	 * 画面アイコンイメージのsetterです。
	 * @param iconImage
	 */
	public void setIconImage( java.lang.String iconImage )
	{
		this.iconImage = iconImage;
	}

	/**
	 * SNMP->ポート番号のgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getSnmpPort()
	{
		return this.snmpPort;
	}

	/**
	 * SNMP->ポート番号のsetterです。
	 * @param snmpPort
	 */
	public void setSnmpPort( java.lang.Integer snmpPort )
	{
		this.snmpPort = snmpPort;
	}

	/**
	 * SNMP->コミュニティ名のgetterです。
	 * @return String
	 */
	public java.lang.String getSnmpCommunity()
	{
		return this.snmpCommunity;
	}

	/**
	 * SNMP->コミュニティ名のsetterです。
	 * @param snmpCommunity
	 */
	public void setSnmpCommunity( java.lang.String snmpCommunity )
	{
		this.snmpCommunity = snmpCommunity;
	}

	/**
	 * SNMP->バージョンのgetterです。
	 * @return String
	 */
	public java.lang.String getSnmpVersion()
	{
		return this.snmpVersion;
	}

	/**
	 * SNMP->バージョンのsetterです。
	 * @param snmpVersion
	 */
	public void setSnmpVersion( java.lang.String snmpVersion )
	{
		this.snmpVersion = snmpVersion;
	}

	/**
	 * SNMP->SNMP タイムアウトのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getSnmpTimeout()
	{
		return this.snmpTimeout;
	}

	/**
	 * SNMP->SNMP タイムアウトのsetterです。
	 * @param snmpTimeout
	 */
	public void setSnmpTimeout( java.lang.Integer snmpTimeout )
	{
		this.snmpTimeout = snmpTimeout;
	}

	/**
	 * SNMP->SNMP リトライ回数のgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getSnmpRetryCount()
	{
		return this.snmpRetryCount;
	}

	/**
	 * SNMP->SNMP リトライ回数のsetterです。
	 * @param snmpRetryCount
	 */
	public void setSnmpRetryCount( java.lang.Integer snmpRetryCount )
	{
		this.snmpRetryCount = snmpRetryCount;
	}

	/**
	 * SNMP->SNMP プロキシのgetterです。
	 * @return String
	 */
	public java.lang.String getSnmpProxy()
	{
		return this.snmpProxy;
	}

	/**
	 * SNMP->SNMP プロキシのsetterです。
	 * @param snmpProxy
	 */
	public void setSnmpProxy( java.lang.String snmpProxy )
	{
		this.snmpProxy = snmpProxy;
	}

	/**
	 * WBEM->接続ユーザ名のgetterです。
	 * @return String
	 */
	public java.lang.String getWbemUser()
	{
		return this.wbemUser;
	}

	/**
	 * WBEM->接続ユーザ名のsetterです。
	 * @param wbemUser
	 */
	public void setWbemUser( java.lang.String wbemUser )
	{
		this.wbemUser = wbemUser;
	}

	/**
	 * WBEM->接続ユーザパスワードのgetterです。
	 * @return String
	 */
	public java.lang.String getWbemUserPassword()
	{
		return this.wbemUserPassword;
	}

	/**
	 * WBEM->接続ユーザパスワードのsetterです。
	 * @param wbemUserPassword
	 */
	public void setWbemUserPassword( java.lang.String wbemUserPassword )
	{
		this.wbemUserPassword = wbemUserPassword;
	}

	/**
	 * WBEM->WBEM ポート番号のgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getWbemPort()
	{
		return this.wbemPort;
	}

	/**
	 * WBEM->WBEM ポート番号のsetterです。
	 * @param wbemPort
	 */
	public void setWbemPort( java.lang.Integer wbemPort )
	{
		this.wbemPort = wbemPort;
	}

	/**
	 * WBEM->WBEM プロトコルのgetterです。
	 * @return String
	 */
	public java.lang.String getWbemProtocol()
	{
		return this.wbemProtocol;
	}

	/**
	 * WBEM->WBEM プロトコルのsetterです。
	 * @param wbemProtocol
	 */
	public void setWbemProtocol( java.lang.String wbemProtocol )
	{
		this.wbemProtocol = wbemProtocol;
	}

	/**
	 * WBEM->WBEM タイムアウトのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getWbemTimeout()
	{
		return this.wbemTimeout;
	}

	/**
	 * WBEM->WBEM タイムアウトのsetterです。
	 * @param wbemTimeout
	 */
	public void setWbemTimeout( java.lang.Integer wbemTimeout )
	{
		this.wbemTimeout = wbemTimeout;
	}

	/**
	 * WBEM->WBEM リトライ回数のgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getWbemRetryCount()
	{
		return this.wbemRetryCount;
	}

	/**
	 * WBEM->WBEM リトライ回数のsetterです。
	 * @param wbemRetryCount
	 */
	public void setWbemRetryCount( java.lang.Integer wbemRetryCount )
	{
		this.wbemRetryCount = wbemRetryCount;
	}

	/**
	 * WBEMで値取得時に必要となるNameSpaceです。
	 * 現在は固定値を返します。
	 * @return 固定値（root/cimv2）を返す。
	 */
	public String getWbemNameSpace(){
		return "root/cimv2";
	}

	/**
	 * IPアドレスのバージョンのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getIpAddressVersion()
	{
		return this.ipAddressVersion;
	}

	/**
	 * IPアドレスのバージョンのsetterです。
	 * @param ipAddressVersion
	 */
	public void setIpAddressVersion( java.lang.Integer ipAddressVersion )
	{
		this.ipAddressVersion = ipAddressVersion;
	}

	/**
	 * IPv4のアドレスのgetterです。
	 * @return String
	 */
	public java.lang.String getIpAddressV4()
	{
		return this.ipAddressV4;
	}

	/**
	 * IPv4のアドレスのsetterです。
	 * @param ipAddressV4
	 */
	public void setIpAddressV4( java.lang.String ipAddressV4 )
	{
		this.ipAddressV4 = ipAddressV4;
	}

	/**
	 * IPv6のアドレスのgetterです。
	 * @return String
	 */
	public java.lang.String getIpAddressV6()
	{
		return this.ipAddressV6;
	}

	/**
	 * IPv6のアドレスのsetterです。
	 * @param ipAddressV6
	 */
	public void setIpAddressV6( java.lang.String ipAddressV6 )
	{
		this.ipAddressV6 = ipAddressV6;
	}

	/**
	 * ノード名のgetterです。
	 * @return String
	 */
	public java.lang.String getNodeName()
	{
		return this.nodeName;
	}

	/**
	 * ノード名のsetterです。
	 * @param nodeName
	 */
	public void setNodeName( java.lang.String nodeName )
	{
		this.nodeName = nodeName;
	}

	/**
	 * OS名のgetterです。
	 * @return String
	 */
	public java.lang.String getOsName()
	{
		return this.osName;
	}

	/**
	 * OS名のsetterです。
	 * @param osName
	 */
	public void setOsName( java.lang.String osName )
	{
		this.osName = osName;
	}

	/**
	 * OSリリースのgetterです。
	 * @return String
	 */
	public java.lang.String getOsRelease()
	{
		return this.osRelease;
	}

	/**
	 * OSリリースのsetterです。
	 * @param osRelease
	 */
	public void setOsRelease( java.lang.String osRelease )
	{
		this.osRelease = osRelease;
	}

	/**
	 * OSバージョンのgetterです。
	 * @return String
	 */
	public java.lang.String getOsVersion()
	{
		return this.osVersion;
	}

	/**
	 * OSバージョンのgetterです。
	 * @param osVersion
	 */
	public void setOsVersion( java.lang.String osVersion )
	{
		this.osVersion = osVersion;
	}

	/**
	 * 文字セットのgetterです。
	 * @return String
	 */
	public java.lang.String getCharacterSet()
	{
		return this.characterSet;
	}

	/**
	 * 文字セットのsetterです。
	 * @param characterSet
	 */
	public void setCharacterSet( java.lang.String characterSet )
	{
		this.characterSet = characterSet;
	}


	/**
	 * IPMI接続アドレスのgetter
	 * @return ipmiIpAddress
	 */
	public java.lang.String getIpmiIpAddress() {
		return this.ipmiIpAddress;
	}

	/**
	 * IPMI接続アドレスのsetter
	 * @param ipmiIpAddress
	 */
	public void setIpmiIpAddress(java.lang.String ipmiIpAddress) {
		this.ipmiIpAddress = ipmiIpAddress;
	}

	/**
	 * IPMI接続ポートのgetter
	 * @return ipmiPort
	 */
	public java.lang.Integer getIpmiPort() {
		return this.ipmiPort;
	}

	/**
	 * IPMI接続ポートのsetter
	 * @param ipmiPort
	 */
	public void setIpmiPort(java.lang.Integer ipmiPort) {
		this.ipmiPort = ipmiPort;
	}

	/**
	 * IPMI接続ユーザのgetter
	 * @return ipmiUser
	 */
	public java.lang.String getIpmiUser() {
		return this.ipmiUser;
	}

	/**
	 * IPMI接続ユーザのsetter
	 * @param ipmiUser
	 */
	public void setIpmiUser(java.lang.String ipmiUser) {
		this.ipmiUser = ipmiUser;
	}

	/**
	 * IPMI接続ユーザパスワードのgetter
	 * @return ipmiUserPassword
	 */
	public java.lang.String getIpmiUserPassword() {
		return this.ipmiUserPassword;
	}

	/**
	 * IPMI接続ユーザパスワードのsetter
	 * @param ipmiUserPassword
	 */
	public void setIpmiUserPassword(java.lang.String ipmiUserPassword) {
		this.ipmiUserPassword = ipmiUserPassword;
	}

	/**
	 * IPMI接続タイムアウトのgetter
	 * @return ipmiTimeout
	 */
	public java.lang.Integer getIpmiTimeout() {
		return this.ipmiTimeout;
	}

	/**
	 * IPMI接続タイムアウトのsetter
	 * @param ipmiTimeout
	 */
	public void setIpmiTimeout(java.lang.Integer ipmiTimeout) {
		this.ipmiTimeout = ipmiTimeout;
	}

	/**
	 * IPMI接続リトライ回数のgetter
	 * @return ipmiRetries
	 */
	public java.lang.Integer getIpmiRetries() {
		return this.ipmiRetries;
	}

	/**
	 * IPMI接続リトライ回数のsetter
	 * @param ipmiRetries
	 */
	public void setIpmiRetries(java.lang.Integer ipmiRetries) {
		this.ipmiRetries = ipmiRetries;
	}

	/**
	 * IPMI接続プロトコルのgetter
	 * @return ipmiProtocol
	 */
	public java.lang.String getIpmiProtocol() {
		return this.ipmiProtocol;
	}

	/**
	 * IPMI接続プロトコルのsetter
	 * @param ipmiProtocol
	 */
	public void setIpmiProtocol(java.lang.String ipmiProtocol) {
		this.ipmiProtocol = ipmiProtocol;
	}

	/**
	 * IPMI接続レベルのgetter
	 * @return ipmiLevel
	 */
	public java.lang.String getIpmiLevel() {
		return this.ipmiLevel;
	}

	/**
	 * IPMI接続レベルのsetter
	 * @param ipmiLevel
	 */
	public void setIpmiLevel(java.lang.String ipmiLevel) {
		this.ipmiLevel = ipmiLevel;
	}

	/**
	 * WinRM接続ユーザのgetter
	 * @return winrmUser
	 */
	public java.lang.String getWinrmUser() {
		return this.winrmUser;
	}

	/**
	 * WinRM接続ユーザのsetter
	 * @param winrmUser
	 */
	public void setWinrmUser(java.lang.String winrmUser) {
		this.winrmUser = winrmUser;
	}

	/**
	 * WinRM接続ユーザパスワードのgetter
	 * @return winrmUserPassword
	 */
	public java.lang.String getWinrmUserPassword() {
		return this.winrmUserPassword;
	}

	/**
	 * WinRM接続ユーザパスワードのsetter
	 * @param winrmUserPassword
	 */
	public void setWinrmUserPassword(java.lang.String winrmUserPassword) {
		this.winrmUserPassword = winrmUserPassword;
	}

	/**
	 * WinRMバージョンのgetter
	 * @return winrmVersion
	 */
	public java.lang.String getWinrmVersion() {
		return this.winrmVersion;
	}

	/**
	 * WinRMバージョンのsetter
	 * @param winrmVersion
	 */
	public void setWinrmVersion(java.lang.String winrmVersion) {
		this.winrmVersion = winrmVersion;
	}

	/**
	 * WinRM接続ポート番号のgetter
	 * @return winrmPort
	 */
	public java.lang.Integer getWinrmPort() {
		return this.winrmPort;
	}

	/**
	 * WinRM接続ポート番号のsetter
	 * @param winrmPort
	 */
	public void setWinrmPort(java.lang.Integer winrmPort) {
		this.winrmPort = winrmPort;
	}

	/**
	 * WinRM接続プロトコルのgetter
	 * @return winrmProtocol
	 */
	public java.lang.String getWinrmProtocol() {
		return this.winrmProtocol;
	}

	/**
	 * WinRM接続プロトコルのsetter
	 * @param winrmProtocol
	 */
	public void setWinrmProtocol(java.lang.String winrmProtocol) {
		this.winrmProtocol = winrmProtocol;
	}

	/**
	 * WinRM接続タイムアウトのgetter
	 * @return winrmTimeout
	 */
	public java.lang.Integer getWinrmTimeout() {
		return this.winrmTimeout;
	}

	/**
	 * WinRM接続タイムアウトのsetter
	 * @param winrmTimeout
	 */
	public void setWinrmTimeout(java.lang.Integer winrmTimeout) {
		this.winrmTimeout = winrmTimeout;
	}

	/**
	 * WinRM接続リトライ回数のgetter
	 * @return winrmRetries
	 */
	public java.lang.Integer getWinrmRetries() {
		return this.winrmRetries;
	}

	/**
	 * WinRM接続リトライ回数のsetter
	 * @param winrmRetries
	 */
	public void setWinrmRetries(java.lang.Integer winrmRetries) {
		this.winrmRetries = winrmRetries;
	}

	/**
	 * 仮想化->ノード種別のgetterです。
	 * @return String
	 */
	public java.lang.String getVirtualizationNodeType()
	{
		return this.virtualizationNodeType;
	}

	/**
	 * 仮想化->ノード種別のsetterです。
	 * @param virtualizationNodeType
	 */
	public void setVirtualizationNodeType( java.lang.String virtualizationNodeType )
	{
		this.virtualizationNodeType = virtualizationNodeType;
	}

	/**
	 * 管理ノードのgetterです。
	 * @return String
	 */
	public java.lang.String getVmManagementNode()
	{
		return this.vmManagementNode;
	}

	/**
	 * 管理ノードのsetterです。
	 * @param vmManagementNode
	 */
	public void setVmManagementNode( java.lang.String vmManagementNode )
	{
		this.vmManagementNode = vmManagementNode;
	}

	/**
	 * 仮想マシンINDEXのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getVmIndex()
	{
		return this.vmIndex;
	}

	/**
	 * 仮想マシンINDEXのsetterです。
	 * @param vmIndex
	 */
	public void setVmIndex( java.lang.Integer vmIndex )
	{
		this.vmIndex = vmIndex;
	}

	/**
	 * 仮想マシン名のgetterです。
	 * @return String
	 */
	public java.lang.String getVmName()
	{
		return this.vmName;
	}

	/**
	 * 仮想マシン名のsetterです。
	 * @param vmName
	 */
	public void setVmName( java.lang.String vmName )
	{
		this.vmName = vmName;
	}

	/**
	 * 仮想化ソリューションのgetterです。
	 * @return String
	 */
	public java.lang.String getVirtualizationSolution()
	{
		return this.virtualizationSolution;
	}

	/**
	 * 仮想化ソリューションのsetterです。
	 * @param virtualizationSolution
	 */
	public void setVirtualizationSolution( java.lang.String virtualizationSolution )
	{
		this.virtualizationSolution = virtualizationSolution;
	}

	/**
	 * 仮想マシンIDのgetterです。
	 * @return String
	 */
	public java.lang.String getVmId()
	{
		return this.vmId;
	}

	/**
	 * 仮想マシンIDのsetterです。
	 * @param vmId
	 */
	public void setVmId( java.lang.String vmId )
	{
		this.vmId = vmId;
	}

	/**
	 * 仮想化ソフト接続ユーザのgetterです。
	 * @return String
	 */
	public java.lang.String getVmUser()
	{
		return this.vmUser;
	}

	/**
	 * 仮想化ソフト接続ユーザのsetterです。
	 * @param vmUser
	 */
	public void setVmUser( java.lang.String vmUser )
	{
		this.vmUser = vmUser;
	}

	/**
	 * 仮想化ソフト接続ユーザパスワードのgetterです。
	 * @return String
	 */
	public java.lang.String getVmUserPassword()
	{
		return this.vmUserPassword;
	}

	/**
	 * 仮想化ソフト接続ユーザパスワードのsetterです。
	 * @param vmUserPassword
	 */
	public void setVmUserPassword( java.lang.String vmUserPassword )
	{
		this.vmUserPassword = vmUserPassword;
	}

	/**
	 * 仮想化ソフト接続プロトコルのgetterです。
	 * @return String
	 */
	public java.lang.String getVmProtocol()
	{
		return this.vmProtocol;
	}

	/**
	 * 仮想化ソフト接続プロトコルのsetterです。
	 * @param vmProtocol
	 */
	public void setVmProtocol( java.lang.String vmProtocol )
	{
		this.vmProtocol = vmProtocol;
	}

	/**
	 * 仮想スイッチ種別のgetter
	 * @return vNetSwitchType
	 */
	public java.lang.String getvNetSwitchType() {
		return this.vNetSwitchType;
	}

	/**
	 * 仮想スイッチ種別のsetter
	 * @param vNetSwitchType
	 */
	public void setvNetSwitchType(java.lang.String vNetSwitchType) {
		this.vNetSwitchType = vNetSwitchType;
	}

	/**
	 * 仮想スイッチホストノードのgetter
	 * @return vNetHostNode
	 */
	public java.lang.String getvNetHostNode() {
		return this.vNetHostNode;
	}

	/**
	 * 仮想スイッチホストノードのsetter
	 * @param vNetHostNode
	 */
	public void setvNetHostNode(java.lang.String vNetHostNode) {
		this.vNetHostNode = vNetHostNode;
	}

	/**
	 * OpenFlow データパスIDのgetter
	 * @return openFlowDataPathId
	 */
	public java.lang.String getOpenFlowDataPathId() {
		return this.openFlowDataPathId;
	}

	/**
	 * OpenFlow データパスIDのgetter
	 * @param openFlowDataPathId
	 */
	public void setOpenFlowDataPathId(java.lang.String openFlowDataPathId) {
		this.openFlowDataPathId = openFlowDataPathId;
	}

	/**
	 * OpenFlow コントローラIPアドレスのgetter
	 * @return openFlowCtrlIpAddress
	 */
	public java.lang.String getOpenFlowCtrlIpAddress() {
		return this.openFlowCtrlIpAddress;
	}

	/**
	 * OpenFlow コントローラIPアドレスのsetter
	 * @param openFlowCtrlIpAddress
	 */
	public void setOpenFlowCtrlIpAddress(java.lang.String openFlowCtrlIpAddress) {
		this.openFlowCtrlIpAddress = openFlowCtrlIpAddress;
	}


	/**
	 * ノード変数のgetter
	 * @return
	 */
	public ArrayList<NodeVariableInfo> getNodeVariableInfo() {
		return nodeVariableInfo;
	}

	/**
	 * ノード変数のsetter
	 * @param nodeVariableInfo
	 */
	public void setNodeVariableInfo(ArrayList<NodeVariableInfo> nodeVariableInfo) {
		this.nodeVariableInfo = nodeVariableInfo;
	}

	/**
	 * 管理者のgetterです。
	 * @return String
	 */
	public java.lang.String getAdministrator()
	{
		return this.administrator;
	}

	/**
	 * 管理者のsetterです。
	 * @param administrator
	 */
	public void setAdministrator( java.lang.String administrator )
	{
		this.administrator = administrator;
	}

	/**
	 * 連絡先のgetterです。
	 * @return String
	 */
	public java.lang.String getContact()
	{
		return this.contact;
	}

	/**
	 * 連絡先のsetterです。
	 * @param contact
	 */
	public void setContact( java.lang.String contact )
	{
		this.contact = contact;
	}

	@Override
	public String toString()
	{
		StringBuffer str = new StringBuffer("");

		str.append(super.toString());

		str.append('{');

		str.append(
				"platformFamily=" + getPlatformFamily() + " " +
				"hardwareType=" + getHardwareType() + " " +
				"iconImage=" + getIconImage() + " " +

				"ipAddressVersion=" + getIpAddressVersion() + " " +
				"ipAddressV4=" + getIpAddressV4() + " " +
				"ipAddressV6=" + getIpAddressV6() + " " +

				"nodeName=" + getNodeName() + " " +
				"osName=" + getOsName() + " " +
				"osRelease=" + getOsRelease() + " " +
				"osVersion=" + getOsVersion() + " " +
				"characterSet=" + getCharacterSet() + " " +

				"snmpPort=" + getSnmpPort() + " " +
				"snmpCommunity=" + getSnmpCommunity() + " " +
				"snmpVersion=" + getSnmpVersion() + " " +
				"snmpTimeout=" + getSnmpTimeout() + " " +
				"snmpRetryCount=" + getSnmpRetryCount() + " " +
				"snmpProxy=" + getSnmpProxy() + " " +

				"wbemUser=" + getWbemUser() + " " +
				"wbemUserPassword=" + getWbemUserPassword() + " " +
				"wbemPort=" + getWbemPort() + " " +
				"wbemProtocol=" + getWbemProtocol() + " " +
				"wbemTimeout=" + getWbemTimeout() + " " +
				"wbemRetryCount=" + getWbemRetryCount() + " " +

				"ipmiIpAddress=" + getIpmiIpAddress() + " " +
				"ipmiPort=" + getIpmiPort() + " " +
				"ipmiUser=" + getIpmiUser() + " " +
				"ipmiUserPassword=" + getIpmiUserPassword() + " " +
				"ipmiTimeout=" + getIpmiTimeout() + " " +
				"ipmiRetries=" + getIpmiRetries() + " " +
				"ipmiProtocol=" + getIpmiProtocol() + " " +
				"ipmiLevel=" + getIpmiLevel() + " " +

				"virtualizationNodeType=" + getVirtualizationNodeType() + " " +
				"vmManagementNode=" + getVmManagementNode() + " " +
				"vmIndex=" + getVmIndex() + " " +
				"vmName=" + getVmName() + " " +
				"virtualizationSolution=" + getVirtualizationSolution() + " " +
				"vmId=" + getVmId() + " " +
				"vmUser=" + getVmUser() + " " +
				"vmUserPassword=" + getVmUserPassword() + " " +
				"vmProtocol=" + getVmProtocol() + " " +

				"vNetSwitchType=" + getvNetSwitchType() + " " +
				"vNetHostNode=" + getvNetHostNode() + " " +
				"openFlowDataPathId=" + getOpenFlowDataPathId() + " " +
				"openFlowCtrlIpAddress=" + getOpenFlowCtrlIpAddress() + " " +

				"administrator=" + getAdministrator() + " " +
				"contact=" + getContact()
		);
		str.append('}');

		return(str.toString());
	}

	@Override
	public boolean equals( Object pOther )
	{
		if( pOther instanceof NodeInfo )
		{
			NodeInfo lTest = (NodeInfo) pOther;
			boolean lEquals = true;

			lEquals = lEquals && super.equals(pOther);

			// HW
			if( this.platformFamily == null )
			{
				lEquals = lEquals && ( lTest.platformFamily == null );
			}
			else
			{
				lEquals = lEquals && this.platformFamily.equals( lTest.platformFamily );
			}
			if( this.hardwareType == null )
			{
				lEquals = lEquals && ( lTest.hardwareType == null );
			}
			else
			{
				lEquals = lEquals && this.hardwareType.equals( lTest.hardwareType );
			}
			if( this.iconImage == null )
			{
				lEquals = lEquals && ( lTest.iconImage == null );
			}
			else
			{
				lEquals = lEquals && this.iconImage.equals( lTest.iconImage );
			}

			// IP アドレス
			if( this.ipAddressVersion == null )
			{
				lEquals = lEquals && ( lTest.ipAddressVersion == null );
			}
			else
			{
				lEquals = lEquals && this.ipAddressVersion.equals( lTest.ipAddressVersion );
			}
			if( this.ipAddressV4 == null )
			{
				lEquals = lEquals && ( lTest.ipAddressV4 == null );
			}
			else
			{
				lEquals = lEquals && this.ipAddressV4.equals( lTest.ipAddressV4 );
			}
			if( this.ipAddressV6 == null )
			{
				lEquals = lEquals && ( lTest.ipAddressV6 == null );
			}
			else
			{
				lEquals = lEquals && this.ipAddressV6.equals( lTest.ipAddressV6 );
			}
			if( this.nodeName == null )
			{
				lEquals = lEquals && ( lTest.nodeName == null );
			}
			else
			{
				lEquals = lEquals && this.nodeName.equals( lTest.nodeName );
			}

			// OS
			if( this.osName == null )
			{
				lEquals = lEquals && ( lTest.osName == null );
			}
			else
			{
				lEquals = lEquals && this.osName.equals( lTest.osName );
			}
			if( this.osRelease == null )
			{
				lEquals = lEquals && ( lTest.osRelease == null );
			}
			else
			{
				lEquals = lEquals && this.osRelease.equals( lTest.osRelease );
			}
			if( this.osVersion == null )
			{
				lEquals = lEquals && ( lTest.osVersion == null );
			}
			else
			{
				lEquals = lEquals && this.osVersion.equals( lTest.osVersion );
			}
			if( this.characterSet == null )
			{
				lEquals = lEquals && ( lTest.characterSet == null );
			}
			else
			{
				lEquals = lEquals && this.characterSet.equals( lTest.characterSet );
			}

			// SNMP
			if( this.snmpPort == null )
			{
				lEquals = lEquals && ( lTest.snmpPort == null );
			}
			else
			{
				lEquals = lEquals && this.snmpPort.equals( lTest.snmpPort );
			}
			if( this.snmpCommunity == null )
			{
				lEquals = lEquals && ( lTest.snmpCommunity == null );
			}
			else
			{
				lEquals = lEquals && this.snmpCommunity.equals( lTest.snmpCommunity );
			}
			if( this.snmpVersion == null )
			{
				lEquals = lEquals && ( lTest.snmpVersion == null );
			}
			else
			{
				lEquals = lEquals && this.snmpVersion.equals( lTest.snmpVersion );
			}
			if( this.snmpTimeout == null )
			{
				lEquals = lEquals && ( lTest.snmpTimeout == null );
			}
			else
			{
				lEquals = lEquals && this.snmpTimeout.equals( lTest.snmpTimeout );
			}
			if( this.snmpRetryCount == null )
			{
				lEquals = lEquals && ( lTest.snmpRetryCount == null );
			}
			else
			{
				lEquals = lEquals && this.snmpRetryCount.equals( lTest.snmpRetryCount );
			}
			if( this.snmpProxy == null )
			{
				lEquals = lEquals && ( lTest.snmpProxy == null );
			}
			else
			{
				lEquals = lEquals && this.snmpProxy.equals( lTest.snmpProxy );
			}

			// WBEM
			if( this.wbemUser == null )
			{
				lEquals = lEquals && ( lTest.wbemUser == null );
			}
			else
			{
				lEquals = lEquals && this.wbemUser.equals( lTest.wbemUser );
			}
			if( this.wbemUserPassword == null )
			{
				lEquals = lEquals && ( lTest.wbemUserPassword == null );
			}
			else
			{
				lEquals = lEquals && this.wbemUserPassword.equals( lTest.wbemUserPassword );
			}
			if( this.wbemPort == null )
			{
				lEquals = lEquals && ( lTest.wbemPort == null );
			}
			else
			{
				lEquals = lEquals && this.wbemPort.equals( lTest.wbemPort );
			}
			if( this.wbemProtocol == null )
			{
				lEquals = lEquals && ( lTest.wbemProtocol == null );
			}
			else
			{
				lEquals = lEquals && this.wbemProtocol.equals( lTest.wbemProtocol );
			}
			if( this.wbemTimeout == null )
			{
				lEquals = lEquals && ( lTest.wbemTimeout == null );
			}
			else
			{
				lEquals = lEquals && this.wbemTimeout.equals( lTest.wbemTimeout );
			}
			if( this.wbemRetryCount == null )
			{
				lEquals = lEquals && ( lTest.wbemRetryCount == null );
			}
			else
			{
				lEquals = lEquals && this.wbemRetryCount.equals( lTest.wbemRetryCount );
			}

			// IPMI
			if( this.ipmiIpAddress == null )
			{
				lEquals = lEquals && ( lTest.ipmiIpAddress == null );
			}
			else
			{
				lEquals = lEquals && this.ipmiIpAddress.equals( lTest.ipmiIpAddress );
			}
			if( this.ipmiPort == null )
			{
				lEquals = lEquals && ( lTest.ipmiPort == null );
			}
			else
			{
				lEquals = lEquals && this.ipmiPort.equals( lTest.ipmiPort );
			}
			if( this.ipmiUser == null )
			{
				lEquals = lEquals && ( lTest.ipmiUser == null );
			}
			else
			{
				lEquals = lEquals && this.ipmiUser.equals( lTest.ipmiUser );
			}
			if( this.ipmiUserPassword == null )
			{
				lEquals = lEquals && ( lTest.ipmiUserPassword == null );
			}
			else
			{
				lEquals = lEquals && this.ipmiUserPassword.equals( lTest.ipmiUserPassword );
			}
			if( this.ipmiTimeout == null )
			{
				lEquals = lEquals && ( lTest.ipmiTimeout == null );
			}
			else
			{
				lEquals = lEquals && this.ipmiTimeout.equals( lTest.ipmiTimeout );
			}
			if( this.ipmiRetries == null )
			{
				lEquals = lEquals && ( lTest.ipmiRetries == null );
			}
			else
			{
				lEquals = lEquals && this.ipmiRetries.equals( lTest.ipmiRetries );
			}
			if( this.ipmiProtocol == null )
			{
				lEquals = lEquals && ( lTest.ipmiProtocol == null );
			}
			else
			{
				lEquals = lEquals && this.ipmiProtocol.equals( lTest.ipmiProtocol );
			}
			if( this.ipmiLevel == null )
			{
				lEquals = lEquals && ( lTest.ipmiLevel == null );
			}
			else
			{
				lEquals = lEquals && this.ipmiLevel.equals( lTest.ipmiLevel );
			}


			// サーバ仮想化
			if( this.virtualizationNodeType == null )
			{
				lEquals = lEquals && ( lTest.virtualizationNodeType == null );
			}
			else
			{
				lEquals = lEquals && this.virtualizationNodeType.equals( lTest.virtualizationNodeType );
			}
			if( this.vmManagementNode == null )
			{
				lEquals = lEquals && ( lTest.vmManagementNode == null );
			}
			else
			{
				lEquals = lEquals && this.vmManagementNode.equals( lTest.vmManagementNode );
			}
			if( this.vmIndex == null )
			{
				lEquals = lEquals && ( lTest.vmIndex == null );
			}
			else
			{
				lEquals = lEquals && this.vmIndex.equals( lTest.vmIndex );
			}
			if( this.vmName == null )
			{
				lEquals = lEquals && ( lTest.vmName == null );
			}
			else
			{
				lEquals = lEquals && this.vmName.equals( lTest.vmName );
			}
			if( this.virtualizationSolution == null )
			{
				lEquals = lEquals && ( lTest.virtualizationSolution == null );
			}
			else
			{
				lEquals = lEquals && this.virtualizationSolution.equals( lTest.virtualizationSolution );
			}
			if( this.vmId == null )
			{
				lEquals = lEquals && ( lTest.vmId == null );
			}
			else
			{
				lEquals = lEquals && this.vmId.equals( lTest.vmId );
			}
			if( this.vmUser == null )
			{
				lEquals = lEquals && ( lTest.vmUser == null );
			}
			else
			{
				lEquals = lEquals && this.vmUser.equals( lTest.vmUser );
			}
			if( this.vmUserPassword == null )
			{
				lEquals = lEquals && ( lTest.vmUserPassword == null );
			}
			else
			{
				lEquals = lEquals && this.vmUserPassword.equals( lTest.vmUserPassword );
			}
			if( this.vmProtocol == null )
			{
				lEquals = lEquals && ( lTest.vmProtocol == null );
			}
			else
			{
				lEquals = lEquals && this.vmProtocol.equals( lTest.vmProtocol );
			}

			// ネットワーク仮想化
			if( this.vNetSwitchType == null )
			{
				lEquals = lEquals && ( lTest.vNetSwitchType == null );
			}
			else
			{
				lEquals = lEquals && this.vNetSwitchType.equals( lTest.vNetSwitchType );
			}
			if( this.vNetHostNode == null )
			{
				lEquals = lEquals && ( lTest.vNetHostNode == null );
			}
			else
			{
				lEquals = lEquals && this.vNetHostNode.equals( lTest.vNetHostNode );
			}
			if( this.openFlowDataPathId == null )
			{
				lEquals = lEquals && ( lTest.openFlowDataPathId == null );
			}
			else
			{
				lEquals = lEquals && this.openFlowDataPathId.equals( lTest.openFlowDataPathId );
			}
			if( this.openFlowCtrlIpAddress == null )
			{
				lEquals = lEquals && ( lTest.openFlowCtrlIpAddress == null );
			}
			else
			{
				lEquals = lEquals && this.openFlowCtrlIpAddress.equals( lTest.openFlowCtrlIpAddress );
			}

			// 保守
			if( this.administrator == null )
			{
				lEquals = lEquals && ( lTest.administrator == null );
			}
			else
			{
				lEquals = lEquals && this.administrator.equals( lTest.administrator );
			}
			if( this.contact == null )
			{
				lEquals = lEquals && ( lTest.contact == null );
			}
			else
			{
				lEquals = lEquals && this.contact.equals( lTest.contact );
			}

			return lEquals;
		}
		else
		{
			return false;
		}
	}

	@Override
	public int hashCode()
	{
		int result = 17;

		result = 37*result + super.hashCode();

		result = 37*result + ((this.platformFamily != null) ? this.platformFamily.hashCode() : 0);
		result = 37*result + ((this.hardwareType != null) ? this.hardwareType.hashCode() : 0);
		result = 37*result + ((this.iconImage != null) ? this.iconImage.hashCode() : 0);

		result = 37*result + ((this.snmpPort != null) ? this.snmpPort.hashCode() : 0);
		result = 37*result + ((this.snmpCommunity != null) ? this.snmpCommunity.hashCode() : 0);
		result = 37*result + ((this.snmpVersion != null) ? this.snmpVersion.hashCode() : 0);
		result = 37*result + ((this.snmpTimeout != null) ? this.snmpTimeout.hashCode() : 0);
		result = 37*result + ((this.snmpRetryCount != null) ? this.snmpRetryCount.hashCode() : 0);
		result = 37*result + ((this.snmpProxy != null) ? this.snmpProxy.hashCode() : 0);

		result = 37*result + ((this.wbemUser != null) ? this.wbemUser.hashCode() : 0);
		result = 37*result + ((this.wbemUserPassword != null) ? this.wbemUserPassword.hashCode() : 0);
		result = 37*result + ((this.wbemPort != null) ? this.wbemPort.hashCode() : 0);
		result = 37*result + ((this.wbemProtocol != null) ? this.wbemProtocol.hashCode() : 0);
		result = 37*result + ((this.wbemTimeout != null) ? this.wbemTimeout.hashCode() : 0);
		result = 37*result + ((this.wbemRetryCount != null) ? this.wbemRetryCount.hashCode() : 0);

		result = 37*result + ((this.ipAddressVersion != null) ? this.ipAddressVersion.hashCode() : 0);
		result = 37*result + ((this.ipAddressV4 != null) ? this.ipAddressV4.hashCode() : 0);
		result = 37*result + ((this.ipAddressV6 != null) ? this.ipAddressV6.hashCode() : 0);
		result = 37*result + ((this.nodeName != null) ? this.nodeName.hashCode() : 0);

		result = 37*result + ((this.osName != null) ? this.osName.hashCode() : 0);
		result = 37*result + ((this.osRelease != null) ? this.osRelease.hashCode() : 0);
		result = 37*result + ((this.osVersion != null) ? this.osVersion.hashCode() : 0);
		result = 37*result + ((this.characterSet != null) ? this.characterSet.hashCode() : 0);

		result = 37*result + ((this.virtualizationNodeType != null) ? this.virtualizationNodeType.hashCode() : 0);
		result = 37*result + ((this.vmManagementNode != null) ? this.vmManagementNode.hashCode() : 0);
		result = 37*result + ((this.vmIndex != null) ? this.vmIndex.hashCode() : 0);
		result = 37*result + ((this.vmName != null) ? this.vmName.hashCode() : 0);
		result = 37*result + ((this.virtualizationSolution != null) ? this.virtualizationSolution.hashCode() : 0);
		result = 37*result + ((this.vmId != null) ? this.vmId.hashCode() : 0);
		result = 37*result + ((this.vmUser != null) ? this.vmUser.hashCode() : 0);
		result = 37*result + ((this.vmUserPassword != null) ? this.vmUserPassword.hashCode() : 0);
		result = 37*result + ((this.vmProtocol != null) ? this.vmProtocol.hashCode() : 0);

		result = 37*result + ((this.administrator != null) ? this.administrator.hashCode() : 0);
		result = 37*result + ((this.contact != null) ? this.contact.hashCode() : 0);

		return result;
	}

	/**
	 * デバイスのgetter
	 * @return ArrayList<NodeDeviceInfo>
	 */
	public ArrayList<NodeDeviceInfo> getNodeDeviceInfo() {
		return nodeDeviceInfo;
	}

	/**
	 * デバイスのsetter
	 * @param nodeDevice
	 */
	public void setNodeDeviceInfo(ArrayList<NodeDeviceInfo> nodeDeviceInfo) {
		this.nodeDeviceInfo = nodeDeviceInfo;
	}

	/**
	 * CPUのgetter
	 * @return nodeCpuInfo
	 */
	public ArrayList<NodeCpuInfo> getNodeCpuInfo() {
		return this.nodeCpuInfo;
	}

	/**
	 * CPUのsetter
	 * @param nodeCpuInfo
	 */
	public void setNodeCpuInfo(ArrayList<NodeCpuInfo> nodeCpuInfo) {
		this.nodeCpuInfo = nodeCpuInfo;
	}

	/**
	 * メモリのgetter
	 * @return nodeMemoryInfo
	 */
	public ArrayList<NodeMemoryInfo> getNodeMemoryInfo() {
		return this.nodeMemoryInfo;
	}

	/**
	 * メモリのsetter
	 * @param nodeMemoryInfo
	 */
	public void setNodeMemoryInfo(ArrayList<NodeMemoryInfo> nodeMemoryInfo) {
		this.nodeMemoryInfo = nodeMemoryInfo;
	}

	/**
	 * ディスクのgetter
	 * @return nodeDiskInfo
	 */
	public ArrayList<NodeDiskInfo> getNodeDiskInfo() {
		return this.nodeDiskInfo;
	}

	/**
	 * ディスクのsetter
	 * @param nodeDiskInfo
	 */
	public void setNodeDiskInfo(ArrayList<NodeDiskInfo> nodeDiskInfo) {
		this.nodeDiskInfo = nodeDiskInfo;
	}

	/**
	 * NICのgetter
	 * @return nodeNetworkInterfaceInfo
	 */
	public ArrayList<NodeNetworkInterfaceInfo> getNodeNetworkInterfaceInfo() {
		return this.nodeNetworkInterfaceInfo;
	}

	/**
	 * NICのsetter
	 * @param nodeNetworkInterfaceInfo
	 */
	public void setNodeNetworkInterfaceInfo(
			ArrayList<NodeNetworkInterfaceInfo> nodeNetworkInterfaceInfo) {
		this.nodeNetworkInterfaceInfo = nodeNetworkInterfaceInfo;
	}

	/**
	 * ファイルシステムのgetter
	 * @return ArrayList<NodeFilesystemInfo>
	 */
	public ArrayList<NodeFilesystemInfo> getNodeFilesystemInfo() {
		return nodeFilesystemInfo;
	}

	/**
	 * ファイルシステムのsetter
	 * @param nodeFilesystemInfo
	 */
	public void setNodeFilesystemInfo(
			ArrayList<NodeFilesystemInfo> nodeFilesystemInfo) {
		this.nodeFilesystemInfo = nodeFilesystemInfo;
	}

	/**
	 * ノード名のgetter
	 * @return ArrayList<NodeHostnameInfo>
	 */
	public ArrayList<NodeHostnameInfo> getNodeHostnameInfo() {
		return nodeHostnameInfo;
	}

	/**
	 * ノード名のsetter
	 * @param nodeHostnameInfo
	 */
	public void setNodeHostnameInfo(ArrayList<NodeHostnameInfo> nodeHostnameInfo) {
		this.nodeHostnameInfo = nodeHostnameInfo;
	}

	/**
	 * 備考のgetter
	 * @return ArrayList<NodeNoteInfo>
	 */
	public ArrayList<NodeNoteInfo> getNodeNoteInfo() {
		return nodeNoteInfo;
	}

	/**
	 * 備考のsetter
	 * @param nodeNoteInfo
	 */
	public void setNodeNoteInfo(ArrayList<NodeNoteInfo> nodeNoteInfo) {
		this.nodeNoteInfo = nodeNoteInfo;
	}

	/**
	 * 利用可能なIPアドレスを返します。
	 * 
	 * @return 利用可能なIPアドレス
	 * @throws UnknownHostException
	 */
	public String getAvailableIpAddress() {
		// 「IPアドレスのバージョン」により指定されたIPアドレスを設定する。
		Integer ipVersion = getIpAddressVersion();
		String ipAddress = null;
		if(ipVersion != null && ipVersion.intValue() == 6){
			ipAddress = getIpAddressV6();
		} else {
			ipAddress = getIpAddressV4();
		}
		return ipAddress;
	}
}
