/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import com.clustercontrol.repository.ejb.entity.FacilityLocal;

/**
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="Node"
 *    jndi-name="Node"
 *    type="CMP"
 *    view-type="local"
 *    schema="NodeSCHEMA"
 *    cmp-version="2.x"
 *    primkey-field="facilityId"
 *
 * @ejb.persistence
 *    table-name="public.cc_cfg_node"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM NodeSCHEMA as a"
 *    signature="java.util.Collection findAll()"
 * 
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findByIpAddressV4(java.lang.String ipaddr)"
 * 
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM NodeSCHEMA as a WHERE a.ipAddressV4 = ?1"
 *    signature="java.util.Collection findByIpAddressV4(java.lang.String ipaddr)"
 * 
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findByIpAddressV6(java.lang.String ipaddr)"
 * 
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM NodeSCHEMA as a WHERE LCASE(a.ipAddressV6) = LCASE(?1)"
 *    signature="java.util.Collection findByIpAddressV6(java.lang.String ipaddr)"
 * 
 * @ejb.finder
 *   query=""
 *   signature="java.util.Collection findByNodename(java.lang.String nodeName)"
 * 
 * @jboss.query
 *   query="SELECT OBJECT(a) FROM NodeSCHEMA as a WHERE LCASE(a.nodeName) = ?1"
 *   signature="java.util.Collection findByNodename(java.lang.String nodeName)"
 * 
 * @ejb.pk class="java.lang.String"
 * 
 * @ejb.permission
 *    unchecked="true"
 *
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cfg_node"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/

public abstract class NodeBean implements javax.ejb.EntityBean {

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public java.lang.String ejbCreate(java.lang.String facilityId) throws javax.ejb.CreateException {
		// EJB 2.0 spec says return null for CMP ejbCreate methods.
		// TODO: YOU MUST INITIALIZE THE FIELDS FOR THE BEAN HERE.
		// setMyField("Something");
		// begin-user-code

		// Primary Key
		setFacilityId(facilityId);

		//////////////////////////
		// Basic Information
		//////////////////////////
		// HW
		setPlatformFamily("");
		setHardwareType("");
		setIconImage("");

		// Network
		setIpAddressVersion(-1);
		setIpAddressV4("");
		setIpAddressV6("");

		// OS
		setNodeName("");
		setOsName("");
		setOsRelease("");
		setOsVersion("");
		setCharacterSet("");

		//////////////////////////
		// Service
		//////////////////////////

		// SNMP
		setSnmpPort(161);
		setSnmpCommunity("public");
		setSnmpVersion("2c");
		setSnmpTimeout(5000);
		setSnmpRetryCount(3);

		// WBEM
		setWbemPort(5988);
		setWbemUser("root");
		setWbemUserPassword("");
		setWbemProtocol("http");
		setWbemTimeout(5000);
		setWbemRetryCount(3);

		// IPMI
		setIpmiIpAddress("");
		setIpmiPort(0);
		setIpmiUser("root");
		setIpmiUserPassword("");
		setIpmiTimeout(5000);
		setIpmiRetryCount(3);
		setIpmiProtocol("RMCP+");
		setIpmiLevel("");

		// WinRM
		setWinrmUser("Administrator");
		setWinrmUserPassword("");
		setWinrmVersion("");
		setWinrmPort(5985);
		setWinrmProtocol("http");
		setWinrmTimeout(5000);
		setWinrmRetryCount(3);

		//////////////////////////
		// Virtualization
		//////////////////////////
		// Server Virtualization
		setVirtualizationNodeType("");
		setVmManagementNode("");
		setVmIndex(-1);
		setVmName("");
		setVirtualizationSolution("");
		setVmId("");
		setVmUser("");
		setVmUserPassword("");
		setVmProtocol("");

		// Network Virtualization
		setVNetSwitchType("");
		setVNetHostNode("");
		setOpenFlowDatapathId("");
		setOpenFlowCtrlIpAddress("");

		//////////////////////////
		// Maintenance
		//////////////////////////
		setAdministrator("");
		setContact("");

		return null;
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field facilityId
	 *
	 * Returns the facilityId
	 * @return the facilityId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getFacilityId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the facilityId
	 * 
	 * @param java.lang.String the new facilityId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setFacilityId(java.lang.String facilityId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field platformFamily
	 *
	 * Returns the platformFamily
	 * @return the platformFamily
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="platform_family"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getPlatformFamily();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the platformFamily
	 * 
	 * @param java.lang.String the new platformFamily value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setPlatformFamily(java.lang.String platformFamily);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field hardwareType
	 *
	 * Returns the hardwareType
	 * @return the hardwareType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="hardware_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getHardwareType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the hardwareType
	 * 
	 * @param java.lang.String the new hardwareType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setHardwareType(java.lang.String hardwareType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field iconImage
	 *
	 * Returns the iconImage
	 * @return the iconImage
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="icon_image"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getIconImage();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the iconImage
	 * 
	 * @param java.lang.String the new iconImage value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIconImage(java.lang.String iconImage);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpPort
	 *
	 * Returns the snmpPort
	 * @return the snmpPort
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="snmp_port"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getSnmpPort();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpPort
	 * 
	 * @param java.lang.Integer the new snmpPort value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setSnmpPort(java.lang.Integer snmpPort);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpCommunity
	 *
	 * Returns the snmpCommunity
	 * @return the snmpCommunity
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="snmp_community"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getSnmpCommunity();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpCommunity
	 * 
	 * @param java.lang.String the new snmpCommunity value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setSnmpCommunity(java.lang.String snmpCommunity);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpVersion
	 *
	 * Returns the snmpVersion
	 * @return the snmpVersion
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="snmp_version"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(8)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getSnmpVersion();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpVersion
	 * 
	 * @param java.lang.String the new snmpVersion value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setSnmpVersion(java.lang.String snmpVersion);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpTimeout
	 *
	 * Returns the snmpTimeout
	 * @return the snmpTimeout
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="snmp_timeout"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getSnmpTimeout();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpTimeout
	 * 
	 * @param java.lang.Integer the new snmpTimeout value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setSnmpTimeout(java.lang.Integer snmpTimeout);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field snmpRetryCount
	 *
	 * Returns the snmpRetryCount
	 * @return the snmpRetryCount
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="snmp_retry_count"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getSnmpRetryCount();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the snmpRetryCount
	 * 
	 * @param java.lang.Integer the new snmpRetryCount value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setSnmpRetryCount(java.lang.Integer snmpRetryCount);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemUser
	 *
	 * Returns the wbemUser
	 * @return the wbemUser
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="wbem_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getWbemUser();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemUser
	 * 
	 * @param java.lang.String the new wbemUser value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWbemUser(java.lang.String wbemUser);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemUserPassword
	 *
	 * Returns the wbemUserPassword
	 * @return the wbemUserPassword
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="wbem_user_password"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getWbemUserPassword();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemUserPassword
	 * 
	 * @param java.lang.String the new wbemUserPassword value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWbemUserPassword(java.lang.String wbemUserPassword);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemPort
	 *
	 * Returns the wbemPort
	 * @return the wbemPort
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="wbem_port"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getWbemPort();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemPort
	 * 
	 * @param java.lang.Integer the new wbemPort value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWbemPort(java.lang.Integer wbemPort);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemProtocol
	 *
	 * Returns the wbemProtocol
	 * @return the wbemProtocol
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="wbem_protocol"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getWbemProtocol();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemProtocol
	 * 
	 * @param java.lang.String the new wbemProtocol value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWbemProtocol(java.lang.String wbemProtocol);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemTimeout
	 *
	 * Returns the wbemTimeout
	 * @return the wbemTimeout
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="wbem_timeout"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getWbemTimeout();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemTimeout
	 * 
	 * @param java.lang.Integer the new wbemTimeout value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWbemTimeout(java.lang.Integer wbemTimeout);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field wbemRetryCount
	 *
	 * Returns the wbemRetryCount
	 * @return the wbemRetryCount
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="wbem_retry_count"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getWbemRetryCount();


	/**
	 * <!-- begin-user-doc -->
	 * Sets the wbemRetryCount
	 * 
	 * @param java.lang.Integer the new wbemRetryCount value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWbemRetryCount(java.lang.Integer wbemRetryCount);


	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipmiIpAddress
	 *
	 * Returns the ipmiIpAddress
	 * @return the ipmiIpAddress
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ipmi_ip_address"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getIpmiIpAddress();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipmiIpAddress
	 * 
	 * @param java.lang.String the new ipmiIpAddress value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpmiIpAddress(java.lang.String ipmiIpAddress);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipmiPort
	 *
	 * Returns the ipmiPort
	 * @return the ipmiPort
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ipmi_port"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getIpmiPort();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipmiPort
	 * 
	 * @param java.lang.Integer the new ipmiPort value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpmiPort(java.lang.Integer ipmiPort);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipmiUser
	 *
	 * Returns the ipmiUser
	 * @return the ipmiUser
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ipmi_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getIpmiUser();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipmiUser
	 * 
	 * @param java.lang.String the new ipmiUser value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpmiUser(java.lang.String ipmiUser);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipmiUserPassword
	 *
	 * Returns the ipmiUserPassword
	 * @return the ipmiUserPassword
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ipmi_user_password"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getIpmiUserPassword();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipmiUserPassword
	 * 
	 * @param java.lang.String the new ipmiUserPassword value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpmiUserPassword(java.lang.String ipmiUserPassword);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipmiTimeout
	 *
	 * Returns the ipmiTimeout
	 * @return the ipmiTimeout
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ipmi_timeout"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getIpmiTimeout();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipmiTimeout
	 * 
	 * @param java.lang.Integer the new ipmiTimeout value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpmiTimeout(java.lang.Integer ipmiTimeout);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipmiRetryCount
	 *
	 * Returns the ipmiRetryCount
	 * @return the ipmiRetryCount
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ipmi_retry_count"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getIpmiRetryCount();


	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipmiRetryCount
	 * 
	 * @param java.lang.Integer the new ipmiRetryCount value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpmiRetryCount(java.lang.Integer ipmiRetryCount);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipmiProtocol
	 *
	 * Returns the ipmiProtocol
	 * @return the ipmiProtocol
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ipmi_protocol"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getIpmiProtocol();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipmiProtocol
	 * 
	 * @param java.lang.String the new ipmiProtocol value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpmiProtocol(java.lang.String ipmiProtocol);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipmiLevel
	 *
	 * Returns the ipmiLevel
	 * @return the ipmiLevel
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ipmi_level"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getIpmiLevel();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipmiLevel
	 * 
	 * @param java.lang.String the new ipmiLevel value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpmiLevel(java.lang.String ipmiLevel);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipAddressVersion
	 *
	 * Returns the ipAddressVersion
	 * @return the ipAddressVersion
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ip_address_version"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="int2"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getIpAddressVersion();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipAddressVersion
	 * 
	 * @param java.lang.Integer the new ipAddressVersion value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpAddressVersion(java.lang.Integer ipAddressVersion);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipAddressV4
	 *
	 * Returns the ipAddressV4
	 * @return the ipAddressV4
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ip_address_v4"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(16)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getIpAddressV4();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipAddressV4
	 * 
	 * @param java.lang.String the new ipAddressV4 value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpAddressV4(java.lang.String ipAddressV4);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field ipAddressV6
	 *
	 * Returns the ipAddressV6
	 * @return the ipAddressV6
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="ip_address_v6"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(40)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getIpAddressV6();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the ipAddressV6
	 * 
	 * @param java.lang.String the new ipAddressV6 value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setIpAddressV6(java.lang.String ipAddressV6);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field nodeName
	 *
	 * Returns the nodeName
	 * @return the nodeName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="node_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(128)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getNodeName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the nodeName
	 * 
	 * @param java.lang.String the new nodeName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setNodeName(java.lang.String nodeName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field osName
	 *
	 * Returns the osName
	 * @return the osName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="os_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getOsName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the osName
	 * 
	 * @param java.lang.String the new osName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setOsName(java.lang.String osName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field osRelease
	 *
	 * Returns the osRelease
	 * @return the osRelease
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="os_release"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getOsRelease();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the osRelease
	 * 
	 * @param java.lang.String the new osRelease value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setOsRelease(java.lang.String osRelease);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field osVersion
	 *
	 * Returns the osVersion
	 * @return the osVersion
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="os_version"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getOsVersion();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the osVersion
	 * 
	 * @param java.lang.String the new osVersion value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setOsVersion(java.lang.String osVersion);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field characterSet
	 *
	 * Returns the characterSet
	 * @return the characterSet
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="character_set"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(16)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getCharacterSet();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the characterSet
	 * 
	 * @param java.lang.String the new characterSet value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setCharacterSet(java.lang.String characterSet);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field winrmUser
	 *
	 * Returns the winrmUser
	 * @return the winrmUser
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="winrm_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getWinrmUser();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the winrmUser
	 * 
	 * @param java.lang.String the new winrmUser value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWinrmUser(java.lang.String winrmUser);


	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field winrmUserPassword
	 *
	 * Returns the winrmUserPassword
	 * @return the winrmUserPassword
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="winrm_user_password"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getWinrmUserPassword();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the winrmUserPassword
	 * 
	 * @param java.lang.String the new winrmUserPassword value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWinrmUserPassword(java.lang.String winrmUserPassword);


	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field winrmVersion
	 *
	 * Returns the winrmVersion
	 * @return the winrmVersion
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="winrm_version"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(8)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getWinrmVersion();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the winrmVersion
	 * 
	 * @param java.lang.String the new winrmVersion value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWinrmVersion(java.lang.String winrmVersion);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field winrmPort
	 *
	 * Returns the winrmPort
	 * @return the winrmPort
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="winrm_port"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getWinrmPort();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the winrmPort
	 * 
	 * @param java.lang.Integer the new winrmPort value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWinrmPort(java.lang.Integer winrmPort);


	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field winrmProtocol
	 *
	 * Returns the winrmProtocol
	 * @return the winrmProtocol
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="winrm_protocol"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getWinrmProtocol();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the winrmProtocol
	 * 
	 * @param java.lang.String the new winrmProtocol value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWinrmProtocol(java.lang.String winrmProtocol);


	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field winrmTimeout
	 *
	 * Returns the winrmTimeout
	 * @return the winrmTimeout
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="winrm_timeout"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getWinrmTimeout();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the winrmTimeout
	 * 
	 * @param java.lang.Integer the new winrmTimeout value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWinrmTimeout(java.lang.Integer winrmTimeout);


	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field winrmRetryCount
	 *
	 * Returns the winrmRetryCount
	 * @return the winrmRetryCount
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="winrm_retry_count"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getWinrmRetryCount();


	/**
	 * <!-- begin-user-doc -->
	 * Sets the winrmRetryCount
	 * 
	 * @param java.lang.Integer the new winrmRetryCount value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setWinrmRetryCount(java.lang.Integer winrmRetryCount);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field virtualizationNodeType
	 *
	 * Returns the virtualizationNodeType
	 * @return the virtualizationNodeType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="virtualization_node_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVirtualizationNodeType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the virtualizationNodeType
	 * 
	 * @param java.lang.String the new virtualizationNodeType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVirtualizationNodeType(
			java.lang.String virtualizationNodeType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmManagementNode
	 *
	 * Returns the vmManagementNode
	 * @return the vmManagementNode
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="vm_management_node"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVmManagementNode();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmManagementNode
	 * 
	 * @param java.lang.String the new vmManagementNode value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVmManagementNode(java.lang.String vmManagementNode);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmIndex
	 *
	 * Returns the vmIndex
	 * @return the vmIndex
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="vm_index"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.Integer getVmIndex();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmIndex
	 * 
	 * @param java.lang.Integer the new vmIndex value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVmIndex(java.lang.Integer vmIndex);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmName
	 *
	 * Returns the vmName
	 * @return the vmName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="vm_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVmName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmName
	 * 
	 * @param java.lang.String the new vmName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVmName(java.lang.String vmName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field virtualizationSolution
	 *
	 * Returns the virtualizationSolution
	 * @return the virtualizationSolution
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="virtualization_solution"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVirtualizationSolution();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the virtualizationSolution
	 * 
	 * @param java.lang.String the new virtualizationSolution value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVirtualizationSolution(
			java.lang.String virtualizationSolution);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmId
	 *
	 * Returns the vmId
	 * @return the vmId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="vm_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVmId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmId
	 * 
	 * @param java.lang.String the new vmId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVmId(java.lang.String vmId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmUser
	 *
	 * Returns the vmUser
	 * @return the vmUser
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="vm_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVmUser();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmUser
	 * 
	 * @param java.lang.String the new vmUser value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVmUser(java.lang.String vmUser);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmUserPassword
	 *
	 * Returns the vmUserPassword
	 * @return the vmUserPassword
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="vm_user_password"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVmUserPassword();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmUserPassword
	 * 
	 * @param java.lang.String the new vmUserPassword value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVmUserPassword(java.lang.String vmUserPassword);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vmProtocol
	 *
	 * Returns the vmProtocol
	 * @return the vmProtocol
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="vm_protocol"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVmProtocol();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vmProtocol
	 * 
	 * @param java.lang.String the new vmProtocol value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVmProtocol(java.lang.String vmProtocol);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vNetSwitchType
	 *
	 * Returns the vNetSwitchType
	 * @return the vNetSwitchType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="vnet_switch_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVNetSwitchType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vNetSwitchType
	 * 
	 * @param java.lang.String the new vNetSwitchType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVNetSwitchType(
			java.lang.String vNetSwitchType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field vNetHostNode
	 *
	 * Returns the vNetHostNode
	 * @return the vNetHostNode
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="vnet_host_node"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getVNetHostNode();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the vNetHostNode
	 * 
	 * @param java.lang.String the new vNetHostNode value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setVNetHostNode(java.lang.String vNetHostNode);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field openFlowDatapathId
	 *
	 * Returns the openFlowDatapathId
	 * @return the openFlowDatapathId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="openflow_data_path_Id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(1024)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getOpenFlowDatapathId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the openFlowDatapathId
	 * 
	 * @param java.lang.String the new openFlowDatapathId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setOpenFlowDatapathId(java.lang.String openFlowDatapathId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field openFlowCtrlIpAddress
	 *
	 * Returns the openFlowCtrlIpAddress
	 * @return the openFlowCtrlIpAddress
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="openflow_ctrl_ip_address"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(1024)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getOpenFlowCtrlIpAddress();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the openFlowCtrlIpAddress
	 * 
	 * @param java.lang.String the new openFlowCtrlIpAddress value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setOpenFlowCtrlIpAddress(java.lang.String openFlowCtrlIpAddress);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field administrator
	 *
	 * Returns the administrator
	 * @return the administrator
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="administrator"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getAdministrator();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the administrator
	 * 
	 * @param java.lang.String the new administrator value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setAdministrator(java.lang.String administrator);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field contact
	 *
	 * Returns the contact
	 * @return the contact
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="contact"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(1024)"
	 *     read-only="false"
	 * 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getContact();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the contact
	 * 
	 * @param java.lang.String the new contact value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setContact(java.lang.String contact);

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	@Override
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	@Override
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	@Override
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	@Override
	public void ejbRemove() throws RemoveException, EJBException,
	RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	@Override
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	@Override
	public void setEntityContext(EntityContext ctx) throws EJBException,
	RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	@Override
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	 * 
	 */
	public NodeBean() {
		// TODO Auto-generated constructor stub
	}

	//==========================================
	// CMR fields
	//==========================================

	/**
	 * ノードが対応するファシリティエンティティを取得します。<BR>
	 * 
	 * @return ファシリティエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="facility-may-contain-node"
	 *    role-name="NodeToFacility"
	 *    cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	public abstract FacilityLocal getFacility();

	/**
	 * ファシリティエンティティを格納します。<BR>
	 * 
	 * @param facility ファシリティエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setFacility(FacilityLocal facility);

	/**
	 * ノードが保持するホスト名エンティティを取得します。<BR>
	 * 
	 * @return ホスト名エンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-hostname"
	 *    role-name="NodeToHostname"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeHostname();

	/**
	 * ホスト名エンティティを格納します。<BR>
	 * 
	 * @param nodeHostname ホスト名エンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeHostname(java.util.Collection nodeHostname);

	/**
	 * ノードが保持するデバイスエンティティを取得します。<BR>
	 * 
	 * @return デバイスエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-device"
	 *    role-name="NodeToDevice"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeDevice();

	/**
	 * デバイスエンティティを格納します。<BR>
	 * 
	 * @param nodeDevice デバイスエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeDevice(java.util.Collection nodeDevice);

	/**
	 * ノードが保持すCPUエンティティを取得します。<BR>
	 * 
	 * @return CPU配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-cpu"
	 *    role-name="NodeToCpu"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeCpu();

	/**
	 * CPUエンティティを格納します。<BR>
	 * 
	 * @param nodeCpu CPU配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeCpu(java.util.Collection nodeCpu);

	/**
	 * ノードが保持すメモリエンティティを取得します。<BR>
	 * 
	 * @return メモリ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-memory"
	 *    role-name="NodeToMemory"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeMemory();

	/**
	 * メモリエンティティを格納します。<BR>
	 * 
	 * @param nodeMemory メモリ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeMemory(java.util.Collection nodeMemory);

	/**
	 * ノードが保持すDISKエンティティを取得します。<BR>
	 * 
	 * @return DISK配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-disk"
	 *    role-name="NodeToDisk"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeDisk();

	/**
	 * DISKエンティティを格納します。<BR>
	 * 
	 * @param nodeDisk DISK配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeDisk(java.util.Collection nodeDisk);

	/**
	 * ノードが保持すNICエンティティを取得します。<BR>
	 * 
	 * @return NIC配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-nic"
	 *    role-name="NodeToNic"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeNetworkInterface();

	/**
	 * NICエンティティを格納します。<BR>
	 * 
	 * @param nodeNetworkInterface NIC配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeNetworkInterface(java.util.Collection nodeNetworkInterface);

	/**
	 * ノードが保持するファイルシステムエンティティを取得します。<BR>
	 * 
	 * @return ファイルシステムエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-filesystem"
	 *    role-name="NodeToFilesystem"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeFilesystem();

	/**
	 * ファイルシステムエンティティを格納します。<BR>
	 * 
	 * @param nodeFilesystem ファイルシステムエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeFilesystem(java.util.Collection nodeFilesystem);

	/**
	 * ノードが保持するノード変数エンティティを取得します。<BR>
	 * 
	 * @return ファイルシステムエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-variable"
	 *    role-name="NodeToVariable"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeVariable();

	/**
	 * ノード変数エンティティを格納します。<BR>
	 * 
	 * @param nodeVariable ファイルシステムエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeVariable(java.util.Collection nodeVariable);

	/**
	 * ノードが保持する備考エンティティを取得します。<BR>
	 * 
	 * @return 備考エンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-note"
	 *    role-name="NodeToNote"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 */
	@SuppressWarnings("unchecked")
	public abstract java.util.Collection getNodeNote();

	/**
	 * 備考エンティティを格納します。<BR>
	 * 
	 * @param note ファイルシステムエンティティ配列
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	@SuppressWarnings("unchecked")
	public abstract void setNodeNote(java.util.Collection note);
}
