package com.clustercontrol.snmptrap.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;

/**
 * SNMPTRAP監視のキャッシュ
 *
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class SnmpTrapMibMasterCache {
	private static Log m_log = LogFactory.getLog( SnmpTrapMibMasterCache.class );

	private static Object lock = new Object();
	private static ConcurrentHashMap<SnmpTrapMibMasterPK, SnmpTrapMibMasterData> trapMibMstCache = new ConcurrentHashMap<SnmpTrapMibMasterPK, SnmpTrapMibMasterData>();

	static {
		refresh();
	}

	/**
	 * キャッシュのリフレッシュ
	 * このメソッドはsynchronizedの内部で呼ぶこと。
	 */
	private static void refresh(){
		if (trapMibMstCache.isEmpty()) {
			m_log.info("refresh SnmpTrapMibMasterCache");
			try {
				Collection<SnmpTrapMibMasterLocal> c = SnmpTrapMibMasterUtil.getLocalHome().findAll();
				for(SnmpTrapMibMasterLocal local : c){
					SnmpTrapMibMasterData mibData =
						new SnmpTrapMibMasterData(
								local.getMib(),
								local.getOrderNo(),
								local.getDescription(),
								local.getRegDate(),
								local.getUpdateDate(),
								local.getRegUser(),
								local.getUpdateUser());
					trapMibMstCache.put((SnmpTrapMibMasterPK)local.getPrimaryKey(), mibData);
				}
			} catch (Exception e) {
				m_log.error("trapMibMstCache : " + e.getMessage(), e);
			}
		}
	}

	public static void clear() {
		synchronized (lock) {
			trapMibMstCache.clear();
		}
	}

	public static SnmpTrapMibMasterData getMibMasterData(String mib) {
		synchronized(lock) {
			refresh();
			for(SnmpTrapMibMasterPK pk : trapMibMstCache.keySet()){
				if(mib.equals(trapMibMstCache.get(pk).getMib())){
					return trapMibMstCache.get(pk);
				}
			}
			return new SnmpTrapMibMasterData();
		}
	}

	public static ArrayList<String> getMibList(){
		synchronized(lock) {
			refresh();
			ArrayList<String> mibList = new ArrayList<String>();
			for(SnmpTrapMibMasterPK pk : trapMibMstCache.keySet()){
				mibList.add(trapMibMstCache.get(pk).getMib());
			}
			return mibList;
		}
	}
}
