/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.systemlog.service.queue;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.systemlog.SyslogReceiverConfig;
import com.clustercontrol.systemlog.service.MatcherTask;

public class Consumer implements Runnable {
	/** ログ出力のインスタンス  */
	private final static Log _log = LogFactory.getLog(Consumer.class);

	private final Channel _channel;

	private SyslogReceiverConfig _config;

	private long _sleepCount = 0;
	private long _count = 0;

	private ExecutorService _executorService;

	public Consumer(Channel channel, SyslogReceiverConfig config){
		_channel = channel;
		_config = config;

		_executorService = Executors.newFixedThreadPool(
				_config.getThreadPoolSize(),
				new ThreadFactory() {
					private volatile int _count = 0;

					@Override
					public Thread newThread(Runnable r) {
						String threadName = "Consumer-SyslogMatcherTask-" + _count++;
						_log.info("create thread : " + threadName);
						return new Thread(r, threadName);
					}
				}
		);
	}

	@Override
	public void run() {
		_log.info("consumer start.");
		while(true){
			byte[] msgData = _channel.getNextMessage();
			if(msgData == null){
				try {
					_sleepCount++;
					Thread.sleep(500);
				} catch (InterruptedException e) {
					_log.error(e.getMessage(), e);
				}
			} else {
				// スレッドを起動しマッチング処理を行う
				_executorService.execute(new MatcherTask(_config, msgData));
				_count++;
			}
		}
	}
}
