/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons.util;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.IEndpointManager;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.jobmanagement.JobCommandInfo;
import com.clustercontrol.ws.jobmanagement.JobEndStatusInfo;
import com.clustercontrol.ws.jobmanagement.JobEndpoint;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobNotificationsInfo;
import com.clustercontrol.ws.jobmanagement.JobObjectInfo;
import com.clustercontrol.ws.jobmanagement.JobParameterInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TemplateJobUtil {
    private static IEndpointManager endpointManager = Activator.getEndpointManager();
    private static MessageManager messages = MessageManager.getInstance("messages");

    private TemplateJobUtil() {
    }

    private static JobTreeItem getRootJobunitForAccountResource(String jobunitId) throws Exception {
        JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
        JobTreeItem jobTreeItem = endpoint.getJobTree(null, true);
        for (JobTreeItem item1 : jobTreeItem.getChildren()) {
            for (JobTreeItem item2 : item1.getChildren()) {
                if (!jobunitId.equals(item2.getData().getId())) continue;
                return item2;
            }
        }
        return null;
    }

    private static JobTreeItem getTemplateJobRoot(String jobunitId) throws Exception {
        JobTreeItem accountItem = TemplateJobUtil.getRootJobunitForAccountResource(jobunitId);
        if (accountItem != null) {
            return TemplateJobUtil.getTemplateJobRoot(accountItem);
        }
        return null;
    }

    private static JobTreeItem getTemplateJobRoot(JobTreeItem jobunit) throws Exception {
        if (jobunit != null) {
            return TemplateJobUtil.findJobTreeItem(jobunit, "Template");
        }
        return null;
    }

    private static JobTreeItem findJobTreeItem(JobTreeItem srcItem, String targetJobId) {
        if (srcItem != null) {
            for (JobTreeItem childItem : srcItem.getChildren()) {
                if (!targetJobId.equals(childItem.getData().getId())) continue;
                return childItem;
            }
        }
        return null;
    }

    public static void registerJob(String jobunitId, TemplateJobnet jobnet) throws Exception {
        JobTreeItem parentItem = TemplateJobUtil.createDefaultJobnetItem();
        JobInfo parentInfo = parentItem.getData();
        parentInfo.setId(jobnet.getJobnetId());
        parentInfo.setJobunitId(jobunitId);
        parentInfo.setName(jobnet.getJobnetName());
        TemplateJobUtil.setNotifyGroupId(parentInfo.getNotifications(), parentInfo.getJobunitId(), parentInfo.getId());
        parentInfo.setPropertyFull(true);
        TemplateJobOSType osType = jobnet.getOsType();
        StringBuffer scripts = new StringBuffer();
        String scriptPrefix = null;
        if (osType.equals((Object)TemplateJobOSType.windows)) {
            scriptPrefix = "%HINEMOS_AGENT_HOME%\\var\\cloud\\";
        } else if (osType.equals((Object)TemplateJobOSType.unix)) {
            scriptPrefix = "${HINEMOS_AGENT_HOME}/var/cloud/";
        }
        for (TemplateJob tmpJob : jobnet.getJobs()) {
            if (!tmpJob.getCommandType().equals((Object)CommandType.script)) continue;
            scripts.append(" " + tmpJob.getCommand());
            tmpJob.setCommand(scriptPrefix + tmpJob.getCommand());
        }
        TemplateJob downloadJob = new TemplateJob();
        downloadJob.setJobId(jobnet.getJobnetId() + messages.getString("parameter.download_job_id_suffix"));
        downloadJob.setJobName(messages.getString("parameter.script_download_job_name"));
        downloadJob.setBehaviorInFailure(BehaviorInFailure.next);
        if (osType.equals((Object)TemplateJobOSType.windows)) {
            downloadJob.setCommand("java -cp %HINEMOS_AGENT_HOME%\\lib\\HinemosAgent.jar;%HINEMOS_AGENT_HOME%\\lib\\commons-logging-1.1.1.jar;%HINEMOS_AGENT_HOME%\\lib\\AgentWS.jar;%HINEMOS_AGENT_HOME%\\lib\\HinemosCommon.jar com.clustercontrol.agent.download.ScriptsDownload %HINEMOS_AGENT_HOME%\\conf\\Agent.properties" + scripts);
            downloadJob.setExecuteUser(messages.getString("parameter.windows_user"));
        } else if (osType.equals((Object)TemplateJobOSType.unix)) {
            downloadJob.setCommand("java -cp ${HINEMOS_AGENT_HOME}/lib/HinemosAgent.jar:${HINEMOS_AGENT_HOME}/lib/commons-logging-1.1.1.jar:${HINEMOS_AGENT_HOME}/lib/AgentWS.jar:${HINEMOS_AGENT_HOME}/lib/HinemosCommon.jar com.clustercontrol.agent.download.ScriptsDownload ${HINEMOS_AGENT_HOME}/conf/Agent.properties" + scripts);
            downloadJob.setExecuteUser(messages.getString("parameter.linux_user"));
        }
        downloadJob.setSuccessRangeStartValue(0);
        downloadJob.setSuccessRangeEndValue(0);
        JobTreeItem downloadItem = TemplateJobUtil.createJobTreeItem(jobunitId, downloadJob);
        TemplateJobUtil.addChildren(parentItem, downloadItem);
        String precedingJobId = downloadJob.getJobId();
        HashMap<String, String> argMap = new HashMap<String, String>();
        for (TemplateJob tmpJob : jobnet.getJobs()) {
            if (precedingJobId != null) {
                tmpJob.setPrecedingJobId(precedingJobId);
            }
            JobTreeItem tmpItem = TemplateJobUtil.createJobTreeItem(jobunitId, tmpJob);
            TemplateJobUtil.addChildren(parentItem, tmpItem);
            precedingJobId = tmpJob.getJobId();
            if (tmpJob.getArgument() == null || tmpJob.getArgument().isEmpty()) continue;
            argMap.put(tmpJob.jobId, tmpJob.getArgument());
        }
        ArrayList<JobParameterInfo> paramList = new ArrayList<JobParameterInfo>();
        for (Map.Entry entry : argMap.entrySet()) {
            JobParameterInfo param = new JobParameterInfo();
            param.setParamId(jobunitId + "_" + (String)entry.getKey());
            param.setType(Integer.valueOf(1));
            param.setDescription(messages.getString("parameter.job_parameter_description", new Object[]{entry.getKey()}));
            param.setValue((String)entry.getValue());
            paramList.add(param);
        }
        TemplateJobUtil.InternalRegisterJob(jobunitId, parentItem, paramList);
    }

    private static void InternalRegisterJob(String jobunitId, JobTreeItem item, List<JobParameterInfo> paramList) throws Exception {
        JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
        JobTreeItem accountRoot = TemplateJobUtil.getRootJobunitForAccountResource(jobunitId);
        if (accountRoot == null) {
            throw new Exception("target jobunit id:" + jobunitId + " was not found.");
        }
        JobInfo info = endpoint.getJobFull(accountRoot.getData());
        accountRoot.setData(info);
        accountRoot.getData().getParam().addAll(paramList);
        JobTreeItem templateRoot = TemplateJobUtil.getTemplateJobRoot(accountRoot);
        if (templateRoot == null) {
            throw new Exception("target jobunit id:" + jobunitId + " doesn't have \"Template\" jobnet.");
        }
        info = endpoint.getJobFull(templateRoot.getData());
        templateRoot.setData(info);
        TemplateJobUtil.addChildren(templateRoot, item);
        item.getData().setOwnerRoleId(templateRoot.getData().getOwnerRoleId());
        TemplateJobUtil.extendsOwnerRoleId(item);
        TemplateJobUtil.removeTreeParent(accountRoot);
        accountRoot.setParent(null);
        endpoint.registerJobunit(accountRoot);
    }

    private static JobInfo getJobFull(JobInfo jobInfo) throws Exception {
        JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
        return endpoint.getJobFull(jobInfo);
    }

    private static void addChildren(JobTreeItem parent, JobTreeItem child) {
        parent.getChildren().add(child);
        child.setParent(parent);
    }

    private static void removeTreeParent(JobTreeItem item) {
        List children = item.getChildren();
        for (JobTreeItem child : children) {
            child.setParent(null);
            TemplateJobUtil.removeTreeParent(child);
        }
    }

    private static void extendsOwnerRoleId(JobTreeItem item) {
        if (item != null && item.getData() != null && item.getData().getOwnerRoleId() != null && !item.getData().getOwnerRoleId().isEmpty() && item.getChildren() != null) {
            for (JobTreeItem child : item.getChildren()) {
                child.getData().setOwnerRoleId(item.getData().getOwnerRoleId());
                TemplateJobUtil.extendsOwnerRoleId(child);
            }
        }
    }

    private static JobTreeItem createDefaultJobnetItem() {
        JobTreeItem item = new JobTreeItem();
        JobInfo info = new JobInfo();
        info.setWaitRule(TemplateJobUtil.getDefaultWaitRuleInfo());
        info.setType(Integer.valueOf(1));
        List notifications = info.getNotifications();
        notifications.clear();
        notifications.addAll(TemplateJobUtil.getDefaultNotifications());
        List endStatusInfos = info.getEndStatus();
        endStatusInfos.clear();
        endStatusInfos.addAll(TemplateJobUtil.getJobEndStatusInfos());
        item.setData(info);
        return item;
    }

    private static JobTreeItem createDefaultJobItem() {
        JobTreeItem item = new JobTreeItem();
        JobInfo info = new JobInfo();
        info.setWaitRule(TemplateJobUtil.getDefaultWaitRuleInfo());
        info.setType(Integer.valueOf(2));
        info.setCommand(TemplateJobUtil.getDefaultCommandInfo());
        List notifications = info.getNotifications();
        notifications.clear();
        notifications.addAll(TemplateJobUtil.getDefaultNotifications());
        List endStatusInfos = info.getEndStatus();
        endStatusInfos.clear();
        endStatusInfos.addAll(TemplateJobUtil.getJobEndStatusInfos());
        item.setData(info);
        return item;
    }

    private static JobWaitRuleInfo getDefaultWaitRuleInfo() {
        JobWaitRuleInfo jobWaitRuleInfo = new JobWaitRuleInfo();
        jobWaitRuleInfo.setSuspend(Integer.valueOf(0));
        jobWaitRuleInfo.setSkip(Integer.valueOf(0));
        jobWaitRuleInfo.setSkipEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setCondition(Integer.valueOf(0));
        jobWaitRuleInfo.setEndCondition(Integer.valueOf(0));
        jobWaitRuleInfo.setEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setCalendar(Integer.valueOf(0));
        jobWaitRuleInfo.setCalendarEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelay(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelaySession(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelaySessionValue(Integer.valueOf(1));
        jobWaitRuleInfo.setStartDelayTime(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayConditionType(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayNotify(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayOperation(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayOperationEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelay(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelaySession(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelaySessionValue(Integer.valueOf(1));
        jobWaitRuleInfo.setEndDelayJob(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayJobValue(Integer.valueOf(1));
        jobWaitRuleInfo.setEndDelayTime(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayConditionType(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayNotify(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayOperation(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayOperationEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setSkipEndStatus(Integer.valueOf(0));
        jobWaitRuleInfo.setEndStatus(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayNotifyPriority(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayOperationType(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayNotifyPriority(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayOperationType(Integer.valueOf(0));
        return jobWaitRuleInfo;
    }

    private static JobCommandInfo getDefaultCommandInfo() {
        JobCommandInfo jobCommandInfo = new JobCommandInfo();
        jobCommandInfo.setFacilityID(SystemParameterConstant.getParamText((String)"FACILITY_ID"));
        jobCommandInfo.setScope("");
        jobCommandInfo.setProcessingMethod(Integer.valueOf(0));
        jobCommandInfo.setStartCommand("");
        jobCommandInfo.setStopCommand("");
        jobCommandInfo.setUser("");
        jobCommandInfo.setErrorEndFlg(Integer.valueOf(YesNoConstant.booleanToType((boolean)true)));
        jobCommandInfo.setErrorEndValue(Integer.valueOf(-1));
        return jobCommandInfo;
    }

    private static List<JobNotificationsInfo> getDefaultNotifications() {
        ArrayList<JobNotificationsInfo> notifications = new ArrayList<JobNotificationsInfo>();
        JobNotificationsInfo infoNormal = null;
        JobNotificationsInfo infoWarning = null;
        JobNotificationsInfo infoAbnormal = null;
        JobNotificationsInfo infoStart = null;
        infoStart = new JobNotificationsInfo();
        infoStart.setType(Integer.valueOf(3));
        infoStart.setPriority(Integer.valueOf(3));
        notifications.add(infoStart);
        infoNormal = new JobNotificationsInfo();
        infoNormal.setType(Integer.valueOf(0));
        infoNormal.setPriority(Integer.valueOf(3));
        notifications.add(infoNormal);
        infoWarning = new JobNotificationsInfo();
        infoWarning.setType(Integer.valueOf(1));
        infoWarning.setPriority(Integer.valueOf(2));
        notifications.add(infoWarning);
        infoAbnormal = new JobNotificationsInfo();
        infoAbnormal.setType(Integer.valueOf(2));
        infoAbnormal.setPriority(Integer.valueOf(0));
        notifications.add(infoAbnormal);
        return notifications;
    }

    private static List<JobEndStatusInfo> getJobEndStatusInfos() {
        ArrayList<JobEndStatusInfo> jobEndStatusInfos = new ArrayList<JobEndStatusInfo>();
        JobEndStatusInfo infoNormal = new JobEndStatusInfo();
        infoNormal.setType(Integer.valueOf(0));
        infoNormal.setValue(Integer.valueOf(0));
        infoNormal.setStartRangeValue(Integer.valueOf(0));
        infoNormal.setEndRangeValue(Integer.valueOf(0));
        jobEndStatusInfos.add(infoNormal);
        JobEndStatusInfo infoWarning = new JobEndStatusInfo();
        infoWarning.setType(Integer.valueOf(1));
        infoWarning.setValue(Integer.valueOf(1));
        infoWarning.setStartRangeValue(Integer.valueOf(1));
        infoWarning.setEndRangeValue(Integer.valueOf(1));
        jobEndStatusInfos.add(infoWarning);
        JobEndStatusInfo infoAbnormal = new JobEndStatusInfo();
        infoAbnormal.setType(Integer.valueOf(2));
        infoAbnormal.setValue(Integer.valueOf(-1));
        jobEndStatusInfos.add(infoAbnormal);
        return jobEndStatusInfos;
    }

    private static void setNotifyGroupId(List<JobNotificationsInfo> notifications, String jobunitId, String jobId) {
        for (JobNotificationsInfo info : notifications) {
            info.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupIdJob((String)jobunitId, (String)jobId, (Integer)0));
        }
    }

    private static JobTreeItem createJobTreeItem(String jobunitId, TemplateJob templateJob) {
        JobTreeItem item = TemplateJobUtil.createDefaultJobItem();
        JobInfo jobInfo = item.getData();
        jobInfo.setJobunitId(jobunitId);
        jobInfo.setId(templateJob.getJobId());
        jobInfo.setName(templateJob.getJobName());
        JobWaitRuleInfo jobWaitRuleInfo = jobInfo.getWaitRule();
        jobWaitRuleInfo.setEndCondition(Integer.valueOf(YesNoConstant.booleanToType((boolean)templateJob.getBehaviorInFailure().isEndJudgementEnabled())));
        jobWaitRuleInfo.setEndValue(templateJob.getBehaviorInFailure().getEndValueInFailure());
        JobCommandInfo jobCommandInfo = jobInfo.getCommand();
        jobCommandInfo.setStartCommand(templateJob.getCommand());
        jobCommandInfo.setStopType(Integer.valueOf(0));
        jobCommandInfo.setStopCommand(messages.getString("parameter.stop_command"));
        jobCommandInfo.setSpecifyUser(Integer.valueOf(1));
        jobCommandInfo.setUser(templateJob.getExecuteUser());
        jobCommandInfo.setErrorEndFlg(Integer.valueOf(YesNoConstant.booleanToType((boolean)true)));
        jobCommandInfo.setErrorEndValue(Integer.valueOf(-1));
        jobCommandInfo.setMessageRetry(Integer.valueOf(10));
        item.getData().setCommand(jobCommandInfo);
        ArrayList<JobEndStatusInfo> jobEndStatusInfos = new ArrayList<JobEndStatusInfo>();
        JobEndStatusInfo infoNormal = new JobEndStatusInfo();
        infoNormal.setType(Integer.valueOf(0));
        infoNormal.setValue(Integer.valueOf(0));
        infoNormal.setStartRangeValue(templateJob.getSuccessRangeStartValue());
        infoNormal.setEndRangeValue(templateJob.getSuccessRangeEndValue());
        jobEndStatusInfos.add(infoNormal);
        JobEndStatusInfo infoWarning = new JobEndStatusInfo();
        infoWarning.setType(Integer.valueOf(1));
        infoWarning.setValue(Integer.valueOf(1));
        infoWarning.setStartRangeValue(templateJob.getSuccessRangeStartValue());
        infoWarning.setEndRangeValue(templateJob.getSuccessRangeEndValue());
        jobEndStatusInfos.add(infoWarning);
        JobEndStatusInfo infoAbnormal = new JobEndStatusInfo();
        infoAbnormal.setType(Integer.valueOf(2));
        infoAbnormal.setValue(Integer.valueOf(-1));
        jobEndStatusInfos.add(infoAbnormal);
        item.getData().getEndStatus().clear();
        item.getData().getEndStatus().addAll(jobEndStatusInfos);
        if (templateJob.getPrecedingJobId() != null && !templateJob.getPrecedingJobId().equals("")) {
            ArrayList<JobObjectInfo> jobObjectInfos = new ArrayList<JobObjectInfo>();
            for (Integer endValueForJudgement : templateJob.behaviorInFailure.getEndValueForJudgement()) {
                JobObjectInfo info = new JobObjectInfo();
                info.setJobId(templateJob.getPrecedingJobId());
                info.setType(Integer.valueOf(1));
                info.setValue(endValueForJudgement);
                jobObjectInfos.add(info);
            }
            item.getData().getWaitRule().getObject().clear();
            item.getData().getWaitRule().getObject().addAll(jobObjectInfos);
            if (templateJob.behaviorInFailure.getEndValueForJudgement().length > 1) {
                item.getData().getWaitRule().setCondition(Integer.valueOf(1));
            }
        }
        if (templateJob.getArgument() != null && !templateJob.getArgument().equals("")) {
            item.getData().getCommand().setStartCommand(item.getData().getCommand().getStartCommand() + " #[" + jobunitId + "_" + templateJob.getJobId() + "]");
        }
        TemplateJobUtil.setNotifyGroupId(item.getData().getNotifications(), jobunitId, templateJob.getJobId());
        item.getData().setPropertyFull(true);
        return item;
    }

    public static List<TemplateJobnet> getTemplateJobList(String jobunitId, Boolean listOnly) throws Exception {
        LinkedList<TemplateJobnet> templateJobs = new LinkedList<TemplateJobnet>();
        JobTreeItem accountRoot = TemplateJobUtil.getTemplateJobRoot(jobunitId);
        if (accountRoot != null) {
            HashMap<String, JobTreeItem> itemMap = new HashMap<String, JobTreeItem>();
            for (JobTreeItem jobnetItem : accountRoot.getChildren()) {
                TemplateJobnet templateJob = new TemplateJobnet();
                templateJob.setJobnetId(jobnetItem.getData().getId());
                templateJob.setJobnetName(jobnetItem.getData().getName());
                itemMap.put(templateJob.getJobnetId(), jobnetItem);
                templateJobs.add(templateJob);
            }
            if (!listOnly.booleanValue()) {
                accountRoot.setData(TemplateJobUtil.getJobFull(accountRoot.getData()));
                HashMap<String, String> paramMap = new HashMap<String, String>();
                for (JobParameterInfo paramInfo : TemplateJobUtil.getJobFull(TemplateJobUtil.getRootJobunitForAccountResource(jobunitId).getData()).getParam()) {
                    paramMap.put(paramInfo.getParamId(), paramInfo.getValue());
                }
                for (TemplateJobnet jobnet : templateJobs) {
                    JobTreeItem item = (JobTreeItem)itemMap.get(jobnet.getJobnetId());
                    LinkedList<TemplateJob> jobs = new LinkedList<TemplateJob>();
                    for (JobTreeItem jobItem : item.getChildren()) {
                        JobInfo jobInfo = TemplateJobUtil.getJobFull(jobItem.getData());
                        TemplateJob job = new TemplateJob();
                        job.setJobId(jobInfo.getId());
                        job.setJobName(jobInfo.getName());
                        job.setCommand(jobInfo.getCommand().getStartCommand());
                        job.setExecuteUser(jobInfo.getCommand().getUser());
                        if (paramMap.containsKey(jobunitId + "_" + job.getJobId())) {
                            job.setArgument((String)paramMap.get(jobunitId + "_" + job.getJobId()));
                        }
                        jobs.add(job);
                    }
                    jobnet.setJobs(jobs);
                }
            }
        }
        return templateJobs;
    }

    public static List<String> getTemplateScripts(String roleId) throws Exception {
        ArrayList<String> scripts = new ArrayList<String>();
        CloudEndpoint endpoint = endpointManager.getEndpoint(CloudEndpoint.class);
        scripts.addAll(endpoint.getTemplateScripts(roleId));
        return scripts;
    }

    public static enum BehaviorInFailure {
        next(new Integer[]{0, -1}, true, -1),
        stop(new Integer[]{0}, true, 0),
        end(new Integer[]{0}, false, null);

        private MessageManager messages = MessageManager.getInstance("messages");
        private final Parameter parameter;

        private BehaviorInFailure(Integer[] endValueForJudgement, Boolean endJudgementEnabled, Integer endValueInFailure) {
            this.parameter = new Parameter(endValueForJudgement, endJudgementEnabled, endValueInFailure);
        }

        public String toString() {
            switch (this) {
                case next: {
                    return this.messages.getString("parameter.behavior_in_failure.next");
                }
                case stop: {
                    return this.messages.getString("parameter.behavior_in_failure.stop");
                }
                case end: {
                    return this.messages.getString("parameter.behavior_in_failure.end");
                }
            }
            throw new IllegalStateException();
        }

        public BehaviorInFailure valueOf(Integer[] endValueForJudgement, Boolean endJudgementEnabled, Integer endValueInFailure) {
            Parameter parameter = new Parameter(endValueForJudgement, endJudgementEnabled, endValueInFailure);
            if (BehaviorInFailure.next.parameter.hashCode() == parameter.hashCode()) {
                return next;
            }
            if (BehaviorInFailure.stop.parameter.hashCode() == parameter.hashCode()) {
                return stop;
            }
            if (BehaviorInFailure.end.parameter.hashCode() == parameter.hashCode()) {
                return end;
            }
            throw new IllegalStateException();
        }

        Integer[] getEndValueForJudgement() {
            return this.parameter.getEndValueForJudgement();
        }

        Boolean isEndJudgementEnabled() {
            return this.parameter.getEndJudgementEnabled();
        }

        Integer getEndValueInFailure() {
            return this.parameter.getEndValueInFailure();
        }

        private static class Parameter {
            private final Integer[] endValueForJudgement;
            private final Boolean endJudgementEnabled;
            private final Integer endValueInFailure;

            public Parameter(Integer[] endValueForJudgement, Boolean endJudgementEnabled, Integer endValueInFailure) {
                this.endValueForJudgement = endValueForJudgement;
                this.endJudgementEnabled = endJudgementEnabled;
                this.endValueInFailure = endValueInFailure;
            }

            public Integer[] getEndValueForJudgement() {
                return this.endValueForJudgement;
            }

            public Boolean getEndJudgementEnabled() {
                return this.endJudgementEnabled;
            }

            public Integer getEndValueInFailure() {
                return this.endValueInFailure;
            }
        }
    }

    public static enum CommandType {
        command,
        script;

    }

    public static enum TemplateJobOSType {
        unix,
        windows;

    }

    public static class TemplateJob {
        private Integer orderNo;
        private String precedingJobId;
        private String jobId;
        private String jobName;
        private CommandType commandType;
        private String command;
        private String argument;
        private String executeUser;
        private BehaviorInFailure behaviorInFailure;
        private Integer successRangeStartValue;
        private Integer successRangeEndValue;

        public void setOrderNo(Integer orderNo) {
            this.orderNo = orderNo;
        }

        public Integer getOrderNo() {
            return this.orderNo;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getJobName() {
            return this.jobName;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public CommandType getCommandType() {
            return this.commandType;
        }

        public void setCommandType(CommandType commandType) {
            this.commandType = commandType;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String getArgument() {
            return this.argument;
        }

        public void setArgument(String argument) {
            this.argument = argument;
        }

        public String getExecuteUser() {
            return this.executeUser;
        }

        public void setExecuteUser(String executeUser) {
            this.executeUser = executeUser;
        }

        public BehaviorInFailure getBehaviorInFailure() {
            return this.behaviorInFailure;
        }

        public void setBehaviorInFailure(BehaviorInFailure behaviorInFailure) {
            this.behaviorInFailure = behaviorInFailure;
        }

        public Integer getSuccessRangeStartValue() {
            return this.successRangeStartValue;
        }

        public void setSuccessRangeStartValue(Integer successRangeStartValue) {
            this.successRangeStartValue = successRangeStartValue;
        }

        public Integer getSuccessRangeEndValue() {
            return this.successRangeEndValue;
        }

        public void setSuccessRangeEndValue(Integer successRangeEndValue) {
            this.successRangeEndValue = successRangeEndValue;
        }

        public void setPrecedingJobId(String precedingJobId) {
            this.precedingJobId = precedingJobId;
        }

        public String getPrecedingJobId() {
            return this.precedingJobId;
        }
    }

    public static class TemplateJobnet {
        private String jobnetId;
        private String jobnetName;
        private TemplateJobOSType osType;
        private List<TemplateJob> jobs;

        public String getJobnetId() {
            return this.jobnetId;
        }

        public void setJobnetId(String jobnetId) {
            this.jobnetId = jobnetId;
        }

        public String getJobnetName() {
            return this.jobnetName;
        }

        public void setJobnetName(String jobnetName) {
            this.jobnetName = jobnetName;
        }

        public TemplateJobOSType getOsType() {
            return this.osType;
        }

        public void setOsType(TemplateJobOSType osType) {
            this.osType = osType;
        }

        public List<TemplateJob> getJobs() {
            return this.jobs;
        }

        public void setJobs(List<TemplateJob> jobs) {
            this.jobs = jobs;
        }
    }
}

