/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.cloud.presenter.ICloudUserManager;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.IFacility;
import com.clustercontrol.cloud.ui.views.AbstractCloudViewPart;
import com.clustercontrol.cloud.ui.views.AccountResourcesView;
import com.clustercontrol.cloud.ui.views.ScopeView;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class CloudUsersView
extends AbstractCloudViewPart
implements ISelectionListener {
    public static final String Id = "com.clustercontrol.cloud.ui.views.CloudUsersView";
    private static MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Table table;
    private TableViewer tableViewer;
    private Label lblHeader;
    private Label lblFooter;
    private ICloudUserManager cloudUserManager;
    private List<ICloudUser> cloudUsers;
    private String headerTitle = bundle_messages.getString("word.account_resource_id") + bundle_messages.getString("caption.title_separator");
    private String footerTitle = bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator");
    private CollectionObserver2<ICloudUser> elementObserver = new CollectionObserver2<ICloudUser>(){

        @Override
        public void elementAdded(CollectionObserver2.ElementAddedEvent<ICloudUser> event) {
            event.getAddedElement().addPropertyObserver2(IElement.allProperty, CloudUsersView.this.propertyObserver);
            CloudUsersView.this.cloudUsers.add(event.getAddedElement());
            CloudUsersView.this.tableViewer.setInput((Object)CloudUsersView.this.cloudUsers);
            CloudUsersView.this.lblFooter.setText(CloudUsersView.this.footerTitle + CloudUsersView.this.cloudUsers.size());
            CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudUsersView.this.tableViewer.refresh(true);
                    ISelection selection = CloudUsersView.this.tableViewer.getSelection();
                    CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(CollectionObserver2.ElementRemovedEvent<ICloudUser> event) {
            event.getRemovedElement().removePropertyObserver2(IElement.allProperty, CloudUsersView.this.propertyObserver);
            CloudUsersView.this.cloudUsers.remove(event.getRemovedElement());
            CloudUsersView.this.tableViewer.setInput((Object)CloudUsersView.this.cloudUsers);
            CloudUsersView.this.lblFooter.setText(CloudUsersView.this.footerTitle + CloudUsersView.this.cloudUsers.size());
            CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudUsersView.this.tableViewer.refresh(true);
                    ISelection selection = CloudUsersView.this.tableViewer.getSelection();
                    CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };
    private AllPropertyObserver propertyObserver = new AllPropertyObserver(){

        @Override
        public void propertyChanged(AllPropertyObserver.ValueChangedEvent event) {
            CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudUsersView.this.tableViewer.refresh(true);
                    ISelection selection = CloudUsersView.this.tableViewer.getSelection();
                    CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(AllPropertyObserver.ElementRemovedEvent event) {
            CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudUsersView.this.tableViewer.refresh(true);
                    ISelection selection = CloudUsersView.this.tableViewer.getSelection();
                    CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementAdded(AllPropertyObserver.ElementAddedEvent event) {
            CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CloudUsersView.this.tableViewer.refresh(true);
                    ISelection selection = CloudUsersView.this.tableViewer.getSelection();
                    CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };

    @Override
    protected void internalCreatePartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        for (final ViewColumn column : ViewColumn.values()) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tcl_composite_1.setColumnData((Widget)tableColumn, (ColumnLayoutData)column.getPixelData());
            tableColumn.setText(column.getLabel());
            tableViewerColumn.setLabelProvider((CellLabelProvider)column.getProvider());
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CloudUsersView.this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter(CloudUsersView.this.tableViewer, column.getProvider()));
                }
            });
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.lblFooter = new Label(composite, 0);
        this.lblFooter.setAlignment(131072);
        this.lblFooter.setSize(this.lblFooter.getSize().x, 80);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblFooter.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        try {
            this.update();
        }
        catch (Throwable e) {
            this.lblFooter.setText(this.footerTitle + 0);
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
            logger.error((Object)e.getMessage(), e);
        }
    }

    private List<ICloudUser> getCloudUsers() {
        if (this.cloudUserManager == null) {
            return new ArrayList<ICloudUser>();
        }
        if (this.cloudUsers == null) {
            try {
                this.cloudUserManager.addPropertyObserver2(ICloudUserManager.p2.cloudUsers, this.elementObserver);
                for (ICloudUser cloudUser : this.cloudUserManager.getCloudUsers()) {
                    cloudUser.addPropertyObserver2(IElement.allProperty, this.propertyObserver);
                }
                this.cloudUsers = new ArrayList<ICloudUser>();
                this.cloudUsers.addAll(Arrays.asList(this.cloudUserManager.getCloudUsers()));
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(CloudUsersView.class);
                logger.warn((Object)"fail to get cloudUsers", (Throwable)e);
                this.cloudUsers = new ArrayList<ICloudUser>();
            }
        }
        return this.cloudUsers;
    }

    public void update() {
        this.changeInput(true);
    }

    private void changeInput(boolean update) {
        if (this.cloudUsers != null) {
            for (ICloudUser cloudUser : this.cloudUsers) {
                cloudUser.removePropertyObserver2(IElement.allProperty, this.propertyObserver);
            }
            this.cloudUsers = null;
        }
        if (this.cloudUserManager != null) {
            this.cloudUserManager.removePropertyObserver2(ICloudUserManager.p2.cloudUsers, this.elementObserver);
            if (update) {
                this.cloudUserManager.update();
            }
        }
        List<ICloudUser> cloudUsers = this.getCloudUsers();
        this.tableViewer.setInput(cloudUsers);
        this.lblFooter.setText(this.footerTitle + cloudUsers.size());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if ((part instanceof ScopeView || part instanceof AccountResourcesView) && selection instanceof IStructuredSelection) {
            if (this.cloudUserManager != null) {
                this.cloudUserManager.removePropertyObserver2(ICloudUserManager.p2.cloudUsers, this.elementObserver);
            }
            this.cloudUserManager = null;
            if (this.cloudUsers != null) {
                this.cloudUsers.clear();
            }
            if (((IStructuredSelection)selection).size() != 1) {
                this.lblHeader.setText(this.headerTitle);
            } else {
                StringBuffer sb = new StringBuffer();
                IAccountResource accountResource = null;
                if (part instanceof ScopeView) {
                    IFacility facility = (IFacility)((IStructuredSelection)selection).getFirstElement();
                    if (facility.getAccountResourceId() != null) {
                        accountResource = AccountControlUtil.getAccountResource(facility.getAccountResourceId());
                    }
                } else if (part instanceof AccountResourcesView) {
                    accountResource = (IAccountResource)((IStructuredSelection)selection).getFirstElement();
                }
                if (accountResource != null) {
                    this.cloudUserManager = accountResource.getCloudUserManager();
                    this.cloudUserManager.addPropertyObserver2(ICloudUserManager.p2.cloudUsers, this.elementObserver);
                    sb.append(accountResource.getAccountResourceId());
                }
                this.lblHeader.setText(this.headerTitle + sb.toString());
            }
            this.changeInput(false);
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    static /* synthetic */ MessageManager access$500() {
        return bundle_messages;
    }

    private static enum ViewColumn {
        cloud_user_id(CloudUsersView.access$500().getString("word.cloud_user_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudUser)element).getCloudUserId();
            }
        }),
        cloud_user_name(CloudUsersView.access$500().getString("word.cloud_user_name"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudUser)element).getCloudUserName();
            }
        }),
        description(CloudUsersView.access$500().getString("word.description"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudUser)element).getDescription();
            }
        }),
        cloud_user_type(CloudUsersView.access$500().getString("word.cloud_user_type"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudUser)element).getCloudUserType();
            }
        }),
        assign_role_id(CloudUsersView.access$500().getString("word.assign_role_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudUser)element).getRoleId();
            }
        }),
        account_resource_id(CloudUsersView.access$500().getString("word.account_resource_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudUser)element).getAccountResourceId();
            }
        }),
        reg_user(CloudUsersView.access$500().getString("word.reg_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudUser)element).getRegUser();
            }
        }),
        reg_date(CloudUsersView.access$500().getString("word.reg_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudUser)element).getRegDate() != null) {
                    return format.format(((ICloudUser)element).getRegDate());
                }
                return "";
            }
        }),
        update_user(CloudUsersView.access$500().getString("word.update_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudUser)element).getUpdateUser();
            }
        }),
        update_date(CloudUsersView.access$500().getString("word.update_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudUser)element).getUpdateDate() != null) {
                    return format.format(((ICloudUser)element).getUpdateDate());
                }
                return "";
            }
        });

        private String label;
        private ColumnLabelProvider provider;
        private ColumnPixelData pixelData;
        private static SimpleDateFormat format;

        private ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider) {
            this.label = label;
            this.pixelData = pixelData;
            this.provider = provider;
        }

        public String getLabel() {
            return this.label;
        }

        public ColumnPixelData getPixelData() {
            return this.pixelData;
        }

        public ColumnLabelProvider getProvider() {
            return this.provider;
        }

        static {
            format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
        }
    }
}

