package com.clustercontrol.cloud.plugin.decorator;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.presenter.ICloudResourceManager;

public class ARDecoratorProvider implements IARDecoratorProvider {
	private static List<IAccountResourceDecorator> decoratorList = null;
	
	private ICloudResourceManager cloudResourceManager; 
	
	public ARDecoratorProvider(ICloudResourceManager cloudResourceManger){
		this.cloudResourceManager = cloudResourceManger;
	}
	
	private void initialize(PluginInfo pluginInfo){
		decoratorList = new ArrayList<>();
		
		IExtensionRegistry registry = Platform.getExtensionRegistry();

		// 拡張ポイントを取得
		IExtensionPoint point = registry.getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName() + "." + pluginInfo.getPluginName());

		for(IExtension extension: point.getExtensions()){
			for(IConfigurationElement element: extension.getConfigurationElements()){
				// 要素名が該当するpluginのIdだった場合、ExtensionTypeの情報を取得
				if(element.getName().equals(pluginInfo.getElementName())){
					try {
						decoratorList.add((IAccountResourceDecorator) element.createExecutableExtension(pluginInfo.getAttributeName()));
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		}
	}
	
	private static class PluginInfo{
		private String pluginName;
		private String elementName;
		private String attributeName;
		public PluginInfo(String pluginName, String elementName, String attributeName){
			this.pluginName = pluginName;
			this.elementName = elementName;
			this.attributeName = attributeName;
		}
		public String getPluginName() {
			return pluginName;
		}
		public String getElementName() {
			return elementName;
		}
		public String getAttributeName() {
			return attributeName;
		}
	}

	@Override
	public ICloudResourceManager getCloudResourceManger() {
		return cloudResourceManager;
	}

	@Override
	public List<IAccountResourceDecorator> getDecoratorList() {
		if(decoratorList == null){
			initialize(new PluginInfo("accountResourceDecoratorPlugin", "account_resource_decorator_plugin", "account_resource_decorator_class"));
		}
		return decoratorList;
	}
}
