package com.clustercontrol.cloud.presenter;

import java.util.Date;

import com.clustercontrol.cloud.commons.util.annotation.Import;

public class CloudService extends Element implements ICloudService {
	private ICloudServiceManager manager;
	private String cloudServiceId;
	private String cloudServiceName;
	private String cloudTypeId;
	private String description;
	private String regUser;
	private Date regDate;
	private String updateUser;
	private Date updateDate;
	
	public CloudService(ICloudServiceManager manager){
		this.manager = manager;
	}
	
	@Override
	public String getCloudServiceId() {
		return cloudServiceId;
	}

	@Override
	public String getCloudServiceName() {
		return cloudServiceName;
	}

	@Override
	public String getCloudTypeId() {
		return cloudTypeId;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public String getRegUser() {
		return regUser;
	}

	@Override
	public Date getRegDate() {
		return regDate;
	}

	@Override
	public String getUpdateUser() {
		return updateUser;
	}

	@Override
	public Date getUpdateDate() {
		return updateDate;
	}

	@Override
	public ICloudServiceManager getCloudServiceManager() {
		return manager;
	}

	@Import
	public void setCloudServiceId(String cloudServiceId) {
		internalSet("cloudServiceId", p2.cloudServiceId, cloudServiceId);
	}

	@Import
	public void setCloudServiceName(String cloudServiceName) {
		internalSet("cloudServiceName", p2.cloudServiceName, cloudServiceName);
	}

	@Import
	public void setCloudTypeId(String cloudTypeId) {
		internalSet("cloudTypeId", p2.cloudTypeId, cloudTypeId);
	}

	@Import
	public void setDescription(String description) {
		internalSet("description", p2.description, description);
	}

//	@Import
	public void setRegUser(String regUser) {
		internalSet("regUser", p2.regUser, regUser);
	}

//	@Import
	public void setRegDate(Date regDate) {
		internalSet("regDate", p2.regDate, regDate);
	}

//	@Import
	public void setUpdateUser(String updateUser) {
		internalSet("updateUser", p2.updateUser, updateUser);
	}

//	@Import
	public void setUpdateDate(Date updateDate) {
		internalSet("updateDate", p2.updateDate, updateDate);
	}

	@Override
	public ICloudService modifyCloudService(ModifyCloudServiceRequest Request) {
		return null;
	}
}