package com.clustercontrol.cloud.presenter;

import java.util.List;

import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.AccountControlUtil.NotFoundAccountResourceException;
//import com.clustercontrol.cloud.commons.util.AccountControlUtil.NotFoundAccountResourceException;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudTemplateManager extends InternalContainer<CloudTemplate, com.clustercontrol.ws.cloud.CloudTemplate> implements ICloudTemplateManager
{
	private AccountResource accountResource;
	
	public CloudTemplateManager(AccountResource accountResource) {
		this.accountResource = accountResource;
	}
	
	@Override
	public CloudTemplate getCloudTemplate(String cloudTemplateId){
		for(CloudTemplate cloudTemplate: getComponents()){
			if(cloudTemplate.getTemplateId().equals(cloudTemplateId)){
				return cloudTemplate;
			}
		}
		return null;
	}
	
	@Override
	public CloudTemplate[] getCloudTemplates() {
		return getComponents().toArray(new CloudTemplate[0]);
	}

	@Override
	public CloudTemplate createCloudTemplate(CreateCloudTemplateRequest createTemplateRequest) {
		com.clustercontrol.ws.cloud.CreateTemplateRequest wsCreateCloudTemplateRequest = new com.clustercontrol.ws.cloud.CreateTemplateRequest();
		ControlUtil.exportObject(createTemplateRequest, wsCreateCloudTemplateRequest);
		try {
			com.clustercontrol.ws.cloud.CloudTemplate reWsCloudTemplate = getEndpoint().addTemplate(getRoleId(), wsCreateCloudTemplateRequest);
			CloudTemplate cloudTemplate = CloudTemplate.createCloudTemplate(this, reWsCloudTemplate);
			getComponents().add(cloudTemplate);
			fireComponentAdded(cloudTemplate);
			return cloudTemplate;
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void removeCloudTemplate(String templateId) {
		try {
			getEndpoint().removeTemplate(getRoleId(), templateId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
		CloudTemplate cloudTemplate = getCloudTemplate(templateId);
		getComponents().remove(cloudTemplate);
		fireComponentRemoved(cloudTemplate);
	}

	@Override
	protected List<com.clustercontrol.ws.cloud.CloudTemplate> getSources() throws CloudModelException {
		try {
			return getEndpoint().getTemplates(getRoleId());
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected CloudTemplate createComponent(com.clustercontrol.ws.cloud.CloudTemplate source) throws CloudModelException {
		CloudTemplate cloudTemplate = new CloudTemplate(this);
		cloudTemplate.overwrite(source);
		return cloudTemplate;
	}

	@Override
	protected void fireComponentAdded(CloudTemplate addedValue) {
		fireElementAdded(p2.cloudTemplates, addedValue);
	}

	@Override
	protected void fireComponentRemoved(CloudTemplate removedValue) {
		fireElementRemoved(p2.cloudTemplates, removedValue);
	}
	
	private CloudEndpoint getEndpoint(){
		return getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
	}
	
	private String getRoleId(){
		try {
			if(AccountControlUtil.isInitializedActiveUser(getAccountResource().getAccountResourceId())){
				return getAccountResource().getActiveUser().getRoleId();
			}
		}
		catch (NotFoundAccountResourceException e) {
		}
		return null;
	}

	@Override
	public AccountResource getAccountResource() {
		return accountResource;
	}
}
