/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IAccountResourceManager;
import com.clustercontrol.cloud.presenter.IElement;


/**
 */
public class AccountResourcesView extends AbstractCloudViewPart {
	public static final String Id = "com.clustercontrol.cloud.ui.views.AccountResourcesView";
	private static MessageManager bundle_messages = MessageManager.getInstance("messages");
	
	private Table table;
	private TableViewer tableViewer;
//	private Label lblHeader;
	private Label lblFooter;
	private IAccountResourceManager accountResourceManager = Activator.getDefault().getCloudResourceManager().getAccountResourceManager();
	private List<IAccountResource> accountResources; 
	private String footerTitle = bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator");
	
	private CollectionObserver2<IAccountResource> elementObserver = new CollectionObserver2<IAccountResource>() {
		@Override
		public void elementAdded(ElementAddedEvent<IAccountResource> event) {
			event.getAddedElement().addPropertyObserver2(IElement.allProperty, propertyObserver);

			accountResources.add(event.getAddedElement());
			tableViewer.setInput(accountResources);

			lblFooter.setText(footerTitle + accountResources.size());

			AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
					AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<IAccountResource> event) {
			event.getRemovedElement().removePropertyObserver2(IElement.allProperty, propertyObserver);

			accountResources.remove(event.getRemovedElement());
			tableViewer.setInput(accountResources);
			
			lblFooter.setText(footerTitle + accountResources.size());

			AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
					AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	private AllPropertyObserver propertyObserver = new AllPropertyObserver() {
		@Override
		public void propertyChanged(ValueChangedEvent event) {
			AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
					AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementRemoved(ElementRemovedEvent event) {
			AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
					AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementAdded(ElementAddedEvent event) {
			AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
					AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	public AccountResourcesView() {
	}
	
 	@Override
	protected void internalCreatePartControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

//		lblHeader = new Label(composite, SWT.NONE);
//		lblHeader.setSize(lblHeader.getSize().x, 80);
//		GridData gridData = new GridData();
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.verticalAlignment = GridData.FILL;
//		lblHeader.setLayoutData(gridData);
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		for(final ViewColumn column: ViewColumn.values()){
			if(!Activator.getDefault().isEnterprisePlugined() && (column.equals(ViewColumn.retention_period) || column.equals(ViewColumn.collect_billing))){
				continue;
			}
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();
			tcl_composite_1.setColumnData(tableColumn, column.getPixelData());
			tableColumn.setText(column.getLabel());
			tableViewerColumn.setLabelProvider(column.getProvider());
			tableColumn.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
				}
			});
		}

		this.getSite().setSelectionProvider(tableViewer);
		
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		lblFooter = new Label(composite, SWT.NONE);
		lblFooter.setAlignment(SWT.RIGHT);
		lblFooter.setSize(lblFooter.getSize().x, 80);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblFooter.setLayoutData(gridData);
		
		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		try {
			update();
		}
		catch (Throwable e) {
			lblFooter.setText(footerTitle + 0);
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);
		}
	}

	private List<IAccountResource> getAccountResources() {
		if (accountResources == null) {
			try {
				accountResourceManager.addPropertyObserver2(IAccountResourceManager.p2.accountResources, elementObserver);
				for (IAccountResource accountResource: accountResourceManager.getAccountResources()) {
					accountResource.addPropertyObserver2(IElement.allProperty, propertyObserver);
				}
				
				accountResources = new ArrayList<IAccountResource>();
				accountResources.addAll(Arrays.asList(accountResourceManager.getAccountResources()));
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(AccountResourcesView.class);
				logger.warn("fail to get accountResources", e);

				accountResources = new ArrayList<IAccountResource>();
			}
		}
		
		return accountResources;
	}
 	
	public void update() {
		if (accountResources != null) {
			for (IAccountResource accountResource: accountResources) {
				accountResource.removePropertyObserver2(IElement.allProperty, propertyObserver);
			}
			accountResources = null;
		}

		if (accountResourceManager != null) {
			accountResourceManager.removePropertyObserver2(IAccountResourceManager.p2.accountResources, elementObserver);
			accountResourceManager.update();
		}

		List<IAccountResource> accountResources = getAccountResources();
		tableViewer.setInput(accountResources);
		lblFooter.setText(footerTitle + accountResources.size());
	}
	
	private enum ViewColumn{
		account_resource_id(
			bundle_messages.getString("word.account_resource_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IAccountResource)element).getAccountResourceId();
				}
			}
		),
		account_resource_name(
			bundle_messages.getString("word.account_resource_name"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IAccountResource)element).getAccountResourceName();
				}
			}
		),
		service_id(
			bundle_messages.getString("word.cloud_service_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IAccountResource)element).getCloudServiceId();
				}
			}
		),
		collect_billing(
			bundle_messages.getString("word.billing_detail_collection"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((IAccountResource)element).getBillingDetailCollectorFlg()){
						return bundle_messages.getString("word.enable");
					} else {
						return bundle_messages.getString("word.disable");
					}
				}
			}
		),
		retention_period(
			bundle_messages.getString("word.retention_period"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((IAccountResource)element).getRetentionPeriod() != null){
						return ((IAccountResource)element).getRetentionPeriod().toString() + bundle_messages.getString("word.days");
					}
					return null;
				}
			}
		),
		reg_user(
			bundle_messages.getString("word.reg_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IAccountResource)element).getRegUser();
				}
			}
		),
		reg_date(
			bundle_messages.getString("word.reg_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((IAccountResource)element).getRegDate() != null){
						return format.format(((IAccountResource)element).getRegDate());
					}
					return "";
				}
			}
		),
		update_user(
			bundle_messages.getString("word.update_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IAccountResource)element).getUpdateUser();
				}
			}
		),
		update_date(
			bundle_messages.getString("word.update_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((IAccountResource)element).getUpdateDate() != null){
						return format.format(((IAccountResource)element).getUpdateDate());
					}
					return "";
				}
			}
		);

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
		private static SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
		
		ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}

	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}
}
