/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.cloud.presenter.ICloudUserManager;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.IFacility;

/**
 */
public class CloudUsersView extends AbstractCloudViewPart implements ISelectionListener {
	public static final String Id = "com.clustercontrol.cloud.ui.views.CloudUsersView";
	private static MessageManager bundle_messages = MessageManager.getInstance("messages");
	
	private Table table;
	private TableViewer tableViewer;
	private Label lblHeader;
	private Label lblFooter;
	private ICloudUserManager cloudUserManager;
	private List<ICloudUser> cloudUsers; 
	private String headerTitle = bundle_messages.getString("word.account_resource_id") + bundle_messages.getString("caption.title_separator");
	private String footerTitle = bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator");
	
	private CollectionObserver2<ICloudUser> elementObserver = new CollectionObserver2<ICloudUser>() {
		@Override
		public void elementAdded(ElementAddedEvent<ICloudUser> event) {
			event.getAddedElement().addPropertyObserver2(IElement.allProperty, propertyObserver);

			cloudUsers.add(event.getAddedElement());
			tableViewer.setInput(cloudUsers);

			lblFooter.setText(footerTitle + cloudUsers.size());

			CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudUsersView.this.tableViewer.getSelection();
					CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<ICloudUser> event) {
			event.getRemovedElement().removePropertyObserver2(IElement.allProperty, propertyObserver);

			cloudUsers.remove(event.getRemovedElement());
			tableViewer.setInput(cloudUsers);
			
			lblFooter.setText(footerTitle + cloudUsers.size());

			CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudUsersView.this.tableViewer.getSelection();
					CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	private AllPropertyObserver propertyObserver = new AllPropertyObserver() {
		@Override
		public void propertyChanged(ValueChangedEvent event) {
			CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudUsersView.this.tableViewer.getSelection();
					CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementRemoved(ElementRemovedEvent event) {
			CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudUsersView.this.tableViewer.getSelection();
					CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementAdded(ElementAddedEvent event) {
			CloudUsersView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudUsersView.this.tableViewer.getSelection();
					CloudUsersView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	public CloudUsersView() {
	}
	
 	@Override
	protected void internalCreatePartControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		lblHeader = new Label(composite, SWT.NONE);
		lblHeader.setSize(lblHeader.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblHeader.setLayoutData(gridData);
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		for(final ViewColumn column: ViewColumn.values()){
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();
			tcl_composite_1.setColumnData(tableColumn, column.getPixelData());
			tableColumn.setText(column.getLabel());
			tableViewerColumn.setLabelProvider(column.getProvider());
			tableColumn.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
				}
			});
		}

		this.getSite().setSelectionProvider(tableViewer);
		
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		lblFooter = new Label(composite, SWT.NONE);
		lblFooter.setAlignment(SWT.RIGHT);
		lblFooter.setSize(lblFooter.getSize().x, 80);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblFooter.setLayoutData(gridData);
		
		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		getSite().getPage().addSelectionListener(this);
		
		try {
			update();
		}
		catch (Throwable e) {
			lblFooter.setText(footerTitle + 0);
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);
		}
	}

	private List<ICloudUser> getCloudUsers() {
		if(cloudUserManager == null){
			return new ArrayList<ICloudUser>();
		}
		
		if (cloudUsers == null) {
			try {
				cloudUserManager.addPropertyObserver2(ICloudUserManager.p2.cloudUsers, elementObserver);
				for (ICloudUser cloudUser: cloudUserManager.getCloudUsers()) {
					cloudUser.addPropertyObserver2(IElement.allProperty, propertyObserver);
				}
				
				cloudUsers = new ArrayList<ICloudUser>();
				cloudUsers.addAll(Arrays.asList(cloudUserManager.getCloudUsers()));
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(CloudUsersView.class);
				logger.warn("fail to get cloudUsers", e);

				cloudUsers = new ArrayList<ICloudUser>();
			}
		}
		
		return cloudUsers;
	}
 	
	public void update() {
		changeInput(true);
	}
 	
	private void changeInput(boolean update) {
		if (cloudUsers != null) {
			for (ICloudUser cloudUser: cloudUsers) {
				cloudUser.removePropertyObserver2(IElement.allProperty, propertyObserver);
			}
			cloudUsers = null;
		}

		if (cloudUserManager != null) {
			cloudUserManager.removePropertyObserver2(ICloudUserManager.p2.cloudUsers, elementObserver);
			if (update) cloudUserManager.update();
		}

		List<ICloudUser> cloudUsers = getCloudUsers();
		tableViewer.setInput(cloudUsers);
		lblFooter.setText(footerTitle + cloudUsers.size());
	}
	
	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if ((part instanceof ScopeView || part instanceof AccountResourcesView) && selection instanceof IStructuredSelection) {
			if (cloudUserManager != null) {
				cloudUserManager.removePropertyObserver2(ICloudUserManager.p2.cloudUsers, elementObserver);
			}
			cloudUserManager = null;
			if(cloudUsers != null){
				cloudUsers.clear();
			}
			if(((IStructuredSelection)selection).size() != 1){
				lblHeader.setText(headerTitle);
			} else {
				StringBuffer sb = new StringBuffer();
				IAccountResource accountResource = null;
				if(part instanceof ScopeView){
					IFacility facility = (IFacility)((IStructuredSelection)selection).getFirstElement();
					if(facility.getAccountResourceId() != null){
						accountResource = AccountControlUtil.getAccountResource(facility.getAccountResourceId());
					}
				} else if(part instanceof AccountResourcesView){
					accountResource = (IAccountResource)((IStructuredSelection)selection).getFirstElement();
				}
				if(accountResource != null){
					cloudUserManager = accountResource.getCloudUserManager();
					cloudUserManager.addPropertyObserver2(ICloudUserManager.p2.cloudUsers, elementObserver);
					sb.append(accountResource.getAccountResourceId());
				}
				lblHeader.setText(headerTitle + sb.toString());
			}
			
			changeInput(false);
		}
	}
	
	private enum ViewColumn{
		cloud_user_id(
			bundle_messages.getString("word.cloud_user_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudUser)element).getCloudUserId();
				}
			}
		),
		cloud_user_name(
			bundle_messages.getString("word.cloud_user_name"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudUser)element).getCloudUserName();
				}
			}
		),
		description(
			bundle_messages.getString("word.description"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudUser)element).getDescription();
				}
			}
		),
		cloud_user_type(
			bundle_messages.getString("word.cloud_user_type"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudUser)element).getCloudUserType();
				}
			}
		),
		assign_role_id(
			bundle_messages.getString("word.assign_role_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudUser)element).getRoleId();
				}
			}
		),
		account_resource_id(
			bundle_messages.getString("word.account_resource_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudUser)element).getAccountResourceId();
				}
			}
		),
		reg_user(
			bundle_messages.getString("word.reg_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudUser)element).getRegUser();
				}
			}
		),
		reg_date(
			bundle_messages.getString("word.reg_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudUser)element).getRegDate() != null){
						return format.format(((ICloudUser)element).getRegDate());
					}
					return "";
				}
			}
		),
		update_user(
			bundle_messages.getString("word.update_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudUser)element).getUpdateUser();
				}
			}
		),
		update_date(
			bundle_messages.getString("word.update_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudUser)element).getUpdateDate() != null){
						return format.format(((ICloudUser)element).getUpdateDate());
					}
					return "";
				}
			}
		);

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
		private static SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
		
		ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}
	
	@Override
	public void dispose() {
		getSite().getPage().removeSelectionListener(this);
		getSite().setSelectionProvider(null);
		super.dispose();
	}

	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}
}
