/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.CloudStorageManager;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.presenter.ICloudStorageManager;
import com.clustercontrol.cloud.presenter.ICloudUser;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CloudStorage;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;


/**
 */
public class StoragesView extends FilterlingViewPartByScopeTree<ICloudStorageManager, ICloudStorage, CloudStorage> implements ISelectionListener {
	public static final String Id = "com.clustercontrol.cloud.ui.views.StoragesView";

	private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
	private static MessageManager bundle_messages = MessageManager.getInstance("messages");
	
	private Label lblHeader;
	private FooterComposite footerComposite;
	private Table table;
	private TableViewer tableViewer;

	public StoragesView() {
	}

	@Override
	protected void internalCreatePartControl(Composite arg0) {
		Composite composite = new Composite(arg0, SWT.NONE);
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		
		lblHeader = new Label(composite, SWT.NONE);
		lblHeader.setSize(lblHeader.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblHeader.setLayoutData(gridData);

		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		for(final ViewColumn column: ViewColumn.values()){
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();
			tcl_composite_1.setColumnData(tableColumn, column.getPixelData());
			tableColumn.setText(column.getLabel());
			tableViewerColumn.setLabelProvider(column.getProvider());
			tableColumn.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
				}
			});
		}
		
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		footerComposite = new FooterComposite(composite, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		footerComposite.setSize(lblHeader.getSize().x, 80);
		footerComposite.setLayoutData(gridData);

		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		getSite().getPage().addSelectionListener(this);
		getSite().setSelectionProvider(tableViewer);

		update();

		getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(
				new Runnable() {
					@Override
					public void run() {
						IViewPart view = getSite().getPage().findView(ScopeView.Id);
						view.getSite().getPage().activate(view);
						view.getSite().getSelectionProvider().setSelection(view.getSite().getSelectionProvider().getSelection());
						getSite().getPage().activate(StoragesView.this);
					}
				});
	}
	
	@Override
	protected ICloudStorageManager getRootElement(IRegion region) {
		return region.getCloudService(ICloudComputeService.class).getStorageManager();
	}
	@Override
	protected List<ICloudStorage> getElements(ICloudStorageManager root) {
		return Arrays.asList(root.getCloudStorages());
	}
	@Override
	protected PropertyId2<CollectionObserver2<ICloudStorage>> getPropertyId() {
		return ICloudStorageManager.p2.cloudStorages;
	}
	@Override
	protected boolean isMatchRegion(IRegion region, ICloudStorage element) {
		return element.getCloudStorageManager().getRegion() == region;
	}
	@Override
	protected boolean isMatchAvailabilityZone(String zoneName, ICloudStorage element) {
		return zoneName.equals(element.getZone());
	}
	@Override
	protected boolean isMatchFacilityId(String facilityId, ICloudStorage element) {
		return facilityId.equals(element.getFacilityId());
	}
	@Override
	protected Label getHeaderLabel() {
		return lblHeader;
	}
	@Override
	protected Label getLeftFooter() {
		return footerComposite.getLeftControl();
	}
	@Override
	protected Label getRightFooter() {
		return footerComposite.getRightControl();
	}
	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}
	@Override
	protected List<CloudStorage> getManagerElements(CloudEndpoint endpoint, IRegion region)  throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception {
		IAccountResource accountResource = region.getAccountResource();
		ICloudUser cloudUser = null;
		cloudUser = accountResource.getActiveUser();
		String roleId = cloudUser.getRoleId();
		String regionId = region.getRegion();
		return endpoint.getStoragesByRegion(roleId, regionId);
	}
	@Override
	protected void setManagerElements(ICloudStorageManager rootElement, List<CloudStorage> managerElements) {
		((CloudStorageManager)rootElement).internalUpdate(managerElements);
	}
	@Override
	protected boolean isInitialized(ICloudStorageManager rootElement) {
		return ((CloudStorageManager)rootElement).isInitialized();
	}
	@Override
	protected ThreadPoolExecutor getExecutor() {
		return threadPool;
	}
	


	private enum ViewColumn{
		storage_id(
			bundle_messages.getString("word.storage_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getStorageId();
				}
			}
		),
		storage_name(
			bundle_messages.getString("word.storage_name"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getStorageName();
				}
			}
		),
		cloud_type_id(
			bundle_messages.getString("word.cloud_type_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getCloudTypeId();
				}
			}
		),
		state(
			bundle_messages.getString("word.state"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getState();
				}
			}
		),
		attached_instance(
			bundle_messages.getString("word.attached_instance"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					ICloudStorage storage = (ICloudStorage)element;
					if(storage != null && storage.getStorageAttachment() != null){
						return storage.getStorageAttachment().getInstanceId();
					}
					return "";
				}
			}
		),
		volume_type(
			bundle_messages.getString("word.storage_type"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getFlavor();
				}
			}
		),
		facility_id(
			bundle_messages.getString("word.facility_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getFacilityId();
				}
			}
		),
		facility_name(
			bundle_messages.getString("word.facility_name"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getFacilityName();
				}
			}
		),
		size(
			bundle_messages.getString("word.size"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudStorage)element).getSize() != null){
						return ((ICloudStorage)element).getSize().toString();
					}
					return null;
				}
			}
		),
		region(
			bundle_messages.getString("word.region"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getCloudStorageManager().getRegion().getRegionName();
				}
			}
		),
		zone(
			bundle_messages.getString("word.zone"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getZone();
				}
			}
		),
		regist_state(
			bundle_messages.getString("word.regist_state"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getRegistState();
				}
			}
		),
		reg_user(
			bundle_messages.getString("word.reg_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getRegUser();
				}
			}
		),
		reg_date(
			bundle_messages.getString("word.reg_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudStorage)element).getRegDate() != null){
						return format.format(((ICloudStorage)element).getRegDate());
					}
					return "";
				}
			}
		),
		update_user(
			bundle_messages.getString("word.update_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorage)element).getUpdateUser();
				}
			}
		),
		update_date(
			bundle_messages.getString("word.update_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudStorage)element).getUpdateDate() != null){
						return format.format(((ICloudStorage)element).getUpdateDate());
					}
					return "";
				}
			}
		);

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
		private static SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
		
		ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}

	@Override
	public void dispose() {
		getSite().getPage().removeSelectionListener(this);
		getSite().setSelectionProvider(null);
		super.dispose();
	}
}
