/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ModifyAccountResourceRequest;
import com.clustercontrol.cloud.ui.dialogs.EditAccountResourceDialog;
import com.clustercontrol.util.Messages;


public class EditAccountResourceAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditAccountResourceAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgEditAccountResourceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.account_resource", "word.modify"});
	private String msgEditAccountResourceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.account_resource", "word.modify"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		IStructuredSelection selection = (IStructuredSelection) viewPart.getSite().getSelectionProvider().getSelection();
		final IAccountResource accountResource = (IAccountResource) selection.getFirstElement();
		
		EditAccountResourceDialog dialog = new EditAccountResourceDialog(this.viewPart.getSite().getShell());

		dialog.setBehavior(new EditAccountResourceDialog.DialogBehavior(){
			@Override
			public void setupAccountResourceId(Text txtAccountResourceId){
				if(accountResource != null && accountResource.getAccountResourceId() != null){
					txtAccountResourceId.setText(accountResource.getAccountResourceId());
				}
				txtAccountResourceId.setEditable(false);
			}
			@Override
			public void setupAccountResourceName(Text accountResourceName){
				if(accountResource != null && accountResource.getAccountResourceName() != null){
					accountResourceName.setText(accountResource.getAccountResourceName());
				}
			}
			@Override
			public void setupAccountResourceDescription(Text txtAccountResourceDescription) {
				if(accountResource != null && accountResource.getDescription() != null){
					txtAccountResourceDescription.setText(accountResource.getDescription());
				}
			}
			@Override
			public void setupCloudServiceId(Combo cmbCloudServiceId) {
				super.setupCloudServiceId(cmbCloudServiceId);
				if(cmbCloudServiceId.indexOf(accountResource.getCloudServiceId()) != -1){
					cmbCloudServiceId.select(cmbCloudServiceId.indexOf(accountResource.getCloudServiceId()));
				}
				cmbCloudServiceId.setEnabled(false);
			}
		});
		
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgEditAccountResourceConfirm)) {

				EditAccountResourceDialog.DialogOutput output = dialog.getOutput();
				
				ModifyAccountResourceRequest request = new ModifyAccountResourceRequest();
				ControlUtil.importObject(request, accountResource);	
				ControlUtil.importObject(request, output);
				request.setDescription(output.getAccountResourceDescription());
				accountResource.modifyAccountResource(request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgEditAccountResourceResult);
			}
			else {
				return;
			}
		}
	}
}