/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws;

import com.clustercontrol.cloud.CloudManagerBaseService;
import com.clustercontrol.cloud.CloudPlugin;
import com.clustercontrol.cloud.ICloudOption;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.aws.factory.AWSOption;
import com.clustercontrol.cloud.aws.factory.AWSResourceManagement;
import com.clustercontrol.cloud.aws.factory.AWSUserManagement;
import com.clustercontrol.cloud.registry.AbstractObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeVariableInfo;
import com.clustercontrol.ws.aws.AWSOptionEndpointImpl;
import com.clustercontrol.ws.cloud.IWebServiceBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AWSManagerBaseService
extends CloudPlugin {
    public static final String id = "com.clustercontrol.cloud.aws.AWSdManagerBaseService";
    private static AWSManagerBaseService singleton;

    public AWSManagerBaseService() {
        singleton = this;
    }

    public Set<String> getDependency() {
        HashSet<String> set = new HashSet<String>();
        set.add(CloudManagerBaseService.class.getName());
        return set;
    }

    public void create() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("creating " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in creating " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public void activate() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("starting " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in starting " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public void deactivate() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("stopping " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in stopping " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public void destroy() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("destroying " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in destroying " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public static AWSManagerBaseService getSingleton() {
        return singleton;
    }

    public String getPluginId() {
        return id;
    }

    public void initialize() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("initializing " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        ObjectRegistryService.registry().put(ICloudOption.class, (Object)"AWS", AWSOption.class);
        ObjectRegistryService.registry().put(IUserManagement.class, (Object)"AWS", AWSUserManagement.class);
        ObjectRegistryService.registry().put(IResourceManagement.class, (Object)"AWS", AWSResourceManagement.class);
        CloudManagerBaseService.getSingleton().publish("/HinemosWS/AWSOptionEndpoint", (IWebServiceBase)new AWSOptionEndpointImpl());
        IObjectChangedService service = (IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class);
        service.addObjectChangedListener("Node_Instance_Modify", NodeInfo.class, (IObjectChangedListener)new AbstractObjectChangedListener<NodeInfo>(){

            public void preModified(String type, NodeInfo object) throws PluginFault {
                NodeVariableInfo instaceId = null;
                ArrayList variables = object.getNodeVariableInfo();
                for (NodeVariableInfo variable : variables) {
                    if (!variable.getNodeVariableName().equals("CLOUD_AWS_InstanceId")) continue;
                    variable.setNodeVariableValue(object.getCloudResourceId());
                    instaceId = variable;
                    break;
                }
                if (instaceId == null) {
                    ArrayList<NodeVariableInfo> newVariables = new ArrayList<NodeVariableInfo>(variables);
                    newVariables.add(new NodeVariableInfo("CLOUD_AWS_InstanceId", object.getCloudResourceId()));
                    object.setNodeVariableInfo(new ArrayList(newVariables));
                }
            }
        });
        service.addObjectChangedListener("Node_Instance_Add", NodeInfo.class, (IObjectChangedListener)new AbstractObjectChangedListener<NodeInfo>(){

            public void preAdded(String type, NodeInfo object) throws PluginFault {
                object.getNodeVariableInfo().add(new NodeVariableInfo("CLOUD_AWS_InstanceId", object.getCloudResourceId()));
            }
        });
        service.addObjectChangedListener("Node_Instance_Clear", NodeInfo.class, (IObjectChangedListener)new AbstractObjectChangedListener<NodeInfo>(){

            public void preModified(String type, NodeInfo object) throws PluginFault {
                for (NodeVariableInfo var : object.getNodeVariableInfo()) {
                    if (!"CLOUD_AWS_InstanceId".equals(var.getNodeVariableName())) continue;
                    object.getNodeVariableInfo().remove(var);
                    break;
                }
            }
        });
        logger.info((Object)("successful in initializing " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }
}

