/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws;

import com.clustercontrol.cloud.commons.PropValidator;
import com.clustercontrol.cloud.commons.PropertyContract;
import com.clustercontrol.commons.util.HinemosProperties;
import org.apache.log4j.Logger;

public enum AWSOptionPropertyConstants implements PropertyContract
{
    aws_node_ip("hinemos.cloud.aws.node.ip", "public", (PropValidator)new PropValidator.StringValidator(new String[]{"public", "private"})),
    aws_client_config_connectionTimeout("hinemos.cloud.aws.client.config.connectionTimeout", String.valueOf(50000), PropValidator.intValidator),
    aws_client_config_maxConnections("hinemos.cloud.aws.client.config.maxConnections", String.valueOf(50), PropValidator.intValidator),
    aws_client_config_maxErrorRetry("hinemos.cloud.aws.client.config.maxErrorRetry", String.valueOf(3), PropValidator.intValidator),
    aws_client_config_protocol("hinemos.cloud.aws.client.config.protocol", "https"),
    aws_client_config_proxyDomain("hinemos.cloud.aws.client.config.proxyDomain", null),
    aws_client_config_proxyHost("hinemos.cloud.aws.client.config.proxyHost", null),
    aws_client_config_proxyPassword("hinemos.cloud.aws.client.config.proxyPassword", null),
    aws_client_config_proxyPort("hinemos.cloud.aws.client.config.proxyPort", String.valueOf(-1), PropValidator.intValidator),
    aws_client_config_proxyUsername("hinemos.cloud.aws.client.config.proxyUsername", null),
    aws_client_config_proxyWorkstation("hinemos.cloud.aws.client.config.proxyWorkstation", null),
    aws_client_config_socketTimeout("hinemos.cloud.aws.client.config.socketTimeout", String.valueOf(50000), PropValidator.intValidator),
    aws_client_config_userAgent("hinemos.cloud.aws.client.config.userAgent", "");

    public final String id;
    public final String value;
    public final PropValidator validator;

    private AWSOptionPropertyConstants(String id, String value) {
        this.id = id;
        this.value = value;
        this.validator = null;
    }

    private AWSOptionPropertyConstants(String id, String value, PropValidator validator) {
        this.id = id;
        this.value = value;
        this.validator = validator;
    }

    public String value() {
        String prop = HinemosProperties.getProperty((String)this.id, (String)this.value);
        if (this.validator != null) {
            try {
                this.validator.validate(prop);
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(AWSOptionPropertyConstants.class);
                logger.error((Object)(this.id + " is invalid(" + prop + "), using default value(" + this.value + ")."));
                prop = this.value;
            }
        }
        return prop;
    }

    public boolean match(String value) {
        return this.value().equals(value);
    }

    public String defaultValue() {
        return this.value;
    }
}

