/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.factory;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.services.ec2.model.AttachVolumeResult;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.CreateImageResult;
import com.amazonaws.services.ec2.model.CreateSnapshotRequest;
import com.amazonaws.services.ec2.model.CreateSnapshotResult;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.services.ec2.model.CreateVolumeResult;
import com.amazonaws.services.ec2.model.DeleteSnapshotRequest;
import com.amazonaws.services.ec2.model.DeleteVolumeRequest;
import com.amazonaws.services.ec2.model.DeregisterImageRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.DescribeSnapshotsResult;
import com.amazonaws.services.ec2.model.DescribeVolumesRequest;
import com.amazonaws.services.ec2.model.DescribeVolumesResult;
import com.amazonaws.services.ec2.model.DetachVolumeRequest;
import com.amazonaws.services.ec2.model.DetachVolumeResult;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.InstanceAttributeName;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.StopInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.services.ec2.model.VolumeAttachment;
import com.amazonaws.services.ec2.model.VolumeType;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.aws.AWSOptionPropertyConstants;
import com.clustercontrol.cloud.aws.util.AWSConstants;
import com.clustercontrol.cloud.aws.util.AWSErrorCode;
import com.clustercontrol.cloud.aws.util.AWSUtil;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.bean.PlatformKind;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StorageAttachmentStateKind;
import com.clustercontrol.cloud.bean.StorageStateKind;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.bean.Zone;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.cloud.persistence.Transactional;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

@Transactional(value=Transactional.TransactionType.Supported)
public class AWSResourceManagement
implements IResourceManagement,
AWSConstants {
    public static String RT_Instance = "EC2";
    public static String RT_Image = "AMI";
    public static String RT_Storage = "EBSVolume";
    public static String RT_Snapshot = "EBSSnapshot";
    public static String RT_LoadBalancer = "ELB";
    public static String RT_InstanceBackup = "InstanceBackup";
    public static String RT_StorageBackup = "StorageBackup";
    private IResourceManagement.IRegion region;
    private IResourceManagement.ICredential credential;
    private IResourceManagement.IStore store;

    public void setAccessDestination(IResourceManagement.ICredential credential, IResourceManagement.IRegion region) {
        this.region = region;
        this.credential = credential;
    }

    public void setStore(IResourceManagement.IStore store) {
        this.store = store;
    }

    private InstanceStateKind instanceStateKind(String state) {
        for (InstanceStateKind stateKind : InstanceStateKind.values()) {
            if (!stateKind.label().equals(state)) continue;
            return stateKind;
        }
        throw new InternalManagerError();
    }

    public IResourceManagement.ICredential getCledential() {
        return this.credential;
    }

    public IResourceManagement.IRegion getRegion() {
        return this.region;
    }

    public void disconnect() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResourceManagement.Instance createInstance(String name, String flavor, String imageId, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault {
        IResourceManagement.Instance instance;
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        com.amazonaws.services.ec2.model.Instance awsInstance = null;
        boolean success = false;
        try {
            ObjectMapper om = new ObjectMapper();
            ObjectReader or = om.reader(InstanceDetail.class);
            InstanceDetail detail = (InstanceDetail)or.readValue(instanceDetail);
            RunInstancesRequest awsRequest = new RunInstancesRequest().withInstanceType(flavor).withEbsOptimized(detail.ebsOptimized).withSecurityGroupIds(detail.securityGroupIds).withInstanceInitiatedShutdownBehavior(detail.instanceInitiatedShutdownBehavior).withImageId(imageId).withMonitoring(detail.monitoring).withKeyName(detail.keyName).withPlacement(new Placement().withAvailabilityZone(zone)).withDisableApiTermination(detail.disableApiTermination).withSubnetId(detail.subnetId).withMinCount(Integer.valueOf(1)).withMaxCount(Integer.valueOf(1));
            if (detail.rootBlockDevice != null) {
                awsRequest.withBlockDeviceMappings(new BlockDeviceMapping[]{new BlockDeviceMapping().withEbs(new com.amazonaws.services.ec2.model.EbsBlockDevice().withDeleteOnTermination(detail.rootBlockDevice.deleteOnTermination).withIops(detail.rootBlockDevice.iops).withVolumeSize(detail.rootBlockDevice.volumeSize).withVolumeType(detail.rootBlockDevice.volumeType)).withDeviceName("/dev/sda1")});
            } else {
                awsRequest.withBlockDeviceMappings(new BlockDeviceMapping[]{new BlockDeviceMapping().withEbs(new com.amazonaws.services.ec2.model.EbsBlockDevice().withDeleteOnTermination(Boolean.valueOf(true))).withDeviceName("/dev/sda1")});
            }
            RunInstancesResult result = ec2.runInstances(awsRequest);
            Reservation reservation = result.getReservation();
            assert (reservation.getInstances().size() == 1);
            awsInstance = (com.amazonaws.services.ec2.model.Instance)reservation.getInstances().get(0);
            ArrayList<com.amazonaws.services.ec2.model.Tag> awsTags = new ArrayList<com.amazonaws.services.ec2.model.Tag>();
            tags.add(new Tag("Name", name));
            for (int i = 0; i < Math.min(tags.size(), 9); ++i) {
                awsTags.add(new com.amazonaws.services.ec2.model.Tag(tags.get(i).getKey(), tags.get(i).getValue()));
            }
            AWSUtil.addTags(ec2, awsInstance.getInstanceId(), awsTags);
            final IResourceManagement.Instance instance2 = new IResourceManagement.Instance();
            instance2.setResourceType(RT_Instance);
            instance2.setInstanceId(awsInstance.getInstanceId());
            instance2.setName(name);
            instance2.setFlavor(flavor);
            instance2.setZone(awsInstance.getPlacement().getAvailabilityZone());
            instance2.setImageId(imageId);
            instance2.setPlatform(awsInstance.getPlatform() == null ? PlatformKind.linux : PlatformKind.windows);
            instance2.setState(this.instanceStateKind(awsInstance.getState().getName()));
            if (AWSOptionPropertyConstants.aws_node_ip.match("public")) {
                instance2.setHostName(awsInstance.getPublicDnsName());
                instance2.setIpAddress(awsInstance.getPublicIpAddress());
            } else {
                instance2.setHostName(awsInstance.getPrivateDnsName());
                instance2.setIpAddress(awsInstance.getPrivateIpAddress());
            }
            ArrayList<IResourceManagement.Instance.BlockDeviceMapping> blockDeviceMappings = new ArrayList<IResourceManagement.Instance.BlockDeviceMapping>();
            for (InstanceBlockDeviceMapping awsBlock : awsInstance.getBlockDeviceMappings()) {
                if (awsBlock.getEbs() == null) continue;
                blockDeviceMappings.add(new IResourceManagement.Instance.BlockDeviceMapping(awsBlock.getEbs().getVolumeId(), awsBlock.getDeviceName(), awsBlock.getEbs().getStatus()));
            }
            instance2.setBlockDeviceMappings(blockDeviceMappings);
            ArrayList<Tag> cloudTags = new ArrayList<Tag>();
            for (com.amazonaws.services.ec2.model.Tag tag : awsTags) {
                cloudTags.add(new Tag(tag.getKey(), tag.getValue()));
            }
            instance2.setTags(cloudTags);
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                public void rollback() throws TransactionException {
                    try {
                        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(AWSResourceManagement.this.credential, AWSResourceManagement.this.region.getEndpoint("ec2").getLocation());
                        ec2.terminateInstances(new TerminateInstancesRequest().withInstanceIds(new String[]{instance2.getInstanceId()}));
                    }
                    catch (CloudManagerFault e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
            success = true;
            instance = instance2;
            if (success) return instance;
            if (awsInstance == null) return instance;
        }
        catch (AmazonServiceException e) {
            try {
                throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
                catch (Exception e2) {
                    throw new InternalManagerError((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                if (awsInstance == null) throw throwable;
                try {
                    Thread.sleep(1000L);
                    ec2.terminateInstances(new TerminateInstancesRequest().withInstanceIds(new String[]{awsInstance.getInstanceId()}));
                    throw throwable;
                }
                catch (InterruptedException e3) {
                    throw throwable;
                }
                catch (Exception e4) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.warn((Object)e4.getMessage(), (Throwable)e4);
                }
                throw throwable;
            }
        }
        try {
            Thread.sleep(1000L);
            ec2.terminateInstances(new TerminateInstancesRequest().withInstanceIds(new String[]{awsInstance.getInstanceId()}));
            return instance;
        }
        catch (InterruptedException e) {
            return instance;
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return instance;
    }

    public void deleteInstance(String instanceId) throws CloudManagerFault {
        try {
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest().withInstanceIds(new String[]{instanceId});
            ec2.terminateInstances(terminateInstancesRequest);
        }
        catch (AmazonServiceException e) {
            if (!AWSErrorCode.InvalidInstanceID_NotFound.label().equals(e.getErrorCode()) && !AWSErrorCode.OperationNotPermitted.label().equals(e.getErrorCode())) {
                throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
            Logger.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private IResourceManagement.Instance convertInstance(com.amazonaws.services.ec2.model.Instance awsInstance) {
        IResourceManagement.Instance instance = new IResourceManagement.Instance();
        instance.setResourceType(RT_Instance);
        instance.setInstanceId(awsInstance.getInstanceId());
        for (com.amazonaws.services.ec2.model.Tag t : awsInstance.getTags()) {
            if (!"Name".equals(t.getKey())) continue;
            instance.setName(t.getValue());
            break;
        }
        instance.setFlavor(awsInstance.getInstanceType());
        instance.setZone(awsInstance.getPlacement().getAvailabilityZone());
        instance.setImageId(awsInstance.getImageId());
        instance.setPlatform(awsInstance.getPlatform() == null ? PlatformKind.linux : PlatformKind.windows);
        instance.setState(this.instanceStateKind(awsInstance.getState().getName()));
        if (AWSOptionPropertyConstants.aws_node_ip.match("public")) {
            instance.setHostName(awsInstance.getPublicDnsName());
            instance.setIpAddress(awsInstance.getPublicIpAddress());
        } else {
            instance.setHostName(awsInstance.getPrivateDnsName());
            instance.setIpAddress(awsInstance.getPrivateIpAddress());
        }
        ArrayList<IResourceManagement.Instance.BlockDeviceMapping> blockDeviceMappings = new ArrayList<IResourceManagement.Instance.BlockDeviceMapping>();
        for (InstanceBlockDeviceMapping awsBlock : awsInstance.getBlockDeviceMappings()) {
            if (awsBlock.getEbs() == null) continue;
            blockDeviceMappings.add(new IResourceManagement.Instance.BlockDeviceMapping(awsBlock.getEbs().getVolumeId(), awsBlock.getDeviceName(), awsBlock.getEbs().getStatus()));
        }
        instance.setBlockDeviceMappings(blockDeviceMappings);
        ArrayList<Tag> cloudTags = new ArrayList<Tag>();
        for (com.amazonaws.services.ec2.model.Tag tag : awsInstance.getTags()) {
            cloudTags.add(new Tag(tag.getKey(), tag.getValue()));
        }
        instance.setTags(cloudTags);
        return instance;
    }

    public IResourceManagement.Instance getInstance(String instanceId) throws CloudManagerFault {
        com.amazonaws.services.ec2.model.Instance awsInstance;
        try {
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DescribeInstancesRequest request = new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId});
            awsInstance = (com.amazonaws.services.ec2.model.Instance)((Reservation)ec2.describeInstances(request).getReservations().get(0)).getInstances().get(0);
        }
        catch (AmazonServiceException e) {
            if (!AWSErrorCode.InvalidVolume_NotFound.match(e.getErrorCode())) {
                throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
            throw IResourceManagement.ErrorCode.Resource_InvalidInstanceID_NotFound.cloudManagerFault(new Object[]{instanceId});
        }
        return this.convertInstance(awsInstance);
    }

    public List<IResourceManagement.Instance> getInstances(String ... instanceIds) throws CloudManagerFault {
        return this.getInstances(Arrays.asList(instanceIds));
    }

    public List<IResourceManagement.Instance> getInstances(List<String> instanceIds) throws CloudManagerFault {
        try {
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DescribeInstancesResult result = ec2.describeInstances(new DescribeInstancesRequest().withInstanceIds(instanceIds));
            ArrayList<IResourceManagement.Instance> instances = new ArrayList<IResourceManagement.Instance>();
            for (Reservation r : result.getReservations()) {
                for (com.amazonaws.services.ec2.model.Instance awsInstance : r.getInstances()) {
                    if (InstanceStateName.ShuttingDown.toString().equals(awsInstance.getState()) && InstanceStateName.Terminated.toString().equals(awsInstance.getState().getName())) continue;
                    instances.add(this.convertInstance(awsInstance));
                }
            }
            return instances;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public com.clustercontrol.cloud.bean.InstanceStateChange startInstance(String instanceId) throws CloudManagerFault {
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        StartInstancesRequest request = new StartInstancesRequest().withInstanceIds(new String[]{instanceId});
        StartInstancesResult result = ec2.startInstances(request);
        try {
            InstanceStateChange awsChange = (InstanceStateChange)result.getStartingInstances().get(0);
            com.clustercontrol.cloud.bean.InstanceStateChange change = new com.clustercontrol.cloud.bean.InstanceStateChange();
            change.setInstanceId(instanceId);
            change.setCurrentState(InstanceStateKind.byLabel((String)awsChange.getCurrentState().getName()));
            change.setPreviousState(InstanceStateKind.byLabel((String)awsChange.getPreviousState().getName()));
            return change;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public com.clustercontrol.cloud.bean.InstanceStateChange stopInstance(String instanceId) throws CloudManagerFault {
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        StopInstancesRequest request = new StopInstancesRequest().withInstanceIds(new String[]{instanceId});
        StopInstancesResult result = ec2.stopInstances(request);
        try {
            InstanceStateChange awsChange = (InstanceStateChange)result.getStoppingInstances().get(0);
            com.clustercontrol.cloud.bean.InstanceStateChange change = new com.clustercontrol.cloud.bean.InstanceStateChange();
            change.setInstanceId(instanceId);
            change.setCurrentState(InstanceStateKind.byLabel((String)awsChange.getCurrentState().getName()));
            change.setPreviousState(InstanceStateKind.byLabel((String)awsChange.getPreviousState().getName()));
            return change;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public List<String> getInstanceFlavors() throws CloudManagerFault {
        ArrayList<String> instanceTypes = new ArrayList<String>();
        for (InstanceType type : InstanceType.values()) {
            instanceTypes.add(type.toString());
        }
        return instanceTypes;
    }

    public List<Zone> getZones() throws CloudManagerFault {
        try {
            ArrayList<Zone> zones = new ArrayList<Zone>();
            DescribeAvailabilityZonesResult result = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation()).describeAvailabilityZones();
            for (AvailabilityZone awsZone : result.getAvailabilityZones()) {
                Zone zone = new Zone();
                zone.setName(awsZone.getZoneName());
                zones.add(zone);
            }
            return zones;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public void attachStorage(final String instanceId, final String storageId, String deviceName) throws CloudManagerFault {
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        boolean success = false;
        AttachVolumeResult result = null;
        try {
            AttachVolumeRequest attachVolumeRequest = new AttachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId).withDevice(deviceName);
            result = ec2.attachVolume(attachVolumeRequest);
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                public void rollback() throws TransactionException {
                    try {
                        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(AWSResourceManagement.this.credential, AWSResourceManagement.this.region.getEndpoint("ec2").getLocation());
                        ec2.detachVolume(new DetachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId));
                    }
                    catch (CloudManagerFault e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
            success = true;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        finally {
            if (!success && result != null) {
                try {
                    DetachVolumeRequest detachVolumeRequest = new DetachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId);
                    ec2.detachVolume(detachVolumeRequest);
                }
                catch (Exception e) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void detachStorage(final String instanceId, final String storageId) throws CloudManagerFault {
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        boolean success = false;
        DetachVolumeResult result = null;
        try {
            DetachVolumeRequest detachVolumeRequest = new DetachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId);
            result = ec2.detachVolume(detachVolumeRequest);
            final String deviceName = result.getAttachment().getDevice();
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                public void rollback() throws TransactionException {
                    try {
                        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(AWSResourceManagement.this.credential, AWSResourceManagement.this.region.getEndpoint("ec2").getLocation());
                        ec2.attachVolume(new AttachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId).withDevice(deviceName));
                    }
                    catch (CloudManagerFault e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
            success = true;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        finally {
            if (!success && result != null) {
                try {
                    AttachVolumeRequest attachVolumeRequest = new AttachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId).withDevice(result.getAttachment().getDevice());
                    ec2.attachVolume(attachVolumeRequest);
                }
                catch (Exception e) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public IResourceManagement.Storage createStorage(String name, String flavor, int size, String snapshotId, String zone, String storageDetail) throws CloudManagerFault {
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        Volume volume = null;
        boolean success = false;
        try {
            StorageDetail detail = null;
            if (storageDetail != null) {
                try {
                    ObjectMapper om = new ObjectMapper();
                    ObjectReader or = om.reader(StorageDetail.class);
                    detail = (StorageDetail)or.readValue(storageDetail);
                }
                catch (Exception e) {
                    throw new InternalManagerError((Throwable)e);
                }
            }
            CreateVolumeRequest awsRequest = new CreateVolumeRequest().withAvailabilityZone(zone).withIops(detail != null ? detail.iops : null).withSize(Integer.valueOf(size)).withSnapshotId(snapshotId).withVolumeType(flavor);
            CreateVolumeResult result = ec2.createVolume(awsRequest);
            volume = result.getVolume();
            AWSUtil.addTag(ec2, volume.getVolumeId(), "Name", name);
            final IResourceManagement.Storage storage = new IResourceManagement.Storage();
            storage.setResourceType(RT_Storage);
            storage.setStorageId(result.getVolume().getVolumeId());
            storage.setName(name);
            storage.setSnapshotId(result.getVolume().getSnapshotId());
            storage.setSize(result.getVolume().getSize().intValue());
            storage.setZone(result.getVolume().getAvailabilityZone());
            storage.setFlavor(result.getVolume().getVolumeType());
            storage.setState(StorageStateKind.byLabel((String)volume.getState()));
            Iterator i$ = volume.getAttachments().iterator();
            if (i$.hasNext()) {
                VolumeAttachment va = (VolumeAttachment)i$.next();
                IResourceManagement.Storage.StorageAttachment sa = new IResourceManagement.Storage.StorageAttachment();
                sa.setInstanceId(va.getInstanceId());
                sa.setDevice(va.getDevice());
                sa.setState(StorageAttachmentStateKind.byLabel((String)va.getState()));
                sa.setAttachTime(va.getAttachTime());
                storage.setStorageAttachment(sa);
            }
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                public void rollback() throws TransactionException {
                    try {
                        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(AWSResourceManagement.this.credential, AWSResourceManagement.this.region.getEndpoint("ec2").getLocation());
                        ec2.deleteVolume(new DeleteVolumeRequest().withVolumeId(storage.getStorageId()));
                    }
                    catch (CloudManagerFault e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
            success = true;
            IResourceManagement.Storage storage2 = storage;
            return storage2;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        finally {
            if (!success && volume != null) {
                try {
                    Thread.sleep(1000L);
                    ec2.deleteVolume(new DeleteVolumeRequest().withVolumeId(volume.getVolumeId()));
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void deleteStorage(String storageId) throws CloudManagerFault {
        try {
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DeleteVolumeRequest awsRequest = new DeleteVolumeRequest().withVolumeId(storageId);
            ec2.deleteVolume(awsRequest);
        }
        catch (AmazonServiceException e) {
            if (AWSErrorCode.InvalidVolume_NotFound.match(e.getErrorCode()) || AWSErrorCode.OperationNotPermitted.match(e.getErrorCode())) {
                throw IResourceManagement.ErrorCode.Resource_InvalidStorage_NotFound.cloudManagerFault(new Object[]{storageId});
            }
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public IResourceManagement.Storage getStorage(String storageId) throws CloudManagerFault {
        try {
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DescribeVolumesRequest request = new DescribeVolumesRequest().withVolumeIds(new String[]{storageId});
            DescribeVolumesResult result = ec2.describeVolumes(request);
            Volume volume = (Volume)result.getVolumes().get(0);
            IResourceManagement.Storage storage = new IResourceManagement.Storage();
            storage.setResourceType(RT_Storage);
            storage.setStorageId(volume.getVolumeId());
            for (com.amazonaws.services.ec2.model.Tag t : volume.getTags()) {
                if (!"Name".equals(t.getKey())) continue;
                storage.setName(t.getValue());
                break;
            }
            storage.setSnapshotId(volume.getSnapshotId());
            storage.setSize(volume.getSize().intValue());
            storage.setZone(volume.getAvailabilityZone());
            storage.setFlavor(volume.getVolumeType());
            storage.setState(StorageStateKind.byLabel((String)volume.getState()));
            Iterator i$ = volume.getAttachments().iterator();
            if (i$.hasNext()) {
                VolumeAttachment va = (VolumeAttachment)i$.next();
                IResourceManagement.Storage.StorageAttachment sa = new IResourceManagement.Storage.StorageAttachment();
                sa.setInstanceId(va.getInstanceId());
                sa.setDevice(va.getDevice());
                sa.setState(StorageAttachmentStateKind.byLabel((String)va.getState()));
                sa.setAttachTime(va.getAttachTime());
                storage.setStorageAttachment(sa);
            }
            storage.setCreateTime(volume.getCreateTime());
            return storage;
        }
        catch (AmazonServiceException e) {
            if (!AWSErrorCode.InvalidVolume_NotFound.match(e.getErrorCode())) {
                throw IResourceManagement.ErrorCode.Resource_InvalidStorage_NotFound.cloudManagerFault(new Object[]{storageId});
            }
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public List<IResourceManagement.Storage> getStorages(String ... storageIds) throws CloudManagerFault {
        return this.getStorages(Arrays.asList(storageIds));
    }

    public List<IResourceManagement.Storage> getStorages(List<String> storageIds) throws CloudManagerFault {
        try {
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DescribeVolumesResult result = ec2.describeVolumes(new DescribeVolumesRequest().withVolumeIds(storageIds));
            ArrayList<IResourceManagement.Storage> storages = new ArrayList<IResourceManagement.Storage>();
            for (Volume volume : result.getVolumes()) {
                IResourceManagement.Storage storage = new IResourceManagement.Storage();
                storage.setStorageId(volume.getVolumeId());
                String name = null;
                for (com.amazonaws.services.ec2.model.Tag t : volume.getTags()) {
                    if (!"Name".equals(t.getKey())) continue;
                    name = t.getValue();
                    break;
                }
                storage.setName(name);
                storage.setSnapshotId(volume.getSnapshotId());
                storage.setSize(volume.getSize().intValue());
                storage.setZone(volume.getAvailabilityZone());
                storage.setFlavor(volume.getVolumeType());
                storage.setState(StorageStateKind.byLabel((String)volume.getState()));
                Iterator i$ = volume.getAttachments().iterator();
                if (i$.hasNext()) {
                    VolumeAttachment va = (VolumeAttachment)i$.next();
                    IResourceManagement.Storage.StorageAttachment sa = new IResourceManagement.Storage.StorageAttachment();
                    sa.setInstanceId(va.getInstanceId());
                    sa.setDevice(va.getDevice());
                    sa.setState(StorageAttachmentStateKind.byLabel((String)va.getState()));
                    sa.setAttachTime(va.getAttachTime());
                    storage.setStorageAttachment(sa);
                }
                storage.setCreateTime(volume.getCreateTime());
                storages.add(storage);
            }
            return storages;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public List<String> getStorageFlavors() throws CloudManagerFault {
        ArrayList<String> storageTypes = new ArrayList<String>();
        for (VolumeType type : VolumeType.values()) {
            storageTypes.add(type.toString());
        }
        return storageTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResourceManagement.StorageBackup createStorageBackup(String storageId, String name, String description, String backupOption) throws CloudManagerFault {
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        String snapshotId = null;
        try {
            CreateSnapshotRequest createSnapshotRequest = new CreateSnapshotRequest().withVolumeId(storageId).withDescription(description);
            final CreateSnapshotResult createSnapshotResult = ec2.createSnapshot(createSnapshotRequest);
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                public void rollback() throws TransactionException {
                    try {
                        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(AWSResourceManagement.this.credential, AWSResourceManagement.this.region.getEndpoint("ec2").getLocation());
                        ec2.deleteSnapshot(new DeleteSnapshotRequest().withSnapshotId(createSnapshotResult.getSnapshot().getSnapshotId()));
                    }
                    catch (CloudManagerFault e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
            snapshotId = createSnapshotResult.getSnapshot().getSnapshotId();
            AWSUtil.addTags(ec2, createSnapshotResult.getSnapshot().getSnapshotId(), new com.amazonaws.services.ec2.model.Tag("Name", name), new com.amazonaws.services.ec2.model.Tag("SouceStorageId", storageId));
            Volume volume = (Volume)ec2.describeVolumes(new DescribeVolumesRequest().withVolumeIds(new String[]{storageId})).getVolumes().get(0);
            BackupedStorageDetail backupedData = new BackupedStorageDetail();
            backupedData.storageId = storageId;
            for (com.amazonaws.services.ec2.model.Tag t : volume.getTags()) {
                if (!"Name".equals(t.getKey())) continue;
                backupedData.name = t.getValue();
                break;
            }
            backupedData.flavor = volume.getVolumeType();
            backupedData.zone = volume.getAvailabilityZone();
            backupedData.size = volume.getSize();
            backupedData.createTime = volume.getCreateTime();
            backupedData.storageDetail = new StorageDetail();
            backupedData.storageDetail.iops = volume.getIops();
            ObjectMapper om = new ObjectMapper();
            ObjectWriter ow = om.writerWithType(BackupedStorageDetail.class);
            String backupedDetail = ow.writeValueAsString((Object)backupedData);
            this.store.put(RT_StorageBackup, snapshotId, backupedDetail);
            IResourceManagement.StorageBackup storageBackup = new IResourceManagement.StorageBackup();
            storageBackup.setResourceType(RT_StorageBackup);
            storageBackup.setStorageBackupId(snapshotId);
            storageBackup.setName(name);
            storageBackup.setDescription(description);
            storageBackup.setStorageId(volume.getVolumeId());
            storageBackup.setCreateTime(backupedData.createTime);
            storageBackup.setBackupedData(new IResourceManagement.StorageBackup.BackupedData());
            storageBackup.getBackupedData().setName(backupedData.name);
            storageBackup.getBackupedData().setFlavor(backupedData.flavor);
            storageBackup.getBackupedData().setZone(backupedData.zone);
            storageBackup.getBackupedData().setSize(backupedData.size.intValue());
            storageBackup.getBackupedData().setStorageDetail(om.writerWithType(StorageDetail.class).writeValueAsString((Object)backupedData.storageDetail));
            return storageBackup;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public void deleteStorageBackup(String storageBackupId) throws CloudManagerFault {
        try {
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DeleteSnapshotRequest awsRequest = new DeleteSnapshotRequest().withSnapshotId(storageBackupId);
            ec2.deleteSnapshot(awsRequest);
        }
        catch (AmazonServiceException e) {
            if (AWSErrorCode.InvalidSnapshot_NotFound.match(e.getErrorCode()) || AWSErrorCode.OperationNotPermitted.match(e.getErrorCode())) {
                throw IResourceManagement.ErrorCode.Resource_InvalidSnapshot_NotFound.cloudManagerFault(new Object[]{storageBackupId});
            }
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        try {
            this.store.remove(RT_StorageBackup, storageBackupId);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public List<Snapshot> getSnapshots(String ... snapshotIds) throws CloudManagerFault {
        return this.getSnapshotsWithFilter(new Filter("snapshot-id", snapshotIds));
    }

    public List<Snapshot> getSnapshots(List<String> snapshotIds) throws CloudManagerFault {
        return this.getSnapshotsWithFilter(new Filter("snapshot-id", snapshotIds));
    }

    public List<Snapshot> getSnapshotsWithFilter(Filter ... filters) throws CloudManagerFault {
        return this.getSnapshotsWithFilter(Arrays.asList(filters));
    }

    public List<Snapshot> getSnapshotsWithFilter(List<Filter> filters) throws CloudManagerFault {
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        ArrayList<com.amazonaws.services.ec2.model.Filter> awsFilters = new ArrayList<com.amazonaws.services.ec2.model.Filter>();
        for (Filter filter : filters) {
            awsFilters.add(new com.amazonaws.services.ec2.model.Filter().withName(filter.getName()).withValues((Collection)filter.getValues()));
        }
        DescribeSnapshotsRequest request = new DescribeSnapshotsRequest().withFilters(awsFilters);
        DescribeSnapshotsResult result = ec2.describeSnapshots(request);
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        for (com.amazonaws.services.ec2.model.Snapshot awsSnapshot : result.getSnapshots()) {
            Snapshot snapshot = new Snapshot();
            snapshot.setResourceType(RT_Snapshot);
            for (com.amazonaws.services.ec2.model.Tag t : awsSnapshot.getTags()) {
                if (!"Name".equals(t.getKey())) continue;
                snapshot.setName(t.getValue());
                break;
            }
            snapshot.setSnapshotId(awsSnapshot.getSnapshotId());
            snapshot.setDescription(awsSnapshot.getDescription());
            snapshots.add(snapshot);
        }
        return snapshots;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResourceManagement.InstanceBackup createInstanceBackup(String instanceId, String name, String description, Boolean withVolumes, Boolean noReboot, String backupOption) throws CloudManagerFault {
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        String imageId = null;
        try {
            CreateImageRequest createImageRequest = new CreateImageRequest().withInstanceId(instanceId).withName(name).withDescription(description).withNoReboot(Boolean.valueOf(noReboot != null ? noReboot : false));
            if (!Boolean.TRUE.equals(withVolumes)) {
                DescribeInstancesRequest request = new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId});
                com.amazonaws.services.ec2.model.Instance instance = (com.amazonaws.services.ec2.model.Instance)((Reservation)ec2.describeInstances(request).getReservations().get(0)).getInstances().get(0);
                ArrayList<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                for (InstanceBlockDeviceMapping instanceBlockDeviceMapping : instance.getBlockDeviceMappings()) {
                    if (instanceBlockDeviceMapping.getDeviceName().equals(instance.getRootDeviceName())) continue;
                    BlockDeviceMapping blockDeviceMapping = new BlockDeviceMapping();
                    blockDeviceMapping.setDeviceName(instanceBlockDeviceMapping.getDeviceName());
                    blockDeviceMapping.setNoDevice("");
                    blockDeviceMappings.add(blockDeviceMapping);
                }
                createImageRequest.setBlockDeviceMappings(blockDeviceMappings);
            }
            CreateImageResult createImageResult = ec2.createImage(createImageRequest);
            imageId = createImageResult.getImageId();
            AWSUtil.addTags(ec2, createImageResult.getImageId(), new com.amazonaws.services.ec2.model.Tag("Name", imageId), new com.amazonaws.services.ec2.model.Tag("SouceInstanceId", instanceId));
            final com.amazonaws.services.ec2.model.Image image = (com.amazonaws.services.ec2.model.Image)ec2.describeImages(new DescribeImagesRequest().withImageIds(new String[]{imageId})).getImages().get(0);
            if (image.getState().equals("failed")) {
                ec2.deregisterImage(new DeregisterImageRequest().withImageId(imageId));
                throw IResourceManagement.ErrorCode.Resource_Instance_Backup_Image_State_Failed.cloudManagerFault(new Object[0]);
            }
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                public void rollback() throws TransactionException {
                    try {
                        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(AWSResourceManagement.this.credential, AWSResourceManagement.this.region.getEndpoint("ec2").getLocation());
                        DeregisterImageRequest deregisterImageRequest = new DeregisterImageRequest().withImageId(image.getImageId());
                        ec2.deregisterImage(deregisterImageRequest);
                    }
                    catch (CloudManagerFault e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
            com.amazonaws.services.ec2.model.Instance instance = (com.amazonaws.services.ec2.model.Instance)((Reservation)ec2.describeInstances(new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId})).getReservations().get(0)).getInstances().get(0);
            BackupedInstanceDetail backupedData = new BackupedInstanceDetail();
            backupedData.instanceId = instanceId;
            for (com.amazonaws.services.ec2.model.Tag t : instance.getTags()) {
                if (!"Name".equals(t.getKey())) continue;
                backupedData.name = t.getValue();
                break;
            }
            backupedData.flavor = instance.getInstanceType();
            backupedData.zone = instance.getPlacement().getAvailabilityZone();
            backupedData.tags = new ArrayList<Tag>();
            backupedData.createTime = new Date();
            for (com.amazonaws.services.ec2.model.Tag t : instance.getTags()) {
                if ("Name".equals(t.getKey())) continue;
                backupedData.tags.add(new Tag(t.getKey(), t.getValue()));
            }
            backupedData.instanceDetail = new InstanceDetail();
            backupedData.instanceDetail.subnetId = instance.getSubnetId();
            backupedData.instanceDetail.securityGroupIds = new ArrayList<String>(instance.getSecurityGroups().size());
            for (GroupIdentifier gi : instance.getSecurityGroups()) {
                backupedData.instanceDetail.securityGroupIds.add(gi.getGroupId());
            }
            backupedData.instanceDetail.keyName = instance.getKeyName();
            backupedData.instanceDetail.monitoring = instance.getMonitoring().getState().equals("enabled");
            backupedData.instanceDetail.disableApiTermination = ec2.describeInstanceAttribute(new DescribeInstanceAttributeRequest().withInstanceId(instanceId).withAttribute(InstanceAttributeName.DisableApiTermination)).getInstanceAttribute().getDisableApiTermination();
            backupedData.instanceDetail.instanceInitiatedShutdownBehavior = ec2.describeInstanceAttribute(new DescribeInstanceAttributeRequest().withInstanceId(instanceId).withAttribute(InstanceAttributeName.InstanceInitiatedShutdownBehavior)).getInstanceAttribute().getInstanceInitiatedShutdownBehavior();
            backupedData.instanceDetail.ebsOptimized = instance.isEbsOptimized();
            backupedData.instanceDetail.rootBlockDevice = new EbsBlockDevice();
            for (InstanceBlockDeviceMapping device : instance.getBlockDeviceMappings()) {
                if (!device.getDeviceName().equals(instance.getRootDeviceName()) || device.getEbs() == null) continue;
                Volume v = (Volume)ec2.describeVolumes(new DescribeVolumesRequest().withVolumeIds(new String[]{device.getEbs().getVolumeId()})).getVolumes().get(0);
                backupedData.instanceDetail.rootBlockDevice.volumeType = v.getVolumeType();
                backupedData.instanceDetail.rootBlockDevice.volumeSize = v.getSize();
                backupedData.instanceDetail.rootBlockDevice.iops = v.getIops();
                backupedData.instanceDetail.rootBlockDevice.deleteOnTermination = device.getEbs().getDeleteOnTermination();
            }
            ObjectMapper om = new ObjectMapper();
            ObjectWriter ow = om.writerWithType(BackupedInstanceDetail.class);
            String backupedDetail = ow.writeValueAsString((Object)backupedData);
            this.store.put(RT_InstanceBackup, imageId, backupedDetail);
            IResourceManagement.InstanceBackup instanceBackup = new IResourceManagement.InstanceBackup();
            instanceBackup.setResourceType(RT_InstanceBackup);
            instanceBackup.setInstanceBackupId(imageId);
            instanceBackup.setName(name);
            instanceBackup.setDescription(description);
            instanceBackup.setInstanceId(instanceId);
            instanceBackup.setPlatform(instance.getPlatform() == null ? PlatformKind.linux : PlatformKind.windows);
            instanceBackup.setCreateTime(backupedData.createTime);
            instanceBackup.setBackupedData(new IResourceManagement.InstanceBackup.BackupedData());
            instanceBackup.getBackupedData().setName(backupedData.name);
            instanceBackup.getBackupedData().setFlavor(backupedData.flavor);
            instanceBackup.getBackupedData().setZone(backupedData.zone);
            instanceBackup.getBackupedData().setTags(backupedData.tags);
            instanceBackup.getBackupedData().setInstanceDetail(om.writerWithType(InstanceDetail.class).writeValueAsString((Object)backupedData.instanceDetail));
            return instanceBackup;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public void deleteInstanceBackup(String instanceBackupId) throws CloudManagerFault {
        com.amazonaws.services.ec2.model.Image image;
        AmazonEC2 ec2;
        block9: {
            ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            image = null;
            try {
                DescribeImagesResult result = ec2.describeImages(new DescribeImagesRequest().withImageIds(new String[]{instanceBackupId}));
                if (!result.getImages().isEmpty()) {
                    image = (com.amazonaws.services.ec2.model.Image)result.getImages().get(0);
                    ec2.deregisterImage(new DeregisterImageRequest(instanceBackupId));
                }
            }
            catch (AmazonServiceException e) {
                if (AWSErrorCode.InvalidAMIID_NotFound.label().equals(e.getErrorCode())) break block9;
                throw e;
            }
        }
        if (image != null) {
            for (BlockDeviceMapping bdm : image.getBlockDeviceMappings()) {
                if (bdm.getEbs() == null) continue;
                try {
                    ec2.deleteSnapshot(new DeleteSnapshotRequest(bdm.getEbs().getSnapshotId()));
                }
                catch (AmazonServiceException e) {
                    if (AWSErrorCode.InvalidSnapshot_NotFound.label().equals(e.getErrorCode())) continue;
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            this.store.remove(RT_InstanceBackup, instanceBackupId);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public List<Image> getImages(String ... imageIds) throws CloudManagerFault {
        return this.getImagesWithFilter(new Filter("image-id", imageIds));
    }

    public List<Image> getImages(List<String> imageIds) throws CloudManagerFault {
        return this.getImagesWithFilter(new Filter("image-id", imageIds));
    }

    public List<Image> getImagesWithFilter(Filter ... filters) throws CloudManagerFault {
        return this.getImagesWithFilter(Arrays.asList(filters));
    }

    public List<Image> getImagesWithFilter(List<Filter> filters) throws CloudManagerFault {
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        ArrayList<com.amazonaws.services.ec2.model.Filter> awsFilters = new ArrayList<com.amazonaws.services.ec2.model.Filter>();
        for (Filter filter : filters) {
            awsFilters.add(new com.amazonaws.services.ec2.model.Filter().withName(filter.getName()).withValues((Collection)filter.getValues()));
        }
        DescribeImagesRequest request = new DescribeImagesRequest().withFilters(awsFilters);
        DescribeImagesResult result = ec2.describeImages(request);
        ArrayList<Image> images = new ArrayList<Image>();
        for (com.amazonaws.services.ec2.model.Image awsImage : result.getImages()) {
            Image image = new Image();
            image.setResourceType(RT_Image);
            image.setName(awsImage.getName());
            image.setImageId(awsImage.getImageId());
            image.setDescription(awsImage.getDescription());
            images.add(image);
        }
        return images;
    }

    public Snapshot getSnapshot(String snapshotId) throws CloudManagerFault {
        List<Snapshot> snapshots = this.getSnapshots(snapshotId);
        if (snapshots.isEmpty()) {
            throw IResourceManagement.ErrorCode.Resource_InvalidSnapshot_NotFound.cloudManagerFault(new Object[]{snapshotId});
        }
        return snapshots.get(0);
    }

    public Image getImage(String imageId) throws CloudManagerFault {
        List<Image> images = this.getImages(imageId);
        if (images.isEmpty()) {
            throw IResourceManagement.ErrorCode.Resource_InvalidImageID_NotFound.cloudManagerFault(new Object[]{imageId});
        }
        return images.get(0);
    }

    public IResourceManagement.Instance restoreInstance(String instanceBackupId, String name, String flavor, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault {
        try {
            String value = this.store.get(RT_InstanceBackup, instanceBackupId);
            ObjectMapper om = new ObjectMapper();
            BackupedInstanceDetail backuped = (BackupedInstanceDetail)om.reader(BackupedInstanceDetail.class).readValue(value);
            backuped.name = name != null ? name : backuped.name;
            backuped.flavor = flavor != null ? flavor : backuped.flavor;
            String string = backuped.zone = zone != null ? zone : backuped.zone;
            if (instanceDetail != null) {
                InstanceDetail override = (InstanceDetail)om.reader(InstanceDetail.class).readValue(instanceDetail);
                if (backuped.instanceDetail == null) {
                    backuped.instanceDetail = override;
                } else {
                    backuped.instanceDetail.subnetId = override.subnetId != null ? override.subnetId : backuped.instanceDetail.subnetId;
                    backuped.instanceDetail.keyName = override.keyName != null ? override.keyName : backuped.instanceDetail.keyName;
                    backuped.instanceDetail.monitoring = override.monitoring != null ? override.monitoring : backuped.instanceDetail.monitoring;
                    backuped.instanceDetail.disableApiTermination = override.disableApiTermination != null ? override.disableApiTermination : backuped.instanceDetail.disableApiTermination;
                    backuped.instanceDetail.instanceInitiatedShutdownBehavior = override.instanceInitiatedShutdownBehavior != null ? override.instanceInitiatedShutdownBehavior : backuped.instanceDetail.instanceInitiatedShutdownBehavior;
                    Boolean bl = backuped.instanceDetail.ebsOptimized = override.ebsOptimized != null ? override.ebsOptimized : backuped.instanceDetail.ebsOptimized;
                    if (backuped.instanceDetail.rootBlockDevice == null) {
                        backuped.instanceDetail.rootBlockDevice = override.rootBlockDevice;
                    } else if (override.rootBlockDevice != null) {
                        backuped.instanceDetail.rootBlockDevice.volumeType = override.rootBlockDevice.volumeType != null ? override.rootBlockDevice.volumeType : backuped.instanceDetail.rootBlockDevice.volumeType;
                        backuped.instanceDetail.rootBlockDevice.volumeSize = override.rootBlockDevice.volumeSize != null ? override.rootBlockDevice.volumeSize : backuped.instanceDetail.rootBlockDevice.volumeSize;
                        backuped.instanceDetail.rootBlockDevice.iops = override.rootBlockDevice.iops != null ? override.rootBlockDevice.iops : backuped.instanceDetail.rootBlockDevice.iops;
                        backuped.instanceDetail.rootBlockDevice.deleteOnTermination = override.rootBlockDevice.deleteOnTermination != null ? override.rootBlockDevice.deleteOnTermination : backuped.instanceDetail.rootBlockDevice.deleteOnTermination;
                    }
                    backuped.instanceDetail.securityGroupIds = override.securityGroupIds != null ? override.securityGroupIds : backuped.instanceDetail.securityGroupIds;
                }
            }
            ArrayList<Tag> tagsTemp = new ArrayList<Tag>(tags);
            block2: for (Tag t : backuped.tags) {
                if (tagsTemp.isEmpty()) break;
                Iterator iter = tagsTemp.iterator();
                while (iter.hasNext()) {
                    Tag override = (Tag)iter.next();
                    if (!t.getKey().equals(override.getKey())) continue;
                    t.setValue(override.getValue());
                    iter.remove();
                    continue block2;
                }
            }
            for (Tag t : tagsTemp) {
                backuped.tags.add(t);
            }
            String backupedDetail = om.writerWithType(InstanceDetail.class).writeValueAsString((Object)backuped.instanceDetail);
            return this.createInstance(backuped.name, backuped.flavor, instanceBackupId, backuped.zone, backupedDetail, backuped.tags);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public IResourceManagement.Storage restoreStorage(String storageBackupId, String name, String flavor, Integer size, String zone, String storageDetail) throws CloudManagerFault {
        try {
            String value = this.store.get(RT_StorageBackup, storageBackupId);
            ObjectMapper om = new ObjectMapper();
            ObjectReader or = om.reader(BackupedStorageDetail.class);
            BackupedStorageDetail backuped = (BackupedStorageDetail)or.readValue(value);
            backuped.name = name != null ? name : backuped.name;
            backuped.flavor = flavor != null ? flavor : backuped.flavor;
            backuped.zone = zone != null ? zone : backuped.zone;
            Integer n = backuped.size = size != null ? size : backuped.size;
            if (storageDetail != null) {
                StorageDetail override = (StorageDetail)or.readValue(storageDetail);
                if (backuped.storageDetail == null) {
                    backuped.storageDetail = override;
                } else {
                    backuped.storageDetail.iops = override.iops != null ? override.iops : backuped.storageDetail.iops;
                }
            }
            ObjectWriter ow = om.writerWithType(InstanceDetail.class);
            String backupedDetail = ow.writeValueAsString((Object)backuped.storageDetail);
            return this.createStorage(backuped.name, backuped.flavor, backuped.size, storageBackupId, backuped.zone, backupedDetail);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public IResourceManagement.StorageBackup getStorageBackup(String storageBackupId) throws CloudManagerFault {
        try {
            ObjectMapper om = new ObjectMapper();
            ObjectReader or = om.reader(BackupedStorageDetail.class);
            ObjectWriter ow = om.writerWithType(StorageDetail.class);
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DescribeSnapshotsResult result = ec2.describeSnapshots(new DescribeSnapshotsRequest().withSnapshotIds(new String[]{storageBackupId}));
            com.amazonaws.services.ec2.model.Snapshot snapshot = (com.amazonaws.services.ec2.model.Snapshot)result.getSnapshots().get(0);
            if (!"error".equals(snapshot.getState())) {
                String backupDetail = this.store.get(RT_StorageBackup, snapshot.getSnapshotId());
                BackupedStorageDetail backuped = (BackupedStorageDetail)or.readValue(backupDetail);
                IResourceManagement.StorageBackup storageBackup = new IResourceManagement.StorageBackup();
                storageBackup.setResourceType(RT_StorageBackup);
                storageBackup.setStorageBackupId(snapshot.getSnapshotId());
                for (com.amazonaws.services.ec2.model.Tag t : snapshot.getTags()) {
                    if (!"Name".equals(t.getKey())) continue;
                    storageBackup.setName(t.getValue());
                    break;
                }
                storageBackup.setStorageId(backuped.storageId);
                storageBackup.setDescription(snapshot.getDescription());
                storageBackup.setCreateTime(backuped.createTime);
                storageBackup.setBackupedData(new IResourceManagement.StorageBackup.BackupedData());
                storageBackup.getBackupedData().setName(backuped.name);
                storageBackup.getBackupedData().setFlavor(backuped.flavor);
                storageBackup.getBackupedData().setZone(backuped.zone);
                storageBackup.getBackupedData().setStorageDetail(ow.writeValueAsString((Object)backuped.storageDetail));
                return storageBackup;
            }
            try {
                this.store.remove(RT_StorageBackup, snapshot.getVolumeId());
            }
            catch (Exception e1) {
                Logger.getLogger(this.getClass()).warn((Object)e1.getMessage(), (Throwable)e1);
            }
            return null;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public List<IResourceManagement.StorageBackup> getStorageBackups(String ... storageBackupId) throws CloudManagerFault {
        return this.getStorageBackups(Arrays.asList(storageBackupId));
    }

    public List<IResourceManagement.StorageBackup> getStorageBackups(List<String> storageBackupIds) throws CloudManagerFault {
        try {
            ObjectMapper om = new ObjectMapper();
            ObjectReader or = om.reader(BackupedStorageDetail.class);
            ObjectWriter ow = om.writerWithType(StorageDetail.class);
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DescribeSnapshotsResult result = ec2.describeSnapshots(new DescribeSnapshotsRequest().withSnapshotIds(storageBackupIds));
            List<String> storageBackupIdsList = storageBackupIds.isEmpty() ? this.store.getIds(RT_StorageBackup) : new ArrayList<String>(storageBackupIds);
            ArrayList<IResourceManagement.StorageBackup> storageBackups = new ArrayList<IResourceManagement.StorageBackup>();
            for (com.amazonaws.services.ec2.model.Snapshot snapshot : result.getSnapshots()) {
                Iterator<String> iter = storageBackupIdsList.iterator();
                while (iter.hasNext()) {
                    if (!iter.next().equals(snapshot.getSnapshotId())) continue;
                    iter.remove();
                    break;
                }
                if (!"error".equals(snapshot.getState())) {
                    String backupDetail = this.store.get(RT_StorageBackup, snapshot.getSnapshotId());
                    BackupedStorageDetail backuped = (BackupedStorageDetail)or.readValue(backupDetail);
                    IResourceManagement.StorageBackup storageBackup = new IResourceManagement.StorageBackup();
                    storageBackup.setResourceType(RT_StorageBackup);
                    storageBackup.setStorageBackupId(snapshot.getSnapshotId());
                    for (com.amazonaws.services.ec2.model.Tag t : snapshot.getTags()) {
                        if (!"Name".equals(t.getKey())) continue;
                        storageBackup.setName(t.getValue());
                        break;
                    }
                    storageBackup.setStorageId(backuped.storageId);
                    storageBackup.setDescription(snapshot.getDescription());
                    storageBackup.setCreateTime(backuped.createTime);
                    storageBackup.setBackupedData(new IResourceManagement.StorageBackup.BackupedData());
                    storageBackup.getBackupedData().setName(backuped.name);
                    storageBackup.getBackupedData().setFlavor(backuped.flavor);
                    storageBackup.getBackupedData().setZone(backuped.zone);
                    storageBackup.getBackupedData().setSize(backuped.size.intValue());
                    storageBackup.getBackupedData().setStorageDetail(ow.writeValueAsString((Object)backuped.storageDetail));
                    storageBackups.add(storageBackup);
                    continue;
                }
                try {
                    this.store.remove(RT_StorageBackup, snapshot.getVolumeId());
                }
                catch (Exception e1) {
                    Logger.getLogger(this.getClass()).warn((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            for (String storageBackupId : storageBackupIdsList) {
                try {
                    this.store.remove(RT_StorageBackup, storageBackupId);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            return storageBackups;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public IResourceManagement.InstanceBackup getInstanceBackup(String instanceBackupId) throws CloudManagerFault {
        try {
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DescribeImagesResult result = ec2.describeImages(new DescribeImagesRequest().withImageIds(new String[]{instanceBackupId}));
            com.amazonaws.services.ec2.model.Image image = (com.amazonaws.services.ec2.model.Image)result.getImages().get(0);
            if (!"deregistered".equals(image.getState())) {
                ObjectMapper om = new ObjectMapper();
                String backupDetail = this.store.get(RT_InstanceBackup, image.getImageId());
                ObjectReader or = om.reader(BackupedInstanceDetail.class);
                BackupedInstanceDetail backuped = (BackupedInstanceDetail)or.readValue(backupDetail);
                IResourceManagement.InstanceBackup instanceBackup = new IResourceManagement.InstanceBackup();
                instanceBackup.setResourceType(RT_InstanceBackup);
                instanceBackup.setInstanceBackupId(image.getImageId());
                for (com.amazonaws.services.ec2.model.Tag t : image.getTags()) {
                    if (!"Name".equals(t.getKey())) continue;
                    instanceBackup.setName(t.getValue());
                    break;
                }
                instanceBackup.setInstanceId(backuped.instanceId);
                instanceBackup.setDescription(image.getDescription());
                instanceBackup.setPlatform(image.getPlatform() == null ? PlatformKind.linux : PlatformKind.windows);
                instanceBackup.setCreateTime(backuped.createTime);
                instanceBackup.setBackupedData(new IResourceManagement.InstanceBackup.BackupedData());
                instanceBackup.getBackupedData().setName(backuped.name);
                instanceBackup.getBackupedData().setFlavor(backuped.flavor);
                instanceBackup.getBackupedData().setZone(backuped.zone);
                instanceBackup.getBackupedData().setTags(backuped.tags);
                ObjectWriter ow = om.writerWithType(InstanceDetail.class);
                instanceBackup.getBackupedData().setInstanceDetail(ow.writeValueAsString((Object)backuped.instanceDetail));
                return instanceBackup;
            }
            try {
                this.store.remove(RT_InstanceBackup, image.getImageId());
            }
            catch (Exception e1) {
                Logger.getLogger(this.getClass()).warn((Object)e1.getMessage(), (Throwable)e1);
            }
            return null;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public List<IResourceManagement.InstanceBackup> getInstanceBackups(String ... instanceBackupIds) throws CloudManagerFault {
        return this.getInstanceBackups(Arrays.asList(instanceBackupIds));
    }

    public List<IResourceManagement.InstanceBackup> getInstanceBackups(List<String> instanceBackupIds) throws CloudManagerFault {
        try {
            ObjectMapper om = new ObjectMapper();
            ObjectReader or = om.reader(BackupedInstanceDetail.class);
            ObjectWriter ow = om.writerWithType(InstanceDetail.class);
            AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
            DescribeImagesResult result = ec2.describeImages(new DescribeImagesRequest().withImageIds(instanceBackupIds));
            List<String> instanceBackupIdsList = instanceBackupIds.isEmpty() ? this.store.getIds(RT_InstanceBackup) : new ArrayList<String>(instanceBackupIds);
            ArrayList<IResourceManagement.InstanceBackup> instanceBackups = new ArrayList<IResourceManagement.InstanceBackup>();
            for (com.amazonaws.services.ec2.model.Image image : result.getImages()) {
                Iterator<String> iter = instanceBackupIdsList.iterator();
                while (iter.hasNext()) {
                    if (!iter.next().equals(image.getImageId())) continue;
                    iter.remove();
                    break;
                }
                if (!"deregistered".equals(image.getState())) {
                    String backupDetail = this.store.get(RT_InstanceBackup, image.getImageId());
                    BackupedInstanceDetail backuped = (BackupedInstanceDetail)or.readValue(backupDetail);
                    IResourceManagement.InstanceBackup instanceBackup = new IResourceManagement.InstanceBackup();
                    instanceBackup.setResourceType(RT_InstanceBackup);
                    instanceBackup.setInstanceBackupId(image.getImageId());
                    for (com.amazonaws.services.ec2.model.Tag t : image.getTags()) {
                        if (!"Name".equals(t.getKey())) continue;
                        instanceBackup.setName(t.getValue());
                        break;
                    }
                    instanceBackup.setInstanceId(backuped.instanceId);
                    instanceBackup.setDescription(image.getDescription());
                    instanceBackup.setPlatform(image.getPlatform() == null ? PlatformKind.linux : PlatformKind.windows);
                    instanceBackup.setCreateTime(backuped.createTime);
                    instanceBackup.setBackupedData(new IResourceManagement.InstanceBackup.BackupedData());
                    instanceBackup.getBackupedData().setName(backuped.name);
                    instanceBackup.getBackupedData().setFlavor(backuped.flavor);
                    instanceBackup.getBackupedData().setZone(backuped.zone);
                    instanceBackup.getBackupedData().setTags(backuped.tags);
                    instanceBackup.getBackupedData().setInstanceDetail(ow.writeValueAsString((Object)backuped.instanceDetail));
                    instanceBackups.add(instanceBackup);
                    continue;
                }
                try {
                    this.store.remove(RT_InstanceBackup, image.getImageId());
                }
                catch (Exception e1) {
                    Logger.getLogger(this.getClass()).warn((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            for (String instanceBackupId : instanceBackupIdsList) {
                try {
                    this.store.remove(RT_InstanceBackup, instanceBackupId);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            return instanceBackups;
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public List<IResourceManagement.LoadBalancer> getLoadBalancers() throws CloudManagerFault {
        AmazonElasticLoadBalancing elb = AWSUtil.createAmazonElasticLoadBalancing(this.credential, this.region.getEndpoint("elb").getLocation());
        AmazonEC2 ec2 = AWSUtil.createAmazonEC2(this.credential, this.region.getEndpoint("ec2").getLocation());
        DescribeLoadBalancersResult elbResult = elb.describeLoadBalancers();
        DescribeInstancesResult instanceResult = ec2.describeInstances();
        ArrayList<IResourceManagement.LoadBalancer> lbs = new ArrayList<IResourceManagement.LoadBalancer>();
        for (LoadBalancerDescription description : elbResult.getLoadBalancerDescriptions()) {
            IResourceManagement.LoadBalancer lb = new IResourceManagement.LoadBalancer();
            lb.setResourceType(RT_LoadBalancer);
            lb.setLbId(description.getLoadBalancerName());
            lb.setRegisterdInstanceIds(new ArrayList());
            for (Instance i : description.getInstances()) {
                lb.getRegisterdInstanceIds().add(i.getInstanceId());
            }
            lb.setAvailableInstanceIds(new ArrayList());
            for (Reservation rev : instanceResult.getReservations()) {
                if (description.getVPCId() != null) {
                    for (com.amazonaws.services.ec2.model.Instance i : rev.getInstances()) {
                        if (lb.getRegisterdInstanceIds().contains(i.getInstanceId())) continue;
                        for (String subnetId : description.getSubnets()) {
                            if (!subnetId.equals(i.getSubnetId())) continue;
                            lb.getAvailableInstanceIds().add(i.getInstanceId());
                        }
                    }
                    continue;
                }
                for (com.amazonaws.services.ec2.model.Instance i : rev.getInstances()) {
                    if (lb.getRegisterdInstanceIds().contains(i.getInstanceId()) || i.getVpcId() != null) continue;
                    for (String zone : description.getAvailabilityZones()) {
                        if (!zone.equals(i.getPlacement().getAvailabilityZone())) continue;
                        lb.getAvailableInstanceIds().add(i.getInstanceId());
                    }
                }
            }
            lbs.add(lb);
        }
        return lbs;
    }

    public void registerInstanceToLoadBalancer(String lbId, String instanceId) throws CloudManagerFault {
        AmazonElasticLoadBalancing elb = AWSUtil.createAmazonElasticLoadBalancing(this.credential, this.region.getEndpoint("elb").getLocation());
        DescribeLoadBalancersResult elbResult = elb.describeLoadBalancers(new DescribeLoadBalancersRequest().withLoadBalancerNames(new String[]{lbId}));
        if (elbResult.getLoadBalancerDescriptions().isEmpty()) {
            return;
        }
        RegisterInstancesWithLoadBalancerRequest regRequest = new RegisterInstancesWithLoadBalancerRequest().withLoadBalancerName(lbId);
        Iterator i$ = elbResult.getLoadBalancerDescriptions().iterator();
        if (i$.hasNext()) {
            LoadBalancerDescription description = (LoadBalancerDescription)i$.next();
            for (Instance i : description.getInstances()) {
                if (i.getInstanceId().equals(instanceId)) {
                    return;
                }
                regRequest.getInstances().add(i);
            }
        }
        regRequest.getInstances().add(new Instance(instanceId));
        elb.registerInstancesWithLoadBalancer(regRequest);
    }

    public void unregisterInstanceToLoadBalancer(String lbId, String instanceId) throws CloudManagerFault {
        AmazonElasticLoadBalancing elb = AWSUtil.createAmazonElasticLoadBalancing(this.credential, this.region.getEndpoint("elb").getLocation());
        DescribeLoadBalancersResult elbResult = elb.describeLoadBalancers(new DescribeLoadBalancersRequest().withLoadBalancerNames(new String[]{lbId}));
        if (elbResult.getLoadBalancerDescriptions().isEmpty()) {
            return;
        }
        LoadBalancerDescription description = (LoadBalancerDescription)elbResult.getLoadBalancerDescriptions().get(0);
        RegisterInstancesWithLoadBalancerRequest regRequest = new RegisterInstancesWithLoadBalancerRequest().withLoadBalancerName(lbId);
        for (Instance i : description.getInstances()) {
            if (i.getInstanceId().equals(instanceId)) continue;
            regRequest.getInstances().add(i);
        }
        if (description.getInstances().size() == regRequest.getInstances().size()) {
            return;
        }
        regRequest.getInstances().add(new Instance(instanceId));
        elb.registerInstancesWithLoadBalancer(regRequest);
    }

    public static class StorageDetail {
        public Integer iops;
    }

    public static class BackupedStorageDetail {
        public String storageId;
        public String name;
        public String flavor;
        public String zone;
        public Integer size;
        public Date createTime;
        public StorageDetail storageDetail;
    }

    public static class InstanceDetail {
        public String subnetId;
        public List<String> securityGroupIds = new ArrayList<String>();
        public String keyName;
        public Boolean monitoring;
        public Boolean disableApiTermination;
        public String instanceInitiatedShutdownBehavior;
        public Boolean ebsOptimized;
        public EbsBlockDevice rootBlockDevice;
    }

    public static class BackupedInstanceDetail {
        public String instanceId;
        public String name;
        public String flavor;
        public String zone;
        public List<Tag> tags;
        public Date createTime;
        public InstanceDetail instanceDetail;
    }

    public static class EbsBlockDevice {
        public Integer volumeSize;
        public Boolean deleteOnTermination;
        public String volumeType;
        public Integer iops;
    }
}

