/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.registry;

import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.registry.IObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectChangedService
implements IObjectChangedService {
    private Map<Key, List<IObjectChangedListener<?>>> listenersMap = new HashMap();

    @Override
    public <T> void addObjectChangedListener(String type, Class<T> clazz, IObjectChangedListener<T> listener) {
        List<IObjectChangedListener<?>> list = this.listenersMap.get(clazz);
        if (list == null) {
            list = new ArrayList();
            this.listenersMap.put(new Key(type, clazz), list);
        }
        listener.onInstall();
        list.add(listener);
    }

    @Override
    public <T> void removeObjectChangedListener(String type, Class<T> clazz, IObjectChangedListener<T> listener) {
        List<IObjectChangedListener<?>> list = this.listenersMap.get(new Key(type, clazz));
        if (list != null) {
            list.remove(listener);
            listener.onUninstall();
        }
    }

    @Override
    public <T> void firePostAddedEvent(String type, Class<T> clazz, T object) throws PluginFault {
        List<IObjectChangedListener<?>> list = this.listenersMap.get(new Key(type, clazz));
        if (list == null) {
            return;
        }
        for (IObjectChangedListener<?> listener : list) {
            listener.postAdded(type, object);
        }
    }

    @Override
    public <T> void firePreRemovedEvent(String type, Class<T> clazz, T object) throws PluginFault {
        List<IObjectChangedListener<?>> list = this.listenersMap.get(new Key(type, clazz));
        if (list == null) {
            return;
        }
        for (IObjectChangedListener<?> listener : list) {
            listener.preRemoved(type, object);
        }
    }

    @Override
    public <T> void firePostModifiedEvent(String type, Class<T> clazz, T object) throws PluginFault {
        List<IObjectChangedListener<?>> list = this.listenersMap.get(new Key(type, clazz));
        if (list == null) {
            return;
        }
        for (IObjectChangedListener<?> listener : list) {
            listener.postModified(type, object);
        }
    }

    @Override
    public <T> void firePreAddedEvent(String type, Class<T> clazz, T object) throws PluginFault {
        List<IObjectChangedListener<?>> list = this.listenersMap.get(new Key(type, clazz));
        if (list == null) {
            return;
        }
        for (IObjectChangedListener<?> listener : list) {
            listener.preAdded(type, object);
        }
    }

    @Override
    public <T> void firePreModifiedEvent(String type, Class<T> clazz, T object) throws PluginFault {
        List<IObjectChangedListener<?>> list = this.listenersMap.get(new Key(type, clazz));
        if (list == null) {
            return;
        }
        for (IObjectChangedListener<?> listener : list) {
            listener.preModified(type, object);
        }
    }

    private static class Key {
        private String type;
        private Class<?> clazz;

        public Key(String type, Class<?> clazz) {
            this.type = type;
            this.clazz = clazz;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

