/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util;

import com.clustercontrol.accesscontrol.bean.ObjectPrivilegeFilterInfo;
import com.clustercontrol.accesscontrol.bean.ObjectPrivilegeInfo;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.accesscontrol.bean.SystemPrivilegeInfo;
import com.clustercontrol.accesscontrol.session.AccessControllerBean;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.commons.util.HinemosSessionContext;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.fault.JobMasterNotFound;
import com.clustercontrol.fault.PrivilegeDuplicate;
import com.clustercontrol.fault.UsedObjectPrivilege;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobEndStatusInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import com.clustercontrol.notify.factory.NotifyEventTaskFactory;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.plugin.impl.AsyncWorkerPlugin;
import com.clustercontrol.repository.bean.NodeDiskInfo;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeVariableInfo;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.session.RepositoryControllerBean;
import com.clustercontrol.ws.util.HttpAuthenticator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Logger;

public class HinemosUtil {
    private static ThreadLocal<ExecutorService> executorService = new ThreadLocal<ExecutorService>(){

        @Override
        protected ExecutorService initialValue() {
            return null;
        }
    };
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "100";
    public static final String MESSAGE_ID_FAILURE = "200";

    protected HinemosUtil() {
    }

    public static ExecutorService executorService() {
        ExecutorService service = executorService.get();
        if (service == null) {
            service = Executors.newSingleThreadExecutor(new ThreadFactory(){
                private final AtomicInteger threadNumber = new AtomicInteger(1);

                @Override
                public Thread newThread(final Runnable r) {
                    final Object accountName = HinemosSessionContext.instance().getProperty("loginUserId");
                    final Object isAdministrator = HinemosSessionContext.instance().getProperty("isAdministrator");
                    return new Thread(new Runnable(){

                        @Override
                        public void run() {
                            HinemosSessionContext.instance().setProperty("loginUserId", accountName);
                            HinemosSessionContext.instance().setProperty("isAdministrator", isAdministrator);
                            r.run();
                        }
                    }, "HinemosUtil-" + poolNumber.getAndIncrement() + "-thread-" + this.threadNumber.getAndIncrement());
                }
            });
            executorService.set(service);
        }
        return service;
    }

    public static void execute(Runnable command) {
        HinemosUtil.executorService().execute(command);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return HinemosUtil.executorService().submit(task);
    }

    public static <T> Future<T> submit(Runnable task, T result) {
        return HinemosUtil.executorService().submit(task, result);
    }

    public static Future<?> submit(Runnable task) {
        return HinemosUtil.executorService().submit(task);
    }

    public static void shutdown() {
        ExecutorService service = executorService.get();
        if (service != null) {
            service.shutdown();
            executorService.set(null);
        }
    }

    public static void authCheck(WebServiceContext wsctx, SystemPrivilegeInfo ... demandingRight) throws InvalidUserPass, InvalidRole, HinemosUnknown {
        HttpAuthenticator.authCheck((WebServiceContext)wsctx, new ArrayList<SystemPrivilegeInfo>(Arrays.asList(demandingRight)));
    }

    public static ScopeInfo createScope(String facilityId, String facilityName, String roleId) {
        ScopeInfo scope = new ScopeInfo();
        scope.setFacilityName(facilityName);
        scope.setFacilityId(facilityId);
        scope.setFacilityType(Integer.valueOf(0));
        scope.setDisplaySortOrder(Integer.valueOf(100));
        scope.setValid(Boolean.valueOf(true));
        scope.setCreateDatetime(Long.valueOf(System.currentTimeMillis()));
        scope.setModifyDatetime(Long.valueOf(System.currentTimeMillis()));
        scope.setBuiltInFlg(Boolean.valueOf(false));
        scope.setOwnerRoleId(roleId);
        return scope;
    }

    public static NodeInfo createNodeInfo(String facilityId, String facilityName, String platform, String subPlatform, String nodeName, String description, String nodeType, String serviceId, String accountResourceId, String resourceType, String instanceId, String region, String availabilityZone, String roleId, NodeVariableInfo ... variables) {
        NodeInfo nodeInfo = new NodeInfo();
        HinemosUtil.setDefaultValue(nodeInfo);
        nodeInfo.setFacilityId(facilityId);
        nodeInfo.setFacilityName(facilityName);
        nodeInfo.setPlatformFamily(platform);
        nodeInfo.setSubPlatformFamily(subPlatform);
        nodeInfo.setIpAddressVersion(Integer.valueOf(4));
        nodeInfo.setIpAddressV4("123.123.123.123");
        nodeInfo.setNodeName(nodeName);
        nodeInfo.setDescription(description);
        nodeInfo.setCloudNodeType(nodeType);
        nodeInfo.setCloudService(serviceId);
        nodeInfo.setCloudAccountResouce(accountResourceId);
        nodeInfo.setCloudResourceType(resourceType);
        nodeInfo.setCloudResourceId(instanceId);
        nodeInfo.setCloudRegion(region);
        nodeInfo.setCloudZone(availabilityZone);
        nodeInfo.setOwnerRoleId(roleId);
        nodeInfo.setNodeVariableInfo(new ArrayList<NodeVariableInfo>(Arrays.asList(variables)));
        return nodeInfo;
    }

    public static NodeInfo resetNodeInfo(NodeInfo nodeInfo, String facilityName, String platform, String subPlatform, String nodeName, String description, String nodeType, String serviceId, String accountResourceId, String resourceType, String instanceId, String region, String availabilityZone) {
        nodeInfo.setFacilityName(facilityName);
        nodeInfo.setPlatformFamily(platform);
        nodeInfo.setSubPlatformFamily(subPlatform);
        nodeInfo.setIpAddressVersion(Integer.valueOf(4));
        nodeInfo.setIpAddressV4("123.123.123.123");
        nodeInfo.setNodeName(nodeName);
        nodeInfo.setDescription(description);
        nodeInfo.setCloudNodeType(nodeType);
        nodeInfo.setCloudService(serviceId);
        nodeInfo.setCloudAccountResouce(accountResourceId);
        nodeInfo.setCloudResourceType(resourceType);
        nodeInfo.setCloudResourceId(instanceId);
        nodeInfo.setCloudRegion(region);
        nodeInfo.setCloudZone(availabilityZone);
        ArrayList disklist = new ArrayList();
        nodeInfo.setNodeDiskInfo(disklist);
        return nodeInfo;
    }

    public static void clearNodeInfo(NodeInfo nodeInfo) {
        nodeInfo.setNodeDiskInfo(new ArrayList(nodeInfo.getNodeDiskInfo()));
        Iterator iter = nodeInfo.getNodeDiskInfo().iterator();
        while (iter.hasNext()) {
            NodeDiskInfo info = (NodeDiskInfo)iter.next();
            if (!info.getDeviceDescription().startsWith("storageId=")) continue;
            iter.remove();
        }
        nodeInfo.setCloudNodeType("");
        nodeInfo.setCloudService("");
        nodeInfo.setCloudAccountResouce("");
        nodeInfo.setCloudResourceType("");
        nodeInfo.setCloudResourceId("");
        nodeInfo.setCloudRegion("");
        nodeInfo.setCloudZone("");
    }

    private static boolean checkEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static void setDefaultValue(NodeInfo nodeInfo) {
        nodeInfo.setFacilityType(Integer.valueOf(1));
        nodeInfo.setDisplaySortOrder(Integer.valueOf(100));
        if (nodeInfo.getFacilityId() == null) {
            nodeInfo.setFacilityId("");
        }
        if (nodeInfo.getFacilityName() == null) {
            nodeInfo.setFacilityName("");
        }
        if (nodeInfo.getDescription() == null) {
            nodeInfo.setDescription("");
        }
        if (nodeInfo.isValid() == null) {
            nodeInfo.setValid(Boolean.TRUE);
        }
        if (nodeInfo.getCreateUserId() == null) {
            nodeInfo.setCreateUserId("");
        }
        if (nodeInfo.getCreateDatetime() == null) {
            nodeInfo.setCreateDatetime(null);
        }
        if (nodeInfo.getModifyUserId() == null) {
            nodeInfo.setModifyUserId("");
        }
        if (nodeInfo.getModifyDatetime() == null) {
            nodeInfo.setModifyDatetime(null);
        }
        if (nodeInfo.getPlatformFamily() == null) {
            nodeInfo.setPlatformFamily("");
        }
        if (nodeInfo.getHardwareType() == null) {
            nodeInfo.setHardwareType("");
        }
        if (nodeInfo.getIconImage() == null) {
            nodeInfo.setIconImage("");
        }
        if (nodeInfo.getIpAddressVersion() == null) {
            nodeInfo.setIpAddressVersion(Integer.valueOf(-1));
        }
        if (nodeInfo.getIpAddressV4() == null) {
            nodeInfo.setIpAddressV4("");
        }
        if (nodeInfo.getIpAddressV6() == null) {
            nodeInfo.setIpAddressV6("");
        }
        if (nodeInfo.getNodeName() == null) {
            nodeInfo.setNodeName("");
        }
        if (nodeInfo.getOsName() == null) {
            nodeInfo.setOsName("");
        }
        if (nodeInfo.getOsRelease() == null) {
            nodeInfo.setOsRelease("");
        }
        if (nodeInfo.getOsVersion() == null) {
            nodeInfo.setOsVersion("");
        }
        if (nodeInfo.getCharacterSet() == null) {
            nodeInfo.setCharacterSet("");
        }
        if (nodeInfo.getSnmpPort() == null) {
            nodeInfo.setSnmpPort(Integer.valueOf(161));
        }
        if (HinemosUtil.checkEmpty(nodeInfo.getSnmpCommunity())) {
            nodeInfo.setSnmpCommunity("public");
        }
        if (HinemosUtil.checkEmpty(nodeInfo.getSnmpVersion())) {
            nodeInfo.setSnmpVersion("2c");
        }
        if (nodeInfo.getSnmpTimeout() == null || nodeInfo.getSnmpTimeout() == -1) {
            nodeInfo.setSnmpTimeout(Integer.valueOf(5000));
        }
        if (nodeInfo.getSnmpRetryCount() == null || nodeInfo.getSnmpRetryCount() == -1) {
            nodeInfo.setSnmpRetryCount(Integer.valueOf(3));
        }
        if (HinemosUtil.checkEmpty(nodeInfo.getWbemUser())) {
            nodeInfo.setWbemUser("root");
        }
        if (nodeInfo.getWbemUserPassword() == null) {
            nodeInfo.setWbemUserPassword("");
        }
        if (nodeInfo.getWbemPort() == null || nodeInfo.getWbemPort() == -1) {
            nodeInfo.setWbemPort(Integer.valueOf(5988));
        }
        if (HinemosUtil.checkEmpty(nodeInfo.getWbemProtocol())) {
            nodeInfo.setWbemProtocol("http");
        }
        if (nodeInfo.getWbemTimeout() == null || nodeInfo.getWbemTimeout() == -1) {
            nodeInfo.setWbemTimeout(Integer.valueOf(5000));
        }
        if (nodeInfo.getWbemRetryCount() == null || nodeInfo.getWbemRetryCount() == -1) {
            nodeInfo.setWbemRetryCount(Integer.valueOf(3));
        }
        if (nodeInfo.getIpmiIpAddress() == null) {
            nodeInfo.setIpmiIpAddress("");
        }
        if (nodeInfo.getIpmiPort() == null || nodeInfo.getIpmiPort() == -1) {
            nodeInfo.setIpmiPort(Integer.valueOf(0));
        }
        if (nodeInfo.getIpmiUser() == null) {
            nodeInfo.setIpmiUser("");
        }
        if (nodeInfo.getIpmiUserPassword() == null) {
            nodeInfo.setIpmiUserPassword("");
        }
        if (nodeInfo.getIpmiTimeout() == null || nodeInfo.getIpmiTimeout() == -1) {
            nodeInfo.setIpmiTimeout(Integer.valueOf(0));
        }
        if (nodeInfo.getIpmiRetries() == null || nodeInfo.getIpmiRetries() == -1) {
            nodeInfo.setIpmiRetries(Integer.valueOf(3));
        }
        if (HinemosUtil.checkEmpty(nodeInfo.getIpmiProtocol())) {
            nodeInfo.setIpmiProtocol("RMCP+");
        }
        if (nodeInfo.getIpmiLevel() == null) {
            nodeInfo.setIpmiLevel("");
        }
        if (nodeInfo.getWinrmUser() == null) {
            nodeInfo.setWinrmUser("");
        }
        if (nodeInfo.getWinrmUserPassword() == null) {
            nodeInfo.setWinrmUserPassword("");
        }
        if (HinemosUtil.checkEmpty(nodeInfo.getWinrmVersion())) {
            nodeInfo.setWinrmVersion("2.0");
        }
        if (nodeInfo.getWinrmPort() == null || nodeInfo.getWinrmPort() == -1) {
            nodeInfo.setWinrmPort(Integer.valueOf(5985));
        }
        if (HinemosUtil.checkEmpty(nodeInfo.getWinrmProtocol())) {
            nodeInfo.setWinrmProtocol("http");
        }
        if (nodeInfo.getWinrmTimeout() == null || nodeInfo.getWinrmTimeout() == -1) {
            nodeInfo.setWinrmTimeout(Integer.valueOf(5000));
        }
        if (nodeInfo.getWinrmRetries() == null || nodeInfo.getWinrmRetries() == -1) {
            nodeInfo.setWinrmRetries(Integer.valueOf(3));
        }
        if (nodeInfo.getVmManagementNode() == null) {
            nodeInfo.setVmManagementNode("");
        }
        if (nodeInfo.getVmName() == null) {
            nodeInfo.setVmName("");
        }
        if (nodeInfo.getVmId() == null) {
            nodeInfo.setVmId("");
        }
        if (nodeInfo.getVmUser() == null) {
            nodeInfo.setVmUser("");
        }
        if (nodeInfo.getVmUserPassword() == null) {
            nodeInfo.setVmUserPassword("");
        }
        if (nodeInfo.getVmProtocol() == null) {
            nodeInfo.setVmProtocol("");
        }
        if (nodeInfo.getOpenFlowDataPathId() == null) {
            nodeInfo.setOpenFlowDataPathId("");
        }
        if (nodeInfo.getOpenFlowCtrlIpAddress() == null) {
            nodeInfo.setOpenFlowCtrlIpAddress("");
        }
        if (nodeInfo.getAdministrator() == null) {
            nodeInfo.setAdministrator("");
        }
        if (nodeInfo.getContact() == null) {
            nodeInfo.setContact("");
        }
    }

    public static String getFacilityName(RepositoryControllerBean repositoryController, String facilityId) {
        try {
            NodeInfo nodeInfo = repositoryController.getNode(facilityId);
            return nodeInfo.getFacilityName();
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(HinemosUtil.class);
            logger.error((Object)("Not got facilityId (" + facilityId + ")"));
            return null;
        }
    }

    public static String getFacilityName(String facilityId) {
        try {
            return HinemosUtil.getFacilityName(new RepositoryControllerBean(), facilityId);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(HinemosUtil.class);
            logger.error((Object)("Not got facilityId (" + facilityId + ")"));
            return null;
        }
    }

    public static JobTreeItem searchJobTreeItem(JobTreeItem treeItem, String jobunitId, String id) {
        if (treeItem.getData().getJobunitId().equals(jobunitId) && treeItem.getData().getId().equals(id)) {
            return treeItem;
        }
        for (JobTreeItem child : treeItem.getChildren()) {
            child.setParent(treeItem);
            JobTreeItem result = HinemosUtil.searchJobTreeItem(child, jobunitId, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void relateJobTreeItems(JobTreeItem parent, JobTreeItem child) {
        child.setParent(parent);
        child.getData().setJobunitId(parent.getData().getJobunitId());
        if (parent.getChildren() == null) {
            parent.setChildren(new ArrayList());
        }
        parent.getChildren().add(child);
    }

    public static OutputBasicInfo createOutputBasicInfo(Priority priority, String pluginId, String monitorId, String subKey, String application, String facilityId, String facilityPath, String message, String messageOrg, Long generationDate) {
        OutputBasicInfo output = new OutputBasicInfo();
        output.setPluginId(pluginId);
        output.setMonitorId(monitorId);
        output.setApplication(application);
        output.setSubKey(subKey);
        output.setFacilityId(facilityId);
        if (facilityPath == null) {
            try {
                facilityPath = RepositoryControllerBeanWrapper.bean().getFacilityPath(facilityId, null);
            }
            catch (Exception e) {
                Logger.getLogger(HinemosUtil.class).error((Object)e.getMessage(), (Throwable)e);
            }
        }
        output.setScopeText(facilityPath);
        output.setPriority(priority.type);
        output.setMessageId(priority.messageId);
        output.setMessage(message);
        output.setMessageOrg(messageOrg);
        output.setGenerationDate(generationDate);
        return output;
    }

    public static OutputBasicInfo createOutputBasicInfoEx(Priority priority, String pluginId, String monitorId, String subKey, String application, String facilityId, String message, String messageOrg) {
        return HinemosUtil.createOutputBasicInfo(priority, pluginId, monitorId, subKey, application, facilityId, null, message, messageOrg, new Date().getTime());
    }

    public static OutputBasicInfo createInternalOutputBasicInfo(Priority priority, String pluginId, String monitorId, String subKey, String scopeText, String application, String message, String messageOrg) {
        return HinemosUtil.createOutputBasicInfo(priority, pluginId, monitorId, subKey, application, "INTERNAL", scopeText, message, messageOrg, new Date().getTime());
    }

    public static void notifyInternalMessage(Priority priority, String pluginId, String monitorId, String subKey, String scopeText, String application, String message, String messageOrg) {
        final OutputBasicInfo output = HinemosUtil.createInternalOutputBasicInfo(priority, pluginId, monitorId, subKey, scopeText, application, message, messageOrg);
        SessionService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncWorkerPlugin.addTask((String)NotifyEventTaskFactory.class.getSimpleName(), (Serializable)output, (boolean)false);
                }
                catch (HinemosUnknown e) {
                    Logger.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public static void addFullRightToRole(AccessControllerBean accessBean, String roleId, String objectType, String objectId) throws PrivilegeDuplicate, UsedObjectPrivilege, HinemosUnknown, InvalidSetting, InvalidRole, JobMasterNotFound {
        ObjectPrivilegeFilterInfo filter = new ObjectPrivilegeFilterInfo();
        filter.setObjectId(objectId);
        filter.setObjectType(objectType);
        ArrayList privileges = accessBean.getObjectPrivilegeInfoList(filter);
        ObjectPrivilegeInfo objectPrivilegeInfo1 = new ObjectPrivilegeInfo();
        objectPrivilegeInfo1.setObjectId(objectId);
        objectPrivilegeInfo1.setObjectType(objectType);
        objectPrivilegeInfo1.setRoleId(roleId);
        objectPrivilegeInfo1.setObjectPrivilege(PrivilegeConstant.ObjectPrivilegeMode.READ.name());
        ObjectPrivilegeInfo objectPrivilegeInfo2 = new ObjectPrivilegeInfo();
        objectPrivilegeInfo2.setObjectId(objectId);
        objectPrivilegeInfo2.setObjectType(objectType);
        objectPrivilegeInfo2.setRoleId(roleId);
        objectPrivilegeInfo2.setObjectPrivilege(PrivilegeConstant.ObjectPrivilegeMode.WRITE.name());
        ObjectPrivilegeInfo objectPrivilegeInfo3 = new ObjectPrivilegeInfo();
        objectPrivilegeInfo3.setObjectId(objectId);
        objectPrivilegeInfo3.setObjectType(objectType);
        objectPrivilegeInfo3.setRoleId(roleId);
        objectPrivilegeInfo3.setObjectPrivilege(PrivilegeConstant.ObjectPrivilegeMode.EXEC.name());
        ArrayList<ObjectPrivilegeInfo> addingPrivileges = new ArrayList<ObjectPrivilegeInfo>(Arrays.asList(objectPrivilegeInfo1, objectPrivilegeInfo2, objectPrivilegeInfo3));
        block0: for (ObjectPrivilegeInfo priviledge : privileges) {
            Iterator iter = addingPrivileges.iterator();
            while (iter.hasNext()) {
                ObjectPrivilegeInfo adding = (ObjectPrivilegeInfo)iter.next();
                if (!priviledge.getObjectPrivilege().equals(adding.getObjectPrivilege()) || !priviledge.getRoleId().equals(adding.getRoleId())) continue;
                iter.remove();
                continue block0;
            }
        }
        addingPrivileges.addAll(privileges);
        accessBean.replaceObjectPrivilegeInfo(objectType, objectId, addingPrivileges);
    }

    public static void removeFullRightToRole(AccessControllerBean accessBean, String roleId, String objectType, String objectId) throws PrivilegeDuplicate, UsedObjectPrivilege, HinemosUnknown, InvalidSetting, InvalidRole, JobMasterNotFound {
        ObjectPrivilegeFilterInfo filter = new ObjectPrivilegeFilterInfo();
        filter.setObjectId(objectId);
        filter.setObjectType(objectType);
        ArrayList privileges = accessBean.getObjectPrivilegeInfoList(filter);
        Iterator iter = privileges.iterator();
        while (iter.hasNext()) {
            ObjectPrivilegeInfo priviledge = (ObjectPrivilegeInfo)iter.next();
            if (!priviledge.getRoleId().equals(roleId)) continue;
            iter.remove();
        }
        accessBean.replaceObjectPrivilegeInfo(objectType, objectId, (List)privileges);
    }

    public static JobInfo createJobInfo(String jobId, int type, String name, String description, String roleId) {
        JobInfo info = new JobInfo();
        info.setId(jobId);
        info.setType(Integer.valueOf(type));
        info.setName(name);
        info.setDescription(description);
        ArrayList<JobEndStatusInfo> statuses = new ArrayList<JobEndStatusInfo>();
        JobEndStatusInfo status0 = new JobEndStatusInfo();
        status0.setType(Integer.valueOf(0));
        status0.setValue(Integer.valueOf(0));
        status0.setStartRangeValue(Integer.valueOf(0));
        status0.setEndRangeValue(Integer.valueOf(0));
        statuses.add(status0);
        JobEndStatusInfo status1 = new JobEndStatusInfo();
        status1.setType(Integer.valueOf(1));
        status1.setValue(Integer.valueOf(1));
        status1.setStartRangeValue(Integer.valueOf(1));
        status1.setEndRangeValue(Integer.valueOf(1));
        statuses.add(status1);
        JobEndStatusInfo status2 = new JobEndStatusInfo();
        status2.setType(Integer.valueOf(2));
        status2.setValue(Integer.valueOf(-1));
        status2.setStartRangeValue(Integer.valueOf(0));
        status2.setEndRangeValue(Integer.valueOf(0));
        statuses.add(status2);
        info.setEndStatus(statuses);
        String notifyGroupId = NotifyGroupIdGenerator.createNotifyGroupIdJob((String)info.getJobunitId(), (String)info.getId(), (Integer)0);
        ArrayList<JobNotificationsInfo> notifications = new ArrayList<JobNotificationsInfo>();
        JobNotificationsInfo infoStart = new JobNotificationsInfo();
        infoStart.setType(Integer.valueOf(3));
        infoStart.setPriority(Integer.valueOf(0));
        infoStart.setNotifyGroupId(notifyGroupId);
        notifications.add(infoStart);
        JobNotificationsInfo infoNormal = new JobNotificationsInfo();
        infoNormal.setType(Integer.valueOf(0));
        infoNormal.setPriority(Integer.valueOf(0));
        infoNormal.setNotifyGroupId(notifyGroupId);
        notifications.add(infoNormal);
        JobNotificationsInfo infoWarning = new JobNotificationsInfo();
        infoWarning.setType(Integer.valueOf(1));
        infoWarning.setPriority(Integer.valueOf(0));
        infoWarning.setNotifyGroupId(notifyGroupId);
        notifications.add(infoWarning);
        JobNotificationsInfo infoAbnormal = new JobNotificationsInfo();
        infoAbnormal.setType(Integer.valueOf(2));
        infoAbnormal.setPriority(Integer.valueOf(0));
        infoAbnormal.setNotifyGroupId(notifyGroupId);
        notifications.add(infoAbnormal);
        info.setNotifications(notifications);
        info.setOwnerRoleId(roleId);
        info.setPropertyFull(true);
        return info;
    }

    public static JobTreeItem createJobnet(String jobnetId, String name, String description, String roleId) {
        JobInfo info = HinemosUtil.createJobInfo(jobnetId, 1, name, description, roleId);
        HinemosUtil.setJobWaitRuleInfo(info);
        JobTreeItem jobnet = new JobTreeItem();
        jobnet.setData(info);
        return jobnet;
    }

    public static JobTreeItem createJob(RepositoryControllerBean repositoryBean, String jobId, String name, String description, String facilityId, String command, String roleId) throws HinemosUnknown {
        JobInfo info = HinemosUtil.createJobInfo(jobId, 2, name, description, roleId);
        HinemosUtil.setJobWaitRuleInfo(info);
        JobCommandInfo jci = new JobCommandInfo();
        info.setCommand(jci);
        jci.setFacilityID(facilityId);
        jci.setScope(repositoryBean.getFacilityPath(facilityId, null));
        jci.setStartCommand(command);
        jci.setStopType(Integer.valueOf(1));
        jci.setSpecifyUser(Integer.valueOf(0));
        jci.setProcessingMethod(Integer.valueOf(0));
        jci.setMessageRetry(Integer.valueOf(10));
        jci.setErrorEndFlg(Integer.valueOf(YesNoConstant.booleanToType((boolean)true)));
        jci.setErrorEndValue(Integer.valueOf(-1));
        JobTreeItem job = new JobTreeItem();
        job.setData(info);
        return job;
    }

    public static void setJobWaitRuleInfo(JobInfo jobInfo) {
        JobWaitRuleInfo jobWaitRuleInfo = new JobWaitRuleInfo();
        jobWaitRuleInfo.setCondition(Integer.valueOf(0));
        jobWaitRuleInfo.setEndCondition(Integer.valueOf(1));
        jobWaitRuleInfo.setEndStatus(Integer.valueOf(2));
        jobWaitRuleInfo.setEndValue(Integer.valueOf(-1));
        jobWaitRuleInfo.setCalendar(Integer.valueOf(0));
        jobWaitRuleInfo.setCalendarEndStatus(Integer.valueOf(2));
        jobWaitRuleInfo.setCalendarEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setSuspend(Integer.valueOf(0));
        jobWaitRuleInfo.setSkip(Integer.valueOf(0));
        jobWaitRuleInfo.setSkipEndStatus(Integer.valueOf(2));
        jobWaitRuleInfo.setSkipEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setStart_delay(Integer.valueOf(0));
        jobWaitRuleInfo.setStart_delay_condition_type(Integer.valueOf(0));
        jobWaitRuleInfo.setStart_delay_notify(Integer.valueOf(0));
        jobWaitRuleInfo.setStart_delay_notify_priority(Integer.valueOf(0));
        jobWaitRuleInfo.setStart_delay_operation_type(Integer.valueOf(0));
        jobWaitRuleInfo.setStart_delay_operation(Integer.valueOf(0));
        jobWaitRuleInfo.setStart_delay_operation_end_status(Integer.valueOf(2));
        jobWaitRuleInfo.setStart_delay_operation_end_value(Integer.valueOf(-1));
        jobWaitRuleInfo.setStart_delay_session(Integer.valueOf(0));
        jobWaitRuleInfo.setStart_delay_session_value(Integer.valueOf(1));
        jobWaitRuleInfo.setStart_delay_time(Integer.valueOf(0));
        jobWaitRuleInfo.setEnd_delay(Integer.valueOf(0));
        jobWaitRuleInfo.setEnd_delay_condition_type(Integer.valueOf(0));
        jobWaitRuleInfo.setEnd_delay_job(Integer.valueOf(0));
        jobWaitRuleInfo.setEnd_delay_job_value(Integer.valueOf(1));
        jobWaitRuleInfo.setEnd_delay_notify(Integer.valueOf(0));
        jobWaitRuleInfo.setEnd_delay_notify_priority(Integer.valueOf(0));
        jobWaitRuleInfo.setEnd_delay_operation(Integer.valueOf(0));
        jobWaitRuleInfo.setEnd_delay_operation_end_status(Integer.valueOf(2));
        jobWaitRuleInfo.setEnd_delay_operation_end_value(Integer.valueOf(-1));
        jobWaitRuleInfo.setEnd_delay_operation_type(Integer.valueOf(0));
        jobWaitRuleInfo.setEnd_delay_session(Integer.valueOf(0));
        jobWaitRuleInfo.setEnd_delay_session_value(Integer.valueOf(1));
        jobWaitRuleInfo.setEnd_delay_time(Integer.valueOf(0));
        jobWaitRuleInfo.setMultiplicityEndValue(Integer.valueOf(-1));
        jobWaitRuleInfo.setMultiplicityNotify(Integer.valueOf(1));
        jobWaitRuleInfo.setMultiplicityNotifyPriority(Integer.valueOf(2));
        jobWaitRuleInfo.setMultiplicityOperation(Integer.valueOf(0));
        jobInfo.setWaitRule(jobWaitRuleInfo);
    }

    public static enum Priority {
        INFO(3, "001"),
        WARNING(2, "002"),
        CRITICAL(0, "003"),
        UNKNOWN(0, "100"),
        FAI(-1, "200");

        public final int type;
        public final String messageId;

        private Priority(int type, String messageId) {
            this.type = type;
            this.messageId = messageId;
        }

        public static Priority priority(int type) {
            for (Priority p : Priority.values()) {
                if (p.type != type) continue;
                return p;
            }
            return null;
        }
    }
}

