/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util;

import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.fault.CalendarNotFound;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidObjectPrivilege;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.JobInfoNotFound;
import com.clustercontrol.fault.JobInvalid;
import com.clustercontrol.fault.JobKickDuplicate;
import com.clustercontrol.fault.JobMasterNotFound;
import com.clustercontrol.fault.JobSessionDuplicate;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.fault.OtherUserGetLock;
import com.clustercontrol.fault.UpdateTimeNotLatest;
import com.clustercontrol.fault.UsedFacility;
import com.clustercontrol.fault.UserNotFound;
import com.clustercontrol.jobmanagement.bean.JobFileCheck;
import com.clustercontrol.jobmanagement.bean.JobForwardFile;
import com.clustercontrol.jobmanagement.bean.JobHistoryFilter;
import com.clustercontrol.jobmanagement.bean.JobHistoryList;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobKick;
import com.clustercontrol.jobmanagement.bean.JobNodeDetail;
import com.clustercontrol.jobmanagement.bean.JobOperationInfo;
import com.clustercontrol.jobmanagement.bean.JobPlan;
import com.clustercontrol.jobmanagement.bean.JobPlanFilter;
import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobTriggerInfo;
import com.clustercontrol.jobmanagement.session.JobControllerBean;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class JobControllerBeanWrapper
extends JobControllerBean {
    private static ThreadLocal<JobControllerBeanWrapper> instance = new ThreadLocal<JobControllerBeanWrapper>(){

        @Override
        protected JobControllerBeanWrapper initialValue() {
            return null;
        }
    };

    private JobControllerBeanWrapper() {
    }

    public JobSchedule getJobSchedule(final String jobKickId) throws JobMasterNotFound, InvalidRole, HinemosUnknown {
        try {
            return this.execute(new Callable<JobSchedule>(){

                @Override
                public JobSchedule call() throws Exception {
                    return new JobControllerBean().getJobSchedule(jobKickId);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof JobMasterNotFound) {
                throw new JobMasterNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public void registerJobunit(final JobTreeItem jobunit) throws HinemosUnknown, JobMasterNotFound, JobInvalid, InvalidObjectPrivilege {
        try {
            final JobTreeItem original = this.execute(new Callable<JobTreeItem>(){

                @Override
                public JobTreeItem call() throws Exception {
                    JobControllerBean bean = new JobControllerBean();
                    JobTreeItem root = bean.getJobTree(null, true, Locale.getDefault());
                    JobTreeItem original = HinemosUtil.searchJobTreeItem(root, jobunit.getData().getJobunitId(), jobunit.getData().getId());
                    bean.registerJobunit(jobunit);
                    return original;
                }
            });
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                @Override
                public void rollback() throws TransactionException {
                    try {
                        JobControllerBeanWrapper.this.execute(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                if (original != null) {
                                    new JobControllerBean().registerJobunit(original);
                                } else {
                                    new JobControllerBean().deleteJobunit(jobunit.getData().getId());
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidObjectPrivilege) {
                throw new InvalidObjectPrivilege(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobMasterNotFound) {
                throw new JobMasterNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobInvalid) {
                throw new JobInvalid(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public void addSchedule(final JobSchedule info) throws HinemosUnknown, InvalidSetting, JobKickDuplicate, InvalidRole {
        try {
            this.execute(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    new JobControllerBean().addSchedule(info);
                    return null;
                }
            });
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                @Override
                public void rollback() throws TransactionException {
                    try {
                        JobControllerBeanWrapper.this.execute(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                new JobControllerBean().deleteSchedule(info.getId());
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobKickDuplicate) {
                throw new JobKickDuplicate(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof InvalidSetting) {
                throw new InvalidSetting(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public JobTreeItem getJobTree(final String ownerRoleId, final boolean treeOnly, final Locale locale) throws NotifyNotFound, HinemosUnknown, JobMasterNotFound, UserNotFound, InvalidRole {
        try {
            return this.execute(new Callable<JobTreeItem>(){

                @Override
                public JobTreeItem call() throws Exception {
                    return new JobControllerBean().getJobTree(ownerRoleId, treeOnly, locale);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof NotifyNotFound) {
                throw new NotifyNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobMasterNotFound) {
                throw new JobMasterNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof UserNotFound) {
                throw new UserNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public void deleteSchedule(final String scheduleId) throws HinemosUnknown, JobInfoNotFound, InvalidRole {
        try {
            final JobSchedule info = this.execute(new Callable<JobSchedule>(){

                @Override
                public JobSchedule call() throws Exception {
                    JobControllerBean bean = new JobControllerBean();
                    JobSchedule info = bean.getJobSchedule(scheduleId);
                    bean.deleteSchedule(scheduleId);
                    return info;
                }
            });
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                @Override
                public void rollback() throws TransactionException {
                    try {
                        JobControllerBeanWrapper.this.execute(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                new JobControllerBean().addSchedule(info);
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobInfoNotFound) {
                throw new JobInfoNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    private <T> T execute(Callable<T> task) throws Exception {
        return HinemosUtil.submit(task).get();
    }

    public static JobControllerBeanWrapper bean() {
        JobControllerBeanWrapper bean = instance.get();
        if (bean == null) {
            bean = new JobControllerBeanWrapper();
            instance.set(bean);
        }
        return bean;
    }

    public String getSeparator() {
        throw new UnsupportedOperationException();
    }

    public JobInfo getJobFull(final JobInfo jobInfo) throws JobMasterNotFound, UserNotFound, HinemosUnknown, InvalidRole {
        try {
            return this.execute(new Callable<JobInfo>(){

                @Override
                public JobInfo call() throws Exception {
                    return new JobControllerBean().getJobFull(jobInfo);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobMasterNotFound) {
                throw new JobMasterNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof UserNotFound) {
                throw new UserNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public void deleteJobunit(final String jobunitId) throws HinemosUnknown, JobMasterNotFound, InvalidSetting, JobInvalid, InvalidObjectPrivilege {
        try {
            final JobTreeItem original = this.execute(new Callable<JobTreeItem>(){

                @Override
                public JobTreeItem call() throws Exception {
                    JobControllerBean bean = new JobControllerBean();
                    JobTreeItem root = bean.getJobTree(null, true, Locale.getDefault());
                    JobTreeItem original = HinemosUtil.searchJobTreeItem(root, jobunitId, jobunitId);
                    bean.deleteJobunit(jobunitId);
                    return original;
                }
            });
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                @Override
                public void rollback() throws TransactionException {
                    try {
                        JobControllerBeanWrapper.this.execute(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                if (original != null) {
                                    new JobControllerBean().registerJobunit(original);
                                } else {
                                    new JobControllerBean().deleteJobunit(jobunitId);
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidSetting) {
                throw new InvalidSetting(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof InvalidObjectPrivilege) {
                throw new InvalidObjectPrivilege(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobMasterNotFound) {
                throw new JobMasterNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobInvalid) {
                throw new JobInvalid(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public void deleteJobunit(String jobunitId, boolean refCheck) throws HinemosUnknown, JobMasterNotFound, InvalidSetting, JobInvalid, InvalidObjectPrivilege {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getAvailableStartOperation(String sessionId, String jobunitId, String jobId, String facilityId, Locale locale) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getAvailableStopOperation(String sessionId, String jobunitId, String jobId, String facilityId, Locale locale) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public String runJob(final String jobunitId, final String jobId, final JobTriggerInfo triggerInfo) throws FacilityNotFound, HinemosUnknown, JobMasterNotFound, JobInfoNotFound, JobSessionDuplicate, InvalidRole {
        try {
            return this.execute(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return new JobControllerBean().runJob(jobunitId, jobId, triggerInfo);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobMasterNotFound) {
                throw new JobMasterNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobInfoNotFound) {
                throw new JobInfoNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobSessionDuplicate) {
                throw new JobSessionDuplicate(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof FacilityNotFound) {
                throw new FacilityNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public String runJob(final String jobunitId, final String jobId, final OutputBasicInfo info, final JobTriggerInfo triggerInfo) throws FacilityNotFound, HinemosUnknown, JobInfoNotFound, JobMasterNotFound, JobSessionDuplicate, InvalidRole {
        try {
            return this.execute(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return new JobControllerBean().runJob(jobunitId, jobId, info, triggerInfo);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobMasterNotFound) {
                throw new JobMasterNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobInfoNotFound) {
                throw new JobInfoNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof JobSessionDuplicate) {
                throw new JobSessionDuplicate(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof FacilityNotFound) {
                throw new FacilityNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public void scheduleRunJob(String jobunitId, String jobId, String calendarId, JobTriggerInfo triggerInfo) throws FacilityNotFound, CalendarNotFound, JobMasterNotFound, JobInfoNotFound, HinemosUnknown, JobSessionDuplicate, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public void operationJob(JobOperationInfo property) throws HinemosUnknown, JobInfoNotFound, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public JobHistoryList getJobHistoryList(JobHistoryFilter property, int histories) throws JobInfoNotFound, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public JobTreeItem getJobDetailList(String sessionId) throws JobInfoNotFound, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<JobNodeDetail> getNodeDetailList(String sessionId, String jobunitId, String jobId, Locale locale) throws JobInfoNotFound, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<JobForwardFile> getForwardFileList(String sessionId, String jobunitId, String jobId) throws JobInfoNotFound, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void addFileCheck(JobFileCheck info) throws HinemosUnknown, InvalidSetting, JobKickDuplicate, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public void modifySchedule(JobSchedule info) throws HinemosUnknown, InvalidSetting, JobInfoNotFound, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public void modifyFileCheck(JobFileCheck info) throws HinemosUnknown, InvalidSetting, JobInfoNotFound, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public void deleteFileCheck(String scheduleId) throws HinemosUnknown, JobInfoNotFound, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public ArrayList<JobKick> getJobKickList() throws JobMasterNotFound, HinemosUnknown, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public JobFileCheck getJobFileCheck(String jobKickId) throws JobMasterNotFound, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<JobFileCheck> getJobFileCheck(ArrayList<String> facilityIdList) throws JobMasterNotFound, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void setJobKickStatus(String scheduleId, boolean validFlag) throws HinemosUnknown, InvalidSetting, JobMasterNotFound, JobInfoNotFound, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public JobTreeItem getSessionJobInfo(String sessionId, String jobunitId, String jobId) throws HinemosUnknown, JobInfoNotFound, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public ArrayList<JobPlan> getPlanList(JobPlanFilter filter, int plans) throws JobMasterNotFound, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void isUseFacilityId(String facilityId) throws UsedFacility {
        throw new UnsupportedOperationException();
    }

    public Long getUpdateTime(String jobunitId) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public Integer getEditLock(String jobunitId, Long updateTime, boolean forceFlag, String userName, String ipAddress) throws HinemosUnknown, OtherUserGetLock, UpdateTimeNotLatest, JobMasterNotFound, JobInvalid, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public void checkEditLock(String jobunitId, Integer editSession) throws HinemosUnknown, OtherUserGetLock, JobMasterNotFound, JobInvalid, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public void releaseEditLock(Integer editSession) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }
}

