/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ws.cloud;

import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.accesscontrol.bean.SystemPrivilegeInfo;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.commons.HinemosProperties;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.cloud.validation.ValidationUtil;
import com.clustercontrol.plugin.impl.WebServicePlugin;
import com.clustercontrol.ws.cloud.IWebServiceBase;
import com.clustercontrol.ws.cloud.security.HinemosAccessRight;
import com.clustercontrol.ws.cloud.security.HinemosAccessRights;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.Invoker;
import javax.xml.ws.spi.Provider;
import org.apache.log4j.Logger;

public class Publisher
implements AutoCloseable {
    private List<CloudInvoker> endpoints = Collections.synchronizedList(new ArrayList());
    private List<MethodChecker> checkers = Collections.synchronizedList(new ArrayList());
    private UncaughtExceptionHandler handler;
    private static ThreadLocal<WebServiceContext> context = new ThreadLocal<WebServiceContext>(){

        @Override
        protected WebServiceContext initialValue() {
            return null;
        }
    };

    public static WebServiceContext getCurrentContext() {
        return context.get();
    }

    public void publish(String address, IWebServiceBase implementor) {
        URL url = null;
        try {
            url = new URL(address);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
        if ("https".equals(url.getProtocol())) {
            URL urlPrefix;
            Map httpsServerMap = null;
            Field field = null;
            Boolean accesible = null;
            try {
                field = WebServicePlugin.class.getDeclaredField("httpsServerMap");
                accesible = field.isAccessible();
                field.setAccessible(true);
                httpsServerMap = (Map)field.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (accesible != null) {
                    field.setAccessible(accesible);
                }
            }
            ThreadPoolExecutor _threadPool = null;
            Field field2 = null;
            Boolean accesible2 = null;
            try {
                field2 = WebServicePlugin.class.getDeclaredField("_threadPool");
                accesible2 = field2.isAccessible();
                field2.setAccessible(true);
                _threadPool = (ThreadPoolExecutor)field2.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (accesible2 != null) {
                    field2.setAccessible(accesible2);
                }
            }
            CloudInvoker invoker = new CloudInvoker(implementor);
            implementor.start();
            Endpoint e = Provider.provider().createEndpoint(null, implementor.getClass(), (Invoker)invoker, new WebServiceFeature[0]);
            e.setExecutor((Executor)_threadPool);
            try {
                urlPrefix = new URL("https://" + url.getHost() + ":" + url.getPort());
            }
            catch (Exception e1) {
                throw new InternalManagerError(e1);
            }
            HttpsServer server = (HttpsServer)httpsServerMap.get(urlPrefix);
            if (server == null) {
                try {
                    String protocol = HinemosProperties.getProperty("common.ws.https.protocol", "TLS");
                    String keystorePath = HinemosProperties.getProperty("common.ws.https.keystore.path", "/root/keystore");
                    String keystorePassword = HinemosProperties.getProperty("common.ws.https.keystore.password", "hinemos");
                    String keystoreType = HinemosProperties.getProperty("common.ws.https.keystore.type", "PKCS12");
                    SSLContext ssl = SSLContext.getInstance(protocol);
                    KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    KeyStore store = KeyStore.getInstance(keystoreType);
                    store.load(new FileInputStream(keystorePath), keystorePassword.toCharArray());
                    keyFactory.init(store, keystorePassword.toCharArray());
                    TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustFactory.init(store);
                    ssl.init(keyFactory.getKeyManagers(), trustFactory.getTrustManagers(), new SecureRandom());
                    HttpsConfigurator configurator = new HttpsConfigurator(ssl);
                    server = HttpsServer.create(new InetSocketAddress(urlPrefix.getHost(), urlPrefix.getPort()), 0);
                    server.setHttpsConfigurator(configurator);
                    httpsServerMap.put(urlPrefix, server);
                }
                catch (Exception e1) {
                    throw new InternalManagerError(e1);
                }
            }
            e.publish((Object)server.createContext(url.getPath()));
            invoker.setEndpoint(e);
            this.endpoints.add(invoker);
        } else {
            CloudInvoker invoker = new CloudInvoker(implementor);
            implementor.start();
            Endpoint e = Provider.provider().createEndpoint(null, implementor.getClass(), (Invoker)invoker, new WebServiceFeature[0]);
            e.publish(address);
            invoker.setEndpoint(e);
            this.endpoints.add(invoker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        List<CloudInvoker> list = this.endpoints;
        synchronized (list) {
            for (CloudInvoker ep : this.endpoints) {
                try {
                    ep.getImplementor().stop();
                }
                catch (Exception e) {
                    Logger logger = Logger.getLogger(Publisher.class);
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void addChecker(MethodChecker checker) {
        this.checkers.add(checker);
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        this.handler = handler;
    }

    private class CloudInvoker
    extends Invoker {
        private IWebServiceBase implementor;
        private Field resourceField;
        private Endpoint endpoint;
        private WebServiceContext wsctx;

        public CloudInvoker(IWebServiceBase implementor) {
            assert (implementor != null);
            for (Field f : implementor.getClass().getDeclaredFields()) {
                if (f.getAnnotation(Resource.class) == null) continue;
                this.resourceField = f;
                break;
            }
            this.implementor = implementor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void inject(WebServiceContext wsctx) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.wsctx = wsctx;
            if (this.resourceField != null) {
                boolean flag = this.resourceField.isAccessible();
                this.resourceField.setAccessible(true);
                try {
                    this.resourceField.set(this.implementor, wsctx);
                }
                finally {
                    this.resourceField.setAccessible(flag);
                }
            }
        }

        public Object invoke(Method method, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Logger logger = Logger.getLogger(Publisher.class);
            logger.debug((Object)("calling " + method.getName()));
            try {
                long before = System.currentTimeMillis();
                context.set(this.wsctx);
                HinemosAccessRight accessRight = method.getAnnotation(HinemosAccessRight.class);
                if (accessRight != null) {
                    for (PrivilegeConstant.SystemPrivilegeMode systemPrivilege : accessRight.right()) {
                        HinemosUtil.authCheck(this.wsctx, new SystemPrivilegeInfo(accessRight.roleName(), systemPrivilege));
                    }
                } else {
                    HinemosAccessRights ars = method.getAnnotation(HinemosAccessRights.class);
                    if (ars != null) {
                        ArrayList spis = new ArrayList();
                        for (HinemosAccessRight ar : ars.value()) {
                            for (PrivilegeConstant.SystemPrivilegeMode systemPrivilege : ar.right()) {
                                HinemosUtil.authCheck(this.wsctx, new SystemPrivilegeInfo(ar.roleName(), systemPrivilege));
                            }
                        }
                        if (!spis.isEmpty()) {
                            HinemosUtil.authCheck(this.wsctx, spis.toArray(new SystemPrivilegeInfo[0]));
                        }
                    }
                }
                ValidationUtil.getMethodValidator().validate(method, args);
                ArrayList checkerList = new ArrayList(Publisher.this.checkers);
                for (MethodChecker checker : checkerList) {
                    checker.check(method, args);
                }
                Object returnValue = method.invoke((Object)this.implementor, args);
                context.set(null);
                long after = System.currentTimeMillis();
                StringBuilder sb = new StringBuilder();
                sb.append("Called ").append(method.getName()).append(" : ").append("elapsedTime=").append(after - before).append("ms");
                if (args != null) {
                    for (Object arg : args) {
                        sb.append(", arg=").append(arg.toString());
                    }
                }
                logger.info((Object)sb.toString());
                Object object = returnValue;
                return object;
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e.getTargetException().getMessage(), e.getTargetException());
                throw e;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                PluginFault fault;
                logger.error((Object)e.getMessage(), (Throwable)e);
                if (Publisher.this.handler != null && (fault = Publisher.this.handler.uncaughtException(e)) != null) {
                    throw new InvocationTargetException(fault);
                }
                if (e instanceof InternalManagerError) {
                    throw (InternalManagerError)e;
                }
                throw new InternalManagerError(e);
            }
            finally {
                SessionService.current().close();
            }
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public IWebServiceBase getImplementor() {
            return this.implementor;
        }
    }

    public static interface UncaughtExceptionHandler {
        public PluginFault uncaughtException(Throwable var1);
    }

    public static interface MethodChecker {
        public void check(Method var1, Object ... var2) throws PluginFault;
    }
}

