/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Messages;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public enum ErrorCode {
    UNEXPECTED("unexpected"),
    HINEMOS_MANAGER_ERROR(new String[0]),
    CLOUDREGION_INVALID_CLOUDREGION_NOT_FOUND("message.validation.entity.invalid_pk2.not_found"),
    CLOUDUSER_ALREADY_EXIST("message.validation.clouduser.already_exist"),
    CLOUDUSER_INVALID_NOT_RELAITED_HINEMOS_ACCOUNT("message.validation.clouduser.not_relaited_hinemos_account"),
    CLOUDUSER_INVALID_ACCESSKEY("message.validation.clouduser.invalid_accesskey.not_found"),
    CLOUDUSER_NOT_FOUND("message.validation.entity.invalid_pk.not_found"),
    CLOUDUSER_INVALID_USE_ONLY_ACCOUNT("message.validation.cloud_user.message5"),
    CLOUDUSER_CAN_NOT_REMOVE_ACCOUNT("message.validation.cloud_user.can_not_remove_account"),
    ACCOUNTRESOURCE_ALREADY_EXIST("message.validation.accountresource.already_exist"),
    ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND("message.validation.accountresource.invalid_pk.not_found"),
    ACCOUNTRESOURCE_INVALID_ALREADY_ASSINED_ADMIN_USER("message.validation.accountresource.already_assined_admin_user"),
    ACCOUNTRESOURCE_MUST_HAVE_ACCOUNT("message.validation.accountresource.must_have_account"),
    ACCOUNTRESOURCE_NOT_REMOVE_NOT_TO_REMOVE_FACILITY("message.account_resource.not_delete_account_resource_not_to_delete_facility.exception"),
    ACCOUNTRESOURCE_NOT_REMOVE_NOT_TO_REMOVE_JOBUNIT("message.account_resource.not_delete_account_resource_not_to_delete_jobunit.exception"),
    CLOUDSERVICE_ALREADY_EXIST("message.validation.cloudservice.already_exist"),
    CLOUDSERVICE_INVALID_CLOUDSERVICE_NOT_FOUND("message.validation.entity.invalid_pk.not_found"),
    CLOUDINSTANCE_ALREADY_EXIST("message.validation.cloudinstance.already_exist"),
    CLOUDINSTANCE_NOT_FOUND("message.validation.entity.invalid_pk.not_found"),
    CLOUDINSTANCE_NOT_RUNNING("message.validation.cloudinstance.not_running"),
    CLOUDINSTANCE_NOT_FOUND_BY_FACILITY("message.validation.cloudinstance.not_found_by_facilityId"),
    CLOUDINSTANCE_DUPLICATE_NODE("message.validation.cloudinstance.duplicate_node"),
    CLOUDSTORAGE_ALREADY_EXIST("message.validation.cloudstorage.already_exist"),
    CLOUDSTORAGE_INVALID_CLOUDSTORAGE_NOT_FOUND("message.validation.entity.invalid_pk.not_found"),
    CLOUDINSTANCEBACKUP_INVALID_CLOUDINSTANCEBACKUP_NOT_FOUND("message.validation.entity.invalid_pk.not_found"),
    CLOUDINSTANCEBACKUP_NOT_FOUND_NODE("message.validation.cloudinstancebackup.not_found_node"),
    CLOUDSTORAGEBACKUP_INVALID_CLOUDSTORAGEBACKUP_NOT_FOUND("message.validation.entity.invalid_pk.not_found"),
    CLOUDTEMPLATE_ALREADY_EXIST("message.validation.cloudtemplate.already_exist"),
    CLOUDTEMPLATE_NOT_FOUND("CloudTemplate.InvaidCloudTemplatePK.NotFound"),
    RESOURCESTORE_NOT_FOUND("message.validation.resourcestore.not_found"),
    RESOURCEMANAGEMENT_NOT_FOUND("message.error.resource_management.not_found"),
    CLOUDAUTOCONTROL_ALREADY_EXIST("message.validation.cloudautocontrol.already_exist"),
    CLOUDAUTOCONTROL_NOT_FOUND("message.validation.cloudautocontrol.not_found"),
    CLOUDAUTOCONTROL_OPERATION_MISSING_PARAM("message.validation.cloudautocontrol.operation.missing_param"),
    CLOUDAUTOCONTROL_OPERATION_NOT_FOUND("message.validation.cloudautocontrol.operation.not_found"),
    CLOUDAUTOCONTROL_OPERATION_NOT_MATCH_PARAM_RORMAT("message.validation.cloudautocontrol.operation.not_match_param_format"),
    MONITOR_MISSING_ACCOUNTRESOURCEID("message.validation.monitor.missing_accountresource_id"),
    MONITOR_INVALID_ACCOUNTRESOURCEID("message.validation.monitor.invalid_accountresource_id"),
    MONITOR_CLOUDSERVICE_FOUND_NO_SERVICEID("message.validation.monitor.cloudservice.found_no_serviceid"),
    MONITOR_CLOUDSERVICE_ONLY_NODE("message.validation.monitor.cloudservice.only_node"),
    AUTOUPDATE_NOT_DELETE_FACILITY("message.autoupdate.not_delete_facility.exception"),
    OBJECTREGISTORY_FOUND_NO_OBJECT("message.validation.monitor.cloudservice.only_node"),
    OBJECTREGISTORY_FOUND_NO_OBJECT2("message.validation.monitor.cloudservice.only_node2"),
    BILLINGALARM_ALREADY_EXIST("message.validation.billingalarm.already_exist"),
    BILLINGALARM_NOT_FOUND("message.validation.billingalarm.not_found"),
    BILLINGALARM_NOT_FOUND_BY_HINEMOSUSER("message.validation.billingalarm.not_found_by_hinemos_user"),
    NODE_DO_NOT_BE_ACCESSIBLE("message.validation.node.do_not_be_accessible"),
    NEED_ADMINISTRATORS_ROLE("message.error.need_administrators_role_in_order_to_perfoem_this_operation"),
    NEED_ADMINISTRATORS_ROLE_OR_ACCOUT_USER("message.error.need_administrators_role_or_account_user_in_order_to_perfoem_this_operation0", "message.error.need_administrators_role_or_account_user_in_order_to_perfoem_this_operation1"),
    NEED_ADMINISTRATORS_ROLE_OR_ACCOUT_USER_OR_SELF("message.error.need_administrators_role_or_account_user_or_self_in_order_to_perfoem_this_operation"),
    BILLINGALARM_INVALID_BILLINGALARMID_NOT_FOUND("BillingAlarm.InvalidBillingAlarmId.NotFound"),
    EC2SERVICE_INVALID_REGIONID_NOT_FOUND("EC2Service.InvaidRegionId.NotFound");

    private String[] messageIds;

    private ErrorCode(String ... messageId) {
        this.messageIds = messageId;
    }

    public String getMessage(Object ... args) {
        MessageFormat messageFormat = new MessageFormat(this.getMessage());
        return messageFormat.format(args);
    }

    public String getMessageByIndex(int index, Object ... args) {
        MessageFormat messageFormat = new MessageFormat(this.getMessage());
        return messageFormat.format(args);
    }

    public boolean match(String errorCode) {
        return this.name().equals(errorCode);
    }

    public boolean match(CloudManagerFault e) {
        return this.name().equals(e.getErrorCode());
    }

    public String getMessage() {
        return this.getMessageByIndex(0);
    }

    public String getMessageByIndex(int index) {
        try {
            return Messages.getString(this.messageIds[index]);
        }
        catch (MissingResourceException e) {
            return this.messageIds[index];
        }
    }

    public CloudManagerFault cloudManagerFault(Object ... args) {
        return new CloudManagerFault(this.getMessage(args), this.name());
    }

    public CloudManagerFault cloudManagerFault(Exception e) {
        return new CloudManagerFault(e.toString(), this.name(), e);
    }

    public CloudManagerFault cloudManagerFault(Exception e, Object ... args) {
        return new CloudManagerFault(this.getMessage(args), this.name(), e);
    }

    public CloudManagerFault cloudManagerFaultByIndex(int index, Object ... args) {
        return new CloudManagerFault(this.getMessageByIndex(index, args), this.name());
    }

    public CloudManagerFault cloudManagerFaultByIndex(int index, Exception e, Object ... args) {
        return new CloudManagerFault(this.getMessageByIndex(index, args), this.name(), e);
    }
}

