/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.bean.BlockDeviceMapping;
import com.clustercontrol.cloud.bean.InstanceRegistStateType;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.dao.CloudInstanceDao;
import com.clustercontrol.cloud.validation.annotation.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CloudInstance
implements Serializable {
    private static final long serialVersionUID = 2744959762926787150L;
    private CloudInstanceDao dao;
    private String facilityName;
    private String platform;
    private String imageId;
    private String cloudTypeId;
    private InstanceStateKind state;
    private String flavor;
    private List<Tag> tags = new ArrayList<Tag>();
    private List<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();

    public CloudInstance() {
        this.dao = new CloudInstanceDao();
    }

    public CloudInstance(CloudInstanceDao dao, String cloudTypeId, String facilityName) {
        this.dao = dao;
        this.facilityName = facilityName;
        this.cloudTypeId = cloudTypeId;
    }

    public CloudInstance(CloudInstanceDao tableData, String cloudTypeId, IResourceManagement.Instance instance, String facilityName) {
        this(tableData, cloudTypeId, facilityName);
        this.platform = instance.getPlatform().label();
        this.imageId = instance.getImageId();
        this.state = InstanceStateKind.byLabel(instance.getState().name());
        this.flavor = instance.getFlavor();
        this.imageId = instance.getImageId();
        for (Tag t : instance.getTags()) {
            Tag tag = new Tag(t.getKey(), t.getValue());
            this.tags.add(tag);
        }
        for (IResourceManagement.Instance.BlockDeviceMapping d : instance.getBlockDeviceMappings()) {
            BlockDeviceMapping device = new BlockDeviceMapping(d.getStorageId(), d.getDeviceName(), d.getStatus());
            this.blockDeviceMappings.add(device);
        }
    }

    public String getFacilityId() {
        return this.dao.getFacilityId();
    }

    public void setFacilityId(String facilityId) {
        throw new UnsupportedOperationException();
    }

    public String getFacilityName() {
        return this.facilityName;
    }

    public void setFacilityName(String facilityName) {
        throw new UnsupportedOperationException();
    }

    public String getInstanceId() {
        return this.dao.getInstanceId();
    }

    public void setInstanceId(String instanceId) {
        throw new UnsupportedOperationException();
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        throw new UnsupportedOperationException();
    }

    public String getAccountResourceId() {
        return this.dao.getAccountResourceId();
    }

    public void setAccountResourceId(String accountResourceId) {
    }

    public String getRegion() {
        return this.dao.getRegion();
    }

    public void setRegion(String region) {
        throw new UnsupportedOperationException();
    }

    public String getZone() {
        return this.dao.getZone();
    }

    public void setZone(String zone) {
        throw new UnsupportedOperationException();
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        throw new UnsupportedOperationException();
    }

    @Size(elementId="cloudInstance.templateId", max=64)
    public String getTemplateId() {
        return this.dao.getTemplateId();
    }

    public void setTemplateId(String templateId) {
        throw new UnsupportedOperationException();
    }

    public InstanceStateKind getState() {
        return this.state;
    }

    public void setState(InstanceStateKind state) {
        throw new UnsupportedOperationException();
    }

    public InstanceRegistStateType getRegistState() {
        if (this.dao.getRegistStatus() == null) {
            return null;
        }
        return InstanceRegistStateType.valueOf(this.dao.getRegistStatus().name());
    }

    public void setRegistState(InstanceRegistStateType registState) {
        throw new UnsupportedOperationException();
    }

    public String getFlavor() {
        return this.flavor;
    }

    public void setFlavor(String flavor) {
        throw new UnsupportedOperationException();
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        throw new UnsupportedOperationException();
    }

    public String getInstanceName() {
        return this.dao.getInstanceName();
    }

    public void setInstanceName(String instanceName) {
        throw new UnsupportedOperationException();
    }

    public String getCloudUserId() {
        return this.dao.getCloudUserId();
    }

    public void setCloudUserId(String cloudUserId) {
        throw new UnsupportedOperationException();
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
        throw new UnsupportedOperationException();
    }

    public Long getRegDate() {
        return this.dao.getRegDate() != null ? Long.valueOf(this.dao.getRegDate().getTime()) : null;
    }

    public void setRegDate(Long regDate) {
        throw new UnsupportedOperationException();
    }

    public Long getUpdateDate() {
        return this.dao.getUpdateDate() != null ? Long.valueOf(this.dao.getUpdateDate().getTime()) : null;
    }

    public void setUpdateDate(Long updateDate) {
        throw new UnsupportedOperationException();
    }

    public String getRegUser() {
        return this.dao.getRegUser();
    }

    public void setRegUser(String regUser) {
        throw new UnsupportedOperationException();
    }

    public String getUpdateUser() {
        return this.dao.getUpdateUser();
    }

    public void setUpdateUser(String updateUser) {
        throw new UnsupportedOperationException();
    }

    public String getCloudTypeId() {
        return this.cloudTypeId;
    }

    public void setCloudTypeId(String cloudTypeId) {
        throw new UnsupportedOperationException();
    }
}

