/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.bean.StorageAttachment;
import com.clustercontrol.cloud.bean.StorageRegistStateType;
import com.clustercontrol.cloud.dao.CloudStorageDao;
import java.io.Serializable;

public class CloudStorage
implements Serializable {
    private static final long serialVersionUID = 5047727801682788230L;
    private CloudStorageDao dao;
    private String state;
    private String facilityName;
    private Integer size;
    private String snapshotId;
    private String flavor;
    private StorageAttachment storageAttachment;

    public CloudStorage() {
        this.dao = new CloudStorageDao();
    }

    public CloudStorage(CloudStorageDao tableData, String facilityName) {
        this.dao = new CloudStorageDao(tableData);
        this.facilityName = facilityName;
    }

    public CloudStorage(CloudStorageDao dao, IResourceManagement.Storage storage, String facilityName) {
        this(dao, facilityName);
        if (storage.getStorageAttachment() != null) {
            StorageAttachment sa = new StorageAttachment();
            sa.setInstanceId(storage.getStorageAttachment().getInstanceId());
            sa.setDevice(storage.getStorageAttachment().getDevice());
            sa.setState(storage.getStorageAttachment().getState().label());
            sa.setAttachTime(storage.getStorageAttachment().getAttachTime().getTime());
            this.setStorageAttachment(sa);
        }
        this.flavor = storage.getFlavor();
        this.facilityName = facilityName;
        this.snapshotId = storage.getSnapshotId();
        this.size = storage.getSize();
        this.state = storage.getState().label();
    }

    public String getStorageId() {
        return this.dao.getStorageId();
    }

    public void setStorageId(String storageId) {
        throw new UnsupportedOperationException();
    }

    public String getState() {
        return this.state;
    }

    public void setState(String status) {
        throw new UnsupportedOperationException();
    }

    public String getStorageName() {
        return this.dao.getStorageName();
    }

    public void setStorageName(String storageName) {
        throw new UnsupportedOperationException();
    }

    public String getFlavor() {
        return this.flavor;
    }

    public void setFlavor(String flavor) {
        throw new UnsupportedOperationException();
    }

    public String getFacilityId() {
        return this.dao.getFacilityId();
    }

    public void setFacilityId(String facilityId) {
        throw new UnsupportedOperationException();
    }

    public Integer getDeviceIndex() {
        return this.dao.getDeviceIndex();
    }

    public void setDeviceIndex(Integer deviceIndex) {
        throw new UnsupportedOperationException();
    }

    public String getDeviceType() {
        return this.dao.getDeviceType();
    }

    public void setDeviceType(String deviceType) {
        throw new UnsupportedOperationException();
    }

    public String getDeviceName() {
        return this.dao.getDeviceName();
    }

    public void setDeviceName(String deviceName) {
        throw new UnsupportedOperationException();
    }

    public String getRegion() {
        return this.dao.getRegion();
    }

    public void setRegion(String region) {
        throw new UnsupportedOperationException();
    }

    public String getZone() {
        return this.dao.getZone();
    }

    public void setZone(String zone) {
        throw new UnsupportedOperationException();
    }

    public StorageRegistStateType getRegistState() {
        if (this.dao.getRegistStatus() == null) {
            return null;
        }
        return StorageRegistStateType.valueOf(this.dao.getRegistStatus().name());
    }

    public void setRegistState(StorageRegistStateType registState) {
        throw new UnsupportedOperationException();
    }

    public Long getRegDate() {
        return this.dao.getRegDate() != null ? Long.valueOf(this.dao.getRegDate().getTime()) : null;
    }

    public void setRegDate(Long regDate) {
        throw new UnsupportedOperationException();
    }

    public Long getUpdateDate() {
        return this.dao.getUpdateDate() != null ? Long.valueOf(this.dao.getUpdateDate().getTime()) : null;
    }

    public void setUpdateDate(Long updateDate) {
        throw new UnsupportedOperationException();
    }

    public String getRegUser() {
        return this.dao.getRegUser();
    }

    public void setRegUser(String regUser) {
        throw new UnsupportedOperationException();
    }

    public String getUpdateUser() {
        return this.dao.getUpdateUser();
    }

    public void setUpdateUser(String updateUser) {
        throw new UnsupportedOperationException();
    }

    public String getFacilityName() {
        return this.facilityName;
    }

    public void setFacilityName(String facilityName) {
        throw new UnsupportedOperationException();
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        throw new UnsupportedOperationException();
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        throw new UnsupportedOperationException();
    }

    public StorageAttachment getStorageAttachment() {
        return this.storageAttachment;
    }

    public void setStorageAttachment(StorageAttachment storageAttachment) {
        this.storageAttachment = storageAttachment;
    }
}

