/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.factory.CloudAccessorUtil;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.AuthorizingUtil;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Size;

@CustomEntityValidation(value=CloudUserValidator.class)
public class ModifyCloudUserRequest {
    private String cloudUserId;
    private String cloudUserName;
    private String description;
    private String accessKey;
    private String secretKey;

    @ElementId(value="cloudUserId")
    @Identity
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    public void setCloudUserId(String cloudUserId) {
        this.cloudUserId = cloudUserId;
    }

    @ElementId(value="cloudUserName")
    @Size(max=128)
    public String getCloudUserName() {
        return this.cloudUserName;
    }

    public void setCloudUserName(String cloudUserName) {
        this.cloudUserName = cloudUserName;
    }

    @ElementId(value="description")
    @Size(max=256)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public static class CloudUserValidator
    implements CustomEntityValidator<ModifyCloudUserRequest>,
    ValidationConstants {
        public void validate(ModifyCloudUserRequest entity, String group, IMessagesHolder messages, EntityValidator.EntityValidationContext context) throws ValidationFault {
            try {
                if (!AuthorizingUtil.checkHinemousUser_administrators_account_self(SessionService.current().getHinemosCredential().getUserId(), entity.getCloudUserId())) {
                    throw ErrorCode.NEED_ADMINISTRATORS_ROLE_OR_ACCOUT_USER_OR_SELF.cloudManagerFault(SessionService.current().getHinemosCredential().getUserId(), entity.getCloudUserId());
                }
                ICloudUserOperator userOperator = (ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class);
                CloudUser cu = userOperator.findCloudUser(entity.getCloudUserId());
                IUserManagement.User user = CloudAccessorUtil.getUser(cu.getAccountResourceId(), entity.getAccessKey() == null ? cu.getAccessKey() : entity.getAccessKey(), entity.getSecretKey() == null ? cu.getSecretKey() : entity.getSecretKey());
                switch (cu.getCloudUserType()) {
                    case account: {
                        if (user.getKind() == IUserManagement.User.UserKind.account) break;
                        throw new ValidationFault(ErrorCode.CLOUDUSER_INVALID_USE_ONLY_ACCOUNT.getMessage(), ErrorCode.CLOUDUSER_INVALID_USE_ONLY_ACCOUNT.name());
                    }
                }
            }
            catch (CloudManagerFault e) {
                throw new ValidationFault(e.getMessage(), e.getErrorCode(), (Throwable)((Object)e));
            }
        }
    }
}

