/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.bean.CreateInstanceByTemplateRequest;
import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.LoadBalancer;
import com.clustercontrol.cloud.bean.RegistNodeRequest;
import com.clustercontrol.cloud.bean.RestoreInstanceRequest;
import com.clustercontrol.cloud.bean.StartInstanceRequest;
import com.clustercontrol.cloud.bean.StopInstanceRequest;
import com.clustercontrol.cloud.dao.CloudInstanceDao;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.IResourceOperatorBase;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public interface IInstanceOperator
extends IResourceOperatorBase {
    public void setFlags(boolean var1, boolean var2, boolean var3);

    public CloudInstance createInstance(CreateInstanceRequest var1) throws CloudManagerFault, InvalidRole;

    public CloudInstance createInstanceByTemplate(CreateInstanceByTemplateRequest var1) throws CloudManagerFault, InvalidRole;

    public CloudInstanceBackup createInstanceBackup(CreateInstanceBackupRequest var1) throws CloudManagerFault, InvalidRole;

    public CloudInstance restoreInstance(RestoreInstanceRequest var1) throws CloudManagerFault, InvalidRole;

    public void removeInstance(String var1) throws CloudManagerFault;

    public void removeInstanceBackup(String var1) throws CloudManagerFault;

    public InstanceStateChange startInstance(StartInstanceRequest var1) throws CloudManagerFault;

    public InstanceStateChange stopInstance(StopInstanceRequest var1) throws CloudManagerFault;

    public UpdateResult updateInstance(String var1) throws CloudManagerFault, InvalidRole;

    public UpdateAllResult updateAllInstance() throws CloudManagerFault, InvalidRole;

    public CloudInstance registNode(RegistNodeRequest var1) throws CloudManagerFault, InvalidRole;

    public void unregistNode(String var1) throws CloudManagerFault, InvalidRole;

    public CloudInstance getInstance(String var1) throws CloudManagerFault, InvalidRole;

    public CloudInstance getInstanceByFacilityId(String var1) throws CloudManagerFault, InvalidRole;

    public List<CloudInstance> getAllInstances() throws CloudManagerFault, InvalidRole;

    public CloudInstanceBackup getInstanceBackup(String var1) throws CloudManagerFault;

    public List<CloudInstanceBackup> getAllInstanceBackup() throws CloudManagerFault;

    public void updateAllInstanceBackup() throws CloudManagerFault, InvalidRole;

    public List<CloudInstanceBackup> getInstanceBackupByInstanceId(String var1) throws CloudManagerFault;

    public List<Image> getImagesWithFilter(List<Filter> var1) throws CloudManagerFault, InvalidUserPass, InvalidRole;

    public List<LoadBalancer> getLoadBalancers() throws CloudManagerFault;

    public void registerInstanceToLoadBalancer(String var1, String var2) throws CloudManagerFault;

    public void unregisterInstanceToLoadBalancer(String var1, String var2) throws CloudManagerFault;

    public static class UpdateResult {
        public final IResourceManagement.Instance awsInstance;
        public final CloudInstanceDao cloudInstance;

        public UpdateResult(IResourceManagement.Instance awsInstance, CloudInstanceDao cloudInstance) {
            this.awsInstance = awsInstance;
            this.cloudInstance = cloudInstance;
        }

        public CloudInstance getCloudInstance() {
            if (this.cloudInstance != null) {
                try {
                    ICloudServiceOperator operator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
                    CloudService service = operator.findCloudService(this.cloudInstance.getCloudServiceId());
                    if (this.awsInstance != null) {
                        return new CloudInstance(this.cloudInstance, service.getCloudTypeId(), this.awsInstance, HinemosUtil.getFacilityName((String)this.cloudInstance.getFacilityId()));
                    }
                    return new CloudInstance(this.cloudInstance, service.getCloudTypeId(), HinemosUtil.getFacilityName((String)this.cloudInstance.getFacilityId()));
                }
                catch (Exception e) {
                    throw new InternalManagerError((Throwable)e);
                }
            }
            return null;
        }
    }

    public static class UpdateAllResult {
        public final List<InstanceMapping> both;
        public final List<InstanceMapping> onlyAws;
        public final List<CloudInstanceDao> onlyCloud;

        public UpdateAllResult(List<InstanceMapping> both, List<InstanceMapping> onlyAws, List<CloudInstanceDao> onlyCloud) {
            this.both = Collections.unmodifiableList(both);
            this.onlyAws = Collections.unmodifiableList(onlyAws);
            this.onlyCloud = Collections.unmodifiableList(onlyCloud);
        }

        public List<CloudInstance> getCloudInstances() {
            try {
                CloudService service;
                ICloudServiceOperator operator;
                Logger logger = Logger.getLogger(UpdateAllResult.class);
                ArrayList<CloudInstance> cloudInstaces = new ArrayList<CloudInstance>();
                for (InstanceMapping mapping : this.both) {
                    operator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
                    service = operator.findCloudService(mapping.cloudInstance.getCloudServiceId());
                    cloudInstaces.add(new CloudInstance(mapping.cloudInstance, service.getCloudTypeId(), mapping.instance, HinemosUtil.getFacilityName((String)mapping.cloudInstance.getFacilityId())));
                    logger.debug((Object)("Both : facilityId=" + mapping.cloudInstance.getFacilityId() + ", instanceId=" + mapping.cloudInstance.getInstanceId()));
                }
                for (InstanceMapping mapping : this.onlyAws) {
                    operator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
                    service = operator.findCloudService(mapping.cloudInstance.getCloudServiceId());
                    cloudInstaces.add(new CloudInstance(mapping.cloudInstance, service.getCloudTypeId(), mapping.instance, HinemosUtil.getFacilityName((String)mapping.cloudInstance.getFacilityId())));
                    logger.debug((Object)("AWS : instanceId=" + mapping.cloudInstance.getInstanceId()));
                }
                for (CloudInstanceDao ci : this.onlyCloud) {
                    operator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
                    service = operator.findCloudService(ci.getCloudServiceId());
                    cloudInstaces.add(new CloudInstance(ci, service.getCloudTypeId(), HinemosUtil.getFacilityName((String)ci.getFacilityId())));
                    logger.debug((Object)("Cloud : facilityId=" + ci.getFacilityId() + ", instanceId=" + ci.getInstanceId()));
                }
                return cloudInstaces;
            }
            catch (Exception e) {
                throw new InternalManagerError((Throwable)e);
            }
        }

        public static class InstanceMapping {
            public IResourceManagement.Instance instance;
            public CloudInstanceDao cloudInstance;

            public InstanceMapping(IResourceManagement.Instance instance, CloudInstanceDao cloudInstance) {
                this.instance = instance;
                this.cloudInstance = cloudInstance;
            }
        }
    }
}

