/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.MessagesHolder;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.bean.CreateInstanceByTemplateRequest;
import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.bean.LoadBalancer;
import com.clustercontrol.cloud.bean.NodeDetail;
import com.clustercontrol.cloud.bean.RegistNodeRequest;
import com.clustercontrol.cloud.bean.RestoreInstanceRequest;
import com.clustercontrol.cloud.bean.RestoreStatus;
import com.clustercontrol.cloud.bean.StartInstanceRequest;
import com.clustercontrol.cloud.bean.StopInstanceRequest;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.commons.Objects;
import com.clustercontrol.cloud.dao.CloudInstanceBackupDao;
import com.clustercontrol.cloud.dao.CloudInstanceDao;
import com.clustercontrol.cloud.factory.ActionMode;
import com.clustercontrol.cloud.factory.IInstanceOperator;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.factory.ITemplateOperator;
import com.clustercontrol.cloud.factory.ResourceOperatorBase;
import com.clustercontrol.cloud.factory.TemplateJobUtil;
import com.clustercontrol.cloud.factory.monitors.InstanceMonitorService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.IDHolder;
import com.clustercontrol.cloud.persistence.PersistenceUtil;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.AccountResourceUtil;
import com.clustercontrol.cloud.util.CloudMessageUtil;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.fault.FacilityDuplicate;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.UsedFacility;
import com.clustercontrol.hinemosagent.util.AgentConnectUtil;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeVariableInfo;
import com.clustercontrol.repository.session.RepositoryControllerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityExistsException;
import org.apache.log4j.Logger;

@Transactional
public class InstanceOperator
extends ResourceOperatorBase
implements IInstanceOperator {
    private boolean update = CloudPropertyConstants.autoupdate_instance.match("on");
    private boolean regist = CloudPropertyConstants.autoregist_instance.match("on");
    private boolean relation = CloudPropertyConstants.autoregist_scope_relation.match("on");
    private static Map<Object, CriticalPoint> criticalPointMap = new HashMap<Object, CriticalPoint>();

    private static synchronized CriticalPoint getCriticalPoint(Object key) {
        CriticalPoint cp = criticalPointMap.get(key);
        if (cp == null) {
            cp = new CriticalPoint();
            criticalPointMap.put(key, cp);
        }
        return cp;
    }

    public static void asyncRegistAgent(String facilityId) {
        Logger logger = Logger.getLogger(InstanceOperator.class);
        logger.info((Object)("start to ping " + facilityId + " as agent for register."));
        SessionService.scheduleWithFixedDelay((Runnable)new RegistAgent(facilityId), (long)0L, (long)Long.parseLong(CloudPropertyConstants.agent_connection_interval.value()), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static void registAgent(String facilityId) {
        Logger logger = Logger.getLogger(InstanceOperator.class);
        logger.info((Object)("start to ping " + facilityId + " as agent for register."));
        RegistAgent ra = new RegistAgent(facilityId);
        try {
            while (true) {
                ra.run();
                Thread.sleep(Long.parseLong(CloudPropertyConstants.agent_connection_interval.value()));
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public static Boolean findAgent(String facilityId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(TemplateJobUtil.class);
        try {
            logger.info((Object)("start to check " + facilityId + " as agent for register."));
            boolean result = false;
            int counter = 0;
            int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
            long interval = Long.parseLong(CloudPropertyConstants.agent_connection_interval.value());
            while (counter < maxCount) {
                logger.debug((Object)("tr\uff59 to find agent " + facilityId + " " + ++counter + "/" + maxCount + " time."));
                RepositoryControllerBeanWrapper.bean().getNode(facilityId);
                if (AgentConnectUtil.isValidAgent((String)facilityId)) {
                    logger.info((Object)("success to find " + facilityId + " as agent."));
                    return true;
                }
                if (counter >= maxCount) {
                    throw new CloudManagerFault("timed out. agent doesn't exist.");
                }
                Thread.sleep(interval);
            }
            return result;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public InstanceOperator() throws CloudManagerFault {
    }

    public InstanceOperator(boolean upate, boolean regist, boolean relation) throws CloudManagerFault {
        this.update = upate;
        this.regist = regist;
        this.relation = relation;
    }

    @Override
    public CloudInstance createInstance(CreateInstanceRequest request) throws CloudManagerFault, InvalidRole {
        CloudInstance instance = this.internalCreateInstance(request.getNodeDetail(), request.getFlavor(), request.getImageId(), request.getZone(), request.getInstanceDetail(), null, request.getTags());
        if (instance.getFacilityId() != null) {
            InstanceOperator.asyncRegistAgent(instance.getFacilityId());
        }
        return instance;
    }

    @Override
    public CloudInstance createInstanceByTemplate(CreateInstanceByTemplateRequest request) throws CloudManagerFault, InvalidRole {
        ITemplateOperator templateOperator = this.getResourceOperator(ITemplateOperator.class);
        CloudTemplate ct = templateOperator.findTemplate(request.getTemplateId());
        CloudInstance ci = this.internalCreateInstance(request.getNodeDetail(), request.getFlavor(), ct.getImageId(), request.getZone(), request.getInstanceDetail(), ct.getTemplateId(), request.getTags());
        if (ct.getLaunchJobId() != null && !ct.getLaunchJobId().equals("")) {
            TemplateJobUtil.asyncExecute(ci.getFacilityId(), ct.getAccountResourceId(), ct.getLaunchJobId(), request.getArguments(), new TemplateJobUtil.JobEventListener(){

                @Override
                public void jobEventOccurerd(String facilityId, String jobunitId, String jobId) throws Exception {
                    InstanceOperator.registAgent(facilityId);
                }
            }, null);
        }
        return ci;
    }

    @Override
    public CloudInstanceBackup createInstanceBackup(CreateInstanceBackupRequest request) throws CloudManagerFault, InvalidRole {
        IResourceManagement rm = this.getResourceManagement();
        CloudInstance instance = this.getInstance(request.getInstanceId());
        NodeInfo nodeInfo = null;
        try {
            nodeInfo = new RepositoryControllerBean().getNode(instance.getFacilityId());
        }
        catch (FacilityNotFound e) {
            throw ErrorCode.CLOUDINSTANCEBACKUP_NOT_FOUND_NODE.cloudManagerFault(request.getInstanceId());
        }
        catch (HinemosUnknown e) {
            throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)((Object)e));
        }
        IResourceManagement.InstanceBackup instanceBackup = rm.createInstanceBackup(request.getInstanceId(), request.getName(), request.getDescription(), request.getWithVolumes(), request.getNoReboot(), request.getDetail());
        CloudInstanceBackupDao dao = new CloudInstanceBackupDao();
        dao.setInstanceBackupId(instanceBackup.getInstanceBackupId());
        dao.setCloudServiceId(this.getAccountResource().getCloudServiceId());
        dao.setRegion(this.getCloudRegion().getRegion());
        dao.setAccountResourceId(this.getAccountResource().getAccountResourceId());
        dao.setName(request.getName());
        dao.setCloudUserId(this.getCloudUser().getCloudUserId());
        dao.setDescription(request.getDescription());
        dao.setRestoreStatus(CloudInstanceBackupDao.RestoreStatus.valueOf((String)RestoreStatus.available.name()));
        CloudInstanceBackupDao.BackupedData backup = new CloudInstanceBackupDao.BackupedData();
        backup.setFacilityId(nodeInfo.getFacilityId());
        backup.setFacilityName(nodeInfo.getFacilityName());
        backup.setFacilityDescription(nodeInfo.getDescription());
        backup.setNodeName(nodeInfo.getNodeName());
        backup.setInstanceId(instance.getInstanceId());
        dao.setBackupedData(backup);
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        em.persist((IDHolder)dao);
        return new CloudInstanceBackup(dao, instanceBackup);
    }

    protected CloudInstance internalCreateInstance(NodeDetail nodeDetail, String flavor, String imageId, String zone, String instanceDetail, String templateId, List<Tag> tags) throws CloudManagerFault, InvalidRole {
        IResourceManagement.Instance instance = this.getResourceManagement().createInstance(nodeDetail.getFacilityName(), flavor, imageId, zone, instanceDetail, tags);
        CloudInstanceDao dao = this.createCloudInstanceDao(instance, templateId);
        CloudInstance cloudInstance = this.createCloudInstance(nodeDetail, dao, instance);
        InstanceMonitorService.getSingleton().startMonitor(instance.getInstanceId(), cloudInstance.getFacilityId(), SessionService.current().getContext(), this.getCloudService(), this.getCloudRegion(), this.getCloudUser(), true, InstanceStateKind.running, InstanceStateKind.terminated, InstanceStateKind.stopped);
        return cloudInstance;
    }

    @Override
    public CloudInstance restoreInstance(RestoreInstanceRequest request) throws CloudManagerFault, InvalidRole, InvalidRole {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudInstanceBackupDao backup = (CloudInstanceBackupDao)em.find(CloudInstanceBackupDao.class, (Object)new CloudInstanceBackupDao.CloudInstanceBackupPK(request.getInstanceBackupId(), this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (backup == null) {
            throw ErrorCode.CLOUDINSTANCEBACKUP_NOT_FOUND_NODE.cloudManagerFault(request.getInstanceBackupId());
        }
        NodeDetail nodeDetail = new NodeDetail();
        nodeDetail.setFacilityId(backup.getBackupedData().getFacilityId());
        nodeDetail.setFacilityName(backup.getBackupedData().getFacilityName());
        nodeDetail.setDescription(backup.getBackupedData().getFacilityDescription());
        nodeDetail.setNodeName(backup.getBackupedData().getNodeName());
        nodeDetail.setReplaceNode(Boolean.TRUE);
        if (request.getNodeDetail() != null) {
            if (request.getNodeDetail().getFacilityId() != null) {
                nodeDetail.setFacilityId(request.getNodeDetail().getFacilityId());
            }
            if (request.getNodeDetail().getFacilityName() != null) {
                nodeDetail.setFacilityName(request.getNodeDetail().getFacilityName());
            }
            if (request.getNodeDetail().getDescription() != null) {
                nodeDetail.setDescription(request.getNodeDetail().getDescription());
            }
            if (request.getNodeDetail().getNodeName() != null) {
                nodeDetail.setNodeName(request.getNodeDetail().getNodeName());
            }
            if (request.getNodeDetail().getReplaceNode() != null) {
                nodeDetail.setReplaceNode(request.getNodeDetail().getReplaceNode());
            }
        }
        IResourceManagement.Instance instance = this.getResourceManagement().restoreInstance(request.getInstanceBackupId(), nodeDetail.getFacilityName(), request.getFlavor(), request.getZone(), request.getInstanceDetail(), request.getTags());
        CloudInstanceDao dao = this.createCloudInstanceDao(instance, null);
        CloudInstance cloudInstance = this.createCloudInstance(nodeDetail, dao, instance);
        InstanceMonitorService.getSingleton().startMonitor(instance.getInstanceId(), cloudInstance.getFacilityId(), SessionService.current().getContext(), this.getCloudService(), this.getCloudRegion(), this.getCloudUser(), true, InstanceStateKind.running, InstanceStateKind.terminated, InstanceStateKind.stopped);
        return cloudInstance;
    }

    private CloudInstance createCloudInstance(NodeDetail nodeDetail, CloudInstanceDao dao, IResourceManagement.Instance instance) throws CloudManagerFault, InvalidRole {
        Object ipAddress;
        NodeInfo nodeInfo = null;
        RepositoryControllerBeanWrapper repositoryControllerBean = RepositoryControllerBeanWrapper.bean();
        String beforeZoneScopeId = null;
        if (Boolean.TRUE.equals(nodeDetail.getReplaceNode())) {
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            List cloudInstanceDaos = em.findByFilter(CloudInstanceDao.class, new Filter[]{new Filter("facilityId", new String[]{nodeDetail.getFacilityId()})});
            for (CloudInstanceDao cloudInstanceDao : cloudInstanceDaos) {
                this.unrelateNode(cloudInstanceDao);
                beforeZoneScopeId = AccountResourceUtil.createAccountResourceZoneId(cloudInstanceDao.getAccountResourceId(), cloudInstanceDao.getZone());
            }
            try {
                nodeInfo = repositoryControllerBean.getNode(nodeDetail.getFacilityId());
            }
            catch (FacilityNotFound e) {
                throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)((Object)e));
            }
            catch (HinemosUnknown e) {
                throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)((Object)e));
            }
            HinemosUtil.resetNodeInfo((NodeInfo)nodeInfo, (String)nodeDetail.getFacilityName(), (String)instance.getPlatform().label(), (String)this.getCloudService().getCloudTypeId(), (String)nodeDetail.getNodeName(), (String)nodeDetail.getDescription(), (String)"Resource", (String)this.getCloudService().getCloudServiceId(), (String)this.getAccountResource().getAccountResourceId(), (String)instance.getResourceType(), (String)instance.getInstanceId(), (String)this.getCloudRegion().getRegion(), (String)instance.getZone());
            ipAddress = instance.getIpAddress();
            if (ipAddress != null) {
                nodeInfo.setIpAddressV4((String)ipAddress);
            } else {
                nodeInfo.setIpAddressV4("123.123.123.123");
            }
            try (ModifiedEventNotifier<NodeInfo> notifier = new ModifiedEventNotifier<NodeInfo>("Node_Instance_Modify", NodeInfo.class, nodeInfo);){
                try {
                    repositoryControllerBean.modifyNode(nodeInfo);
                }
                catch (HinemosUnknown | InvalidSetting e) {
                    throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
                }
            }
        }
        if (nodeInfo == null) {
            nodeInfo = HinemosUtil.createNodeInfo((String)nodeDetail.getFacilityId(), (String)nodeDetail.getFacilityName(), (String)instance.getPlatform().label(), (String)this.getCloudService().getCloudTypeId(), (String)nodeDetail.getNodeName(), (String)nodeDetail.getDescription(), (String)"Resource", (String)this.getCloudService().getCloudServiceId(), (String)this.getAccountResource().getAccountResourceId(), (String)instance.getResourceType(), (String)instance.getInstanceId(), (String)this.getCloudRegion().getRegion(), (String)instance.getZone(), (String)this.getCloudUser().getRoleId(), (NodeVariableInfo[])new NodeVariableInfo[0]);
            String ipAddress2 = instance.getIpAddress();
            if (ipAddress2 != null) {
                nodeInfo.setIpAddressV4(ipAddress2);
            } else {
                nodeInfo.setIpAddressV4("123.123.123.123");
            }
            AddedEventNotifier<NodeInfo> notifier = new AddedEventNotifier<NodeInfo>("Node_Instance_Add", NodeInfo.class, nodeInfo);
            ipAddress = null;
            try {
                try {
                    repositoryControllerBean.addNode(nodeInfo);
                }
                catch (FacilityDuplicate e) {
                    throw ErrorCode.CLOUDINSTANCE_DUPLICATE_NODE.cloudManagerFault(dao.getAccountResourceId(), dao.getInstanceId(), nodeDetail.getFacilityId());
                }
                catch (HinemosUnknown | InvalidSetting e) {
                    throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
                }
            }
            catch (Throwable throwable) {
                ipAddress = throwable;
                throw throwable;
            }
            finally {
                if (notifier != null) {
                    if (ipAddress != null) {
                        try {
                            notifier.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)ipAddress).addSuppressed(x2);
                        }
                    } else {
                        notifier.close();
                    }
                }
            }
        }
        dao.setFacilityId(nodeDetail.getFacilityId());
        dao.setRegistStatus(CloudInstanceDao.InstanceStatus.registered);
        try {
            if (beforeZoneScopeId != null && !beforeZoneScopeId.equals(AccountResourceUtil.createAccountResourceZoneId(dao.getAccountResourceId(), dao.getZone()))) {
                repositoryControllerBean.releaseNodeScope(beforeZoneScopeId, new String[]{nodeDetail.getFacilityId()});
            }
            AccountResourceUtil.attachScope((RepositoryControllerBean)repositoryControllerBean, this.getCloudUser().getAccountResourceId(), this.getAccountResource().getAccountResourceName(), this.getCloudRegion().getRegion(), this.getCloudRegion().getRegionName(), instance.getZone(), nodeDetail.getFacilityId(), this.getCloudUser().getRoleId(), (IMessagesHolder)new MessagesHolder("com.clustercontrol.cloud.messages"));
        }
        catch (FacilityDuplicate | HinemosUnknown | InvalidSetting e) {
            throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
        }
        IStorageOperator strageOperator = this.getResourceOperator(IStorageOperator.class);
        strageOperator.setFlags(true, true, true);
        for (IResourceManagement.Instance.BlockDeviceMapping bd : instance.getBlockDeviceMappings()) {
            strageOperator.updateStorage(bd.getStorageId());
        }
        if (this.relation) {
            this.relateExistedScope(dao.getFacilityId(), instance);
        }
        return new CloudInstance(dao, this.getCloudService().getCloudTypeId(), instance, nodeInfo.getFacilityName());
    }

    @Override
    public void removeInstance(String instanceId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudInstanceDao dao = (CloudInstanceDao)em.find(CloudInstanceDao.class, (Object)new CloudInstanceDao.CloudInstancePK(instanceId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (dao == null) {
            try {
                this.getResourceManagement().deleteInstance(instanceId);
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ErrorCode.CLOUDINSTANCE_NOT_FOUND.cloudManagerFault(instanceId);
        }
        if (dao.getRegistStatus() == CloudInstanceDao.InstanceStatus.deleted) {
            throw new CloudManagerFault();
        }
        switch (dao.getRegistStatus()) {
            case unregistered: 
            case registered: {
                this.getResourceManagement().deleteInstance(instanceId);
                break;
            }
        }
        String facilityId = dao.getFacilityId();
        em.remove((Object)dao);
        if (facilityId != null) {
            try {
                RepositoryControllerBeanWrapper.bean().deleteNode(facilityId);
            }
            catch (UsedFacility e) {
                this.getLogger().warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.getLogger().error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public InstanceStateChange startInstance(StartInstanceRequest request) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudInstanceDao instanceDao = (CloudInstanceDao)em.find(CloudInstanceDao.class, (Object)new CloudInstanceDao.CloudInstancePK(request.getInstanceId(), this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (instanceDao == null) {
            throw ErrorCode.CLOUDINSTANCE_NOT_FOUND.cloudManagerFault(request.getInstanceId());
        }
        InstanceStateChange instanceStateChange = this.internalStartInstance(instanceDao);
        if (request.getRunJobFlg().booleanValue() && instanceDao.getFacilityId() != null) {
            String jobId;
            String string = request.getJobId() == null ? (instanceDao.getTemplateId() != null ? this.getResourceOperator(ITemplateOperator.class).findTemplate(instanceDao.getTemplateId()).getStartJobId() : null) : (jobId = request.getJobId());
            if (jobId != null) {
                TemplateJobUtil.asyncExecute(instanceDao.getFacilityId(), instanceDao.getAccountResourceId(), jobId, request.getArguments(), new TemplateJobUtil.JobEventListener(){

                    @Override
                    public void jobEventOccurerd(String facilityId, String jobunitId, String jobId) throws Exception {
                        InstanceOperator.findAgent(facilityId);
                    }
                }, null);
            }
            return instanceStateChange;
        }
        return instanceStateChange;
    }

    private InstanceStateChange internalStartInstance(CloudInstanceDao instanceDao) throws CloudManagerFault {
        InstanceStateChange changed = this.getResourceManagement().startInstance(instanceDao.getInstanceId());
        if (instanceDao.getFacilityId() != null) {
            InstanceMonitorService.getSingleton().startMonitor(instanceDao.getInstanceId(), instanceDao.getFacilityId(), SessionService.current().getContext(), this.getCloudService(), this.getCloudRegion(), this.getCloudUser(), false, InstanceStateKind.running, InstanceStateKind.terminated, InstanceStateKind.stopped);
        }
        return changed;
    }

    @Override
    public InstanceStateChange stopInstance(StopInstanceRequest request) throws CloudManagerFault {
        IResourceManagement rm = this.getResourceManagement();
        IResourceManagement.Instance instance = rm.getInstance(request.getInstanceId());
        if (InstanceStateKind.running != instance.getState()) {
            throw ErrorCode.CLOUDINSTANCE_NOT_RUNNING.cloudManagerFault(request.getInstanceId());
        }
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        final CloudInstanceDao instanceDao = (CloudInstanceDao)em.find(CloudInstanceDao.class, (Object)new CloudInstanceDao.CloudInstancePK(request.getInstanceId(), this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (instanceDao == null) {
            throw ErrorCode.CLOUDINSTANCE_NOT_FOUND.cloudManagerFault(request.getInstanceId());
        }
        if (request.getRunJobFlg().booleanValue() && instanceDao.getFacilityId() != null) {
            String jobId;
            String string = request.getJobId() == null ? (instanceDao.getTemplateId() != null ? this.getResourceOperator(ITemplateOperator.class).findTemplate(instanceDao.getTemplateId()).getStopJobId() : null) : (jobId = request.getJobId());
            if (jobId != null) {
                TemplateJobUtil.asyncExecute(instanceDao.getFacilityId(), instanceDao.getAccountResourceId(), jobId, request.getArguments(), null, new TemplateJobUtil.JobEventListener(){

                    @Override
                    public void jobEventOccurerd(String facilityId, String jobunitId, String jobId) throws Exception {
                        InstanceOperator.this.internalStopInstance(instanceDao);
                    }
                });
            }
            InstanceStateKind state = instance.getState();
            InstanceStateChange change = new InstanceStateChange();
            change.setInstanceId(request.getInstanceId());
            change.setCurrentState(state);
            change.setPreviousState(state);
            return change;
        }
        return this.internalStopInstance(instanceDao);
    }

    private InstanceStateChange internalStopInstance(CloudInstanceDao instanceDao) throws CloudManagerFault {
        InstanceStateChange changed = this.getResourceManagement().stopInstance(instanceDao.getInstanceId());
        if (instanceDao.getFacilityId() != null) {
            InstanceMonitorService.getSingleton().startMonitor(instanceDao.getInstanceId(), instanceDao.getFacilityId(), SessionService.current().getContext(), this.getCloudService(), this.getCloudRegion(), this.getCloudUser(), false, InstanceStateKind.running, InstanceStateKind.terminated, InstanceStateKind.stopped);
        }
        return changed;
    }

    @Override
    public IInstanceOperator.UpdateResult updateInstance(String instanceId) throws CloudManagerFault, InvalidRole {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudInstanceDao cloudInstanceDao = (CloudInstanceDao)em.find(CloudInstanceDao.class, (Object)new CloudInstanceDao.CloudInstancePK(instanceId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        IResourceManagement.Instance instance = null;
        if ((cloudInstanceDao == null || cloudInstanceDao.getRegistStatus() != CloudInstanceDao.InstanceStatus.deleted) && (InstanceStateKind.shutting_down.equals((Object)(instance = this.getResourceManagement().getInstance(instanceId)).getState()) || InstanceStateKind.terminated.equals((Object)instance.getState()))) {
            instance = null;
        }
        IInstanceOperator.UpdateResult result = this.internalUpdate(cloudInstanceDao, instance, InstanceOperator.getCriticalPoint(this.getCloudRegion().getRegion()).isEntering());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IInstanceOperator.UpdateResult internalUpdate(CloudInstanceDao cloudInstanceDao, IResourceManagement.Instance instance, boolean entering) throws CloudManagerFault, InvalidRole {
        try (PersistenceUtil.TransactionScope scope = new PersistenceUtil.TransactionScope(Transactional.TransactionType.RequiredNew);){
            block32: {
                try {
                    EntityManagerEx em = SessionService.current().getEntityManagerEx();
                    if (cloudInstanceDao != null) {
                        cloudInstanceDao = (CloudInstanceDao)em.getReference(CloudInstanceDao.class, (Object)cloudInstanceDao.getId());
                    }
                    if (instance != null) {
                        if (cloudInstanceDao == null) {
                            block33: {
                                if (!this.update || entering) break block32;
                                try {
                                    cloudInstanceDao = this.createCloudInstanceDao(instance, null);
                                }
                                catch (CloudManagerFault e) {
                                    if (!ErrorCode.CLOUDINSTANCE_ALREADY_EXIST.match(e)) throw e;
                                    cloudInstanceDao = (CloudInstanceDao)em.find(CloudInstanceDao.class, (Object)new CloudInstanceDao.CloudInstancePK(instance.getInstanceId(), this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
                                    if (cloudInstanceDao != null) break block33;
                                    throw e;
                                }
                            }
                            if (!this.regist) break block32;
                            this.addNodeRelation(cloudInstanceDao, instance);
                            if (this.relation) {
                                this.relateExistedScope(cloudInstanceDao.getFacilityId(), instance);
                            }
                            if (cloudInstanceDao.getFacilityId() != null) {
                                InstanceOperator.asyncRegistAgent(cloudInstanceDao.getFacilityId());
                            }
                            break block32;
                        }
                        if (!this.update) break block32;
                        this.updateCloudInstanceDao(cloudInstanceDao, instance);
                        if (cloudInstanceDao.getFacilityId() == null) {
                            if (!this.regist) break block32;
                            this.addNodeRelation(cloudInstanceDao, instance);
                            if (this.relation) {
                                this.relateExistedScope(cloudInstanceDao.getFacilityId(), instance);
                            }
                            if (cloudInstanceDao.getFacilityId() != null) {
                                InstanceOperator.asyncRegistAgent(cloudInstanceDao.getFacilityId());
                            }
                            break block32;
                        }
                        if (this.relation) {
                            this.relateExistedScope(cloudInstanceDao.getFacilityId(), instance);
                        }
                        break block32;
                    }
                    if (cloudInstanceDao == null) break block32;
                    if (this.update) {
                        if (cloudInstanceDao.getRegistStatus() != CloudInstanceDao.InstanceStatus.deleted) {
                            cloudInstanceDao.setRegistStatus(CloudInstanceDao.InstanceStatus.deleted);
                        }
                        if (this.regist) {
                            this.removeNodeRelation(cloudInstanceDao);
                        }
                    }
                    if (cloudInstanceDao.getFacilityId() == null) {
                        this.deleteInstance(cloudInstanceDao);
                        cloudInstanceDao = null;
                    }
                }
                catch (CloudManagerFault e) {
                    if (!ErrorCode.CLOUDINSTANCE_DUPLICATE_NODE.match(e)) {
                        if (!ErrorCode.HINEMOS_MANAGER_ERROR.match(e)) throw e;
                    }
                    CloudMessageUtil.notify_AutoUpadate_Error_InstanceOperator(cloudInstanceDao.getAccountResourceId(), cloudInstanceDao.getInstanceId(), (Exception)((Object)e));
                }
            }
            scope.complete();
            return new IInstanceOperator.UpdateResult(instance, cloudInstanceDao);
        }
        catch (CloudManagerFault e) {
            CloudMessageUtil.notify_AutoUpadate_Error_InstanceOperator(cloudInstanceDao.getAccountResourceId(), cloudInstanceDao.getInstanceId(), (Exception)((Object)e));
        }
        return new IInstanceOperator.UpdateResult(instance, cloudInstanceDao);
    }

    protected void relateExistedScope(String facilityId, IResourceManagement.Instance instance) {
        String scopesString = null;
        for (Tag t : instance.getTags()) {
            if (!t.getKey().equals("hinemosAssignScopeId")) continue;
            scopesString = t.getValue();
            break;
        }
        if (scopesString != null) {
            String[] scopes = scopesString.split(",");
            try {
                for (String scope : scopes) {
                    try {
                        if (ActionMode.isAutoDetection()) {
                            this.getLogger().info((Object)("Assign Node, Method=autoRegist, CloudUser=" + this.getCloudUser().getCloudUserId() + ", ParentFacilityID=" + scope + ", AssginFacilityID=" + facilityId));
                        }
                        RepositoryControllerBeanWrapper.bean().assignNodeScope(scope, new String[]{facilityId});
                    }
                    catch (Exception e) {
                        Logger logger = Logger.getLogger(InstanceOperator.class);
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(InstanceOperator.class);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     */
    private CloudInstanceDao createCloudInstanceDao(IResourceManagement.Instance instance, String templateId) throws CloudManagerFault {
        InstanceOperator.getCriticalPoint(new Objects(new Object[]{this.getCloudUser().getAccountResourceId(), this.getCloudRegion().getRegion()})).enter();
        CloudInstanceDao dao = new CloudInstanceDao();
        dao.setInstanceId(instance.getInstanceId());
        dao.setCloudServiceId(this.getAccountResource().getCloudServiceId());
        dao.setRegion(this.getCloudRegion().getRegion());
        dao.setAccountResourceId(this.getCloudUser().getAccountResourceId());
        dao.setInstanceName(instance.getName());
        dao.setZone(instance.getZone());
        dao.setCloudUserId(this.getCloudUser().getCloudUserId());
        dao.setRegistStatus(CloudInstanceDao.InstanceStatus.unregistered);
        dao.setTemplateId(templateId);
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        em.persist((IDHolder)dao);
        CloudInstanceDao cloudInstanceDao = dao;
        InstanceOperator.getCriticalPoint(new Objects(new Object[]{this.getCloudUser().getAccountResourceId(), this.getCloudRegion().getRegion()})).leave();
        return cloudInstanceDao;
        {
            catch (EntityExistsException e) {
                try {
                    throw ErrorCode.CLOUDSTORAGE_ALREADY_EXIST.cloudManagerFault(dao.getInstanceId());
                }
                catch (Throwable throwable) {
                    InstanceOperator.getCriticalPoint(new Objects(new Object[]{this.getCloudUser().getAccountResourceId(), this.getCloudRegion().getRegion()})).leave();
                    throw throwable;
                }
            }
        }
    }

    private void updateCloudInstanceDao(CloudInstanceDao instanceDao, IResourceManagement.Instance instance) throws CloudManagerFault, InvalidRole {
        instanceDao.setInstanceName(instance.getName());
        if (instanceDao.getFacilityId() != null) {
            try {
                RepositoryControllerBeanWrapper repositoryLocal = RepositoryControllerBeanWrapper.bean();
                NodeInfo node = repositoryLocal.getNode(instanceDao.getFacilityId());
                String ipAddress = instance.getIpAddress();
                if (node.getIpAddressV4() == null || ipAddress == null && !"123.123.123.123".equals(node.getIpAddressV4()) || ipAddress != null && !node.getIpAddressV4().equals(ipAddress)) {
                    if (ipAddress != null) {
                        node.setIpAddressV4(ipAddress);
                    } else {
                        node.setIpAddressV4("123.123.123.123");
                    }
                    repositoryLocal.modifyNode(node);
                }
            }
            catch (FacilityNotFound | HinemosUnknown | InvalidSetting e) {
                throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
            }
        }
    }

    private void deleteInstance(CloudInstanceDao cloudInstance) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        em.remove((Object)cloudInstance);
    }

    @Override
    @Transactional
    public IInstanceOperator.UpdateAllResult updateAllInstance() throws CloudManagerFault, InvalidRole {
        IInstanceOperator.UpdateResult updateResult;
        IResourceManagement rm = this.getResourceManagement();
        ArrayList<IResourceManagement.Instance> awsInstances = new ArrayList<IResourceManagement.Instance>(rm.getInstances(new String[0]));
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Filter filter = new Filter("accountResourceId", new String[]{this.getCloudUser().getAccountResourceId()});
        Filter filter2 = new Filter("region", new String[]{this.getCloudRegion().getRegion()});
        ArrayList CloudInstanceDaos = new ArrayList(em.findByFilter(CloudInstanceDao.class, new Filter[]{filter, filter2}));
        Iterator iIter = awsInstances.iterator();
        ArrayList<IInstanceOperator.UpdateAllResult.InstanceMapping> instanceMappings = new ArrayList<IInstanceOperator.UpdateAllResult.InstanceMapping>();
        block0: while (iIter.hasNext()) {
            IResourceManagement.Instance i = (IResourceManagement.Instance)iIter.next();
            if (InstanceStateKind.shutting_down == i.getState() || InstanceStateKind.terminated == i.getState()) {
                iIter.remove();
                continue;
            }
            Iterator ciIter = CloudInstanceDaos.iterator();
            while (ciIter.hasNext()) {
                CloudInstanceDao ci = (CloudInstanceDao)ciIter.next();
                if (!i.getInstanceId().equals(ci.getInstanceId())) continue;
                instanceMappings.add(new IInstanceOperator.UpdateAllResult.InstanceMapping(i, ci));
                iIter.remove();
                ciIter.remove();
                continue block0;
            }
        }
        ArrayList<IInstanceOperator.UpdateAllResult.InstanceMapping> both = new ArrayList<IInstanceOperator.UpdateAllResult.InstanceMapping>();
        ArrayList<IInstanceOperator.UpdateAllResult.InstanceMapping> onlyAws = new ArrayList<IInstanceOperator.UpdateAllResult.InstanceMapping>();
        ArrayList<CloudInstanceDao> onlyCloud = new ArrayList<CloudInstanceDao>();
        boolean entering = InstanceOperator.getCriticalPoint(new Objects(new Object[]{this.getCloudUser().getAccountResourceId(), this.getCloudRegion().getRegion()})).isEntering();
        for (IInstanceOperator.UpdateAllResult.InstanceMapping storageMapping : instanceMappings) {
            this.internalUpdate(storageMapping.cloudInstance, storageMapping.instance, entering);
        }
        both.addAll(instanceMappings);
        for (IResourceManagement.Instance i : awsInstances) {
            updateResult = this.internalUpdate(null, i, entering);
            if (updateResult.cloudInstance == null) continue;
            onlyAws.add(new IInstanceOperator.UpdateAllResult.InstanceMapping(updateResult.awsInstance, updateResult.cloudInstance));
            this.getLogger().debug((Object)("AWS : instanceId=" + i.getInstanceId()));
        }
        for (CloudInstanceDao cs : CloudInstanceDaos) {
            updateResult = this.internalUpdate(cs, null, entering);
            if (updateResult.cloudInstance == null) continue;
            onlyCloud.add(updateResult.cloudInstance);
        }
        return new IInstanceOperator.UpdateAllResult(both, onlyAws, onlyCloud);
    }

    private void addNodeRelation(CloudInstanceDao dao, IResourceManagement.Instance instance) throws CloudManagerFault, InvalidRole {
        String instanceName = instance.getName() == null || instance.getName().isEmpty() ? instance.getInstanceId() : instance.getName();
        String hostName = instance.getHostName();
        if (hostName == null || hostName.length() == 0) {
            hostName = instanceName;
        }
        NodeInfo nodeInfo = HinemosUtil.createNodeInfo((String)instance.getInstanceId(), (String)instanceName, (String)instance.getPlatform().label(), (String)this.getCloudService().getCloudTypeId(), (String)hostName, (String)"Hinemos Auto Regist", (String)"Resource", (String)this.getCloudService().getCloudServiceId(), (String)this.getAccountResource().getAccountResourceId(), (String)instance.getResourceType(), (String)instance.getInstanceId(), (String)this.getCloudRegion().getRegion(), (String)instance.getZone(), (String)this.getCloudUser().getRoleId(), (NodeVariableInfo[])new NodeVariableInfo[0]);
        String ipAddress = instance.getIpAddress();
        if (ipAddress != null) {
            nodeInfo.setIpAddressV4(ipAddress);
        } else {
            nodeInfo.setIpAddressV4("123.123.123.123");
        }
        RepositoryControllerBeanWrapper repositoryControllerBean = RepositoryControllerBeanWrapper.bean();
        if (ActionMode.isAutoDetection()) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.info((Object)("Add Node, Method=autoRegist, CloudUser=" + this.getCloudUser().getCloudUserId() + ", FacilityID=" + nodeInfo.getFacilityId() + ", InstanceId=" + instance.getInstanceId()));
        }
        try (AddedEventNotifier<NodeInfo> notifier = new AddedEventNotifier<NodeInfo>("Node_Instance_Add", NodeInfo.class, nodeInfo);){
            try {
                repositoryControllerBean.addNode(nodeInfo);
            }
            catch (FacilityDuplicate e) {
                throw ErrorCode.CLOUDINSTANCE_DUPLICATE_NODE.cloudManagerFault(dao.getAccountResourceId(), dao.getInstanceId(), nodeInfo.getFacilityId());
            }
            catch (HinemosUnknown | InvalidSetting e) {
                throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
            }
        }
        try {
            AccountResourceUtil.attachScope((RepositoryControllerBean)repositoryControllerBean, this.getCloudUser().getAccountResourceId(), this.getAccountResource().getAccountResourceName(), this.getCloudRegion().getRegion(), this.getCloudRegion().getRegionName(), instance.getZone(), instance.getInstanceId(), this.getCloudUser().getRoleId(), (IMessagesHolder)new MessagesHolder("com.clustercontrol.cloud.messages"));
        }
        catch (FacilityDuplicate | HinemosUnknown | InvalidSetting e) {
            throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
        }
        dao.setFacilityId(instance.getInstanceId());
        dao.setRegistStatus(CloudInstanceDao.InstanceStatus.registered);
        IStorageOperator storageOperator = this.getResourceOperator(IStorageOperator.class);
        storageOperator.setFlags(true, true, true);
        for (IResourceManagement.Instance.BlockDeviceMapping bd : instance.getBlockDeviceMappings()) {
            storageOperator.updateStorage(bd.getStorageId());
        }
    }

    private void removeNodeRelation(CloudInstanceDao cloudInstanceDao) throws CloudManagerFault {
        if (cloudInstanceDao.getFacilityId() == null) {
            return;
        }
        String facilityId = cloudInstanceDao.getFacilityId();
        String instanceId = cloudInstanceDao.getInstanceId();
        boolean autoRegist = ActionMode.isAutoDetection();
        try {
            if (autoRegist) {
                Logger.getLogger(this.getClass());
                this.getLogger().info((Object)("Delete Node, Method=autoRegist, CloudUser=" + this.getCloudUser().getCloudUserId() + ", FacilityID=" + facilityId + ", InstanceId=" + instanceId));
            }
            RepositoryControllerBeanWrapper.bean().deleteNode(facilityId);
        }
        catch (Exception e) {
            throw ErrorCode.AUTOUPDATE_NOT_DELETE_FACILITY.cloudManagerFault(e, cloudInstanceDao.getAccountResourceId(), cloudInstanceDao.getFacilityId(), CloudManagerFault.getMessage(e));
        }
        this.unrelateNode(cloudInstanceDao);
    }

    private void unrelateNode(CloudInstanceDao cloudInstanceDao) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        cloudInstanceDao.setFacilityId(null);
        cloudInstanceDao.setRegistStatus(CloudInstanceDao.InstanceStatus.unregistered);
        em.flush();
    }

    @Override
    public CloudInstance registNode(RegistNodeRequest request) throws CloudManagerFault, InvalidRole {
        IResourceManagement.Instance instance = this.getResourceManagement().getInstance(request.getInstanceId());
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudInstanceDao dao = (CloudInstanceDao)em.find(CloudInstanceDao.class, (Object)new CloudInstanceDao.CloudInstancePK(request.getInstanceId(), this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (dao == null) {
            throw ErrorCode.CLOUDINSTANCE_NOT_FOUND.cloudManagerFault(request.getInstanceId());
        }
        return this.createCloudInstance(request.getNodeDetail(), dao, instance);
    }

    @Override
    public void unregistNode(String instanceId) throws CloudManagerFault, InvalidRole {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudInstanceDao dao = (CloudInstanceDao)em.find(CloudInstanceDao.class, (Object)new CloudInstanceDao.CloudInstancePK(instanceId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (dao == null) {
            throw ErrorCode.CLOUDINSTANCE_NOT_FOUND.cloudManagerFault(instanceId);
        }
        if (dao.getRegistStatus() != CloudInstanceDao.InstanceStatus.deleted) {
            try {
                this.getResourceManagement().getInstance(instanceId);
            }
            catch (CloudManagerFault e) {
                if (IResourceManagement.ErrorCode.Resource_InvalidInstanceID_NotFound.name().equals(e.getErrorCode())) {
                    dao.setRegistStatus(CloudInstanceDao.InstanceStatus.deleted);
                }
                throw e;
            }
        }
        em.remove((Object)dao);
        if (dao.getFacilityId() != null) {
            try {
                RepositoryControllerBeanWrapper repositoryBean = RepositoryControllerBeanWrapper.bean();
                NodeInfo nodeInfo = repositoryBean.getNode(dao.getFacilityId());
                HinemosUtil.clearNodeInfo((NodeInfo)nodeInfo);
                try (ModifiedEventNotifier<NodeInfo> notifier = new ModifiedEventNotifier<NodeInfo>("Node_Instance_Clear", NodeInfo.class, nodeInfo);){
                    repositoryBean.modifyNode(nodeInfo);
                }
            }
            catch (FacilityNotFound | HinemosUnknown | InvalidSetting e) {
                throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
            }
        }
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public void setFlags(boolean update, boolean regist, boolean relation) {
        this.update = update;
        this.regist = regist;
        this.relation = relation;
    }

    @Override
    public CloudInstance getInstance(String instanceId) throws CloudManagerFault, InvalidRole {
        CloudInstance ci = this.updateInstance(instanceId).getCloudInstance();
        if (ci == null) {
            throw ErrorCode.CLOUDINSTANCE_NOT_FOUND.cloudManagerFault(instanceId);
        }
        return ci;
    }

    @Override
    public CloudInstance getInstanceByFacilityId(String facilityId) throws CloudManagerFault, InvalidRole {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        List instanceDaos = em.findByFilter(CloudInstanceDao.class, new Filter[]{new Filter("facilityId", new String[]{facilityId})});
        if (instanceDaos.isEmpty()) {
            throw ErrorCode.CLOUDINSTANCE_NOT_FOUND_BY_FACILITY.cloudManagerFault(facilityId);
        }
        return this.updateInstance(((CloudInstanceDao)instanceDaos.get(0)).getInstanceId()).getCloudInstance();
    }

    @Override
    public List<CloudInstance> getAllInstances() throws CloudManagerFault, InvalidRole {
        return this.updateAllInstance().getCloudInstances();
    }

    @Override
    public void removeInstanceBackup(final String instanceBackupId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudInstanceBackupDao dao = (CloudInstanceBackupDao)em.find(CloudInstanceBackupDao.class, (Object)new CloudInstanceBackupDao.CloudInstanceBackupPK(instanceBackupId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (dao == null) {
            this.getResourceManagement().deleteInstanceBackup(instanceBackupId);
            throw ErrorCode.CLOUDINSTANCEBACKUP_NOT_FOUND_NODE.cloudManagerFault(instanceBackupId);
        }
        em.remove((Object)dao);
        switch (dao.getRestoreStatus()) {
            case available: {
                SessionService.current().addPreCommitAction(new SessionService.PreCommitAction(){

                    public SessionService.RolebackAction preCommit() throws TransactionException {
                        try {
                            InstanceOperator.this.getResourceManagement().deleteInstanceBackup(instanceBackupId);
                        }
                        catch (CloudManagerFault e) {
                            throw new TransactionException((Throwable)((Object)e));
                        }
                        return null;
                    }
                });
                break;
            }
        }
    }

    @Override
    public CloudInstanceBackup getInstanceBackup(String instanceBackupId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudInstanceBackupDao dao = (CloudInstanceBackupDao)em.find(CloudInstanceBackupDao.class, (Object)new CloudInstanceBackupDao.CloudInstanceBackupPK(instanceBackupId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (dao == null) {
            throw ErrorCode.CLOUDINSTANCEBACKUP_NOT_FOUND_NODE.cloudManagerFault(instanceBackupId);
        }
        IResourceManagement.InstanceBackup backup = this.getResourceManagement().getInstanceBackup(instanceBackupId);
        if (dao.getRestoreStatus() == CloudInstanceBackupDao.RestoreStatus.available && backup == null) {
            dao.setRestoreStatus(CloudInstanceBackupDao.RestoreStatus.unavailable);
        }
        return new CloudInstanceBackup(dao, backup);
    }

    @Override
    public List<CloudInstanceBackup> getAllInstanceBackup() throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Filter filter = new Filter("accountResourceId", new String[]{this.getCloudUser().getAccountResourceId()});
        Filter filter2 = new Filter("region", new String[]{this.getCloudRegion().getRegion()});
        ArrayList daos = new ArrayList(em.findByFilter(CloudInstanceBackupDao.class, new Filter[]{filter, filter2}));
        ArrayList<String> backupIdsIds = new ArrayList<String>();
        for (CloudInstanceBackupDao backupDao : daos) {
            if (backupDao.getRestoreStatus() != CloudInstanceBackupDao.RestoreStatus.available) continue;
            backupIdsIds.add(backupDao.getInstanceBackupId());
        }
        HashMap<String, IResourceManagement.InstanceBackup> instanceBackupsMap = new HashMap<String, IResourceManagement.InstanceBackup>();
        if (!backupIdsIds.isEmpty()) {
            List<IResourceManagement.InstanceBackup> instanceBackups = this.getResourceManagement().getInstanceBackups(backupIdsIds);
            for (IResourceManagement.InstanceBackup instanceBackup : instanceBackups) {
                instanceBackupsMap.put(instanceBackup.getInstanceBackupId(), instanceBackup);
            }
        }
        ArrayList<CloudInstanceBackup> backups = new ArrayList<CloudInstanceBackup>();
        for (CloudInstanceBackupDao backupDao : daos) {
            IResourceManagement.InstanceBackup instanceBackup = (IResourceManagement.InstanceBackup)instanceBackupsMap.get(backupDao.getInstanceBackupId());
            if (backupDao.getRestoreStatus() == CloudInstanceBackupDao.RestoreStatus.available && instanceBackup == null) {
                backupDao.setRestoreStatus(CloudInstanceBackupDao.RestoreStatus.unavailable);
            }
            backups.add(new CloudInstanceBackup(backupDao, instanceBackup));
        }
        return backups;
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<Image> getImagesWithFilter(List<Filter> filters) throws CloudManagerFault {
        IResourceManagement rm = this.getResourceManagement();
        return rm.getImagesWithFilter(filters);
    }

    @Override
    public void updateAllInstanceBackup() throws CloudManagerFault, InvalidRole {
        this.getAllInstanceBackup();
    }

    @Override
    public List<LoadBalancer> getLoadBalancers() throws CloudManagerFault {
        List<IResourceManagement.LoadBalancer> lbs = this.getResourceManagement().getLoadBalancers();
        ArrayList<LoadBalancer> loadBalancers = new ArrayList<LoadBalancer>();
        for (IResourceManagement.LoadBalancer lb : lbs) {
            LoadBalancer loadBalancer = new LoadBalancer();
            loadBalancer.setLbId(lb.getLbId());
            loadBalancer.setRegisterdInstanceIds(lb.getRegisterdInstanceIds());
            loadBalancer.setAvailableInstanceIds(lb.getAvailableInstanceIds());
            loadBalancers.add(loadBalancer);
        }
        return loadBalancers;
    }

    @Override
    public void registerInstanceToLoadBalancer(String lbId, String instanceId) throws CloudManagerFault {
        this.getResourceManagement().registerInstanceToLoadBalancer(lbId, instanceId);
    }

    @Override
    public void unregisterInstanceToLoadBalancer(String lbId, String instanceId) throws CloudManagerFault {
        this.getResourceManagement().unregisterInstanceToLoadBalancer(lbId, instanceId);
    }

    @Override
    public List<CloudInstanceBackup> getInstanceBackupByInstanceId(String instanceId) throws CloudManagerFault {
        return null;
    }

    private static class RegistAgent
    implements Runnable {
        private String facilityId;
        private int count = 0;
        private int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());

        public RegistAgent(String facilityId) {
            this.facilityId = facilityId;
        }

        @Override
        public void run() {
            Logger logger = Logger.getLogger(this.getClass());
            ++this.count;
            logger.debug((Object)("try to regist agent " + this.facilityId + " " + this.count + "/" + this.maxCount + " time."));
            boolean success = false;
            try {
                RepositoryControllerBeanWrapper.bean().getNode(this.facilityId);
                success = AgentConnectUtil.sendManagerDiscoveryInfo((String)this.facilityId);
            }
            catch (FacilityNotFound e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException();
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            if (success) {
                logger.info((Object)("success to regist " + this.facilityId + " as agent."));
                throw new RuntimeException();
            }
            if (this.maxCount <= this.count) {
                logger.warn((Object)"timed out. agent doesn't exist.");
                throw new RuntimeException();
            }
        }
    }

    private static class CriticalPoint {
        private AtomicInteger syncCount = new AtomicInteger();

        private CriticalPoint() {
        }

        public void enter() {
            this.syncCount.incrementAndGet();
        }

        public void leave() {
            this.syncCount.decrementAndGet();
        }

        public boolean isEntering() {
            return this.syncCount.get() != 0;
        }
    }

    public static class ModifiedEventNotifier<T>
    implements AutoCloseable {
        private String type;
        private Class<T> clazz;
        private T object;

        public ModifiedEventNotifier(String type, Class<T> clazz, T object) throws CloudManagerFault, InvalidRole {
            this.type = type;
            this.clazz = clazz;
            this.object = object;
            try {
                ((IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class)).firePreModifiedEvent(type, clazz, object);
            }
            catch (CloudManagerFault e) {
                if (e.getCause() instanceof InvalidRole) {
                    throw (InvalidRole)e.getCause();
                }
                throw e;
            }
            catch (PluginFault e) {
                throw new CloudManagerFault(e);
            }
        }

        @Override
        public void close() throws CloudManagerFault, InvalidRole {
            try {
                ((IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class)).firePostModifiedEvent(this.type, this.clazz, this.object);
            }
            catch (CloudManagerFault e) {
                if (e.getCause() instanceof InvalidRole) {
                    throw (InvalidRole)e.getCause();
                }
                throw e;
            }
            catch (PluginFault e) {
                throw new CloudManagerFault(e);
            }
        }
    }

    public static class AddedEventNotifier<T>
    implements AutoCloseable {
        private String type;
        private Class<T> clazz;
        private T object;

        public AddedEventNotifier(String type, Class<T> clazz, T object) throws CloudManagerFault, InvalidRole {
            this.type = type;
            this.clazz = clazz;
            this.object = object;
            try {
                ((IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class)).firePreAddedEvent(type, clazz, object);
            }
            catch (CloudManagerFault e) {
                if (e.getCause() instanceof InvalidRole) {
                    throw (InvalidRole)e.getCause();
                }
                throw e;
            }
            catch (PluginFault e) {
                throw new CloudManagerFault(e);
            }
        }

        @Override
        public void close() throws CloudManagerFault, InvalidRole {
            try {
                ((IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class)).firePostAddedEvent(this.type, this.clazz, this.object);
            }
            catch (CloudManagerFault e) {
                if (e.getCause() instanceof InvalidRole) {
                    throw (InvalidRole)e.getCause();
                }
                throw e;
            }
            catch (PluginFault e) {
                throw new CloudManagerFault(e);
            }
        }
    }
}

