/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.RestoreStatus;
import com.clustercontrol.cloud.bean.RestoreStorageRequest;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StorageStateKind;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.dao.CloudStorageBackupDao;
import com.clustercontrol.cloud.dao.CloudStorageDao;
import com.clustercontrol.cloud.factory.ActionMode;
import com.clustercontrol.cloud.factory.IInstanceOperator;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.factory.ResourceOperatorBase;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.IDHolder;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.repository.bean.NodeDiskInfo;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.session.RepositoryControllerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityExistsException;
import org.apache.log4j.Logger;

@Transactional
public class StorageOperator
extends ResourceOperatorBase
implements IStorageOperator {
    private boolean update = CloudPropertyConstants.autoupdate_storage.match("on");
    private boolean regist = CloudPropertyConstants.autoregist_storage.match("on");
    private boolean mount = CloudPropertyConstants.autoupdate_mount.match("on");

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public void setFlags(boolean update, boolean regist, boolean mount) {
        this.update = update;
        this.regist = regist;
        this.mount = mount;
    }

    @Override
    public CloudStorage createStorage(CreateStorageRequest request) throws CloudManagerFault {
        IResourceManagement.Storage storage = this.getResourceManagement().createStorage(request.getStorageName(), request.getFlavor(), request.getStorageSize(), request.getSnapshotId(), request.getZone(), request.getStorageDetail());
        CloudStorageDao cloudStorage = this.createCloudStorageDao(storage);
        return new CloudStorage(cloudStorage, storage, null);
    }

    @Override
    public CloudStorageBackup createStorageBackup(CreateStorageBackupRequest request) throws CloudManagerFault {
        IResourceManagement.StorageBackup storageBackup = this.getResourceManagement().createStorageBackup(request.getStorageId(), request.getSnapshotName(), request.getDescription(), request.getSnapshotDetail());
        CloudStorageBackupDao dao = new CloudStorageBackupDao();
        dao.setStorageBackupId(storageBackup.getStorageBackupId());
        dao.setCloudServiceId(this.getAccountResource().getCloudServiceId());
        dao.setRegion(this.getCloudRegion().getRegion());
        dao.setAccountResourceId(this.getAccountResource().getAccountResourceId());
        dao.setSnapshotName(storageBackup.getName());
        dao.setCloudUserId(this.getCloudUser().getCloudUserId());
        dao.setDescription(request.getDescription());
        dao.setRestoreStatus(CloudStorageBackupDao.RestoreStatus.valueOf((String)RestoreStatus.available.name()));
        CloudStorageBackupDao.BackupedData backup = new CloudStorageBackupDao.BackupedData();
        backup.setStorageId(storageBackup.getStorageId());
        dao.setBackupedData(backup);
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        em.persist((IDHolder)dao);
        return new CloudStorageBackup(dao, storageBackup);
    }

    @Override
    public CloudStorage restoreStorage(RestoreStorageRequest request) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudStorageBackupDao backup = (CloudStorageBackupDao)em.find(CloudStorageBackupDao.class, (Object)new CloudStorageBackupDao.CloudStorageBackupPK(request.getStorageBackupId(), this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (backup == null) {
            throw ErrorCode.CLOUDSTORAGEBACKUP_INVALID_CLOUDSTORAGEBACKUP_NOT_FOUND.cloudManagerFault(request.getStorageBackupId());
        }
        IResourceManagement.Storage storage = this.getResourceManagement().restoreStorage(request.getStorageBackupId(), request.getStorageName(), request.getFlavor(), request.getStorageSize(), request.getFlavor(), request.getDetail());
        CloudStorageDao cloudStorage = this.createCloudStorageDao(storage);
        return new CloudStorage(cloudStorage, storage, null);
    }

    @Override
    public void removeStorage(String storageId) throws CloudManagerFault, InvalidRole {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudStorageDao storageDao = (CloudStorageDao)em.find(CloudStorageDao.class, (Object)new CloudStorageDao.CloudStoragePK(storageId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (storageDao == null) {
            try {
                this.getResourceManagement().deleteStorage(storageId);
            }
            catch (Exception e) {
                this.getLogger().warn((Object)e.getMessage(), (Throwable)e);
            }
            throw ErrorCode.CLOUDSTORAGE_INVALID_CLOUDSTORAGE_NOT_FOUND.cloudManagerFault(storageId);
        }
        em.remove((Object)storageDao);
        try {
            this.removeDiskInfo(storageDao.getFacilityId(), storageId);
        }
        catch (FacilityNotFound e) {
            // empty catch block
        }
        switch (storageDao.getRegistStatus()) {
            case exist: {
                this.getResourceManagement().deleteStorage(storageId);
                break;
            }
        }
    }

    @Override
    public void removeStorageBackup(String storageBackupId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudStorageBackupDao storageBackupDao = (CloudStorageBackupDao)em.find(CloudStorageBackupDao.class, (Object)new CloudStorageBackupDao.CloudStorageBackupPK(storageBackupId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (storageBackupDao == null) {
            try {
                this.getResourceManagement().deleteStorageBackup(storageBackupId);
            }
            catch (Exception e) {
                this.getLogger().warn((Object)e.getMessage(), (Throwable)e);
            }
            throw ErrorCode.CLOUDSTORAGEBACKUP_INVALID_CLOUDSTORAGEBACKUP_NOT_FOUND.cloudManagerFault(storageBackupId);
        }
        em.remove((Object)storageBackupDao);
        switch (storageBackupDao.getRestoreStatus()) {
            case available: {
                this.getResourceManagement().deleteStorageBackup(storageBackupId);
                break;
            }
        }
    }

    @Override
    public IStorageOperator.UpdateResult updateStorage(String storageId) throws CloudManagerFault, InvalidRole {
        IResourceManagement rm = this.getResourceManagement();
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudStorageDao cloudStorageDao = (CloudStorageDao)em.find(CloudStorageDao.class, (Object)new CloudStorageDao.CloudStoragePK(storageId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        IResourceManagement.Storage s = null;
        if ((cloudStorageDao == null || cloudStorageDao.getRegistStatus() != CloudStorageDao.StorageStatus.deleted) && StorageStateKind.deleting.equals((Object)(s = rm.getStorage(storageId)).getState())) {
            s = null;
        }
        IStorageOperator.UpdateResult result = this.internalUpdate(this.getCloudRegion().getRegion(), cloudStorageDao, s);
        return result;
    }

    /*
     * Exception decompiling
     */
    private IStorageOperator.UpdateResult internalUpdate(String region, CloudStorageDao cloudStorageDao, IResourceManagement.Storage storage) throws CloudManagerFault, InvalidRole {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateCloudStorageDao(CloudStorageDao storageDao, IResourceManagement.Storage storage) throws CloudManagerFault {
        if (storage.getName() != null) {
            if (!storage.getName().equals(storageDao.getStorageName())) {
                storageDao.setStorageName(storage.getName());
            }
        } else if (storageDao.getStorageName() != null) {
            storageDao.setStorageName(null);
        }
    }

    private void updateStorageRelation(String Region, CloudStorageDao cloudStorageDao, IResourceManagement.Storage storage) throws CloudManagerFault, InvalidRole {
        if (storage.getStorageAttachment() == null) {
            this.removeStorageRelation(cloudStorageDao);
        } else {
            this.addStorageRelation(Region, cloudStorageDao, storage);
        }
    }

    private CloudStorageDao createCloudStorageDao(IResourceManagement.Storage storage) throws CloudManagerFault {
        CloudStorageDao dao = new CloudStorageDao();
        dao.setStorageId(storage.getStorageId());
        dao.setRegion(this.getCloudRegion().getRegion());
        dao.setCloudServiceId(this.getAccountResource().getCloudServiceId());
        dao.setAccountResourceId(this.getCloudUser().getAccountResourceId());
        dao.setStorageName(storage.getName());
        dao.setZone(storage.getZone());
        dao.setFlavor(storage.getFlavor());
        dao.setRegistStatus(CloudStorageDao.StorageStatus.exist);
        try {
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            em.persist((IDHolder)dao);
            return dao;
        }
        catch (EntityExistsException e) {
            throw ErrorCode.CLOUDSTORAGE_INVALID_CLOUDSTORAGE_NOT_FOUND.cloudManagerFault(dao.getStorageId());
        }
    }

    private void deleteStorage(CloudStorageDao cloudStorage) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        em.remove((Object)cloudStorage);
    }

    @Override
    public IStorageOperator.UpdateAllResult updateAllStorage() throws CloudManagerFault, InvalidRole {
        IStorageOperator.UpdateResult updateResult;
        this.getLogger().debug((Object)"enter updateAll()");
        IResourceManagement rm = this.getResourceManagement();
        List<IResourceManagement.Storage> result = rm.getStorages(new String[0]);
        Filter filter = new Filter("region", new String[]{this.getCloudRegion().getRegion()});
        Filter filter2 = new Filter("accountResourceId", new String[]{this.getCloudUser().getAccountResourceId()});
        ArrayList csList = new ArrayList(SessionService.current().getEntityManagerEx().findByFilter(CloudStorageDao.class, new Filter[]{filter, filter2}));
        ArrayList<IResourceManagement.Storage> sList = new ArrayList<IResourceManagement.Storage>(result);
        Iterator sIter = sList.iterator();
        ArrayList<IStorageOperator.UpdateAllResult.StorageMapping> storageMappings = new ArrayList<IStorageOperator.UpdateAllResult.StorageMapping>();
        block0: while (sIter.hasNext()) {
            IResourceManagement.Storage s = (IResourceManagement.Storage)sIter.next();
            if (StorageStateKind.deleting == s.getState()) {
                sIter.remove();
                continue;
            }
            Iterator csIter = csList.iterator();
            while (csIter.hasNext()) {
                CloudStorageDao cs = (CloudStorageDao)csIter.next();
                if (!s.getStorageId().equals(cs.getStorageId())) continue;
                storageMappings.add(new IStorageOperator.UpdateAllResult.StorageMapping(s, cs));
                sIter.remove();
                csIter.remove();
                continue block0;
            }
        }
        ArrayList<IStorageOperator.UpdateAllResult.StorageMapping> both = new ArrayList<IStorageOperator.UpdateAllResult.StorageMapping>();
        ArrayList<IStorageOperator.UpdateAllResult.StorageMapping> onlyAws = new ArrayList<IStorageOperator.UpdateAllResult.StorageMapping>();
        ArrayList<CloudStorageDao> onlyCloud = new ArrayList<CloudStorageDao>();
        for (IStorageOperator.UpdateAllResult.StorageMapping storageMapping : storageMappings) {
            this.internalUpdate(this.getCloudRegion().getRegion(), storageMapping.cloudStorage, storageMapping.storage);
        }
        both.addAll(storageMappings);
        for (IResourceManagement.Storage s : sList) {
            updateResult = this.internalUpdate(this.getCloudRegion().getRegion(), null, s);
            if (updateResult.cloudStorage != null) {
                onlyAws.add(new IStorageOperator.UpdateAllResult.StorageMapping(updateResult.stroage, updateResult.cloudStorage));
            }
            this.getLogger().debug((Object)("AWS : volumeId=" + s.getStorageId()));
        }
        for (CloudStorageDao cs : csList) {
            updateResult = this.internalUpdate(this.getCloudRegion().getRegion(), cs, null);
            if (updateResult.cloudStorage == null) continue;
            onlyCloud.add(updateResult.cloudStorage);
        }
        this.getLogger().debug((Object)"exit updateAll()");
        return new IStorageOperator.UpdateAllResult(both, onlyAws, onlyCloud);
    }

    private void addStorageRelation(String Region, CloudStorageDao CloudStorageDao2, IResourceManagement.Storage storage) throws CloudManagerFault, InvalidRole {
        if (storage.getStorageAttachment() == null) {
            return;
        }
        try {
            IInstanceOperator operator = this.getResourceOperator(IInstanceOperator.class);
            operator.setFlags(false, false, false);
            CloudInstance cloudInstance = operator.getInstance(storage.getStorageAttachment().getInstanceId());
            this.addDiskInfo(cloudInstance, CloudStorageDao2, storage);
        }
        catch (CloudManagerFault e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.warn((Object)e.getMessage(), (Throwable)((Object)e));
        }
    }

    private void addDiskInfo(CloudInstance cloudInstance, CloudStorageDao cloudStorageDao, IResourceManagement.Storage storage) throws CloudManagerFault {
        assert (storage.getStorageAttachment() != null);
        if (cloudInstance.getFacilityId() != null) {
            NodeInfo nodeInfo;
            RepositoryControllerBeanWrapper bean = RepositoryControllerBeanWrapper.bean();
            try {
                nodeInfo = bean.getNode(cloudInstance.getFacilityId());
            }
            catch (FacilityNotFound | HinemosUnknown e) {
                throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
            }
            NodeDiskInfo nodeDiskInfo = null;
            for (NodeDiskInfo diskInfo : nodeInfo.getNodeDiskInfo()) {
                if (!("storageId=" + storage.getStorageId()).equals(diskInfo.getDeviceDescription())) continue;
                nodeDiskInfo = diskInfo;
                break;
            }
            if (nodeDiskInfo == null) {
                nodeDiskInfo = new NodeDiskInfo();
                nodeDiskInfo.setDeviceType("disk");
                nodeDiskInfo.setDeviceName(storage.getStorageAttachment().getDevice());
                HashSet<Integer> indexs = new HashSet<Integer>();
                for (NodeDiskInfo diskInfo : nodeInfo.getNodeDiskInfo()) {
                    indexs.add(diskInfo.getDeviceIndex());
                }
                for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                    if (indexs.contains(i)) continue;
                    nodeDiskInfo.setDeviceIndex(Integer.valueOf(i));
                    break;
                }
                nodeDiskInfo.setDeviceSize(Integer.valueOf(storage.getSize()));
                nodeDiskInfo.setDeviceSizeUnit("Gib");
                nodeDiskInfo.setDeviceDescription("storageId=" + storage.getStorageId());
                nodeDiskInfo.setDeviceDisplayName(cloudStorageDao.getStorageName() == null ? storage.getStorageAttachment().getDevice() : cloudStorageDao.getStorageName());
                ArrayList<NodeDiskInfo> disklist = new ArrayList<NodeDiskInfo>(nodeInfo.getNodeDiskInfo());
                disklist.add(nodeDiskInfo);
                nodeInfo.setNodeDiskInfo(disklist);
                if (ActionMode.isAutoDetection()) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.info((Object)("Change Node, Method=autoRegist, CloudUser=" + this.getCloudUser().getCloudUserId() + ", FacilityID=" + nodeInfo.getFacilityId() + ", InstanceId=" + cloudInstance.getInstanceId() + ", AddDisk=" + storage.getStorageAttachment().getDevice() + ", StorageId=" + storage.getStorageId()));
                }
                try {
                    bean.modifyNode(nodeInfo);
                }
                catch (HinemosUnknown | InvalidRole | InvalidSetting e) {
                    throw new CloudManagerFault(e.getMessage(), ErrorCode.HINEMOS_MANAGER_ERROR.name(), e);
                }
            }
            if (cloudStorageDao.getFacilityId() == null) {
                cloudStorageDao.setDeviceIndex(nodeDiskInfo.getDeviceIndex());
                cloudStorageDao.setDeviceName(nodeDiskInfo.getDeviceName());
                cloudStorageDao.setDeviceType(nodeDiskInfo.getDeviceType());
                cloudStorageDao.setFacilityId(nodeInfo.getFacilityId());
                cloudStorageDao.setRegistStatus(CloudStorageDao.StorageStatus.exist);
            }
        }
    }

    private void removeStorageRelation(CloudStorageDao CloudStorageDao2) throws CloudManagerFault, InvalidRole {
        if (CloudStorageDao2.getFacilityId() == null) {
            return;
        }
        try {
            this.removeDiskInfo(CloudStorageDao2.getFacilityId(), CloudStorageDao2.getStorageId());
        }
        catch (FacilityNotFound e) {
            Logger.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
        }
        CloudStorageDao2.setFacilityId(null);
        CloudStorageDao2.setDeviceIndex(null);
        CloudStorageDao2.setDeviceName(null);
        CloudStorageDao2.setDeviceType(null);
    }

    private void removeDiskInfo(String facilityId, String storageId) throws CloudManagerFault, InvalidRole, FacilityNotFound {
        NodeInfo nodeInfo = null;
        try {
            nodeInfo = new RepositoryControllerBean().getNode(facilityId);
        }
        catch (HinemosUnknown e) {
            throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)((Object)e));
        }
        if (nodeInfo != null && nodeInfo.getNodeDiskInfo() != null) {
            for (NodeDiskInfo disk : nodeInfo.getNodeDiskInfo()) {
                if (!("storageId=" + storageId).equals(disk.getDeviceDescription())) continue;
                ArrayList disklist = new ArrayList(nodeInfo.getNodeDiskInfo());
                disklist.remove(disk);
                if (ActionMode.isAutoDetection()) {
                    IInstanceOperator instanceOperator = this.getResourceOperator(IInstanceOperator.class);
                    CloudInstance cloudInstance = null;
                    try {
                        cloudInstance = instanceOperator.getInstanceByFacilityId(facilityId);
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).warn((Object)e.toString(), (Throwable)e);
                    }
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.info((Object)("Change Node, Method=autoRegist, CloudUser=" + this.getCloudUser().getCloudUserId() + ", FacilityID=" + nodeInfo.getFacilityId() + ", InstanceId=" + (cloudInstance != null ? cloudInstance.getInstanceId() : null) + ", DelDisk=" + disk.getDeviceName() + ", VolumeId=" + storageId));
                }
                nodeInfo.setNodeDiskInfo(disklist);
                break;
            }
        }
    }

    @Override
    public void attachStorage(String instanceId, String storageId, String device) throws CloudManagerFault, InvalidRole {
        IResourceManagement rm = this.getResourceManagement();
        rm.attachStorage(instanceId, storageId, device);
        IResourceManagement.Storage s = rm.getStorage(storageId);
        CloudStorageDao cloudStorageDao = (CloudStorageDao)SessionService.current().getEntityManagerEx().find(CloudStorageDao.class, (Object)new CloudStorageDao.CloudStoragePK(storageId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (cloudStorageDao == null) {
            throw ErrorCode.CLOUDSTORAGE_INVALID_CLOUDSTORAGE_NOT_FOUND.cloudManagerFault(storageId);
        }
        this.internalUpdate(this.getCloudRegion().getRegion(), cloudStorageDao, s);
    }

    @Override
    public void detachStorage(String instanceId, String storageId) throws CloudManagerFault, InvalidRole {
        IResourceManagement rm = this.getResourceManagement();
        rm.detachStorage(instanceId, storageId);
        IResourceManagement.Storage after = rm.getStorage(storageId);
        CloudStorageDao cloudStorageDao = (CloudStorageDao)SessionService.current().getEntityManagerEx().find(CloudStorageDao.class, (Object)new CloudStorageDao.CloudStoragePK(storageId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (cloudStorageDao == null) {
            throw ErrorCode.CLOUDSTORAGE_INVALID_CLOUDSTORAGE_NOT_FOUND.cloudManagerFault(storageId);
        }
        this.internalUpdate(this.getCloudRegion().getRegion(), cloudStorageDao, after);
    }

    @Override
    public CloudStorage getStorage(String storageId) throws CloudManagerFault, InvalidRole {
        return this.updateStorage(storageId).getCloudStorage();
    }

    @Override
    public List<CloudStorage> getAllStorage() throws CloudManagerFault, InvalidRole {
        return this.updateAllStorage().getCloudStorages();
    }

    @Override
    public CloudStorageBackup getStorageBackup(String storageBackupId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudStorageBackupDao dao = (CloudStorageBackupDao)em.find(CloudStorageBackupDao.class, (Object)new CloudStorageBackupDao.CloudStorageBackupPK(storageBackupId, this.getCloudRegion().getRegion(), this.getCloudUser().getAccountResourceId()));
        if (dao == null) {
            throw ErrorCode.CLOUDSTORAGEBACKUP_INVALID_CLOUDSTORAGEBACKUP_NOT_FOUND.cloudManagerFault(storageBackupId);
        }
        IResourceManagement rm = this.getResourceManagement();
        IResourceManagement.StorageBackup storageBackup = rm.getStorageBackup(storageBackupId);
        if (dao.getRestoreStatus() == CloudStorageBackupDao.RestoreStatus.available && storageBackup == null) {
            dao.setRestoreStatus(CloudStorageBackupDao.RestoreStatus.unavailable);
        }
        return new CloudStorageBackup(dao, storageBackup);
    }

    @Override
    public List<CloudStorageBackup> getAllStorageBuckup() throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Filter filter = new Filter("accountResourceId", new String[]{this.getCloudUser().getAccountResourceId()});
        Filter filter2 = new Filter("region", new String[]{this.getCloudRegion().getRegion()});
        ArrayList daos = new ArrayList(em.findByFilter(CloudStorageBackupDao.class, new Filter[]{filter, filter2}));
        ArrayList<String> storageBackupIds = new ArrayList<String>();
        for (CloudStorageBackupDao backupDao : daos) {
            if (backupDao.getRestoreStatus() != CloudStorageBackupDao.RestoreStatus.available) continue;
            storageBackupIds.add(backupDao.getStorageBackupId());
        }
        HashMap<String, IResourceManagement.StorageBackup> snapshotMap = new HashMap<String, IResourceManagement.StorageBackup>();
        if (!storageBackupIds.isEmpty()) {
            IResourceManagement rm = this.getResourceManagement();
            List<IResourceManagement.StorageBackup> storageBackups = rm.getStorageBackups(storageBackupIds);
            for (IResourceManagement.StorageBackup storageBackup : storageBackups) {
                snapshotMap.put(storageBackup.getStorageBackupId(), storageBackup);
            }
        }
        ArrayList<CloudStorageBackup> backups = new ArrayList<CloudStorageBackup>();
        for (CloudStorageBackupDao backupDao : daos) {
            IResourceManagement.StorageBackup storageBackup;
            storageBackup = (IResourceManagement.StorageBackup)snapshotMap.get(backupDao.getStorageBackupId());
            if (backupDao.getRestoreStatus() == CloudStorageBackupDao.RestoreStatus.available && storageBackup == null) {
                backupDao.setRestoreStatus(CloudStorageBackupDao.RestoreStatus.unavailable);
            }
            backups.add(new CloudStorageBackup(backupDao, storageBackup));
        }
        return backups;
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<Snapshot> getSnapshotsWithFilter(List<Filter> filters) throws CloudManagerFault, InvalidRole {
        IResourceManagement rm = this.getResourceManagement();
        return rm.getSnapshotsWithFilter(filters);
    }

    @Override
    public void updateAllStorageBackup() throws CloudManagerFault, InvalidRole {
        this.getAllStorageBuckup();
    }

    @Override
    public List<CloudStorageBackup> getStorageBuckupsByStorageId(String storageId) throws CloudManagerFault {
        return null;
    }
}

