/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory.monitors;

import com.clustercontrol.accesscontrol.session.AccessControllerBean;
import com.clustercontrol.cloud.HinemosCredential;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.factory.ActionMode;
import com.clustercontrol.cloud.factory.IAccountResourceOperator;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.factory.IInstanceOperator;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.factory.monitors.AbstractCloudJob;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.AccessDestination;
import com.clustercontrol.cloud.util.CloudContext;
import com.clustercontrol.cloud.util.CloudMessageUtil;
import com.clustercontrol.cloud.util.ResourceUtil;
import com.clustercontrol.commons.util.HinemosSessionContext;
import com.clustercontrol.fault.HinemosUnknown;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class AutoDetectionManager {
    private static final String quartzJobName = "AotoDetection";
    private static final String quartzJobGroupName = "CLOUD_MANAGEMENT";
    private static Scheduler scheduler;
    private static IAutoDetectionService ad;

    private static synchronized Scheduler getScheduler() throws IllegalStateException {
        if (scheduler == null) {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            try {
                final Scheduler internalScheduler = factory.getScheduler();
                scheduler = (Scheduler)Proxy.newProxyInstance(Scheduler.class.getClassLoader(), new Class[]{Scheduler.class}, new InvocationHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        1 var4_4 = this;
                        synchronized (var4_4) {
                            return method.invoke((Object)internalScheduler, args);
                        }
                    }
                });
                scheduler.start();
            }
            catch (SchedulerException e) {
                throw new IllegalStateException(e);
            }
        }
        return scheduler;
    }

    public static IAutoDetectionService getService() {
        return ad;
    }

    static {
        ad = new AutoDetectionService();
    }

    public static class AutoDetectionJob
    extends AbstractCloudJob {
        private static ExecutorService threadPool = new ThreadPoolExecutor(3, 3, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(final Runnable r) {
                return new Thread(new Runnable(){

                    @Override
                    public void run() {
                        String userId = CloudPropertyConstants.internal_thread_admin_user.value();
                        HinemosSessionContext.instance().setProperty("loginUserId", (Object)userId);
                        SessionService.current().setHinemosCredential(new HinemosCredential(userId));
                        try {
                            HinemosSessionContext.instance().setProperty("isAdministrator", (Object)new AccessControllerBean().isAdministrator());
                        }
                        catch (HinemosUnknown e) {
                            throw new InternalManagerError((Throwable)e);
                        }
                        r.run();
                    }
                }, "AutoDetectionService-thread-" + this.threadNumber.getAndIncrement());
            }
        }){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                SessionService.current().close();
            }
        };

        @Override
        public void internalExecute(JobExecutionContext arg0) throws JobExecutionException {
            try {
                ActionMode.enterAutoDetection();
                Logger logger = Logger.getLogger(this.getClass());
                logger.debug((Object)"enter AsyncCallAutoDetection.");
                final boolean autoDetection = ActionMode.isAutoDetection();
                IAccountResourceOperator carOperator = (IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class);
                ICloudUserOperator userOperator = (ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class);
                ICloudServiceOperator serviceOperator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
                for (CloudAccountResource accountResource : carOperator.findAllCloudAccountResource()) {
                    CloudService service = serviceOperator.findCloudService(accountResource.getCloudServiceId());
                    List<CloudRegion> regions = serviceOperator.findCloudRegionsByService(accountResource.getCloudServiceId());
                    CloudUser account = userOperator.findCloudUser(accountResource.getAccountId());
                    try {
                        for (final CloudRegion region : regions) {
                            SessionService.current().set(ICloudContext.class, (Object)new CloudContext(new AccessDestination(account, service, accountResource), region));
                            final SessionService.ContextData contextData = SessionService.current().getContext();
                            try {
                                threadPool.execute(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        SessionService.changeContext((SessionService.ContextData)contextData);
                                        if (autoDetection) {
                                            ActionMode.enterAutoDetection();
                                        }
                                        Logger logger = Logger.getLogger(this.getClass());
                                        try {
                                            logger.debug((Object)("enter AutoDetection : region=" + region.getRegionName()));
                                            IInstanceOperator instanceOpearter = ResourceUtil.getResourceOperator(IInstanceOperator.class);
                                            instanceOpearter.setFlags(CloudPropertyConstants.autoupdate_instance.match("on"), CloudPropertyConstants.autoregist_instance.match("on"), CloudPropertyConstants.autoregist_scope_relation.match("on"));
                                            instanceOpearter.updateAllInstance();
                                            IStorageOperator storageOpearter = ResourceUtil.getResourceOperator(IStorageOperator.class);
                                            storageOpearter.setFlags(CloudPropertyConstants.autoupdate_storage.match("on"), CloudPropertyConstants.autoregist_storage.match("on"), CloudPropertyConstants.autoupdate_mount.match("on"));
                                            storageOpearter.updateAllStorage();
                                            if (CloudPropertyConstants.autoupdate_backup.match("on")) {
                                                instanceOpearter.updateAllInstanceBackup();
                                                storageOpearter.updateAllStorageBackup();
                                            }
                                            logger.debug((Object)("exit AutoDetection : region=" + region.getRegionName()));
                                        }
                                        catch (Exception e) {
                                            logger.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                        finally {
                                            if (autoDetection) {
                                                ActionMode.leaveAutoDetection();
                                            }
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                logger.debug((Object)"leave AsyncCallAutoDetection.");
            }
            catch (Exception e) {
                throw new JobExecutionException((Throwable)e);
            }
            finally {
                ActionMode.leaveAutoDetection();
            }
        }
    }

    private static class AutoDetectionService
    implements IAutoDetectionService {
        private AutoDetectionService() {
        }

        @Override
        public void start() {
            Logger logger = Logger.getLogger(AutoDetectionService.class);
            Scheduler scheduler = AutoDetectionManager.getScheduler();
            try {
                scheduler.deleteJob(new JobKey(AutoDetectionManager.quartzJobName, AutoDetectionManager.quartzJobGroupName));
            }
            catch (SchedulerException e) {
                logger.warn((Object)("scheduleEjbInvokerJob() deleteJob : " + ((Object)((Object)e)).getClass().getSimpleName() + ", " + e.getMessage()));
            }
            JobDetail job = JobBuilder.newJob(AutoDetectionJob.class).withIdentity(AutoDetectionManager.quartzJobName, AutoDetectionManager.quartzJobGroupName).storeDurably(true).requestRecovery(false).build();
            String cronString = CloudPropertyConstants.autoupdate_interval.value();
            CronScheduleBuilder scheduleBuilder = null;
            try {
                scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronString).withMisfireHandlingInstructionDoNothing();
            }
            catch (RuntimeException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                CloudMessageUtil.notify_InvalidCronString("AUTO_UPDATE", "AutoUpdate", cronString);
                try {
                    scheduleBuilder = CronScheduleBuilder.cronSchedule((String)CloudPropertyConstants.autoupdate_interval.defaultValue()).withMisfireHandlingInstructionDoNothing();
                }
                catch (RuntimeException e1) {
                    throw new IllegalStateException(e);
                }
            }
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(AutoDetectionManager.quartzJobName, AutoDetectionManager.quartzJobGroupName).withSchedule((ScheduleBuilder)scheduleBuilder).startNow().build();
            try {
                scheduler.scheduleJob(job, (Trigger)trigger);
            }
            catch (SchedulerException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void stop() {
            Logger logger = Logger.getLogger(AutoDetectionService.class);
            try {
                AutoDetectionManager.getScheduler().deleteJob(new JobKey(AutoDetectionManager.quartzJobName, AutoDetectionManager.quartzJobGroupName));
            }
            catch (SchedulerException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static interface IAutoDetectionService {
        public void start();

        public void stop();
    }
}

