package com.clustercontrol.cloud.aws;

import java.text.MessageFormat;
import java.util.MissingResourceException;

import com.clustercontrol.cloud.CloudManagerFault;

public enum ErrorCode {
	UNEXPECTED("unexpected"),

	// 
	CLOUDUSER_INVALID_ACCESSKEY("message.validation.clouduser.invalid_accesskey.not_found")
	;
	
	private String messageId;

	private ErrorCode(String messageId) {
		this.messageId = messageId;
	}
	
	public String getMessage(Object... args) {
		MessageFormat messageFormat = new MessageFormat(getMessage());
		return messageFormat.format(args);
	}

	public String getMessage() {
		try {
			return Messages.getString(messageId);
		}
		catch (MissingResourceException e) {
			return messageId;
		}
	}

	public CloudManagerFault cloudManagerFault(Object... args) {
		return new CloudManagerFault(getMessage(args), this.name());
	}
}
