package com.clustercontrol.cloud.aws.factory;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.IUserManagement.User.UserKind;
import com.clustercontrol.cloud.aws.util.AWSUtil;

public class AWSUserManagement implements IUserManagement {
	private ICredential credential;

	@Override
	public void setCredential(ICredential credential) {
		this.credential = credential;
	}

	@Override
	public User getCurrentUser() {
		AWSCredentials credentials = new BasicAWSCredentials(credential.getAccessKey(), credential.getSecretKey());
		AmazonIdentityManagement aim = new AmazonIdentityManagementClient(credentials);
		GetUserResult result = aim.getUser();

		AWSUtil.AMIArn arn = new AWSUtil.AMIArn(result.getUser().getArn());
		return new User(arn.userName, arn.isRoot() ? UserKind.account: UserKind.user);
	}
}
