/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.ws.aws;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;

/**
 * クラウド管理オプションの Web サービス API 定義。
 * 
 *
 */
@WebService(targetNamespace = "http://aws.ws.clustercontrol.com")
public interface AWSOptionEndpoint {
	@WebMethod
	List<KeyPair> getKeyNames(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region) throws CloudManagerFault, InvalidUserPass, InvalidRole;	
	
	@WebMethod
	String getWindowsPassword(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name = "instanceId") String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	@WebMethod
	List<Subnet> getSubnets(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	@WebMethod
	List<SecurityGroup> getSecurityGroups(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region) throws CloudManagerFault, InvalidUserPass, InvalidRole;
	
	@WebMethod
	List<SecurityGroup> getSecurityGroupsWithFilters(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name = "filters") List<Filter> filters) throws CloudManagerFault, InvalidUserPass, InvalidRole;
}