SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_cloud_type_mst (cloud_id, cloud_name, description) FROM stdin (DELIMITER ',');
AWS,AWS,AWS
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_cloud_service (cloud_service_id, cloud_service_name, cloud_type_id, description) FROM stdin (DELIMITER ',');
AWS,Amazon Web Services,AWS,http://aws.amazon.com/jp/ 
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_cloud_region (region, cloud_service_id, region_name, description) FROM stdin (DELIMITER ',');
us-east-1,AWS,米国東部(バージニア北部),EC2 利用可能ゾーン数: 5*    2006 年開始
us-west-2,AWS,米国西部(オレゴン),EC2 利用可能ゾーン数: 3    2011年開始
us-west-1,AWS,米国西部(北カリフォルニア),EC2 利用可能ゾーン数: 3*    2009 年開始
eu-west-1,AWS,欧州(アイルランド),EC2 利用可能ゾーン数: 3    2007年開始
ap-southeast-1,AWS,アジアパシフィック(シンガポール),EC2 利用可能ゾーン数: 2    2010年開始
ap-southeast-2,AWS,アジアパシフィック(シドニー),EC2 利用可能ゾーン数: 2    2012 年開始
ap-northeast-1,AWS,アジアパシフィック(東京),EC2 利用可能ゾーン数: 3    2011年開始
sa-east-1,AWS,南アメリカ (サンパウロ),EC2 利用可能ゾーン数: 2    2011年開始
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP
--\http://docs.aws.amazon.com/general/latest/gr/rande.html
COPY cc_cloud_endpoint (ep_type, cloud_service_id, region, location) FROM stdin (DELIMITER ',');
ec2,AWS,us-east-1,ec2.us-east-1.amazonaws.com
ec2,AWS,us-west-2,ec2.us-west-2.amazonaws.com
ec2,AWS,us-west-1,ec2.us-west-1.amazonaws.com
ec2,AWS,eu-west-1,ec2.eu-west-1.amazonaws.com
ec2,AWS,ap-southeast-1,ec2.ap-southeast-1.amazonaws.com
ec2,AWS,ap-southeast-2,ec2.ap-southeast-2.amazonaws.com
ec2,AWS,ap-northeast-1,ec2.ap-northeast-1.amazonaws.com
ec2,AWS,sa-east-1,ec2.sa-east-1.amazonaws.com
\.

COMMIT;