CREATE OR REPLACE FUNCTION maint_cc_cloud_type_mst(text, cc_cloud_type_mst[]) RETURNS SETOF cc_cloud_type_mst AS $$
DECLARE
	r cc_cloud_type_mst%ROWTYPE;
BEGIN
	FOREACH r IN ARRAY $2 LOOP
		IF ($1 = 'INSERT') THEN
			UPDATE cc_cloud_type_mst SET cloud_name=r.cloud_name, description=r.description WHERE cloud_id=r.cloud_id;
			IF NOT FOUND THEN
				INSERT INTO cc_cloud_type_mst(cloud_id, cloud_name, description) VALUES (r.cloud_id, r.cloud_name, r.description);
				RETURN NEXT r;
			END IF;
		ELSIF ($1 = 'DELETE') THEN
			DELETE FROM cc_cloud_type_mst WHERE cloud_id=r.cloud_id;
			IF FOUND THEN
				RETURN NEXT r;
			END IF;
    	END IF;
	END LOOP;
	RETURN;
END;$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION maint_cc_cloud_service(text, cc_cloud_service[]) RETURNS SETOF cc_cloud_service AS $$
DECLARE
	r cc_cloud_service%ROWTYPE;
BEGIN
	FOREACH r IN ARRAY $2 LOOP
		IF ($1 = 'INSERT') THEN
			UPDATE cc_cloud_service SET cloud_service_name=r.cloud_service_name, cloud_type_id=r.cloud_type_id, description=r.description WHERE cloud_service_id=r.cloud_service_id;
			IF NOT FOUND THEN
				INSERT INTO cc_cloud_service(cloud_service_id, cloud_service_name, cloud_type_id, description) VALUES (r.cloud_service_id, r.cloud_service_name, r.cloud_type_id, r.description);
				RETURN NEXT r;
			END IF;
		ELSIF ($1 = 'DELETE') THEN
			DELETE FROM cc_cloud_service WHERE cloud_service_id=r.cloud_service_id;
			IF FOUND THEN
				RETURN NEXT r;
			END IF;
    	END IF;
	END LOOP;
	RETURN;
END;$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION maint_cc_cloud_region(text, cc_cloud_region[]) RETURNS SETOF cc_cloud_region AS $$
DECLARE
	r cc_cloud_region%ROWTYPE;
BEGIN
	FOREACH r IN ARRAY $2 LOOP
		IF ($1 = 'INSERT') THEN
			UPDATE cc_cloud_region SET region_name=r.region_name, description=r.description WHERE region=r.region AND cloud_service_id=r.cloud_service_id;
			IF NOT FOUND THEN
				INSERT INTO cc_cloud_region(region, cloud_service_id, region_name, description) VALUES (r.region, r.cloud_service_id, r.region_name, r.description);
				RETURN NEXT r;
			END IF;
		ELSIF ($1 = 'DELETE') THEN
			DELETE FROM cc_cloud_region WHERE region=r.region AND cloud_service_id=r.cloud_service_id;
			IF FOUND THEN
				RETURN NEXT r;
			END IF;
    	END IF;
	END LOOP;
	RETURN;
END;$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION maint_cc_cloud_endpoint(text, cc_cloud_endpoint[]) RETURNS SETOF cc_cloud_endpoint AS $$
DECLARE
	r cc_cloud_endpoint%ROWTYPE;
BEGIN
	FOREACH r IN ARRAY $2 LOOP
		IF ($1 = 'INSERT') THEN
			UPDATE cc_cloud_endpoint SET location=r.location WHERE  ep_type=r.ep_type AND cloud_service_id=r.cloud_service_id AND region=r.region;
			IF NOT FOUND THEN
				INSERT INTO cc_cloud_endpoint(ep_type, cloud_service_id, region, location) VALUES (r.ep_type, r.cloud_service_id, r.region, r.location);
				RETURN NEXT r;
			END IF;
		ELSIF ($1 = 'DELETE') THEN
			DELETE FROM cc_cloud_endpoint WHERE ep_type=r.ep_type AND cloud_service_id=r.cloud_service_id AND region=r.region;
			IF FOUND THEN
				RETURN NEXT r;
			END IF;
    	END IF;
	END LOOP;
	RETURN;
END;$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION cloud_maint_operation(
	text,
	cc_cloud_type_mst[],
	cc_cloud_service[],
	cc_cloud_region[],
	cc_cloud_endpoint[]
	) RETURNS VOID AS $$
BEGIN
	IF ($1 = 'INSERT') THEN
		PERFORM maint_cc_cloud_type_mst($1, $2);
		PERFORM maint_cc_cloud_service($1, $3);
		PERFORM maint_cc_cloud_region($1, $4);
		PERFORM maint_cc_cloud_endpoint($1, $5);
	ELSIF ($1 = 'DELETE') THEN
		PERFORM maint_cc_cloud_endpoint($1, $5);
		PERFORM maint_cc_cloud_region($1, $4);
		PERFORM maint_cc_cloud_service($1, $3);
		PERFORM maint_cc_cloud_type_mst($1, $2);
	ELSE
		RAISE EXCEPTION 'invalid operation ---> %', $1;
	END IF;
	RETURN;
END;$$ LANGUAGE plpgsql;