#!/bin/bash

#Copyright (C) 2013 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or 
#Modify it under the terms of the GNU General Public License 
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful, 
#but WITHOUT ANY WARRANTY; without even the implied warranty of 
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
#GNU General Public License for more details

VERSION_NUMBER=2.0.0
VERSION_FILE_NAME="_version_cloud_std"
OPTION_PACKAGE_NAME="cloud_manager_standard-2.0.0"
DEPENDENCY_VER_FILE="${HINEMOS_HOME}/_version"
DEPENDENCY_MODULE_NAME="Hinemos"
REQUIRED_VERSION="4.1.0"
INSTALL_USER="hinemos"
INSTALL_GROUP="hinemos"

LIBDIR="${HINEMOS_HOME}/lib/cloud"
PLUGINS_DIR="${HINEMOS_HOME}/plugins"
PLUGINS_IN_PACKAGE_DIR="${SCRIPT_DIR}/plugins"

ENTITY_JARS="CloudManagerDao.jar ManagerPluginBaseDao.jar"
ORM_XML_PATHS="META-INF/orm_cloud.xml META-INF/orm_plugin_base.xml"

INSTALL_LIBRARIES="CloudManagerBase.jar CloudManagerDao.jar CloudManagerStd.jar ManagerPluginBase.jar ManagerPluginBaseDao.jar jackson-annotations-2.2.0.jar jackson-core-2.2.0.jar jackson-databind-2.2.0.jar"

INSTALL_LIB_FILES=""
INSTALL_PLUGIN_FILES=""
for LIBRARY in ${INSTALL_LIBRARIES}
do
	INSTALL_LIB_FILES="${INSTALL_LIB_FILES}
${LIBDIR}/${LIBRARY}"
	INSTALL_PLUGIN_FILES="${INSTALL_PLUGIN_FILES}
${PLUGINS_DIR}/${LIBRARY}"
done
INSTALL_LIB_FILES=${INSTALL_LIB_FILES}
INSTALL_PLUGIN_FILES=${INSTALL_PLUGIN_FILES}


INSTALL_FILES="${INSTALL_LIB_FILES}
${INSTALL_PLUGIN_FILES}
${HINEMOS_HOME}/${VERSION_FILE_NAME}"


PERSISTENCE_XML_PATH="${HINEMOS_ETC_DIR}/META-INF/persistence.xml"
XML_POST_JAR_POSITION="<!-- add jar-file here -->"
XML_POST_ORM_POSITION="<!-- add mapping-file here -->"
