package com.clustercontrol.cloud;

public class InternalManagerError extends RuntimeException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8764716113090107366L;

	private String errorCode;

	public InternalManagerError() {
		this(PluginBaseMessages.getString("message.unexpected_error"), "UNEXPECTED");
	}

	public InternalManagerError(String message, Throwable cause) {
		this(message, "UNEXPECTED", cause);
	}

	public InternalManagerError(String message, String errorCode, Throwable cause) {
		super(message, cause);
		setErrorCode("UNEXPECTED");
	}

	public InternalManagerError(String message) {
		this(message, "UNEXPECTED", null);
	}

	public InternalManagerError(String message, String errorCode) {
		this(message, errorCode, null);
	}

	public InternalManagerError(Throwable cause) {
		this(cause instanceof PluginFault ? ((PluginFault)cause).getUndecoratedMessage():(cause.getMessage() == null ? cause.toString(): cause.getMessage()), cause instanceof PluginFault ? ((PluginFault)cause).getErrorCode():"UNEXPECTED", cause);
	}

	public InternalManagerError(String message, String errorCode, Throwable cause,
			boolean enableSuppression, boolean writableStackTrace) {
		super(message, cause, enableSuppression, writableStackTrace);
		setErrorCode(errorCode);
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorCode() {
		return errorCode;
	}

	@Override
	public String getMessage() {
		return super.getMessage() + " : ErrorCode=" + errorCode;
	}
}
