package com.clustercontrol.cloud;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MultiBundleHolder implements IMessagesHolder {
	private Map<String, String> messageMap = new HashMap<>();
	private List<ResourceBundle> bundles = new ArrayList<>();
	
	public MultiBundleHolder(String...resourceNames) {
		for (String resourceName: resourceNames) {
			ResourceBundle bundle = ResourceBundle.getBundle(resourceName);
			bundles.add(bundle);
		}
	}
	
	public void addBundle(String resourceName) {
		ResourceBundle bundle = ResourceBundle.getBundle(resourceName);
		bundles.add(bundle);
	}
	
	@Override
	public String getString(String key, Object... args) {
		MessageFormat messageFormat = new MessageFormat(getString(key));
		return messageFormat.format(args);
	}

	@Override
	public String getString(String key) {
		return getString(key, key);
	}

	@Override
	public String getString(String key, String def) {
		String message = messageMap.get(key);
		if (message != null) return message;
		
		for (ResourceBundle bundle: bundles) {
			try {
				message = bundle.getString(key);
				break;
			}
			catch (MissingResourceException e) {
			}
		}
		
		message = message == null ? (def == null ? key: def): message;
		messageMap.put(key, message);
		return message;
	}
}
