package com.clustercontrol.cloud.commons;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public interface PropValidator {
	public static class StringValidator implements PropValidator {
		private Set<String> stringSet;
		
		public StringValidator(String... strings) {
			stringSet = new HashSet<String>(Arrays.asList(strings));
		}
		
		@Override
		public void validate(String value) throws Exception {
			if (!stringSet.contains(value)) {
				throw new Exception();
			}
		}
	}

	static StringValidator switchValidator = new StringValidator(PropertyContract.on, PropertyContract.off);
	
	static PropValidator intValidator = new PropValidator() {
		@Override
		public void validate(String value) throws Exception {
			Integer.parseInt(value);
		}
	};

	void validate(String value) throws Exception;
}
