package com.clustercontrol.cloud.persistence;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class BooleanTFConverter implements AttributeConverter<Boolean, Integer>{
    @Override
    public Integer convertToDatabaseColumn(Boolean value) {
        if (value != null && value) {
            return 1;
        } else {
            return 0;
        }
    }
    @Override
    public Boolean convertToEntityAttribute(Integer value) {
        return Integer.valueOf(1).equals(value);
    }
}
