package com.clustercontrol.cloud.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public interface Processor<A extends Annotation> {
	void init(A annotation, Method getMethod, Method setMethod) throws Exception;

	void postLoad(Object entity) throws Exception;
	void prePersist(Object entity) throws Exception;
	void postPersist(Object entity) throws Exception;
	void preUpdate(Object entity) throws Exception;
	void postUpdate(Object entity) throws Exception;
}
