package com.clustercontrol.cloud.persistence;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)  
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface Transactional {
	enum TransactionType {
		Required,
		RequiredNew,
		NotSupported, //未使用
		Supported,
	};
	TransactionType value() default TransactionType.Required;
}
