package com.clustercontrol.cloud.registry;

import com.clustercontrol.cloud.PluginFault;

public interface IObjectChangedListener<T> {
	void onInstall();
	void onUninstall();
	void preAdded(String type, T object) throws PluginFault;
	void postAdded(String type, T object) throws PluginFault;
	void preRemoved(String type, T object) throws PluginFault;
	void preModified(String type, T object) throws PluginFault;
	void postModified(String type, T object) throws PluginFault;
}